# Medium Writing Guide

> This guide provides comprehensive reference for writing on Medium, including platform characteristics, audience profile, article structure, and writing techniques.

## Platform Overview

### Basic Information
- **User Base**: 100M+ monthly readers
- **Positioning**: Platform for thoughtful writing
- **Content Format**: Long-form articles (1500-3000 words)
- **User Characteristics**: Educated, curious, patient readers

### Medium Ecosystem Features
- **Publication-Based**: Articles live in publications or personal blogs
- **Member-Only Stories**: Paywall option for monetization
- **Curation System**: Editors curate quality content
- **Partner Program**: Earnings based on member reading time

## Reader Demographics

### Core Audience

**Age Distribution:**
- 25-34: Largest segment (35%)
- 35-44: Significant presence (25%)
- 45-54: Growing segment (20%)
- 18-24: Younger readers (15%)
- 55+: Mature readers (5%)

**Professional Background:**
- Knowledge workers
- Entrepreneurs
- Developers/tech professionals
- Writers and creators
- Consultants
- Managers and executives

**Reading Habits:**
- **Deep Readers**: Will read 7-15 minute articles
- **Patient**: Willing to engage with complex ideas
- **Thoughtful**: Leave considered responses
- **Curious**: Seeking insights and perspectives

**Content Preferences:**
- ✅ Personal essays with insights
- ✅ Deep dives into specific topics
- ✅ Thoughtful analysis
- ✅ Stories that teach
- ✅ Well-crafted prose
- ❌ Shallow listicles
- ❌ Clickbait
- ❌ Pure news aggregation
- ❌ Overly promotional content

## Article Types That Succeed

### 1. Personal Essay + Universal Insight
```
Structure:
Personal experience → Reflection → Broader meaning

Characteristics:
- Starts with a story
- Finds universal truth
- Well-crafted narrative
- Emotional resonance

Example:
"What Seven Days with Atlas Taught Me About the Privacy-Convenience Tradeoff"

Why it works:
- Personal + universal
- Story creates engagement
- Insight has value
- Relatable experience
```

### 2. Deep Dive Analysis
```
Structure:
Question → Investigation → Discovery → Implications

Characteristics:
- Thorough research
- Multiple perspectives
- Data-informed
- Nuanced conclusions

Example:
"The Uncomfortable Truth About AI Browsers: A Deep Dive"

Why it works:
- Depth > breadth
- Shows intellectual rigor
- Teaches readers something
- Reference value
```

### 3. "What I Learned From..."
```
Structure:
Experience → Lessons → Application

Characteristics:
- Concrete experience
- Clear takeaways
- Actionable insights
- Personal growth

Example:
"What Building with AI Tools for 30 Days Taught Me"

Why it works:
- Learning from experience
- Practical wisdom
- Inspires action
- Honest reflection
```

### 4. Contrarian Perspective
```
Structure:
Common belief → Challenge → Evidence → Reframing

Characteristics:
- Questions assumptions
- Evidence-based
- Thought-provoking
- Respectful tone

Example:
"Why 'AI-Native' Doesn't Mean 'Better'"

Why it works:
- Challenges thinking
- Backed by reasoning
- Creates discussion
- Memorable perspective
```

### 5. Comprehensive Guide
```
Structure:
Problem → Framework → Application → Examples

Characteristics:
- Systematic approach
- Well-structured
- Practical value
- Detailed examples

Example:
"A Framework for Evaluating AI Tools in Your Workflow"

Why it works:
- Actionable
- Comprehensive
- Reference material
- Shows expertise
```

## Title and Subtitle Strategy

### Title Formulas

**Formula 1: Insight-Forward**
```
"What [X] Taught Me About [Y]"
"The [Adjective] Truth About [X]"
"Why [Common Belief] Is Wrong"

Examples:
- "What Atlas Browser Taught Me About the Privacy-Convenience Tradeoff"
- "The Uncomfortable Truth About AI Browsers"
- "Why 'AI-Native' Doesn't Mean 'Better'"
```

**Formula 2: Question-Based**
```
"Are We Ready for [X]?"
"What Happens When [X]?"
"Can [X] Really [Y]?"

Examples:
- "Are We Ready to Trust AI with Our Browsing History?"
- "What Happens When AI Knows Everything You Read?"
- "Can a Browser Really Understand What You Need?"
```

**Formula 3: Narrative**
```
"I Spent [Time] [Doing X]. Here's What Changed."
"My [Time] With [X]: A Story of [Y]"
"The Day I Realized [Insight]"

Examples:
- "I Spent a Week Using Only AI-Powered Tools. Here's What Changed."
- "My Seven Days With Atlas: A Story of Fascination and Fear"
- "The Day I Realized My Browser Knows Me Better Than I Know Myself"
```

**Title Guidelines:**
```
✅ 40-80 characters
✅ Intriguing but honest
✅ Keywords for discovery
✅ Emotionally resonant
✅ Clear value proposition

❌ Clickbait
❌ Misleading
❌ Too vague
❌ Too long (>100 chars)
```

### Subtitle Strategy

**Purpose of Subtitle:**
- Add context
- Complete the story
- Include keywords
- Set expectations

**Subtitle Formula:**
```
Title: [Hook/Question/Statement]
Subtitle: [Context + Specifics + Promise]

Example:
Title: "What Atlas Browser Taught Me About the Privacy-Convenience Tradeoff"
Subtitle: "Seven days of testing OpenAI's new browser revealed uncomfortable truths about what we're willing to sacrifice for better technology"
```

**Subtitle Guidelines:**
```
✅ 80-140 characters
✅ Complements title
✅ Adds key information
✅ Creates curiosity
✅ SEO-friendly

❌ Redundant with title
❌ Too vague
❌ Missing key details
```

## Opening Strategy

### The Hook (First 3 Paragraphs)

**Goal: Hook + Promise + Personal Connection**

**Opening Type 1: Scene/Moment**
```
[Vivid scene or specific moment]
↓
[What this moment meant]
↓
[Bridge to main topic]

Example:
"It was 2 AM when I realized my browser had become my diary.

I was testing Atlas, OpenAI's new AI-powered browser, when it suggested an article I'd been thinking about but hadn't searched for. It knew. It had been watching, learning, anticipating.

That's when I understood: we're not just getting a new browser. We're getting a new relationship with technology—and I'm not sure we're ready for it."
```

**Opening Type 2: Surprising Statement**
```
[Counterintuitive or provocative statement]
↓
[Why this matters]
↓
[Personal stake]

Example:
"The best new browser I've tried this year is also the one I trust the least.

After a week with Atlas, I'm convinced we're at an inflection point. Not just in browser technology, but in how we think about the privacy-convenience tradeoff.

Here's what I learned—and why it matters for all of us."
```

**Opening Type 3: Question**
```
[Thought-provoking question]
↓
[Why you're asking]
↓
[What you'll explore]

Example:
"What would you trade for a browser that knows exactly what you need before you know it yourself?

This isn't hypothetical. I've been using Atlas for a week, and it's shown me a future where AI anticipates my every digital need. It's impressive. It's useful.

And it's deeply unsettling."
```

**Opening Requirements:**
```
✅ 150-250 words
✅ Creates curiosity
✅ Establishes personal connection
✅ Sets up the journey
✅ Elegant prose
✅ Draws reader in emotionally

❌ Too long
❌ Too abstract
❌ Missing personal element
❌ Vague setup
```

## Body Structure

### Narrative Arc

**Classic Structure:**
```
Opening: Hook + Setup
↓
Section 1: Context/Background
↓
Section 2: The Experience
↓
Section 3: The Complication
↓
Section 4: The Insight
↓
Section 5: The Implication
↓
Ending: Resonance
```

**Example Structure for Atlas Article:**
```
## The Promise of AI-Native Browsing
[Setup: What drew you in]

## The First Three Days: Delighted
[The honeymoon period]

## Day Four: The Uneasy Realization
[When doubt creeps in]

## The Convenience-Privacy Calculation
[The core tension]

## What This Means for All of Us
[Broader implications]

[Ending: Lingering question]
```

### Section Guidelines

**Each Section Should:**
```
✅ Have a clear theme
✅ Build on previous sections
✅ Move the story forward
✅ Contain concrete examples
✅ Be 300-500 words

❌ Repeat information
❌ Lose focus
❌ Be too long (>600 words)
```

### Writing Principles

**1. Show, Don't Just Tell**
```
❌ "The AI search was good."
✅ "I typed 'that Stripe article' and it instantly pulled up a blog post I'd read three weeks ago. No author name, no specific keywords. It just knew."
```

**2. Blend Personal and Universal**
```
Personal: "I realized I was measuring value in a new way..."
Universal: "...what this means for all of us"

Balance both throughout.
```

**3. Use Transitional Thinking**
```
Guide readers through your thought process:
- "This made me think about..."
- "Which raises a question..."
- "Here's what struck me..."
- "The turning point came when..."
```

**4. Acknowledge Complexity**
```
✅ "This isn't black and white..."
✅ "The answer isn't simple..."
✅ "I'm still grappling with..."

Avoids oversimplification.
```

**5. Build Towards Insight**
```
Each section advances understanding:
- Section 1: Here's what I did
- Section 2: Here's what I found
- Section 3: Here's what surprised me
- Section 4: Here's what it means
- Section 5: Here's why it matters
```

## Writing Craft

### Sentence Structure

**Vary Sentence Length:**
```
❌ Monotonous (all similar length):
"Atlas is fast. The interface is clean. The AI works well."

✅ Rhythmic (varied length):
"Atlas is fast.

This is the first thing you notice. Pages load quickly, the interface responds instantly, everything feels snappy.

But speed isn't the whole story."
```

**Create Rhythm:**
```
Long sentence (build tension)
↓
Short sentence (release/emphasis)
↓
Medium sentence (transition)
↓
Repeat
```

### Paragraph Structure

**Vary Paragraph Length:**
```
Long paragraph (develop idea)
↓
Short paragraph (emphasize)
↓
Single sentence paragraph (maximum impact)
↓
Long paragraph (continue)
```

**Example:**
```
[3-5 sentence paragraph developing an idea about AI browsers learning your habits]

This made me uncomfortable.

[3-5 sentence paragraph exploring why this discomfort matters and what it reveals about our relationship with technology]
```

### Voice and Tone

**Medium Voice:**
```
✅ Thoughtful but accessible
✅ Personal but not oversharing
✅ Confident but not arrogant
✅ Conversational but polished
✅ Honest about uncertainty

❌ Academic/stuffy
❌ Overly casual
❌ Preachy
❌ Defensive
❌ Artificially enthusiastic
```

**Tone Calibration:**
```
More Personal:
- Use "I" frequently
- Share specific moments
- Admit feelings and doubts

More Universal:
- Connect to broader themes
- Use "we" and "us"
- Explore implications
```

## Ending Strategy

### Effective Conclusions

**Goal: Leave Readers Thinking**

**Ending Type 1: Reflective**
```
[Return to opening theme]
↓
[Refined understanding]
↓
[Lingering question]

Example:
"I'm still using Atlas, though not for everything. I've created boundaries—work research yes, personal browsing no.

But I'm not sure how long these boundaries will hold. The convenience is real. The value is undeniable.

Maybe that's the point. We're all making these calculations now, one app at a time, one feature at a time.

The question isn't whether we'll trade privacy for convenience. The question is: at what point do we realize we've traded too much?"
```

**Ending Type 2: Forward-Looking**
```
[What you'll do going forward]
↓
[What you hope others will do]
↓
[Bigger picture]

Example:
"Going forward, I'm asking myself a new question before adopting any AI tool: 'What would it take for this to go wrong?'

Not in a paranoid way. But in a realistic way.

Because these tools work precisely because they know us so well. And that's both their power and their danger.

We can't uninvent this technology. But we can choose to engage with it thoughtfully."
```

**Ending Type 3: Open Question**
```
[Synthesis of journey]
↓
[Invitation to reader]
↓
[Final resonant thought]

Example:
"Seven days with Atlas taught me something uncomfortable: I care about privacy in theory but convenience in practice.

I suspect I'm not alone.

As AI becomes more capable, we'll face this tension again and again. Better to grapple with it now, consciously, than to wake up one day and realize we've made choices we can't unmake.

What would you trade for a browser that knows you perfectly?

I'm still figuring out my answer."
```

**Ending Requirements:**
```
✅ 150-250 words
✅ Circles back to beginning
✅ Offers insight, not summary
✅ Leaves reader thinking
✅ Doesn't over-explain
✅ Resonates emotionally

❌ Introduces new topics
❌ Mere summary
❌ Preachy conclusion
❌ Abrupt ending
```

## Formatting for Medium

### Visual Elements

**Headers:**
```
# Title (auto-generated from title)
## Section Headers (H2 - use these)
### Subsection (H3 - use sparingly)

Don't go deeper than H3.
```

**Pull Quotes:**
```
Use Medium's pull quote feature for key insights:

> "The question isn't whether we'll trade privacy for convenience. The question is: at what point do we realize we've traded too much?"

Guidelines:
- 1-2 per article
- Key insights or themes
- Not too long (1-2 sentences)
```

**Emphasis:**
```
✅ *Italics* for emphasis (sparingly)
❌ **Bold** rarely used on Medium
✅ Use structure and white space for emphasis
```

**Line Breaks:**
```
Use generously to create breathing room:

Paragraph 1

[Space]

Paragraph 2

Helps with rhythm and readability.
```

**Images:**
```
Feature image: Required
Body images: 2-5 recommended

Image guidelines:
- High quality
- Relevant to content
- Not stock photos (if possible)
- Proper attribution
```

## Tags and Distribution

### Tag Strategy

**Select 5 Tags:**
```
2 specific tags: "Atlas Browser", "AI Tools"
2 broader tags: "Technology", "Privacy"
1 engagement tag: "Productivity", "Future of Work"

Tag guidelines:
✅ Relevant to content
✅ Mix of specific and broad
✅ Popular but not oversaturated
✅ Check tag follower counts

❌ Irrelevant tags
❌ All niche or all broad
❌ Abandoned tags
```

### Publication Submission

**Top Publications (Tech/Productivity):**
- Better Programming
- The Startup
- UX Collective
- Towards Data Science
- Level Up Coding

**Submission Guidelines:**
```
1. Write quality article first
2. Research publication requirements
3. Follow submission process
4. Be patient (may take days/weeks)
5. If rejected, try elsewhere

Note: Many publications no longer accept unsolicited submissions.
```

## Monetization

### Medium Partner Program

**Requirements:**
```
- Stripe account
- Published at least one story
- Located in eligible country
- Follow Medium Rules

Earnings: Based on member reading time
```

**Strategies for Success:**
```
✅ Write quality content consistently
✅ Focus on topics people search for
✅ Engage with readers in comments
✅ Build a following
✅ Be patient (takes time)

❌ Clickbait
❌ Thin content
❌ Inconsistent posting
❌ Gaming the system
```

## Writing Schedule

### Recommended Frequency

**Building Phase (First 6 months):**
```
- 2-3 articles per week
- Focus on quality + consistency
- Experiment with topics
- Learn what resonates
```

**Established (After 6 months):**
```
- 1-2 articles per week
- Higher quality expected
- Deeper, more thoughtful pieces
- Build on successful topics
```

### Time Investment

**Per Article:**
```
Planning/Research: 2-4 hours
First Draft: 3-5 hours
Editing/Polishing: 2-3 hours
Images/Formatting: 1 hour

Total: 8-13 hours for quality piece
```

## Common Mistakes

### Content Mistakes

**1. Too Shallow**
```
❌ Surface-level observations
❌ Obvious insights
❌ No depth or nuance

✅ Go deeper
✅ Add layers
✅ Explore complexity
```

**2. Too Self-Focused**
```
❌ Pure personal story with no broader insight
❌ "Here's what I did" without "here's what it means"

✅ Personal + universal
✅ Experience + insight
```

**3. Overly Academic**
```
❌ Jargon-heavy
❌ Overly formal
❌ Inaccessible

✅ Thoughtful but readable
✅ Intelligent but warm
```

**4. Rushed Ending**
```
❌ Abrupt conclusion
❌ Just summary
❌ Introducing new ideas

✅ Take time with ending
✅ Create resonance
✅ Leave them thinking
```

### Writing Mistakes

**1. Weak Opening**
```
❌ Starting with throat-clearing
❌ Too much setup
❌ Boring first paragraph

✅ Hook immediately
✅ Create curiosity
✅ Engage emotionally
```

**2. Poor Structure**
```
❌ Wandering narrative
❌ No clear progression
❌ Repetitive sections

✅ Clear arc
✅ Each section builds
✅ Eliminate redundancy
```

**3. Telling Not Showing**
```
❌ "It was interesting"
❌ "The experience was valuable"

✅ Show through concrete details
✅ Use specific examples
```

## Core Principles

### Essential Guidelines

✅ **Depth Over Breadth**: Go deep into one thing
✅ **Story + Insight**: Weave narrative with wisdom
✅ **Craft Matters**: Take time to write well
✅ **Personal + Universal**: Make it about you and everyone
✅ **Leave Them Thinking**: Provoke thought, don't just conclude
✅ **Respect Intelligence**: Readers are smart
✅ **Be Honest**: Authenticity > performance

### What Medium Readers Expect
```
Substance: Deep, thoughtful content
Craft: Well-written, polished prose
Respect: Treating readers as intelligent
Time: Worth their 7-15 minutes
Insight: Something they can't get elsewhere
```

---

**Remember Medium's Essence:**
- Medium readers come for depth and craft
- They have time and attention for quality
- Personal stories that teach are powerful
- Well-crafted prose matters
- Leave readers with something to think about
- It's not about virality, it's about resonance