# Reddit Writing Guide

> This guide provides comprehensive reference for writing on Reddit, including platform characteristics, user behavior, community culture, and writing techniques.

## Platform Overview

### Basic Information
- **User Base**: 500M+ MAU (Monthly Active Users)
- **Positioning**: "The front page of the internet"
- **Content Format**: Text posts, links, images, videos
- **User Characteristics**: Tech-savvy, skeptical, values authenticity

### Reddit Ecosystem Features
- **Subreddit-Based**: Organized by interest communities
- **Upvote/Downvote System**: Community-driven content ranking
- **Anonymous Culture**: Username-based, privacy-focused
- **Anti-Marketing**: Extremely hostile to promotion

## User Demographics

### Core User Groups

**Age Distribution:**
- 18-29: Largest segment (36%)
- 30-49: Significant presence (36%)
- 50+: Growing segment (28%)

**Gender Distribution:**
- Male: ~60%
- Female: ~40%
- More balanced than historically

**Geographic Distribution:**
- US: ~48%
- UK: ~7%
- Canada: ~7%
- Australia: ~4%
- Rest of World: ~34%

**Education/Occupation:**
- Highly educated (college+)
- Tech workers: Large presence
- Students: Very active
- Professionals across industries

### Behavioral Characteristics

**Reading Habits:**
- **Skeptical**: Assume everything is marketing until proven otherwise
- **Detail-Oriented**: Will fact-check claims
- **Long-Form Friendly**: Will read 1000+ word posts if valuable
- **Desktop + Mobile**: Mix of both

**Interaction Style:**
- **Direct and Blunt**: No sugarcoating
- **Values Authenticity**: Fake enthusiasm = downvotes
- **Helpful**: Will genuinely help if you're authentic
- **Critical**: Will call out BS immediately

**Content Preferences:**
- ✅ Honest experiences (including failures)
- ✅ Detailed explanations
- ✅ Data and evidence
- ✅ Admitting limitations
- ✅ Asking for feedback
- ❌ Marketing speak
- ❌ Self-promotion
- ❌ Clickbait
- ❌ Fake enthusiasm

## Subreddit Selection

### Finding the Right Subreddit

**For Tech/Tools Content:**
```
Primary Options:
- r/productivity (2.5M+ members)
- r/SideProject (200K+ members)
- r/technology (14M+ members)
- r/software (300K+ members)
- r/selfhosted (500K+ members)

Secondary Options:
- r/webdev (if technical)
- r/programming (if code-heavy)
- r/entrepreneur (if business-focused)
- r/SaaS (if SaaS product)
```

**Research Checklist:**
```
Before posting, check:
- [ ] What types of posts get upvoted?
- [ ] What's the subreddit vibe?
- [ ] Are self-posts allowed?
- [ ] Any rules about promotion?
- [ ] What's considered spam?
- [ ] Posting frequency limits?
```

**Subreddit Rules (CRITICAL):**
```
✅ ALWAYS read rules before posting
✅ Follow submission guidelines
✅ Respect post format requirements
✅ Check if your post fits

❌ Don't assume rules are the same across subreddits
❌ Don't post without reading rules
```

## High-Performing Post Types

### 1. Experience Sharing
```
Format:
"I tried [X] for [timeframe], here's what happened"

Characteristics:
- Personal experience
- Both positives and negatives
- Specific examples
- No obvious agenda

Why it works:
- Authentic
- Relatable
- Provides value
- Not trying to sell

Example:
"I tested 5 AI browsers for a week. Here's my honest take."
```

### 2. Detailed Analysis
```
Format:
"I analyzed [X], here are the findings"

Characteristics:
- Deep dive into a topic
- Data and evidence
- Methodology explained
- Limitations acknowledged

Why it works:
- High information value
- Shows effort
- Educational
- Citable

Example:
"I benchmarked Atlas vs Chrome vs Firefox: Results and methodology"
```

### 3. Asking for Feedback
```
Format:
"I built/tried [X], looking for feedback"

Characteristics:
- Genuine request for input
- Provides context
- Open to criticism
- Not defensive

Why it works:
- Community loves to help
- Invites engagement
- Shows humility
- Creates discussion

Example:
"Built a browser extension for productivity. Would love your thoughts."
```

### 4. Problem-Solution
```
Format:
"Had problem [X], here's how I solved it"

Characteristics:
- Clear problem statement
- Solution explained
- Results shown
- Others can replicate

Why it works:
- Helps others with same problem
- Shows problem-solving
- Practical value
- Community contribution

Example:
"Chrome was eating 8GB RAM. Here's what fixed it."
```

### 5. Educational/Tutorial
```
Format:
"How to [X]: A complete guide"

Characteristics:
- Step-by-step
- Screenshots/examples
- Covers edge cases
- Links to resources

Why it works:
- Direct value
- Saves others time
- Reference material
- Shows expertise without bragging

Example:
"How to set up privacy-focused browsing: Complete guide"
```

## Title Formulas

### Effective Title Patterns

**Pattern 1: Experience Report**
```
"I [action] for [timeframe], here's what [happened/learned]"

Examples:
- "I used Atlas for 7 days, here's my honest experience"
- "I tested 10 productivity apps, here's what actually worked"
- "I switched from Chrome to Firefox, here's what changed"
```

**Pattern 2: Data-Driven**
```
"I [measured/tested/analyzed] [X], [results]"

Examples:
- "I benchmarked 5 browsers, Atlas was 40% faster"
- "I tracked my productivity for a month with AI tools"
- "I analyzed 100 browser extensions for privacy issues"
```

**Pattern 3: Question-Based**
```
"Has anyone [experience]? Looking for [input]"

Examples:
- "Has anyone tried Atlas browser? Thoughts on privacy?"
- "Anyone switched from Chrome recently? How's it going?"
- "Looking for browser recommendations for developers"
```

**Pattern 4: Problem Statement**
```
"[Problem statement]. [Solution/Question]"

Examples:
- "Chrome is killing my RAM. What are you using?"
- "Tired of Chrome's memory usage. Alternatives?"
- "Need a faster browser. Recommendations?"
```

**Title Guidelines:**
```
✅ DO:
- Be specific and clear
- Use natural language
- Include key information
- Keep it honest

❌ DON'T:
- Use ALL CAPS
- Add excessive punctuation!!!
- Write clickbait
- Make absolute claims ("best ever")
- Be vague
```

## Post Structure

### Opening (First 2-3 Paragraphs)

**Critical: First impression is everything**

**Effective Opening Formula:**
```
Paragraph 1: Context
[Brief background, why you're posting]

Paragraph 2: What you did
[Your experience/test/action]

Paragraph 3: Preview
[What you'll cover]
```

**Example:**
```
I've been using Chrome for 10+ years, so switching browsers is a big deal for me.

Last week OpenAI released Atlas. I decided to give it a serious try for a full week - work, personal browsing, everything.

Here's my honest experience. The good, the bad, and some concerning privacy issues.
```

**Opening Principles:**
```
✅ Get to the point quickly
✅ Establish credibility naturally
✅ Set expectations clearly
✅ Be conversational

❌ Long introductions
❌ Excessive self-promotion
❌ Fake enthusiasm
❌ Marketing speak
```

### Body Content

**Structure Options:**

**Option 1: Chronological**
```
Day 1: [Experience]
Day 3: [Experience]
Day 7: [Experience]

Conclusion: [Overall thoughts]
```

**Option 2: Categorical**
```
## The Good
- Point 1
- Point 2

## The Bad
- Point 1
- Point 2

## The Concerning
- Point 1
- Point 2
```

**Option 3: Q&A Style**
```
Q: Is it faster than Chrome?
A: [Detailed answer with data]

Q: What about privacy?
A: [Detailed answer]

Q: Worth switching?
A: [Nuanced answer]
```

**Content Guidelines:**

**1. Be Detailed**
```
❌ "The AI search is great"
✅ "The AI search lets you type natural language queries like 'that article about cats I read last week' and it actually finds it. Tested with 20+ queries, worked 80% of the time."
```

**2. Include Evidence**
```
✅ Screenshots (mention you'll add them)
✅ Specific numbers/metrics
✅ Concrete examples
✅ Comparative data

Example:
"Page load speed improved from 2.5s to 1.2s (measured with Lighthouse)"
```

**3. Admit Limitations**
```
✅ "This is based on my experience. YMMV."
✅ "I'm not a security expert, but here's what I found..."
✅ "Could be just my setup, but..."
✅ "Sample size is small, take with grain of salt"
```

**4. Balanced Perspective**
```
Always include both positives and negatives:

Positives:
- Speed is noticeably faster
- UI is cleaner
- AI features are useful

Negatives:
- Extension ecosystem is tiny
- Privacy policy is concerning
- Crashed twice during testing
```

**5. Format for Readability**
```
✅ Use headers (##, ###)
✅ Use bullet points
✅ Break into sections
✅ Add horizontal rules (---) for major sections
✅ Use code blocks for technical content
```

### Conclusion

**Effective Ending Formula:**

**Option 1: Summary + Open Question**
```
[Brief summary of key points]

[What you're still unsure about]

[Question to the community]
```

**Option 2: Recommendation + Caveats**
```
[Who should/shouldn't use this]

[Your recommendation]

[Important caveats]
```

**Option 3: Ongoing Experience**
```
[Current status]

[What you'll watch for]

[Invitation for questions]
```

**Example:**
```
## Final Thoughts

Atlas shows promise, but it's not ready to replace Chrome for me. The privacy tradeoffs are too significant for handling client work.

I'll keep it installed and check back in 6 months to see if they've addressed these issues.

Happy to answer questions about specific features or use cases.
```

## Reddit Writing Style

### Tone and Voice

**The Reddit Voice:**
```
✅ Conversational but clear
✅ Direct and honest
✅ Slightly self-deprecating
✅ Humble, not expert-posturing
✅ Open to being wrong

❌ Corporate/marketing speak
❌ Overly enthusiastic
❌ Defensive
❌ Arrogant
❌ Salesy
```

**Language Principles:**

**1. Use "I" not "we"**
```
❌ "We believe this product..."
✅ "I think..."
✅ "In my experience..."
```

**2. Admit uncertainty**
```
✅ "I could be wrong, but..."
✅ "Not sure if this applies to everyone..."
✅ "This worked for me, YMMV"
```

**3. Be specific, not vague**
```
❌ "It's much better"
✅ "It's 40% faster in my tests"

❌ "Great features"
✅ "The tab grouping feature lets you..."
```

**4. Avoid superlatives**
```
❌ "Amazing"
❌ "Game-changing"
❌ "Revolutionary"
❌ "Life-changing"

✅ "Useful"
✅ "Interesting"
✅ "Worth trying"
✅ "Pretty good"
```

### Forbidden Phrases (Will Get Downvoted)

**Marketing Speak:**
```
❌ "Check out..."
❌ "I'm excited to share..."
❌ "Game-changer"
❌ "Revolutionary"
❌ "You should definitely..."
❌ "Click here"
❌ Any external links in main post (unless necessary)
```

**Authentic Alternatives:**
```
✅ "Here's my experience..."
✅ "This might not work for everyone, but..."
✅ "I'm probably biased, but..."
✅ "Could be wrong, but here's what I think..."
✅ "YMMV (Your Mileage May Vary)"
✅ "Not affiliated, just sharing"
```

## Handling Comments

### Initial Engagement (First 2 Hours)

**Critical Period:**
```
First 2 hours determine trajectory:
- Stay online if possible
- Respond to comments quickly
- Engage genuinely
- Don't get defensive
```

**Response Strategies:**

**For Questions:**
```
✅ Answer thoroughly
✅ Provide additional context
✅ Link to resources if helpful
✅ Thank them for asking

Example:
"Good question. I tested this by [methodology]. Results: [data]. Let me know if you want more details on the testing process."
```

**For Criticism:**
```
✅ Acknowledge valid points
✅ Don't get defensive
✅ Clarify if misunderstood
✅ Thank them for feedback

Example:
"You're right, I should have tested that. Will add it to my next round of testing. Thanks for pointing it out."
```

**For Trolls:**
```
✅ Ignore or respond once calmly
❌ Don't engage in arguments
❌ Don't feed trolls

Example:
"Appreciate your perspective" [then move on]
```

**For Compliments:**
```
✅ Thank genuinely
✅ Keep it brief
✅ Stay humble

Example:
"Thanks! Glad it was helpful."
```

## Common Mistakes to Avoid

### Content Mistakes

**1. Self-Promotion**
```
❌ "Check out my product..."
❌ Direct links to your site in post
❌ "Sign up for..."

✅ If you must mention your work:
- "I wrote about this on my blog (not linking to avoid self-promo)"
- "I'm working on something related (happy to share in DMs)"
- Wait for people to ask, then share
```

**2. Fake Enthusiasm**
```
❌ "This is AMAZING!!!"
❌ "You won't believe..."
❌ "This changed my life!"

✅ "This is pretty good"
✅ "Worth checking out if..."
✅ "Useful for my use case"
```

**3. Marketing Language**
```
❌ "Leverage"
❌ "Synergy"
❌ "Disrupting"
❌ "Paradigm shift"

✅ Use plain English
```

**4. Being Vague**
```
❌ "It's better"
❌ "Works well"
❌ "Good features"

✅ "40% faster in my tests"
✅ "Handles 100 tabs without lag"
✅ "The AI search can..."
```

### Engagement Mistakes

**1. Getting Defensive**
```
When criticized:
❌ "You don't understand..."
❌ "Actually, you're wrong..."
❌ Arguing aggressively

✅ "Good point, I hadn't considered that"
✅ "You're right, I should clarify..."
✅ "Thanks for the feedback"
```

**2. Over-Responding**
```
❌ Responding to every single comment
❌ Long defensive explanations
❌ Arguing in comment threads

✅ Respond selectively
✅ Keep responses concise
✅ Know when to disengage
```

**3. Ignoring Feedback**
```
❌ No responses to any comments
❌ Only responding to praise

✅ Engage with genuine questions
✅ Acknowledge valid criticism
✅ Build discussion
```

## Subreddit-Specific Adjustments

### r/productivity
```
Focus: Practical benefits
Tone: Results-oriented
Evidence: Time saved, efficiency gains
Avoid: Theoretical benefits, vague claims
```

### r/technology
```
Focus: Technical depth
Tone: Informed analysis
Evidence: Technical specs, comparisons
Avoid: Surface-level reviews, hype
```

### r/SideProject
```
Focus: Building/creating
Tone: Maker mindset
Evidence: What you built, how it works
Avoid: Pure consumption content
Note: Can be slightly more promotional here
```

### r/entrepreneur
```
Focus: Business value
Tone: ROI-focused
Evidence: Metrics, growth, business impact
Avoid: Pure tech talk, consumer perspective
```

## Timing and Frequency

### Best Posting Times

**General Guidelines:**
```
Best Times (EST):
- Morning: 6:00-8:00 AM
- Late Morning: 10:00-11:00 AM  
- Afternoon: 2:00-4:00 PM
- Evening: 6:00-8:00 PM

Avoid:
- Late night (12:00-5:00 AM)
- Very early morning (5:00-6:00 AM)
```

**Day of Week:**
```
Best: Tuesday, Wednesday, Thursday
Good: Monday, Sunday
Slower: Friday, Saturday
```

### Posting Frequency

**Guidelines:**
```
✅ Quality over quantity
✅ One good post > ten mediocre posts
✅ Don't spam multiple subreddits
✅ Space out posts (don't post multiple in one day)

Recommended:
- 1-2 posts per week max
- In different subreddits
- On different topics
```

## Metrics and Success

### What Success Looks Like

**Upvotes:**
```
Small subreddit (<100K members):
- 50+ upvotes: Good
- 100+ upvotes: Very good
- 500+ upvotes: Excellent

Medium subreddit (100K-1M):
- 100+ upvotes: Good
- 500+ upvotes: Very good
- 1000+ upvotes: Excellent

Large subreddit (1M+):
- 500+ upvotes: Good
- 1000+ upvotes: Very good
- 5000+ upvotes: Excellent
```

**Engagement:**
```
Good indicators:
- Upvote ratio >85%
- Active discussion in comments
- Quality questions asked
- Constructive debate
- Cross-posting by others

Bad indicators:
- Downvote ratio >30%
- Negative comments
- Reports
- Removed by moderators
```

### Learning from Feedback

**Analyze Your Posts:**
```
After each post, review:
- What worked well?
- What got criticized?
- What questions came up?
- What would you change?
- How can you improve next time?
```

## Core Principles

### The Reddit Mindset

**1. Authenticity > Perfection**
```
Reddit users can detect inauthenticity instantly.
Be real, be honest, be human.
```

**2. Value > Promotion**
```
Give without expecting anything back.
The community will remember those who contribute.
```

**3. Humble > Expert**
```
Share experiences, don't preach.
You're part of the community, not above it.
```

**4. Discussion > Broadcasting**
```
Start conversations, don't just announce.
Engage with responses.
```

**5. Community > Individual**
```
Reddit is community-first.
Respect the culture.
Add value to the community.
```

## Essential Checklist

### Before Posting
```
- [ ] Read subreddit rules thoroughly
- [ ] Check recent posts for similar content
- [ ] Ensure title is clear and honest
- [ ] Content provides genuine value
- [ ] No obvious self-promotion
- [ ] Evidence/data included where needed
- [ ] Tone is authentic and humble
- [ ] Ready to engage with comments
- [ ] Have time to monitor for first 2 hours
```

### During Engagement
```
- [ ] Respond to questions promptly
- [ ] Acknowledge valid criticism
- [ ] Stay humble and open
- [ ] Don't get defensive
- [ ] Provide additional value in comments
- [ ] Thank people for engagement
```

### After Posting
```
- [ ] Review what worked/didn't work
- [ ] Save helpful feedback
- [ ] Update post if needed (with "Edit:")
- [ ] Continue responding to new comments
- [ ] Learn for next time
```

## Key Takeaways

### DO:
✅ Be authentic and honest
✅ Provide detailed, valuable content
✅ Admit limitations and biases
✅ Engage genuinely with comments
✅ Include evidence and examples
✅ Write clearly and directly
✅ Respect the community culture

### DON'T:
❌ Self-promote
❌ Use marketing language
❌ Fake enthusiasm
❌ Be defensive when criticized
❌ Clickbait
❌ Spam multiple subreddits
❌ Ignore community norms

---

**Remember Reddit's Core Truth:**
- Redditors are smart, skeptical, and can smell BS from miles away
- They value authenticity over polish
- They'll help you if you're genuine, destroy you if you're fake
- Respect the community, contribute value, stay humble
- If it feels like marketing, it probably is - and they'll downvote it