# Meeting Intelligence - Agenda Structure Guide

## Professional Agenda Format

A well-structured meeting agenda serves as both a preview for participants and a guide for the meeting facilitator.

### Essential Components

**1. Header Information**
```
Meeting: [Clear, Descriptive Title]
Date: [Date and Time with Timezone]
Duration: [e.g., 60 minutes]
Location/Link: [Physical location or Zoom link]
Organizer: [Who's running the meeting]
```

**2. Purpose Statement**
Clear, 1-2 sentence description of why this meeting exists and what success looks like.

**3. Attendees**
- Required attendees with roles
- Optional attendees
- Guest speakers (if any)

**4. Pre-Read Materials**
- What should attendees review before the meeting
- Location/links to key documents
- Time to review suggested (e.g., 10 minutes)

### Agenda Items Template

For each agenda item, include:

```
## [Time] - [Topic Title]

**Purpose:** Why are we discussing this?
**Key Questions:** What do we need to decide/understand?
**Owner:** Who is leading this discussion?
**Expected Outcome:** What should we have when done?

**Materials:**
- [Link to relevant doc]
- [Link to data/metrics]
```

### Timing Guidelines

**Total meeting time: 60 minutes**

| Duration | Time per Item | Type | Example |
|----------|--------------|------|---------|
| 30 min | 5-7 min | Status update | Updates from team |
| 60 min | 10-15 min | Decision | Technical approach choice |
| 90 min | 15-20 min | Deep dive | Specification review |
| 120 min | 20-30 min | Planning | Sprint planning |

**Rule of Thumb:** Each agenda item should take 30% longer than you think to avoid rushing.

### Different Meeting Types

#### Executive Status Meeting
```
- Quick wins/metrics (5 min)
- Blockers/risks (10 min)
- Key decisions needed (10 min)
- Q&A (5 min)
```

#### Sprint Planning
```
- Goal review & context (10 min)
- Backlog review (20 min)
- Capacity planning (15 min)
- Sprint goal finalization (10 min)
- Q&A (5 min)
```

#### 1-on-1 Conversation
```
- How are you doing? (5 min)
- Work update (10 min)
- One development area (10 min)
- Support/help needed (5 min)
```

#### Cross-functional Kickoff
```
- Project overview (10 min)
- Success criteria (10 min)
- Team roles (10 min)
- Timeline/milestones (10 min)
- Q&A (10 min)
```

### Internal Pre-Read vs. External Agenda

**Internal Pre-Read (Team Only)**
- Honest assessment and context
- Sensitive business information
- Detailed background
- Strategic rationale
- Concerns and risks

**External Agenda (All Participants)**
- Focused objectives
- Clear decisions needed
- Professional tone
- Time allocations
- Preparation requirements

### Creating Effective Agendas

**Do:**
✓ Include time allocations
✓ State clear objectives for each item
✓ Link to relevant materials
✓ Designate topic owners
✓ Leave buffer time
✓ End with clear next steps

**Don't:**
✗ Create vague agenda items ("Miscellaneous")
✗ Overload meetings with too many topics
✗ Forget time allocations
✗ Create agendas without objectives
✗ Ignore pre-read materials
✗ Skip attendee confirmations

### Post-Meeting Update

After the meeting:

```
## Decisions Made
- [Decision 1 and rationale]
- [Decision 2 and rationale]

## Action Items
| Owner | Task | Deadline |
|-------|------|----------|
| | | |

## Next Meeting
- Date/Time:
- Purpose:
- Tentative Topics:
```

### Agenda Best Practices

1. **Share Early**: Send 24+ hours before meeting
2. **Collaborative**: Encourage attendees to suggest additions
3. **Time-Boxed**: Be realistic about timing
4. **Prioritized**: Put critical items first
5. **Flexible**: Build in buffer for important discussions
6. **Connected**: Link to related materials and decisions
7. **Documented**: Keep for future reference
