# Platform-Specific Patterns

Detailed patterns extracted from 571 conversations and 165 preference instructions.

---

## LinkedIn

### Message Types
- Connection thank-you replies
- Comment on posts
- Reply to recruiters
- Bio/headline rewrites
- Post about accomplishments

### Style Rules
| Aspect | Rule |
|--------|------|
| Length | 2-4 sentences |
| Tone | Professional + warm |
| Emojis | 0-1 max |
| Structure | Acknowledge → Add value → Stay connected |

### Templates

**Connection Reply:**
```
Thank you for connecting! [Acknowledge their interest/background]. Looking forward to sharing insights and staying in touch.
```

**Recruiter Message:**
```
Thank you for reaching out. I'm interested in [role/opportunity] and would be happy to discuss further. Please let me know the next steps.
```

**Comment on Post:**
```
[Insight that adds value to the post]. [Optional: connection to your experience].
```

### Anti-Patterns
- Long paragraphs (keep it scannable)
- Multiple emojis
- Generic "Great post!" comments
- Overselling without context

---

## Fiverr

### Message Types
- Reply to initial inquiry ("How are you?")
- Scope clarification
- Off-topic request handling
- Project discussion

### Style Rules
| Aspect | Rule |
|--------|------|
| Length | 2-3 sentences for initial reply |
| Tone | Friendly, professional |
| Goal | Redirect to project discussion |
| Honesty | Never oversell, clarify scope |

### Templates

**Generic Greeting:**
```
Hi! I'm doing well, thank you. How can I help you today?
```

**Scope Question:**
```
Thanks for reaching out! Yes, I can help with [specific capability]. Could you share more details about your project requirements?
```

**Off-Topic Request:**
```
Thanks for reaching out! I specialize in [your specialty] rather than [their request]. If you need [related service you offer], I'd be happy to help!
```

**Skills Clarification:**
```
I have hands-on experience with [strong skill]. I'm currently exploring [learning skill] and can adapt quickly if needed.
```

### Anti-Patterns
- Long initial messages before understanding project
- Saying "I can do everything"
- Ignoring red flags in requests
- Not redirecting vague inquiries

---

## Upwork

### Message Types
- Job proposals
- Clarification responses
- Cover letter customization
- Follow-up messages

### Style Rules
| Aspect | Rule |
|--------|------|
| Length | 4-6 sentences |
| Tone | Natural, humanized, conversational |
| Structure | Greeting → Solution approach → Experience → Closing |
| Tech mentions | Specific: n8n, Python, Google Sheets, AI |

### Templates

**Proposal Opening:**
```
Hey there! [Show enthusiasm for the project].

I can help you [specific solution]. Here's my approach:
- [Step 1]
- [Step 2]
- [Step 3]

I've worked with [relevant experience]. Looking forward to discussing further!
```

**Skills Clarification:**
```
I have solid experience with [strong skills] through [projects/learning]. I'm expanding into [learning area] and can adapt quickly as they share similar concepts.
```

### Anti-Patterns
- Robotic, template-sounding proposals
- Not mentioning specific approach
- Generic "I'm the best fit" without proof
- Overly formal tone

---

## Interview/Recruiter

### Message Types
- Interest confirmation
- Availability scheduling
- Skills clarification
- Notice period discussion

### Style Rules
| Aspect | Rule |
|--------|------|
| Length | 3-5 sentences |
| Tone | Professional, polite |
| Honesty | Clear about skill levels |
| Context | Include relevant personal info (travel, schedule) |

### Templates

**Interest Confirmation:**
```
Thank you for reaching out. I'm interested in the [role] position and would be happy to discuss the opportunity. Please let me know the next steps.
```

**Availability with Context:**
```
Yes, I'm available [time]. I'll be [context, e.g., traveling to Lahore for my class] but can adjust timing accordingly. Please let me know what works best for you.
```

**Skills Honesty:**
```
I have hands-on experience with [strong skill] through [projects/learning]. I haven't worked professionally with [gap skill] yet, but I understand the concepts and can adapt quickly.
```

**Notice Period:**
```
Regarding notice period, I can manage the transition by [specific plan, e.g., helping hire/onboard a replacement and transferring responsibilities properly].
```

### Anti-Patterns
- Hiding skill gaps (they'll find out)
- Being too eager/desperate
- Not mentioning relevant constraints
- Vague availability responses

---

## Email (Formal)

### Message Types
- Business inquiries
- Appeal letters
- Formal requests
- Client communications

### Style Rules
| Aspect | Rule |
|--------|------|
| Length | Structured, complete |
| Tone | Formal, clear |
| Structure | Greeting → Context → Details → Action → Closing |
| Sections | Use headers for long emails |

### Templates

**Formal Request:**
```
Subject: [Clear subject line]

Dear [Name/Team],

[Opening context - why you're writing]

[Details - organized in sections if needed]

[Requested action]

Thank you for your consideration.

Best regards,
Muhammad Umer Razzaq
```

**Appeal/Explanation:**
```
Subject: [Reference number/topic]

Hello [Team],

I am writing regarding [issue].

**Background:**
[Context]

**Actions Taken:**
[What you did to fix]

**Request:**
[What you need]

Thank you for your time.

Regards,
Muhammad Umer Razzaq
```

### Anti-Patterns
- Wall of text without structure
- Missing clear action request
- Overly casual tone for formal context
- Not providing enough context

---

## WhatsApp

### Message Types
- Quick replies
- Availability confirmations
- Casual follow-ups
- Brief updates

### Style Rules
| Aspect | Rule |
|--------|------|
| Length | 1-3 sentences |
| Tone | Casual, direct |
| Emojis | Acceptable (1-2) |
| Speed | Quick, to the point |

### Templates

**Quick Confirmation:**
```
Yes, I'm available. Let me know the time!
```

**Brief Update:**
```
Done! Let me know if you need anything else.
```

**Casual Follow-up:**
```
Hi! Just checking in about [topic]. Let me know when you're free to discuss.
```

### Anti-Patterns
- Long formal messages on WhatsApp
- Overly professional tone for casual chat
- Multiple paragraphs for simple confirmations
