# Mnemonic Research Methodology

## Purpose

Guide to researching established medical mnemonics using the mnemonic-researcher agent.

---

## Research Sources (Priority Order)

### 1. r/medicalschool (Reddit)
**Why first:** Largest community, peer-reviewed by thousands of students
**Reliability:** High (5-star if 15+ confirmations)
**Access:** Web search

### 2. First Aid USMLE
**Why important:** Standard board prep resource
**Reliability:** Very high (official publication)
**Access:** Referenced in forums

### 3. Student Doctor Network (SDN)
**Why valuable:** Long-established medical student community
**Reliability:** High (peer-verified)
**Access:** Web search

### 4. Sketchy Medical
**Why useful:** Visual learning platform with mnemonics
**Reliability:** High (commercial product)
**Access:** Referenced in forums

### 5. Pathoma
**Why trusted:** Standard pathology resource
**Reliability:** High
**Access:** Referenced in forums

---

## Research Process

### Step 1: Search Strategy
```
1. Identify topic (e.g., "P450 inducers")
2. Search r/medicalschool for topic + "mnemonic"
3. Search SDN forums for topic
4. Look for First Aid references
5. Check Sketchy/Pathoma mentions
```

### Step 2: Evaluation Criteria
**For each mnemonic found:**
- User confirmations (how many students confirm it works?)
- Source reliability (Reddit upvotes, SDN replies, First Aid publication)
- Clarity (are components clearly defined?)
- Accuracy (do components match medical facts?)
- Appropriateness (professional, not offensive)

### Step 3: Ranking
**5-star (⭐⭐⭐⭐⭐):** 15+ confirmations, multiple sources
**4-star (⭐⭐⭐⭐):** 8-14 confirmations, 2+ sources
**3-star (⭐⭐⭐):** 3-7 confirmations, 1-2 sources
**2-star (⭐⭐):** 1-2 mentions, single source
**1-star (⭐):** Single unverified mention

---

## Output Format

**Provide top 3 mnemonics:**
```
1. "[Mnemonic]"
   - Source: [r/medicalschool / SDN / First Aid]
   - Reliability: [star rating]
   - Confirmations: [count]
   - Components: [breakdown]

2. [Second option]

3. [Third option]
```

---

## When No Mnemonics Found

**If research yields no results:**
- Report "No established mnemonics found"
- Don't invent one
- Student can create their own if desired

---

## Summary

**Research = Finding existing mnemonics, not creating new ones**

**Quality over quantity:** Better to have 1 well-verified mnemonic than 3 unverified ones

**Trust the community:** Medical students extensively share what works

---

**See also:**
- [Source Prioritization Guide](source-prioritization.md)
- [Validation Criteria](validation-criteria.md)
