---
name: mnemonics
description: Generate Hindi vocabulary mnemonics using strong visual imagery and sound matching
---

# Hindi Vocabulary Mnemonic Generator

Use this skill when the user asks you to create mnemonics for Hindi vocabulary words.

## Core Principles

1. **PHONETIC SOUND MATCHING (CRITICAL)**: English words must ACTUALLY SOUND LIKE the Hindi transliteration
   - Work from the transliteration (romanized pronunciation), NOT the Devanagari
   - Say the Hindi word out loud, then say your English mnemonic - do they rhyme/sound similar?
   - First syllable match is most important, but ONLY if it actually sounds alike!

2. **First syllable priority (flexible)**: The first syllable of the mnemonic word should almost perfectly match the first syllable of the target Hindi word
   - **EXCEPTION**: If a really strong match exists for the second syllable with a slightly off-key first syllable, this can be acceptable
   - **EXCEPTION**: If the phrase is a common idiom/expression whose overall meaning matches the target word, individual syllable-words don't need to carry the meaning

3. **DIRECT imagery**: The mnemonic words themselves should directly evoke the meaning, not through round-about connections
   - GOOD: "sun" → SOARING RAYS (rays directly relate to sun)
   - BAD: "sun" → SUE the RAJAH (suing a king has no direct connection to sun)
   - **EXCEPTION**: Idiomatic phrases where the phrase as a whole carries the meaning (see below)

4. **Complete coverage**: Include all syllables when possible (perfect matches not required for later syllables, but don't skip them unless truly difficult)

5. **Ideal outcome**: Capture multiple syllables with a single memorable phrase/image where the words directly describe or relate to the target meaning

## Mnemonic Structure

Each mnemonic should include:

- **Target word**: Hindi word in Devanagari with transliteration
- **Meaning**: English translation
- **Mnemonic phrase**: Capitalized sound-matching words with image
- **Sound mapping**: Show how mnemonic maps to Hindi syllables
- **Visual image**: Brief description of the memorable scene

## Example Format

**Word**: स्वादिष्ट (svādiṣṭ)
**Meaning**: delicious

**Mnemonic**: SWAllowing a DISH (of tea cakes)

**Sound mapping**: swa-DISH(-t) → स्वादिष्ट

**Image**: Someone so excited by the delicious smell that they swallow an entire dish of tea cakes in one gulp - dish and all! Their eyes bulge comically as the whole porcelain dish slides down their throat

---

**Idiomatic Phrase Examples** (where the whole phrase carries the meaning):

**Word**: आवाज़ (āvāz)
**Meaning**: voice, sound

**Mnemonic**: AS I VUZ saying
**Sound mapping**: AZ I VUZ → आवाज़ (with "I was" pronounced with slight lisp/German accent)
**Image**: Someone repeatedly saying "as I was saying" to regain attention - their voice trying to be heard

(Note: "As I was saying" is an idiomatic phrase about speaking/voice. The phrase as a whole conveys the meaning, even though individual words like "as" or "I" don't mean "voice")

---

**Word**: अंतिम (antim)
**Meaning**: final, last

**Mnemonic**: for the UMpTEENth time!
**Sound mapping**: UM-TEEN(th) → अंतिम
**Sound mapping**: UN-TEEM → अंतिम
**Image**: Someone exasperatedly saying "for the umpteenth time!" - implying this is the final warning

(Note: "For the umpteenth time" is an idiomatic expression conveying finality/lastness. First syllable match is slightly off, but strong second syllable match + idiomatic meaning makes it excellent)

---

**Good Example - Direct Imagery**:

**Word**: सूरज (sūraj)
**Meaning**: sun

**Option 1**: SOARING RAYS
**Sound mapping**: SŌR(-ing) RAYS → सूरज
**Image**: Rays of sunlight soaring upward from the horizon at dawn

**Option 2**: SUN RAYS
**Sound mapping**: SUN RAYS → सूरज
**Image**: The sun's rays streaming through clouds

(Note: The mnemonic words "soaring rays" and "sun rays" DIRECTLY describe aspects of the sun itself)

---

**Bad Example - Round-about Connections**:

**Word**: सूरज (sūraj)
**Meaning**: sun

**Option 1**: SUE the RAJAH
**Image**: A lawyer suing a rajah in an outdoor courtroom where the sun is blazing

(Note: This is BAD because "suing a king" has no direct connection to "sun" - the sun is only added as background scenery, not inherent to the mnemonic words)

---

## PHONETIC MATCHING: The Critical Foundation

**The #1 failure mode**: Creating mnemonics with words that DON'T ACTUALLY SOUND like the Hindi word!

### The Phonetic Matching Process

**MANDATORY WORKFLOW** - Follow these steps in order:

1. **Look at the transliteration** (romanized spelling) - e.g., "uṛnā"
2. **Sound it out phonetically** - e.g., "UR-naa"
3. **Break into syllables** - e.g., "UR" + "naa"
4. **Find English words that rhyme/sound like each syllable** - e.g., "YOUR", "EARN", "URN" all sound like "UR"
5. **VERIFY the match** - Say the Hindi word, then say your English phrase. Do they sound similar?
6. **Then (and only then) filter for meaning** - Which sound-matches also relate to the word's meaning?

### Examples of GOOD vs BAD Sound Matches

---

**Example 1: उड़ना (uṛnā) - "to fly"**

**PHONETIC BREAKDOWN**: UR-naa

**GOOD SOUND MATCHES**:
- ✅ YOUR-NAH (sounds like: UR-naa)
- ✅ EARN-AH (sounds like: UR-naa)
- ✅ URN-AH (sounds like: UR-naa)

**BAD SOUND MATCHES**:
- ❌ NAV-I-GAT-OR (sounds like: NAV-ih-gay-tor) - Doesn't rhyme with "UR-naa" AT ALL!
- ❌ FLY-ING (sounds like: FLY-ing) - Wrong sounds entirely, even though it means "fly"
- ❌ SOAR-ING (sounds like: SOR-ing) - Wrong initial sound (SOR vs UR)

**WHY the bad ones fail**: They don't sound like "uṛnā" when you say them out loud! Even if "navigator" relates to flying, it's useless if it doesn't match the sounds "UR-naa".

---

**Example 2: सूरज (sūraj) - "sun"**

**PHONETIC BREAKDOWN**: SOO-raj (or SŪ-raj)

**GOOD SOUND MATCHES**:
- ✅ SUE-RAGE (sounds like: SUE-raj) - "Sue" sounds like "sū"
- ✅ SOAR-RAJAH (sounds like: SOR-rah-jah) - Close to "sūraj"
- ✅ SO-RADGE (sounds like: SO-raj) - Matches the sounds

**BAD SOUND MATCHES**:
- ❌ SUN-RAYS (sounds like: SUN-rays) - "Sun" doesn't sound like "sū" or "soo"
- ❌ SHINE-ROGER (sounds like: SHINE-ROJ-er) - Wrong initial sound entirely

**NOTE**: Even though "SUN RAYS" relates perfectly to the meaning "sun", it fails because "SUN" doesn't sound like "SŪ". The first example in the skill file is actually problematic - "SOAR-ing RAYS" works because "SOAR" ≈ "SŪR", but "SUN RAYS" doesn't!

---

**Example 3: बाहर (bāhar) - "outside"**

**PHONETIC BREAKDOWN**: BAA-har

**GOOD SOUND MATCHES**:
- ✅ BAA-HAR (sheep sound + HAR) - Direct phonetic match
- ✅ BAR-HARD (sounds like: BAR-har) - Very close
- ✅BAAR (bar/tavern) - Matches first syllable strongly

**BAD SOUND MATCHES**:
- ❌ OUT-SIDE (sounds like: OUT-side) - Means "outside" but doesn't sound like "BAA-har"!
- ❌ EX-TER-NAL (sounds like: EKS-ter-nal) - Wrong sounds entirely
- ❌ BE-YOND (sounds like: BEE-yond) - Wrong sounds

---

### Sound Matching Guidelines

**CRITICAL CHECKS** before accepting a mnemonic:

1. ✅ **The Rhyme Test**: Say the Hindi word out loud, then say your English phrase. Do they rhyme or sound similar?

2. ✅ **The First Syllable Test**: Does your first English word start with a sound that's VERY close to the Hindi first syllable?
   - uṛnā (UR) → YOUR ✅, NAVIGATOR ❌
   - sūraj (SOO/SŪ) → SUE ✅, SUN ❌
   - bāhar (BAA) → BAA ✅, OUT ❌

3. ✅ **The False Friend Test**: Does your English word MEAN the right thing but SOUND wrong? If yes, reject it!
   - "to fly" → "FLYING" means right but sounds nothing like "uṛnā" ❌

**REMEMBER**: A mnemonic that means the right thing but sounds wrong is USELESS. Sound matching comes FIRST, meaning comes SECOND.

---

## Instructions

When the user provides Hindi vocabulary:

1. **FIRST: Analyze the PHONETIC sounds**
   - Look at the transliteration (romanized spelling)
   - Sound it out loud: what does it actually sound like?
   - Break into syllables phonetically

2. **SECOND: Find English words that SOUND like those syllables**
   - Generate a list of English words/sounds that rhyme with each syllable
   - Use the Phonetic Matching Process from the section above
   - Verify each match using the Rhyme Test and First Syllable Test

3. **THIRD: Filter for meaning**
   - From your sound-matched words, which ones relate to the target meaning?
   - Consider TWO approaches:
     - **Direct match**: Words that directly describe the meaning + match the sound
     - **Idiomatic match**: Common phrases/expressions whose overall meaning matches, even if individual words don't

4. **CRITICAL**: The mnemonic words must INHERENTLY evoke the meaning, not require adding unrelated imagery as "scenery"

5. **ALWAYS generate 5 different mnemonic options** for each word

6. **FLEXIBILITY**: Include 1-2 idiomatic phrase options if they provide excellent sound matches, even with slightly off first syllables

7. Present all 5 options in the format shown above

**REJECTION CRITERIA** - Discard any mnemonic that:
- Fails the Rhyme Test (doesn't sound like the Hindi word when spoken aloud)
- Fails the First Syllable Test (first English word doesn't match Hindi first syllable sound)
- Passes False Friend Test (means right but sounds wrong)

**IMPORTANT**:
- Always provide exactly 5 different mnemonic options for each Hindi word
- Most options should use direct imagery (words themselves relate to meaning)
- 1-2 options can use idiomatic phrases if the phrase as a whole conveys the meaning well
- Avoid round-about connections where the meaning is only added as background context

Focus on creating mnemonics that are (in priority order):
1. **Sound-accurate**: This is THE MOST CRITICAL - the English words must ACTUALLY SOUND like the Hindi transliteration! If it doesn't pass the Rhyme Test, it's useless!
2. **UNFORGETTABLE**: Boring mnemonics won't stick! Make them funny, shocking, absurd, or surprising
3. **Meaningful**: The image should clearly connect to the word's meaning
4. **Complete**: Cover all syllables when feasible

**PRIORITY HIERARCHY**: Sound matching > Memorability > Meaning coverage > Syllable completeness

## The Memorability Requirement

**CRITICAL**: A mnemonic that doesn't stick in your memory is useless. Each mnemonic must be:
- **Unusual** - Not just any ordinary phrase
- **Funny** - Humor makes things memorable
- **Shocking** - Unexpected or surprising elements help retention
- **Vivid** - Create a clear, striking mental image
- **Emotional** - Evoke a reaction (laughter, surprise, disgust, delight)

**Boring mnemonics to AVOID**:
- Plain descriptions without energy
- Generic phrases that don't evoke emotion
- Forgettable imagery

**Memorable mnemonics to AIM FOR**:
- Exaggerated, over-the-top scenarios
- Absurd combinations that make you laugh
- Slightly shocking or unexpected imagery
- Things that make you go "That's ridiculous... but I'll never forget it!"

## Tips for Strong Mnemonics

**STEP 1 - Sound Matching (DO THIS FIRST!)**:
- **Start with the sounds**: Look at the transliteration and say it out loud
- **Brainstorm rhymes**: List English words that sound like each syllable
- **Test the rhyme**: Say the Hindi word, then say your English word - do they rhyme?
- **Verify first syllable**: The first English word MUST sound very similar to the Hindi first syllable

**STEP 2 - Meaning Integration**:
- **Filter for meaning**: From your sound-matched words, which relate to the target meaning?
- **Consider idioms**: Think of common phrases/expressions that match both sound AND meaning
- **Direct imagery preferred**: Words that inherently relate to the meaning (not added as scenery)

**STEP 3 - Memorability Enhancement**:
- **Amp up the drama**: Use action verbs for dynamic, energetic imagery
- **Go extreme**: Exaggerate size, quantity, emotion, or absurdity
- **Add surprise**: Include unexpected twists or shocking elements
- **Make it ridiculous**: If it makes you chuckle or go "wow, that's weird," it's working
- Include sensory details (taste, touch, sight, sound, smell)

**FORMATTING**:
- Capitalize the sound-matching portions

**FINAL TESTS**:
- **RHYME TEST** (MANDATORY): Say Hindi word + English phrase aloud. Do they rhyme? If NO → reject!
- **TEST 1**: If you removed the image description, would the mnemonic words alone (or phrase as a whole) suggest the meaning? If not, find different words.
- **TEST 2**: Would you actually remember this a week from now? If not, make it more memorable!

## How to Avoid Round-about Connections

**Ask yourself**: Do the mnemonic words themselves relate to the meaning, or am I forcing a connection by adding the meaning as scenery in the image description?

**GOOD - Direct**: "sun" → SOARING RAYS (rays are literally part of what the sun is)
**GOOD - Idiomatic**: "voice" → AS I WAS SAYING (common phrase about speaking)
**GOOD - Idiomatic**: "final" → FOR THE UMPTEENTH TIME (expression conveying finality, even with slightly off first syllable but excellent second syllable match)

**BAD**: "sun" → SUE ROGER (suing someone has nothing to do with sun; the sun is added artificially to the scene)

**Strategy**:
1. **START WITH SOUNDS**: Look at the transliteration, say it aloud, break into phonetic syllables
2. **Brainstorm rhyming English words**: List words that SOUND like each syllable (ignore meaning for now)
3. **Filter for meaning**: Which sound-matched words relate to the target meaning?
4. **Amp up the memorability**: Make it funny, shocking, or absurd
5. **Verify with tests**: Run the Rhyme Test, First Syllable Test, and False Friend Test
6. **Reject failures**: If it doesn't sound right when spoken aloud, throw it out and start over

**NEVER**:
- ❌ Find meaning-matched words that don't sound like the Hindi (e.g., "FLYING" for उड़ना)
- ❌ Settle for boring imagery - keep pushing until it's unforgettable
- ❌ Skip the Rhyme Test - ALWAYS say it aloud to verify!

---

## Handling Rejections and Iterations

**CRITICAL**: When the user rejects your first set of mnemonics, DO NOT just give variations on the same words!

### What to Do When Mnemonics Are Rejected:

1. **ASSUME COMPLETE FAILURE**: Your previous approach didn't work - abandon those words entirely

2. **START FRESH**: Go back to the phonetic breakdown and brainstorm COMPLETELY DIFFERENT words
   - If you used "YOUR" before, try "URN", "EARN", "URBAN", etc.
   - If you used "SOAR" before, try "SURE", "SUE", "SEWER", etc.
   - Don't just rearrange or recombine the same words!

3. **EXPLORE DIFFERENT SOUND INTERPRETATIONS**:
   - Try alternate pronunciations (e.g., "sūraj" could be "SOO-raj" or "SUR-aj")
   - Consider different syllable breakdowns
   - Look for English words with similar sounds you didn't try before

4. **TRY DIFFERENT SEMANTIC ANGLES**:
   - If direct imagery didn't work, try idiomatic phrases
   - If idiomatic phrases didn't work, try more literal/direct words
   - Think of synonyms and related concepts for the meaning

5. **EXAMPLE - Wrong Approach** (what NOT to do):

   **Word**: उड़ना (uṛnā) - "to fly"

   ```
   First attempt: YOUR WINGS NAH
   Rejected ❌

   Second attempt (BAD):
   - YOUR WINGSPAN
   - YOUR WING-NUTS
   - YOUR WINGED NAG
   ❌ BAD - These all just recycle "YOUR" with slight variations!
   ```

6. **EXAMPLE - Right Approach** (what to do):

   **Word**: उड़ना (uṛnā) - "to fly"

   ```
   First attempt: YOUR WINGS NAH
   Rejected ❌

   Second attempt (GOOD):
   - URN of ASHES (cremated pilot's ashes in an urn that magically flies)
   - EARNED WINGS (pilot who earned their wings/license)
   - TURN UP in the air (suddenly turning up high in the sky)
   - YEARN to SOAR (yearning to fly high)
   ✅ GOOD - Completely different base words (URN, EARN, TURN, YEARN), all relating to flight!
   ```

### Exception: User Guidance

**ONLY reuse or modify previous words if**:
- The user explicitly says "try variations on X"
- The user says "X was close, tweak it"
- The user provides specific direction on what to keep/change

**DEFAULT BEHAVIOR**: Treat rejection as "start over with completely new words"

### Quick Reference:

**User rejects mnemonics** → Abandon all previous words → Brainstorm NEW rhyming words → Generate 5 completely fresh options
