# Mongoose - Aggregation

**Pages:** 5

---

## Aggregate

**URL:** https://mongoosejs.com/docs/5.x/docs/api/aggregate.html

**Contents:**
- Aggregate
  - Aggregate()
      - Parameters
    - Example:
    - Note:
  - Aggregate.prototype.Symbol.asyncIterator()
    - Example
  - Aggregate.prototype.addCursorFlag
      - Parameters
      - Returns:

Aggregate constructor used for building aggregation pipelines. Do not instantiate this class directly, use Model.aggregate() instead.

Returns an asyncIterator for use with [for/await/of loops](https://thecodebarbarian.com/getting-started-with-async-iterators-in-node-js You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not set if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

Sets an option on this aggregation. This function will be deprecated in a future release. Use the cursor(), collation(), etc. helpers to set individual options, or access agg.options directly.

Note that MongoDB aggregations do not support the noCursorTimeout flag, if you try setting that flag with this function you will get a "unrecognized field 'noCursorTimeout'" error.

Appends a new $addFields operator to this aggregate pipeline. Requires MongoDB v3.4+ to work

Sets the allowDiskUse option for the aggregation query (ignored for < 2.6.0)

Appends new operators to this aggregate pipeline

Executes the query returning a Promise which will be resolved with either the doc(s) or rejected with the error. Like .then(), but only takes a rejection handler.

Appends a new $count operator to this aggregate pipeline.

Sets the cursor option option for the aggregation query (ignored for < 2.6.0). Note the different syntax below: .exec() returns a cursor object, and no callback is necessary.

Executes the aggregate pipeline on the currently bound Model.

Execute the aggregation with explain

Combines multiple aggregation pipelines.

Appends new custom $graphLookup operator(s) to this aggregate pipeline, performing a recursive search on a collection.

Note that graphLookup can only consume at most 100MB of memory, and does not allow disk use even if { allowDiskUse: true } is specified.

Appends a new custom $group operator to this aggregate pipeline.

Sets the hint option for the aggregation query (ignored for < 3.6.0)

Appends a new $limit operator to this aggregate pipeline.

Appends new custom $lookup operator to this aggregate pipeline.

Appends a new custom $match operator to this aggregate pipeline.

Get/set the model that this aggregation will execute on.

Appends a new $geoNear operator to this aggregate pipeline.

MUST be used as the first operator in the pipeline.

Lets you set arbitrary options, for middleware or plugins.

Contains options passed down to the aggregate command.

Returns the current pipeline

Appends a new $project operator to this aggregate pipeline.

Mongoose query selection syntax is also supported.

Sets the readPreference option for the aggregation query.

Sets the readConcern level for the aggregation query.

Appends a new $redact operator to this aggregate pipeline.

If 3 arguments are supplied, Mongoose will wrap them with if-then-else of $cond operator respectively If thenExpr or elseExpr is string, make sure it starts with $$, like $$DESCEND, $$PRUNE or $$KEEP.

Appends a new $replaceRoot operator to this aggregate pipeline.

Note that the $replaceRoot operator requires field strings to start with '$'. If you are passing in a string Mongoose will prepend '$' if the specified field doesn't start '$'. If you are passing in an object the strings in your expression will not be altered.

Appends new custom $sample operator to this aggregate pipeline.

Helper for Atlas Text Search's $search stage.

Sets the session for this aggregation. Useful for transactions.

Appends a new $skip operator to this aggregate pipeline.

Appends a new $sort operator to this aggregate pipeline.

If an object is passed, values allowed are asc, desc, ascending, descending, 1, and -1.

If a string is passed, it must be a space delimited list of path names. The sort order of each path is ascending unless the path name is prefixed with - which will be treated as descending.

Appends a new $sortByCount operator to this aggregate pipeline. Accepts either a string field name or a pipeline object.

Note that the $sortByCount operator requires the new root to start with '$'. Mongoose will prepend '$' if the specified field name doesn't start with '$'.

Provides promise for aggregate.

Appends new custom $unwind operator(s) to this aggregate pipeline.

Note that the $unwind operator requires the path name to start with '$'. Mongoose will prepend '$' if the specified field doesn't start '$'.

**Examples:**

Example 1 (json):
```json
const aggregate = Model.aggregate([
  { $project: { a: 1, b: 1 } },
  { $skip: 5 }
]);

Model.
  aggregate([{ $match: { age: { $gte: 21 }}}]).
  unwind('tags').
  exec(callback);
```

Example 2 (javascript):
```javascript
const agg = Model.aggregate([{ $match: { age: { $gte: 25 } } }]);
for await (const doc of agg) {
  console.log(doc.name);
}
```

Example 3 (css):
```css
// adding new fields based on existing fields
aggregate.addFields({
    newField: '$b.nested'
  , plusTen: { $add: ['$val', 10]}
  , sub: {
       name: '$a'
    }
})

// etc
aggregate.addFields({ salary_k: { $divide: [ "$salary", 1000 ] } });
```

Example 4 (css):
```css
await Model.aggregate([{ $match: { foo: 'bar' } }]).allowDiskUse(true);
```

---

## Model

**URL:** https://mongoosejs.com/docs/5.x/docs/api/model.html

**Contents:**
- Model
  - Model()
      - Parameters
      - Inherits:
    - Example:
  - Model.aggregate()
      - Parameters
      - Returns:
    - Example:
    - NOTE:

A Model is a class that's your primary tool for interacting with MongoDB. An instance of a Model is called a Document.

In Mongoose, the term "Model" refers to subclasses of the mongoose.Model class. You should not use the mongoose.Model class directly. The mongoose.model() and connection.model() functions create subclasses of mongoose.Model as shown below.

Performs aggregations on the models collection.

If a callback is passed, the aggregate is executed and a Promise is returned. If a callback is not passed, the aggregate itself is returned.

This function triggers the following middleware.

@param {[Document]} documents The array of documents to build write operations of

takes an array of documents, gets the changes and inserts/updates documents in the database according to whether or not the document is new, or whether it has changes or not.

bulkSave uses bulkWrite under the hood, so it's mostly useful when dealing with many documents (10K+)

Sends multiple insertOne, updateOne, updateMany, replaceOne, deleteOne, and/or deleteMany operations to the MongoDB server in one command. This is faster than sending multiple independent operations (e.g. if you use create()) because with bulkWrite() there is only one round trip to MongoDB.

Mongoose will perform casting on all operations you provide.

This function does not trigger any middleware, neither save(), nor update(). If you need to trigger save() middleware for every document use create() instead.

The supported operations are:

Deletes all indexes that aren't defined in this model's schema. Used by syncIndexes().

The returned promise resolves to a list of the dropped indexes' names as an array

Counts number of documents that match filter in a database collection.

This method is deprecated. If you want to count the number of documents in a collection, e.g. count({}), use the estimatedDocumentCount() function instead. Otherwise, use the countDocuments() function instead.

Counts number of documents matching filter in a database collection.

If you want to count all documents in a large collection, use the estimatedDocumentCount() function instead. If you call countDocuments({}), MongoDB will always execute a full collection scan and not use any indexes.

The countDocuments() function is similar to count(), but there are a few operators that countDocuments() does not support. Below are the operators that count() supports but countDocuments() does not, and the suggested replacement:

Shortcut for saving one or more documents to the database. MyModel.create(docs) does new MyModel(doc).save() for every doc in docs.

This function triggers the following middleware.

Create the collection for this model. By default, if no indexes are specified, mongoose will not create the collection for the model until any documents are created. Use this method to create the collection explicitly.

Note 1: You may need to call this before starting a transaction See https://docs.mongodb.com/manual/core/transactions/#transactions-and-operations

Note 2: You don't have to call this if your schema contains index or unique field. In that case, just use Model.init()

Similar to ensureIndexes(), except for it uses the createIndex function.

Deletes all of the documents that match conditions from the collection. Behaves like remove(), but deletes all documents that match conditions regardless of the single option.

This function triggers deleteMany query hooks. Read the middleware docs to learn more.

Deletes the first document that matches conditions from the collection. Behaves like remove(), but deletes at most one document regardless of the single option.

This function triggers deleteOne query hooks. Read the middleware docs to learn more.

Does a dry-run of Model.syncIndexes(), meaning that the result of this function would be the result of Model.syncIndexes().

Adds a discriminator type.

Creates a Query for a distinct operation.

Passing a callback executes the query.

Sends createIndex commands to mongo for each index declared in the schema. The createIndex commands are sent in series.

After completion, an index event is emitted on this Model passing an error if one occurred.

NOTE: It is not recommended that you run this in production. Index creation may impact database performance depending on your load. Use with caution.

Estimates the number of documents in the MongoDB collection. Faster than using countDocuments() for large collections because estimatedDocumentCount() uses collection metadata rather than scanning the entire collection.

Event emitter that reports any errors that occurred. Useful for global error handling.

Returns true if at least one document exists in the database that matches the given filter, and false otherwise.

Under the hood, MyModel.exists({ answer: 42 }) is equivalent to MyModel.findOne({ answer: 42 }).select({ _id: 1 }).lean().then(doc => !!doc)

This function triggers the following middleware.

Mongoose casts the filter to match the model's schema before the command is sent. See our query casting tutorial for more information on how Mongoose casts filter.

Finds a single document by its _id field. findById(id) is almost* equivalent to findOne({ _id: id }). If you want to query by a document's _id, use findById() instead of findOne().

The id is cast based on the Schema before sending the command.

This function triggers the following middleware.

* Except for how it treats undefined. If you use findOne(), you'll see that findOne(undefined) and findOne({ _id: undefined }) are equivalent to findOne({}) and return arbitrary documents. However, mongoose translates findById(undefined) into findOne({ _id: null }).

Issue a MongoDB findOneAndDelete() command by a document's _id field. In other words, findByIdAndDelete(id) is a shorthand for findOneAndDelete({ _id: id }).

This function triggers the following middleware.

Issue a mongodb findAndModify remove command by a document's _id field. findByIdAndRemove(id, ...) is equivalent to findOneAndRemove({ _id: id }, ...).

Finds a matching document, removes it, passing the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

Issues a mongodb findAndModify update command by a document's _id field. findByIdAndUpdate(id, ...) is equivalent to findOneAndUpdate({ _id: id }, ...).

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed.

This function triggers the following middleware.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

The conditions are cast to their respective SchemaTypes before the command is sent.

Note: conditions is optional, and if conditions is null or undefined, mongoose will send an empty findOne command to MongoDB, which will return an arbitrary document. If you're querying by _id, use findById() instead.

Issue a MongoDB findOneAndDelete() command.

Finds a matching document, removes it, and passes the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

This function differs slightly from Model.findOneAndRemove() in that findOneAndRemove() becomes a MongoDB findAndModify() command, as opposed to a findOneAndDelete() command. For most mongoose use cases, this distinction is purely pedantic. You should use findOneAndDelete() unless you have a good reason not to.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a mongodb findAndModify remove command.

Finds a matching document, removes it, passing the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a MongoDB findOneAndReplace() command.

Finds a matching document, replaces it with the provided doc, and passes the returned doc to the callback.

Executes the query if callback is passed.

This function triggers the following query middleware.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

Issues a mongodb findAndModify update command.

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed else a Query object is returned.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Implements $geoSearch functionality for Mongoose

This function does not trigger any middleware

Shortcut for creating a new Document from existing raw data, pre-saved in the DB. The document returned has no paths marked as modified initially.

This function is responsible for building indexes, unless autoIndex is turned off.

Mongoose calls this function automatically when a model is created using mongoose.model() or connection.model(), so you don't need to call it. This function is also idempotent, so you may call it to get back a promise that will resolve when your indexes are finished building as an alternative to MyModel.on('index')

Shortcut for validating an array of documents and inserting them into MongoDB if they're all valid. This function is faster than .create() because it only sends one operation to the server, rather than one for each document.

Mongoose always validates each document before sending insertMany to MongoDB. So if one document has a validation error, no documents will be saved, unless you set the ordered option to false.

This function does not trigger save middleware.

This function triggers the following middleware.

Helper for console.log. Given a model named 'MyModel', returns the string 'Model { MyModel }'.

Lists the indexes currently defined in MongoDB. This may or may not be the same as the indexes defined in your schema depending on whether you use the autoIndex option and if you build indexes manually.

Executes a mapReduce command.

o is an object specifying all mapReduce options as well as the map and reduce functions. All options are delegated to the driver implementation. See node-mongodb-native mapReduce() documentation for more detail about options.

This function does not trigger any middleware.

If options.out is set to replace, merge, or reduce, a Model instance is returned that can be used for further querying. Queries run against this model are all executed with the lean option; meaning only the js object is returned and no Mongoose magic is applied (getters, setters, etc).

Populates document references.

Additional properties to attach to the query when calling save() and isNew is false.

Creates a Query and specifies a $where condition.

Sometimes you need to query for things in mongodb using a JavaScript expression. You can do so via find({ $where: javascript }), or you can use the mongoose shortcut method $where via a Query chain or from your mongoose Model.

Base Mongoose instance the model uses.

If this is a discriminator model, baseModelName is the name of the base model.

Collection the model uses.

This property is read-only. Modifying this property is a no-op.

Connection the model uses.

Removes this document from the db. Equivalent to .remove().

Registered discriminators for this model.

Returns another Model instance.

The name of the model

Removes this document from the db.

As an extra measure of flow control, remove will return a Promise (bound to fn if passed) so it could be chained, or hooked to recieve errors

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation with just the modified paths if isNew is false.

If save is successful, the returned promise will fulfill with the document saved.

Schema the model uses.

Removes all documents that match conditions from the collection. To remove just the first document that matches conditions, set the single option to true.

This method sends a remove command directly to MongoDB, no Mongoose documents are involved. Because no Mongoose documents are involved, Mongoose does not execute document middleware.

Same as update(), except MongoDB replace the existing document with the given document (no atomic operators like $set).

This function triggers the following middleware.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling MyModel.startSession() is equivalent to calling MyModel.db.startSession().

This function does not trigger any middleware.

Makes the indexes in MongoDB match the indexes defined in this model's schema. This function will drop any indexes that are not defined in the model's schema except the _id index, and build any indexes that are in your schema but not in MongoDB.

See the introductory blog post for more information.

Translate any aliases fields/conditions so the final query or document object is pure

Only translate arguments of object type anything else is returned raw

Updates one document in the database without returning it.

This function triggers the following middleware.

All update values are cast to their appropriate SchemaTypes before being sent.

The callback function receives (err, rawResponse).

All top level keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting all documents in your collection with { name: 'jason bourne' }.

Be careful to not use an existing model instance for the update clause (this won't work and can cause weird behavior like infinite loops). Also, ensure that the update clause does not have an _id property, which causes Mongo to return a "Mod on _id not allowed" error.

Mongoose casts values and runs setters when using update. The following features are not applied by default.

If you need document middleware and fully-featured validation, load the document first and then use save().

Same as update(), except MongoDB will update all documents that match filter (as opposed to just the first one) regardless of the value of the multi option.

Note updateMany will not fire update middleware. Use pre('updateMany') and post('updateMany') instead.

This function triggers the following middleware.

Same as update(), except it does not support the multi or overwrite options.

This function triggers the following middleware.

Casts and validates the given object against this model's schema, passing the given context to custom validators.

Requires a replica set running MongoDB >= 3.6.0. Watches the underlying collection for changes using MongoDB change streams.

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

Creates a Query, applies the passed conditions, and returns the Query.

For example, instead of writing:

we can instead write:

Since the Query class also supports where you can continue chaining

Signal that we desire an increment of this documents version.

**Examples:**

Example 1 (javascript):
```javascript
// `UserModel` is a "Model", a subclass of `mongoose.Model`.
const UserModel = mongoose.model('User', new Schema({ name: String }));

// You can use a Model to create new documents using `new`:
const userDoc = new UserModel({ name: 'Foo' });
await userDoc.save();

// You also use a model to create queries:
const userFromDb = await UserModel.findOne({ name: 'Foo' });
```

Example 2 (json):
```json
// Find the max balance of all accounts
Users.aggregate([
  { $group: { _id: null, maxBalance: { $max: '$balance' }}},
  { $project: { _id: 0, maxBalance: 1 }}
]).
then(function (res) {
  console.log(res); // [ { maxBalance: 98000 } ]
});

// Or use the aggregation pipeline builder.
Users.aggregate().
  group({ _id: null, maxBalance: { $max: '$balance' } }).
  project('-id maxBalance').
  exec(function (err, res) {
    if (err) return handleError(err);
    console.log(res); // [ { maxBalance: 98 } ]
  });
```

Example 3 (javascript):
```javascript
Character.bulkWrite([
  {
    insertOne: {
      document: {
        name: 'Eddard Stark',
        title: 'Warden of the North'
      }
    }
  },
  {
    updateOne: {
      filter: { name: 'Eddard Stark' },
      // If you were using the MongoDB driver directly, you'd need to do
      // `update: { $set: { title: ... } }` but mongoose adds $set for
      // you.
      update: { title: 'Hand of the King' }
    }
  },
  {
    deleteOne: {
      {
        filter: { name: 'Eddard Stark' }
      }
    }
  }
]).then(res => {
 // Prints "1 1 1"
 console.log(res.insertedCount, res.modifiedCount, res.deletedCount);
});
```

Example 4 (css):
```css
Adventure.count({ type: 'jungle' }, function (err, count) {
  if (err) ..
  console.log('there are %d jungle adventures', count);
});
```

---

## Aggregate

**URL:** https://mongoosejs.com/docs/api/aggregate.html

**Contents:**
- Aggregate
  - Aggregate()
      - Parameters:
      - See:
    - Example:
    - Note:
  - Aggregate.prototype.addFields()
      - Parameters:
      - Returns:
      - See:

Aggregate constructor used for building aggregation pipelines. Do not instantiate this class directly, use Model.aggregate() instead.

The documents returned are plain javascript objects, not mongoose documents (since any shape of document can be returned).

Mongoose does not cast pipeline stages. The below will not work unless _id is a string in the database

new Aggregate([{ $match: { _id: '00000000000000000000000a' } }]); // Do this instead to cast to an ObjectId new Aggregate([{ $match: { _id: new mongoose.Types.ObjectId('00000000000000000000000a') } }]);

Appends a new $addFields operator to this aggregate pipeline. Requires MongoDB v3.4+ to work

Sets the allowDiskUse option for the aggregation query

Appends new operators to this aggregate pipeline

Executes the aggregation returning a Promise which will be resolved with either the doc(s) or rejected with the error. Like .then(), but only takes a rejection handler. Compatible with await.

Appends a new $count operator to this aggregate pipeline.

Sets the cursor option and executes this aggregation, returning an aggregation cursor. Cursors are useful if you want to process the results of the aggregation one-at-a-time because the aggregation result is too big to fit into memory.

Appends a new $densify operator to this aggregate pipeline.

Executes the aggregate pipeline on the currently bound Model.

Execute the aggregation with explain

Combines multiple aggregation pipelines.

Appends a new $fill operator to this aggregate pipeline.

Executes the aggregate returning a Promise which will be resolved with .finally() chained.

More about Promise finally() in JavaScript.

Appends new custom $graphLookup operator(s) to this aggregate pipeline, performing a recursive search on a collection.

Note that graphLookup can only consume at most 100MB of memory, and does not allow disk use even if { allowDiskUse: true } is specified.

Appends a new custom $group operator to this aggregate pipeline.

Sets the hint option for the aggregation query

Appends a new $limit operator to this aggregate pipeline.

Appends new custom $lookup operator to this aggregate pipeline.

Appends a new custom $match operator to this aggregate pipeline.

Get/set the model that this aggregation will execute on.

Appends a new $geoNear operator to this aggregate pipeline.

MUST be used as the first operator in the pipeline.

Lets you set arbitrary options, for middleware or plugins.

Contains options passed down to the aggregate command. Supported options are:

Returns the current pipeline

Appends a new $project operator to this aggregate pipeline.

Mongoose query selection syntax is also supported.

Sets the readPreference option for the aggregation query.

Sets the readConcern level for the aggregation query.

Appends a new $redact operator to this aggregate pipeline.

If 3 arguments are supplied, Mongoose will wrap them with if-then-else of $cond operator respectively If thenExpr or elseExpr is string, make sure it starts with $$, like $$DESCEND, $$PRUNE or $$KEEP.

Appends a new $replaceRoot operator to this aggregate pipeline.

Note that the $replaceRoot operator requires field strings to start with '$'. If you are passing in a string Mongoose will prepend '$' if the specified field doesn't start '$'. If you are passing in an object the strings in your expression will not be altered.

Appends new custom $sample operator to this aggregate pipeline.

Helper for Atlas Text Search's $search stage.

Sets the session for this aggregation. Useful for transactions.

Appends a new $skip operator to this aggregate pipeline.

Appends a new $sort operator to this aggregate pipeline.

If an object is passed, values allowed are asc, desc, ascending, descending, 1, and -1.

If a string is passed, it must be a space delimited list of path names. The sort order of each path is ascending unless the path name is prefixed with - which will be treated as descending.

Appends a new $sortByCount operator to this aggregate pipeline. Accepts either a string field name or a pipeline object.

Note that the $sortByCount operator requires the new root to start with '$'. Mongoose will prepend '$' if the specified field name doesn't start with '$'.

Provides a Promise-like then function, which will call .exec without a callback Compatible with await.

Appends new $unionWith operator to this aggregate pipeline.

Appends new custom $unwind operator(s) to this aggregate pipeline.

Note that the $unwind operator requires the path name to start with '$'. Mongoose will prepend '$' if the specified field doesn't start '$'.

Returns an asyncIterator for use with for/await/of loops You do not need to call this function explicitly, the JavaScript runtime will call it for you.

**Examples:**

Example 1 (json):
```json
const aggregate = Model.aggregate([
  { $project: { a: 1, b: 1 } },
  { $skip: 5 }
]);

Model.
  aggregate([{ $match: { age: { $gte: 21 }}}]).
  unwind('tags').
  exec();
```

Example 2 (css):
```css
// adding new fields based on existing fields
aggregate.addFields({
    newField: '$b.nested'
  , plusTen: { $add: ['$val', 10]}
  , sub: {
       name: '$a'
    }
})

// etc
aggregate.addFields({ salary_k: { $divide: [ "$salary", 1000 ] } });
```

Example 3 (css):
```css
await Model.aggregate([{ $match: { foo: 'bar' } }]).allowDiskUse(true);
```

Example 4 (css):
```css
aggregate.append({ $project: { field: 1 }}, { $limit: 2 });

// or pass an array
const pipeline = [{ $match: { daw: 'Logic Audio X' }} ];
aggregate.append(pipeline);
```

---

## Aggregate

**URL:** https://mongoosejs.com/docs/6.x/docs/api/aggregate.html

**Contents:**
- Aggregate
  - Aggregate()
      - Parameters:
      - See:
    - Example:
    - Note:
  - Aggregate.prototype.addFields()
      - Parameters:
      - Returns:
      - See:

Aggregate constructor used for building aggregation pipelines. Do not instantiate this class directly, use Model.aggregate() instead.

The documents returned are plain javascript objects, not mongoose documents (since any shape of document can be returned).

Mongoose does not cast pipeline stages. The below will not work unless _id is a string in the database

new Aggregate([{ $match: { _id: '00000000000000000000000a' } }]); // Do this instead to cast to an ObjectId new Aggregate([{ $match: { _id: new mongoose.Types.ObjectId('00000000000000000000000a') } }]);

Appends a new $addFields operator to this aggregate pipeline. Requires MongoDB v3.4+ to work

Sets the allowDiskUse option for the aggregation query

Appends new operators to this aggregate pipeline

Executes the query returning a Promise which will be resolved with either the doc(s) or rejected with the error. Like .then(), but only takes a rejection handler. Compatible with await.

Appends a new $count operator to this aggregate pipeline.

Sets the cursor option and executes this aggregation, returning an aggregation cursor. Cursors are useful if you want to process the results of the aggregation one-at-a-time because the aggregation result is too big to fit into memory.

Appends a new $densify operator to this aggregate pipeline.

Executes the aggregate pipeline on the currently bound Model.

Execute the aggregation with explain

Combines multiple aggregation pipelines.

Appends a new $fill operator to this aggregate pipeline.

Appends new custom $graphLookup operator(s) to this aggregate pipeline, performing a recursive search on a collection.

Note that graphLookup can only consume at most 100MB of memory, and does not allow disk use even if { allowDiskUse: true } is specified.

Appends a new custom $group operator to this aggregate pipeline.

Sets the hint option for the aggregation query

Appends a new $limit operator to this aggregate pipeline.

Appends new custom $lookup operator to this aggregate pipeline.

Appends a new custom $match operator to this aggregate pipeline.

Get/set the model that this aggregation will execute on.

Appends a new $geoNear operator to this aggregate pipeline.

MUST be used as the first operator in the pipeline.

Lets you set arbitrary options, for middleware or plugins.

Contains options passed down to the aggregate command. Supported options are:

Returns the current pipeline

Appends a new $project operator to this aggregate pipeline.

Mongoose query selection syntax is also supported.

Sets the readPreference option for the aggregation query.

Sets the readConcern level for the aggregation query.

Appends a new $redact operator to this aggregate pipeline.

If 3 arguments are supplied, Mongoose will wrap them with if-then-else of $cond operator respectively If thenExpr or elseExpr is string, make sure it starts with $$, like $$DESCEND, $$PRUNE or $$KEEP.

Appends a new $replaceRoot operator to this aggregate pipeline.

Note that the $replaceRoot operator requires field strings to start with '$'. If you are passing in a string Mongoose will prepend '$' if the specified field doesn't start '$'. If you are passing in an object the strings in your expression will not be altered.

Appends new custom $sample operator to this aggregate pipeline.

Helper for Atlas Text Search's $search stage.

Sets the session for this aggregation. Useful for transactions.

Appends a new $skip operator to this aggregate pipeline.

Appends a new $sort operator to this aggregate pipeline.

If an object is passed, values allowed are asc, desc, ascending, descending, 1, and -1.

If a string is passed, it must be a space delimited list of path names. The sort order of each path is ascending unless the path name is prefixed with - which will be treated as descending.

Appends a new $sortByCount operator to this aggregate pipeline. Accepts either a string field name or a pipeline object.

Note that the $sortByCount operator requires the new root to start with '$'. Mongoose will prepend '$' if the specified field name doesn't start with '$'.

Provides a Promise-like then function, which will call .exec without a callback Compatible with await.

Appends new $unionWith operator to this aggregate pipeline.

Appends new custom $unwind operator(s) to this aggregate pipeline.

Note that the $unwind operator requires the path name to start with '$'. Mongoose will prepend '$' if the specified field doesn't start '$'.

Returns an asyncIterator for use with for/await/of loops You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not set if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

**Examples:**

Example 1 (json):
```json
const aggregate = Model.aggregate([
  { $project: { a: 1, b: 1 } },
  { $skip: 5 }
]);

Model.
  aggregate([{ $match: { age: { $gte: 21 }}}]).
  unwind('tags').
  exec(callback);
```

Example 2 (css):
```css
// adding new fields based on existing fields
aggregate.addFields({
    newField: '$b.nested'
  , plusTen: { $add: ['$val', 10]}
  , sub: {
       name: '$a'
    }
})

// etc
aggregate.addFields({ salary_k: { $divide: [ "$salary", 1000 ] } });
```

Example 3 (css):
```css
await Model.aggregate([{ $match: { foo: 'bar' } }]).allowDiskUse(true);
```

Example 4 (css):
```css
aggregate.append({ $project: { field: 1 }}, { $limit: 2 });

// or pass an array
const pipeline = [{ $match: { daw: 'Logic Audio X' }} ];
aggregate.append(pipeline);
```

---

## Aggregate

**URL:** https://mongoosejs.com/docs/7.x/docs/api/aggregate.html

**Contents:**
- Aggregate
  - Aggregate()
      - Parameters:
      - See:
    - Example:
    - Note:
  - Aggregate.prototype.addFields()
      - Parameters:
      - Returns:
      - See:

Aggregate constructor used for building aggregation pipelines. Do not instantiate this class directly, use Model.aggregate() instead.

The documents returned are plain javascript objects, not mongoose documents (since any shape of document can be returned).

Mongoose does not cast pipeline stages. The below will not work unless _id is a string in the database

new Aggregate([{ $match: { _id: '00000000000000000000000a' } }]); // Do this instead to cast to an ObjectId new Aggregate([{ $match: { _id: new mongoose.Types.ObjectId('00000000000000000000000a') } }]);

Appends a new $addFields operator to this aggregate pipeline. Requires MongoDB v3.4+ to work

Sets the allowDiskUse option for the aggregation query

Appends new operators to this aggregate pipeline

Executes the aggregation returning a Promise which will be resolved with either the doc(s) or rejected with the error. Like .then(), but only takes a rejection handler. Compatible with await.

Appends a new $count operator to this aggregate pipeline.

Sets the cursor option and executes this aggregation, returning an aggregation cursor. Cursors are useful if you want to process the results of the aggregation one-at-a-time because the aggregation result is too big to fit into memory.

Appends a new $densify operator to this aggregate pipeline.

Executes the aggregate pipeline on the currently bound Model.

Execute the aggregation with explain

Combines multiple aggregation pipelines.

Appends a new $fill operator to this aggregate pipeline.

Executes the aggregate returning a Promise which will be resolved with .finally() chained.

More about Promise finally() in JavaScript.

Appends new custom $graphLookup operator(s) to this aggregate pipeline, performing a recursive search on a collection.

Note that graphLookup can only consume at most 100MB of memory, and does not allow disk use even if { allowDiskUse: true } is specified.

Appends a new custom $group operator to this aggregate pipeline.

Sets the hint option for the aggregation query

Appends a new $limit operator to this aggregate pipeline.

Appends new custom $lookup operator to this aggregate pipeline.

Appends a new custom $match operator to this aggregate pipeline.

Get/set the model that this aggregation will execute on.

Appends a new $geoNear operator to this aggregate pipeline.

MUST be used as the first operator in the pipeline.

Lets you set arbitrary options, for middleware or plugins.

Contains options passed down to the aggregate command. Supported options are:

Returns the current pipeline

Appends a new $project operator to this aggregate pipeline.

Mongoose query selection syntax is also supported.

Sets the readPreference option for the aggregation query.

Sets the readConcern level for the aggregation query.

Appends a new $redact operator to this aggregate pipeline.

If 3 arguments are supplied, Mongoose will wrap them with if-then-else of $cond operator respectively If thenExpr or elseExpr is string, make sure it starts with $$, like $$DESCEND, $$PRUNE or $$KEEP.

Appends a new $replaceRoot operator to this aggregate pipeline.

Note that the $replaceRoot operator requires field strings to start with '$'. If you are passing in a string Mongoose will prepend '$' if the specified field doesn't start '$'. If you are passing in an object the strings in your expression will not be altered.

Appends new custom $sample operator to this aggregate pipeline.

Helper for Atlas Text Search's $search stage.

Sets the session for this aggregation. Useful for transactions.

Appends a new $skip operator to this aggregate pipeline.

Appends a new $sort operator to this aggregate pipeline.

If an object is passed, values allowed are asc, desc, ascending, descending, 1, and -1.

If a string is passed, it must be a space delimited list of path names. The sort order of each path is ascending unless the path name is prefixed with - which will be treated as descending.

Appends a new $sortByCount operator to this aggregate pipeline. Accepts either a string field name or a pipeline object.

Note that the $sortByCount operator requires the new root to start with '$'. Mongoose will prepend '$' if the specified field name doesn't start with '$'.

Provides a Promise-like then function, which will call .exec without a callback Compatible with await.

Appends new $unionWith operator to this aggregate pipeline.

Appends new custom $unwind operator(s) to this aggregate pipeline.

Note that the $unwind operator requires the path name to start with '$'. Mongoose will prepend '$' if the specified field doesn't start '$'.

Returns an asyncIterator for use with for/await/of loops You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not set if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

**Examples:**

Example 1 (json):
```json
const aggregate = Model.aggregate([
  { $project: { a: 1, b: 1 } },
  { $skip: 5 }
]);

Model.
  aggregate([{ $match: { age: { $gte: 21 }}}]).
  unwind('tags').
  exec();
```

Example 2 (css):
```css
// adding new fields based on existing fields
aggregate.addFields({
    newField: '$b.nested'
  , plusTen: { $add: ['$val', 10]}
  , sub: {
       name: '$a'
    }
})

// etc
aggregate.addFields({ salary_k: { $divide: [ "$salary", 1000 ] } });
```

Example 3 (css):
```css
await Model.aggregate([{ $match: { foo: 'bar' } }]).allowDiskUse(true);
```

Example 4 (css):
```css
aggregate.append({ $project: { field: 1 }}, { $limit: 2 });

// or pass an array
const pipeline = [{ $match: { daw: 'Logic Audio X' }} ];
aggregate.append(pipeline);
```

---
