# Mongoose - Api Reference

**Pages:** 46

---

## Mongoose

**URL:** https://mongoosejs.com/docs/7.x/docs/api/mongoose.html

**Contents:**
- Mongoose
  - Mongoose()
      - Parameters:
    - Example:
  - Mongoose.prototype.Aggregate()
  - Mongoose.prototype.CastError()
      - Parameters:
  - Mongoose.prototype.Collection()
  - Mongoose.prototype.Connection()
  - Mongoose.prototype.ConnectionStates

Mongoose constructor.

The exports object of the mongoose module is an instance of this class. Most apps will only use this one instance.

The Mongoose Aggregate constructor

The Mongoose CastError constructor

The Mongoose Collection constructor

The Mongoose Connection constructor

Expose connection states for user-land

The Mongoose Date SchemaType.

The Mongoose Decimal128 SchemaType. Used for declaring paths in your schema that should be 128-bit decimal floating points. Do not use this to create a new Decimal128 instance, use mongoose.Types.Decimal128 instead.

The Mongoose Document constructor.

The Mongoose DocumentProvider constructor. Mongoose users should not have to use this directly

The MongooseError constructor.

The Mongoose Mixed SchemaType. Used for declaring paths in your schema that Mongoose's change tracking, casting, and validation should ignore.

The Mongoose Model constructor.

The Mongoose constructor

The exports of the mongoose module is an instance of this class.

The Mongoose Number SchemaType. Used for declaring paths in your schema that Mongoose should cast to numbers.

The Mongoose ObjectId SchemaType. Used for declaring paths in your schema that should be MongoDB ObjectIds. Do not use this to create a new ObjectId instance, use mongoose.Types.ObjectId instead.

The Mongoose Query constructor.

Expose connection states for user-land

The Mongoose Schema constructor

The Mongoose SchemaType constructor

The constructor used for schematype options

The various Mongoose SchemaTypes.

Alias of mongoose.Schema.Types for backwards compatibility.

The various Mongoose Types.

Using this exposed access to the ObjectId type, we can construct ids on demand.

The Mongoose VirtualType constructor

Opens the default mongoose connection.

The Mongoose module's default connection. Equivalent to mongoose.connections[0], see connections.

This is the connection used by default for every model created using mongoose.model.

To create a new connection, use createConnection().

An array containing all connections associated with this Mongoose instance. By default, there is 1 connection. Calling createConnection() adds a connection to this array.

Creates a Connection instance.

Each connection instance maps to a single database. This method is helpful when managing multiple db connections.

Options passed take precedence over options included in connection strings.

Removes the model named name from the default connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Equivalent to mongoose.connection.deleteModel(name).

Runs .close() on all connections in parallel.

Object with get() and set() containing the underlying driver this Mongoose instance uses to communicate with the database. A driver is a Mongoose-specific interface that defines functions like find().

Gets mongoose options

Returns true if the given value is a Mongoose ObjectId (using instanceof) or if the given value is a 24 character hex string, which is the most commonly used string representation of an ObjectId.

This function is similar to isValidObjectId(), but considerably more strict, because isValidObjectId() will return true for any value that Mongoose can convert to an ObjectId. That includes Mongoose documents, any string of length 12, and any number. isObjectIdOrHexString() returns true only for ObjectId instances or 24 character hex strings, and will return false for numbers, documents, and strings of length 12.

Returns true if Mongoose can cast the given value to an ObjectId, or false otherwise.

Defines a model or retrieves it.

Models defined on the mongoose instance are available to all connection created by the same mongoose instance.

If you call mongoose.model() with twice the same name but a different schema, you will get an OverwriteModelError. If you call mongoose.model() with the same name and same schema, you'll get the same schema back.

When no collection argument is passed, Mongoose uses the model name. If you don't like this behavior, either pass a collection name, use mongoose.pluralize(), or set your schemas collection name option.

Returns an array of model names created on this instance of Mongoose.

Does not include names of models created using connection.model().

The node-mongodb-native driver Mongoose uses.

The mquery query builder Mongoose uses.

Mongoose uses this function to get the current time when setting timestamps. You may stub out this function using a tool like Sinon for testing.

Use this function in post() middleware to replace the result

Declares a global plugin executed on all Schemas.

Equivalent to calling .plugin(fn) on each Schema you create.

Getter/setter around function for pluralizing collection names.

Sanitizes query filters against query selector injection attacks by wrapping any nested objects that have a property whose name starts with $ in a $eq.

Sets mongoose options

key can be used a object to set multiple options at once. If a error gets thrown for one option, other options will still be evaluated.

Currently supported options are:

Overwrites the current driver used by this Mongoose instance. A driver is a Mongoose-specific interface that defines functions like find().

Use this function in pre() middleware to skip calling the wrapped function.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling mongoose.startSession() is equivalent to calling mongoose.connection.startSession(). Sessions are scoped to a connection, so calling mongoose.startSession() starts a session on the default mongoose connection.

Syncs all the indexes for the models registered with this connection.

Tells sanitizeFilter() to skip the given object when filtering out potential query selector injection attacks. Use this method when you have a known query selector that you want to use.

**Examples:**

Example 1 (javascript):
```javascript
const mongoose = require('mongoose');
mongoose instanceof mongoose.Mongoose; // true

// Create a new Mongoose instance with its own `connect()`, `set()`, `model()`, etc.
const m = new mongoose.Mongoose();
```

Example 2 (css):
```css
const schema = new Schema({ test: Date });
schema.path('test') instanceof mongoose.Date; // true
```

Example 3 (css):
```css
const vehicleSchema = new Schema({ fuelLevel: mongoose.Decimal128 });
```

Example 4 (css):
```css
const schema = new Schema({ arbitrary: mongoose.Mixed });
```

---

## SchemaDocumentArray

**URL:** https://mongoosejs.com/docs/api/schemadocumentarray.html

**Contents:**
- SchemaDocumentArray
  - SchemaDocumentArray()
      - Parameters:
      - Inherits:
  - SchemaDocumentArray.get()
      - Parameters:
      - Returns:
      - Type:
  - SchemaDocumentArray.options
      - Type:

SubdocsArray SchemaType constructor

Attaches a getter for all DocumentArrayPath instances

Options for all document arrays.

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$size is the function Mongoose calls to cast $size filter operators.

Adds a discriminator to this document array.

Performs local validations first, then validations on each embedded doc

Returns this schema type's representation in a JSON schema.

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all DocumentArray instances.

**Examples:**

Example 1 (swift):
```swift
const shapeSchema = Schema({ name: String }, { discriminatorKey: 'kind' });
const schema = Schema({ shapes: [shapeSchema] });

const docArrayPath = parentSchema.path('shapes');
docArrayPath.discriminator('Circle', Schema({ radius: Number }));
```

Example 2 (unknown):
```unknown
// Make all numbers have option `min` equal to 0.
mongoose.Schema.DocumentArray.set('_id', false);
```

---

## Mongoose

**URL:** https://mongoosejs.com/docs/5.x/docs/api/mongoose.html

**Contents:**
- Mongoose
  - Mongoose()
      - Parameters
    - Example:
  - Mongoose.prototype.Aggregate()
  - Mongoose.prototype.CastError()
      - Parameters
  - Mongoose.prototype.Collection()
  - Mongoose.prototype.Connection()
  - Mongoose.prototype.Date

Mongoose constructor.

The exports object of the mongoose module is an instance of this class. Most apps will only use this one instance.

The Mongoose Aggregate constructor

The Mongoose CastError constructor

The Mongoose Collection constructor

The Mongoose Connection constructor

The Mongoose Date SchemaType.

The Mongoose Decimal128 SchemaType. Used for declaring paths in your schema that should be 128-bit decimal floating points. Do not use this to create a new Decimal128 instance, use mongoose.Types.Decimal128 instead.

The Mongoose Document constructor.

The Mongoose DocumentProvider constructor. Mongoose users should not have to use this directly

The MongooseError constructor.

The Mongoose Mixed SchemaType. Used for declaring paths in your schema that Mongoose's change tracking, casting, and validation should ignore.

The Mongoose Model constructor.

The Mongoose constructor

The exports of the mongoose module is an instance of this class.

The Mongoose Number SchemaType. Used for declaring paths in your schema that Mongoose should cast to numbers.

The Mongoose ObjectId SchemaType. Used for declaring paths in your schema that should be MongoDB ObjectIds. Do not use this to create a new ObjectId instance, use mongoose.Types.ObjectId instead.

The Mongoose Promise constructor.

Storage layer for mongoose promises

The Mongoose Query constructor.

Expose connection states for user-land

The Mongoose Schema constructor

The Mongoose SchemaType constructor

The constructor used for schematype options

The various Mongoose SchemaTypes.

Alias of mongoose.Schema.Types for backwards compatibility.

The various Mongoose Types.

Using this exposed access to the ObjectId type, we can construct ids on demand.

The Mongoose VirtualType constructor

Opens the default mongoose connection.

The Mongoose module's default connection. Equivalent to mongoose.connections[0], see connections.

This is the connection used by default for every model created using mongoose.model.

To create a new connection, use createConnection().

An array containing all connections associated with this Mongoose instance. By default, there is 1 connection. Calling createConnection() adds a connection to this array.

Creates a Connection instance.

Each connection instance maps to a single database. This method is helpful when managing multiple db connections.

Options passed take precedence over options included in connection strings.

Removes the model named name from the default connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Equivalent to mongoose.connection.deleteModel(name).

Runs .close() on all connections in parallel.

Object with get() and set() containing the underlying driver this Mongoose instance uses to communicate with the database. A driver is a Mongoose-specific interface that defines functions like find().

Gets mongoose options

Returns true if Mongoose can cast the given value to an ObjectId, or false otherwise.

Defines a model or retrieves it.

Models defined on the mongoose instance are available to all connection created by the same mongoose instance.

If you call mongoose.model() with twice the same name but a different schema, you will get an OverwriteModelError. If you call mongoose.model() with the same name and same schema, you'll get the same schema back.

When no collection argument is passed, Mongoose uses the model name. If you don't like this behavior, either pass a collection name, use mongoose.pluralize(), or set your schemas collection name option.

Returns an array of model names created on this instance of Mongoose.

Does not include names of models created using connection.model().

The node-mongodb-native driver Mongoose uses.

The mquery query builder Mongoose uses.

Mongoose uses this function to get the current time when setting timestamps. You may stub out this function using a tool like Sinon for testing.

Declares a global plugin executed on all Schemas.

Equivalent to calling .plugin(fn) on each Schema you create.

Getter/setter around function for pluralizing collection names.

Sets mongoose options

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling mongoose.startSession() is equivalent to calling mongoose.connection.startSession(). Sessions are scoped to a connection, so calling mongoose.startSession() starts a session on the default mongoose connection.

**Examples:**

Example 1 (javascript):
```javascript
const mongoose = require('mongoose');
mongoose instanceof mongoose.Mongoose; // true

// Create a new Mongoose instance with its own `connect()`, `set()`, `model()`, etc.
const m = new mongoose.Mongoose();
```

Example 2 (css):
```css
const schema = new Schema({ test: Date });
schema.path('test') instanceof mongoose.Date; // true
```

Example 3 (css):
```css
const vehicleSchema = new Schema({ fuelLevel: mongoose.Decimal128 });
```

Example 4 (css):
```css
const schema = new Schema({ arbitrary: mongoose.Mixed });
```

---

## Virtualtype

**URL:** https://mongoosejs.com/docs/5.x/docs/api/virtualtype.html

**Contents:**
- Virtualtype
  - VirtualType()
      - Parameters
    - Example:
  - VirtualType.prototype.applyGetters()
      - Parameters
      - Returns:
  - VirtualType.prototype.applySetters()
      - Parameters
      - Returns:

VirtualType constructor

This is what mongoose uses to define virtual attributes via Schema.prototype.virtual.

Applies getters to value.

Applies setters to value.

Adds a custom getter to this virtual.

Mongoose calls the getter function with the below 3 parameters.

Adds a custom setter to this virtual.

Mongoose calls the setter function with the below 3 parameters.

**Examples:**

Example 1 (javascript):
```javascript
const fullname = schema.virtual('fullname');
fullname instanceof mongoose.VirtualType // true
```

Example 2 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.get(function(value, virtual, doc) {
  return this.name.first + ' ' + this.name.last;
});
```

Example 3 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.set(function(value, virtual, doc) {
  const parts = value.split(' ');
  this.name.first = parts[0];
  this.name.last = parts[1];
});

const Model = mongoose.model('Test', schema);
const doc = new Model();
// Calls the setter with `value = 'Jean-Luc Picard'`
doc.fullname = 'Jean-Luc Picard';
doc.name.first; // 'Jean-Luc'
doc.name.last; // 'Picard'
```

---

## SchemaNumber

**URL:** https://mongoosejs.com/docs/api/schemanumber.html

**Contents:**
- SchemaNumber
  - SchemaNumber()
      - Parameters:
      - Inherits:
  - SchemaNumber.cast()
      - Parameters:
      - Returns:
      - Type:
    - Example:
  - SchemaNumber.checkRequired()

Number SchemaType constructor.

Get/set the function used to cast arbitrary values to numbers.

Override the function the required validator uses to check whether a string passes the required check.

Attaches a getter for all Number instances.

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$gte is the function Mongoose calls to cast $gte filter operators.

Check if the given value satisfies a required validator.

Sets a enum validator

Sets a maximum number validator.

Sets a minimum number validator.

Returns this schema type's representation in a JSON schema.

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all Number instances.

**Examples:**

Example 1 (typescript):
```typescript
// Make Mongoose cast empty strings '' to 0 for paths declared as numbers
const original = mongoose.Number.cast();
mongoose.Number.cast(v => {
  if (v === '') { return 0; }
  return original(v);
});

// Or disable casting entirely
mongoose.Number.cast(false);
```

Example 2 (css):
```css
// Make all numbers round down
mongoose.Number.get(function(v) { return Math.floor(v); });

const Model = mongoose.model('Test', new Schema({ test: Number }));
new Model({ test: 3.14 }).test; // 3
```

Example 3 (javascript):
```javascript
const s = new Schema({ n: { type: Number, enum: [1, 2, 3] });
const M = db.model('M', s);

const m = new M({ n: 4 });
await m.save(); // throws validation error

m.n = 3;
await m.save(); // succeeds
```

Example 4 (javascript):
```javascript
const s = new Schema({ n: { type: Number, max: 10 })
const M = db.model('M', s)
const m = new M({ n: 11 })
m.save(function (err) {
  console.error(err) // validator error
  m.n = 10;
  m.save() // success
})

// custom error messages
// We can also use the special {MAX} token which will be replaced with the invalid value
const max = [10, 'The value of path `{PATH}` ({VALUE}) exceeds the limit ({MAX}).'];
const schema = new Schema({ n: { type: Number, max: max })
const M = mongoose.model('Measurement', schema);
const s= new M({ n: 4 });
s.validate(function (err) {
  console.log(String(err)) // ValidationError: The value of path `n` (4) exceeds the limit (10).
})
```

---

## Virtualtype

**URL:** https://mongoosejs.com/docs/7.x/docs/api/virtualtype.html

**Contents:**
- Virtualtype
  - VirtualType()
      - Parameters:
    - Example:
  - VirtualType.prototype.applyGetters()
      - Parameters:
      - Returns:
  - VirtualType.prototype.applySetters()
      - Parameters:
      - Returns:

VirtualType constructor

This is what mongoose uses to define virtual attributes via Schema.prototype.virtual.

Applies getters to value.

Applies setters to value.

Adds a custom getter to this virtual.

Mongoose calls the getter function with the below 3 parameters.

Adds a custom setter to this virtual.

Mongoose calls the setter function with the below 3 parameters.

**Examples:**

Example 1 (javascript):
```javascript
const fullname = schema.virtual('fullname');
fullname instanceof mongoose.VirtualType // true
```

Example 2 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.get(function(value, virtual, doc) {
  return this.name.first + ' ' + this.name.last;
});
```

Example 3 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.set(function(value, virtual, doc) {
  const parts = value.split(' ');
  this.name.first = parts[0];
  this.name.last = parts[1];
});

const Model = mongoose.model('Test', schema);
const doc = new Model();
// Calls the setter with `value = 'Jean-Luc Picard'`
doc.fullname = 'Jean-Luc Picard';
doc.name.first; // 'Jean-Luc'
doc.name.last; // 'Picard'
```

---

## Redirecting

**URL:** https://mongoosejs.com/docs/api.html

**Contents:**
- Redirecting

Redirecting to proper API page, please wait

This Page requires JavaScript to Redirect old links properly

---

## SchemaUuid

**URL:** https://mongoosejs.com/docs/api/schemauuid.html

**Contents:**
- SchemaUuid
  - SchemaUUID()
      - Parameters:
      - Inherits:
  - SchemaUUID.checkRequired()
      - Parameters:
      - Returns:
      - Type:
  - SchemaUUID.get()
      - Parameters:

UUIDv1 SchemaType constructor.

Override the function the required validator uses to check whether a string passes the required check.

Attaches a getter for all UUID instances.

Get/set the function used to cast arbitrary values to UUIDs.

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$exists is the function Mongoose calls to cast $exists filter operators.

Check if the given value satisfies a required validator.

Returns this schema type's representation in a JSON schema.

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all UUID instances.

**Examples:**

Example 1 (javascript):
```javascript
// Note that `v` is a string by default
mongoose.Schema.UUID.get(v => v.toUpperCase());

const Model = mongoose.model('Test', new Schema({ test: 'UUID' }));
new Model({ test: uuid.v4() }).test; // UUID with all uppercase
```

Example 2 (javascript):
```javascript
// Make Mongoose refuse to cast UUIDs with 0 length
const original = mongoose.Schema.Types.UUID.cast();
mongoose.UUID.cast(v => {
  assert.ok(typeof v === "string" && v.length > 0);
  return original(v);
});

// Or disable casting entirely
mongoose.UUID.cast(false);
```

Example 3 (css):
```css
// Make all UUIDs have `required` of true by default.
mongoose.Schema.UUID.set('required', true);

const User = mongoose.model('User', new Schema({ test: mongoose.UUID }));
new User({ }).validateSync().errors.test.message; // Path `test` is required.
```

---

## SchemaType

**URL:** https://mongoosejs.com/docs/api/schematype.html

**Contents:**
- SchemaType
  - SchemaType()
      - Parameters:
    - Example:
  - SchemaType.cast()
      - Parameters:
      - Returns:
    - Example:
  - SchemaType.checkRequired()
      - Parameters:

SchemaType constructor. Do not instantiate SchemaType directly. Mongoose converts your schema paths into SchemaTypes automatically.

Get/set the function used to cast arbitrary values to this type.

Set & Get the checkRequired function Override the function the required validator uses to check whether a value passes the required check. Override this on the individual SchemaType.

Attaches a getter for all instances of this schema type.

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$exists is the function Mongoose calls to cast $exists filter operators.

The function that Mongoose calls to cast arbitrary values to this SchemaType.

Get/set the function used to cast arbitrary values to this particular schematype instance. Overrides SchemaType.cast().

Sets a default value for this SchemaType.

Defaults can be either functions which return the value to use as the default or the literal value itself. Either way, the value will be cast based on its schema type before being set during document creation.

Performs a validation of value using the validators declared for this SchemaType.

Adds a getter to this schematype.

Getters allow you to transform the representation of the data as it travels from the raw mongodb document to the value that you see.

Suppose you are storing credit card numbers and you want to hide everything except the last 4 digits to the mongoose user. You can do so by defining a getter in the following way:

Getters are also passed a second argument, the schematype on which the getter was defined. This allows for tailored behavior based on options passed in the schema.

Returns the embedded schema type, if any. For arrays, document arrays, and maps, getEmbeddedSchemaType() returns the schema type of the array's elements (or map's elements). For other types, getEmbeddedSchemaType() returns undefined.

Defines this path as immutable. Mongoose prevents you from changing immutable paths unless the parent document has isNew: true.

Mongoose also prevents changing immutable properties using updateOne() and updateMany() based on strict mode.

Declares the index options for this schematype.

True if this SchemaType has a required validator. False otherwise.

The path to this SchemaType in a Schema.

Set the model that this path refers to. This is the option that populate looks at to determine the foreign collection it should query.

Adds a required validator to this SchemaType. The validator gets added to the front of this SchemaType's validators array using unshift().

The required validator uses the SchemaType's checkRequired function to determine whether a given value satisfies the required validator. By default, a value satisfies the required validator if val != null (that is, if the value is not null nor undefined). However, most built-in mongoose schema types override the default checkRequired function:

Sets default select() behavior for this path.

Set to true if this path should always be included in the results, false if it should be excluded by default. This setting can be overridden at the query level.

Adds a setter to this schematype.

Setters allow you to transform the data before it gets to the raw mongodb document or query.

Suppose you are implementing user registration for a website. Users provide an email and password, which gets saved to mongodb. The email is a string that you will want to normalize to lower case, in order to avoid one email having more than one account -- e.g., otherwise, avenue@q.com can be registered for 2 accounts via avenue@q.com and AvEnUe@Q.CoM.

You can set up email lower case normalization easily via a Mongoose setter.

As you can see above, setters allow you to transform the data before it stored in MongoDB, or before executing a query.

NOTE: we could have also just used the built-in lowercase: true SchemaType option instead of defining our own function.

Setters are also passed a second argument, the schematype on which the setter was defined. This allows for tailored behavior based on options passed in the schema.

You can also use setters to modify other properties on the document. If you're setting a property name on a document, the setter will run with this as the document. Be careful, in mongoose 5 setters will also run when querying by name with this as the query.

Declares a sparse index.

Declares a full text index.

Returns a plain JavaScript object representing this SchemaType.

Typically used by JSON.stringify() or when calling .toJSON() on a SchemaType instance. Omits certain internal properties such as parentSchema that can cause circular references.

Returns this schema type's representation in a JSON schema.

Defines a custom function for transforming this path when converting a document to JSON.

Mongoose calls this function with one parameter: the current value of the path. Mongoose then uses the return value in the JSON output.

Declares an unique index.

NOTE: violating the constraint returns an E11000 error from MongoDB when saving, not a Mongoose validation error.

You can optionally specify an error message to replace MongoDB's default E11000 duplicate key error message. The following will throw a "Email must be unique" error if save(), updateOne(), updateMany(), replaceOne(), findOneAndUpdate(), or findOneAndReplace() throws a duplicate key error:

Note that the above syntax does not work for bulkWrite() or insertMany(). bulkWrite() and insertMany() will still throw MongoDB's default E11000 duplicate key error message.

Adds validator(s) for this document path.

Validators always receive the value to validate as their first argument and must return Boolean. Returning false or throwing an error means validation failed.

The error message argument is optional. If not passed, the default generic error message template will be used.

Below is a list of supported template keywords:

If Mongoose's built-in error message templating isn't enough, Mongoose supports setting the message property to a function.

To bypass Mongoose's error messages and just copy the error message that the validator throws, do this:

Mongoose supports validators that return a promise. A validator that returns a promise is called an async validator. Async validators run in parallel, and validate() will wait until all async validators have settled.

You might use asynchronous validators to retreive other documents from the database to validate against or to meet other I/O bound validation needs.

Validation occurs pre('save') or whenever you manually execute document#validate.

If validation fails during pre('save') and no callback was passed to receive the error, an error event will be emitted on your Models associated db connection, passing the validation error object along.

If you want to handle these errors at the Model level, add an error listener to your Model as shown below.

Adds multiple validators for this document path. Calls validate() for every element in validators.

The validators that Mongoose should run to validate properties at this SchemaType's path.

Sets a default option for this schema type.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ name: String });
schema.path('name') instanceof SchemaType; // true
```

Example 2 (r):
```r
// Disallow `null` for numbers, and don't try to cast any values to
// numbers, so even strings like '123' will cause a CastError.
mongoose.Number.cast(function(v) {
  assert.ok(v === undefined || typeof v === 'number');
  return v;
});
```

Example 3 (javascript):
```javascript
// Use this to allow empty strings to pass the `required` validator
mongoose.Schema.Types.String.checkRequired(v => typeof v === 'string');
```

Example 4 (r):
```r
// Make all numbers round down
mongoose.Number.get(function(v) { return Math.floor(v); });
```

---

## Connection

**URL:** https://mongoosejs.com/docs/7.x/docs/api/connection.html

**Contents:**
- Connection
  - Connection()
      - Parameters:
      - Inherits:
  - Connection.prototype.asPromise()
      - Returns:
    - Example:
  - Connection.prototype.client
      - Type:
  - Connection.prototype.close()

Connection constructor

For practical reasons, a Connection equals a Db.

Returns a promise that resolves when this connection successfully connects to MongoDB, or rejects if this connection failed to connect.

The MongoClient instance this connection uses to talk to MongoDB. Mongoose automatically sets this property when the connection is opened.

Closes the connection

Retrieves a raw collection instance, creating it if not cached. This method returns a thin wrapper around a [MongoDB Node.js driver collection](MongoDB Node.js driver collection). Using a Collection bypasses Mongoose middleware, validation, and casting, letting you use MongoDB Node.js driver functionality directly.

A hash of the collections associated with this connection

A hash of the global options that are associated with this connection

Helper for createCollection(). Will explicitly create the given collection with specified options. Used to create capped collections and views from mongoose.

Options are passed down without modification to the MongoDB driver's createCollection() function

Calls createCollection() on a models in a series.

The mongodb.Db instance, set when the connection is opened

Removes the model named name from this connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Destroy the connection. Similar to .close, but also removes the connection from Mongoose's connections list and prevents the connection from ever being re-opened.

Helper for dropCollection(). Will delete the given collection, including all documents and indexes.

Helper for dropDatabase(). Deletes the given database, including all collections, documents, and indexes.

Gets the value of the option key. Equivalent to conn.options[key]

Returns the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB.

The host name portion of the URI. If multiple hosts, such as a replica set, this will contain the first host name in the URI

A number identifier for this connection. Used for debugging when you have multiple connections.

Defines or retrieves a model.

When no collection argument is passed, Mongoose produces a collection name by passing the model name to the utils.toCollectionName method. This method pluralizes the name. If you don't like this behavior, either pass a collection name or set your schemas collection name option.

Returns an array of model names created on this connection.

A POJO containing a map from model names to models. Contains all models that have been added to this connection using Connection#model().

The name of the database this connection points to.

Opens the connection with a URI using MongoClient.connect().

The password specified in the URI

Declares a plugin executed on all schemas you pass to conn.model()

Equivalent to calling .plugin(fn) on each schema you create.

The plugins that will be applied to all models created on this connection.

The port portion of the URI. If multiple hosts, such as a replica set, this will contain the port from the first host name in the URI.

Connection ready state

Each state change emits its associated event name.

Removes the database connection with the given name created with with useDb().

Throws an error if the database connection was not found.

Sets the value of the option key. Equivalent to conn.options[key] = val

Supported options include:

Set the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB. This is useful if you already have a MongoClient instance, and want to reuse it.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Syncs all the indexes for the models registered with this connection.

Requires MongoDB >= 3.6.0. Executes the wrapped async function in a transaction. Mongoose will commit the transaction if the async function executes successfully and attempt to retry if there was a retriable error.

Calls the MongoDB driver's session.withTransaction(), but also handles resetting Mongoose document state as shown below.

Switches to a different database using the same connection pool.

Returns a new connection object, with the new db.

The username specified in the URI

Watches the entire underlying database for changes. Similar to Model.watch().

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

The ChangeStream object is an event emitter that emits the following events:

**Examples:**

Example 1 (javascript):
```javascript
const conn = await mongoose.createConnection('mongodb://127.0.0.1:27017/test').
  asPromise();
conn.readyState; // 1, means Mongoose is connected
```

Example 2 (css):
```css
conn.model('User', new Schema({ name: String }));
console.log(conn.model('User')); // Model object
conn.deleteModel('User');
console.log(conn.model('User')); // undefined

// Usually useful in a Mocha `afterEach()` hook
afterEach(function() {
  conn.deleteModel(/.+/); // Delete every model
});
```

Example 3 (javascript):
```javascript
const conn = mongoose.createConnection('mongodb://127.0.0.1:27017/mydb');
// Deletes the entire 'mydb' database
await conn.dropDatabase();
```

Example 4 (unknown):
```unknown
conn.get('test'); // returns the 'test' value
```

---

## Schema

**URL:** https://mongoosejs.com/docs/7.x/docs/api/schema.html

**Contents:**
- Schema
  - Schema()
      - Parameters:
      - Inherits:
    - Example:
    - Options:
    - Options for Nested Schemas:
    - Note:
  - Schema.Types
      - Type:

When nesting schemas, (children in the example above), always declare the child schema first before passing it into its parent.

The various built-in Mongoose Schema Types.

Using this exposed access to the Mixed SchemaType, we can use them in our schema.

The allowed index types

Adds key path / schema type pairs to this schema.

Add an alias for path. This means getting or setting the alias is equivalent to getting or setting the path.

Array of child schemas (from document arrays and single nested subdocs) and their corresponding compiled models. Each element of the array is an object with 2 properties: schema and model.

This property is typically only useful for plugin authors and advanced users. You do not need to interact with this property at all to use mongoose.

Remove all indexes from this schema.

clearIndexes only removes indexes from your schema object. Does not affect the indexes in MongoDB.

Returns a deep copy of the schema

Inherit a Schema by applying a discriminator on an existing Schema.

Iterates the schemas paths similar to Array#forEach.

The callback is passed the pathname and the schemaType instance.

Gets a schema option.

Defines an index (most likely compound) for this schema.

Returns a list of indexes that this schema declares, via schema.index() or by index: true in a path's options. Indexes are expressed as an array [spec, options].

Plugins can use the return value of this function to modify a schema's indexes. For example, the below plugin makes every index unique by default.

Loads an ES6 class into a schema. Maps setters + getters, static methods, and instance methods to schema virtuals, statics, and methods.

Adds an instance method to documents constructed from Models compiled from this schema.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as methods.

NOTE: Schema.method() adds instance methods to the Schema.methods object. You can also add instance methods directly to the Schema.methods object as seen in the guide

The original object passed to the schema constructor

Returns a new schema that has the paths from the original schema, minus the omitted ones.

This method is analagous to Lodash's omit() function for Mongoose schemas.

Gets/sets schema paths.

Sets a path (if arity 2) Gets a path (if arity 1)

Returns the pathType of path for this schema.

Given a path, returns whether it is a real, virtual, nested, or ad-hoc/undefined path.

The paths defined on this schema. The keys are the top-level paths in this schema, and the values are instances of the SchemaType class.

Returns a new schema that has the picked paths from this schema.

This method is analagous to Lodash's pick() function for Mongoose schemas.

Registers a plugin for this schema.

Defines a post hook for the document

Defines a pre hook for the model.

Adds a method call to the queue.

Removes the given path (or [paths]).

Remove an index by name or index specification.

removeIndex only removes indexes from your schema object. Does not affect the indexes in MongoDB.

Removes the given virtual or virtuals from the schema.

Returns an Array of path strings that are required by this schema.

Sets a schema option.

Adds static "class" methods to Models compiled from this schema.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as methods.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as statics.

Creates a virtual type with the given name.

Returns the virtual type with the given name.

Object containing all virtuals defined on this schema. The objects' keys are the virtual paths and values are instances of VirtualType.

This property is typically only useful for plugin authors and advanced users. You do not need to interact with this property at all to use mongoose.

Reserved document keys.

Keys in this object are names that are warned in schema declarations because they have the potential to break Mongoose/ Mongoose plugins functionality. If you create a schema using new Schema() with one of these property names, Mongoose will log a warning.

NOTE: Use of these terms as method names is permitted, but play at your own risk, as they may be existing mongoose document methods you are stomping on.

**Examples:**

Example 1 (swift):
```swift
const child = new Schema({ name: String });
const schema = new Schema({ name: String, age: Number, children: [child] });
const Tree = mongoose.model('Tree', schema);

// setting schema options
new Schema({ name: String }, { _id: false, autoIndex: false })
```

Example 2 (javascript):
```javascript
const mongoose = require('mongoose');
const ObjectId = mongoose.Schema.Types.ObjectId;
```

Example 3 (css):
```css
const Mixed = mongoose.Schema.Types.Mixed;
new mongoose.Schema({ _user: Mixed })
```

Example 4 (css):
```css
const ToySchema = new Schema();
ToySchema.add({ name: 'string', color: 'string', price: 'number' });

const TurboManSchema = new Schema();
// You can also `add()` another schema and copy over all paths, virtuals,
// getters, setters, indexes, methods, and statics.
TurboManSchema.add(ToySchema).add({ year: Number });
```

---

## VirtualType

**URL:** https://mongoosejs.com/docs/api/virtualtype.html

**Contents:**
- VirtualType
  - VirtualType()
      - Parameters:
    - Example:
  - VirtualType.prototype.applyGetters()
      - Parameters:
      - Returns:
  - VirtualType.prototype.applySetters()
      - Parameters:
      - Returns:

VirtualType constructor

This is what mongoose uses to define virtual attributes via Schema.prototype.virtual.

Applies getters to value.

Applies setters to value.

Adds a custom getter to this virtual.

Mongoose calls the getter function with the below 3 parameters.

Adds a custom setter to this virtual.

Mongoose calls the setter function with the below 3 parameters.

**Examples:**

Example 1 (javascript):
```javascript
const fullname = schema.virtual('fullname');
fullname instanceof mongoose.VirtualType // true
```

Example 2 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.get(function(value, virtual, doc) {
  return this.name.first + ' ' + this.name.last;
});
```

Example 3 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.set(function(value, virtual, doc) {
  const parts = value.split(' ');
  this.name.first = parts[0];
  this.name.last = parts[1];
});

const Model = mongoose.model('Test', schema);
const doc = new Model();
// Calls the setter with `value = 'Jean-Luc Picard'`
doc.fullname = 'Jean-Luc Picard';
doc.name.first; // 'Jean-Luc'
doc.name.last; // 'Picard'
```

---

## SchemaDateOptions

**URL:** https://mongoosejs.com/docs/api/schemadateoptions.html

**Contents:**
- SchemaDateOptions
  - SchemaDateOptions()
      - Type:
      - Inherits:
    - Example:
  - SchemaDateOptions.prototype.expires
      - Type:
    - Example:
  - SchemaDateOptions.prototype.max
      - Type:

The options defined on a Date schematype.

If set, Mongoose creates a TTL index on this path.

mongo TTL index expireAfterSeconds value will take 'expires' value expressed in seconds.

If set, Mongoose adds a validator that checks that this path is before the given max.

If set, Mongoose adds a validator that checks that this path is after the given min.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ startedAt: Date });
schema.path('startedAt').options; // SchemaDateOptions instance
```

Example 2 (json):
```json
const schema = new Schema({ "expireAt": { type: Date,  expires: 11 } });
// if 'expireAt' is set, then document expires at expireAt + 11 seconds
```

---

## SchemaDateOptions

**URL:** https://mongoosejs.com/docs/6.x/docs/api/schemadateoptions.html

**Contents:**
- SchemaDateOptions
  - SchemaDateOptions()
      - Type:
      - Inherits:
    - Example:
  - SchemaDateOptions.prototype.expires
      - Type:
    - Example:
  - SchemaDateOptions.prototype.max
      - Type:

The options defined on a Date schematype.

If set, Mongoose creates a TTL index on this path.

mongo TTL index expireAfterSeconds value will take 'expires' value expressed in seconds.

If set, Mongoose adds a validator that checks that this path is before the given max.

If set, Mongoose adds a validator that checks that this path is after the given min.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ startedAt: Date });
schema.path('startedAt').options; // SchemaDateOptions instance
```

Example 2 (json):
```json
const schema = new Schema({ "expireAt": { type: Date,  expires: 11 } });
// if 'expireAt' is set, then document expires at expireAt + 11 seconds
```

---

## Model

**URL:** https://mongoosejs.com/docs/api/model.html

**Contents:**
- Model
  - Model()
      - Parameters:
      - Inherits:
    - Example:
  - Model.$where()
      - Parameters:
      - Returns:
      - See:
  - Model.aggregate()

A Model is a class that's your primary tool for interacting with MongoDB. An instance of a Model is called a Document.

In Mongoose, the term "Model" refers to subclasses of the mongoose.Model class. You should not use the mongoose.Model class directly. The mongoose.model() and connection.model() functions create subclasses of mongoose.Model as shown below.

Creates a Query and specifies a $where condition.

Sometimes you need to query for things in mongodb using a JavaScript expression. You can do so via find({ $where: javascript }), or you can use the mongoose shortcut method $where via a Query chain or from your mongoose Model.

Performs aggregations on the models collection.

The aggregate itself is returned.

This function triggers the following middleware.

Apply defaults to the given document or POJO.

Apply this model's timestamps to a given POJO, including subdocument timestamps

Apply this model's virtuals to a given POJO. Virtuals execute with the POJO as the context this.

Takes an array of documents, gets the changes and inserts/updates documents in the database according to whether or not the document is new, or whether it has changes or not.

bulkSave uses bulkWrite under the hood, so it's mostly useful when dealing with many documents (10K+)

bulkSave() throws errors under the following conditions:

Note that bulkSave() will not throw an error if only some of the save() calls succeeded.

Sends multiple insertOne, updateOne, updateMany, replaceOne, deleteOne, and/or deleteMany operations to the MongoDB server in one command. This is faster than sending multiple independent operations (e.g. if you use create()) because with bulkWrite() there is only one round trip to MongoDB.

Mongoose will perform casting on all operations you provide. The only exception is setting the update operator for updateOne or updateMany to a pipeline: Mongoose does not cast update pipelines.

This function does not trigger any middleware, neither save(), nor update(). If you need to trigger save() middleware for every document use create() instead.

The supported operations are:

Cast the given POJO to the model's schema

Deletes all indexes that aren't defined in this model's schema. Used by syncIndexes().

The returned promise resolves to a list of the dropped indexes' names as an array

If auto encryption is enabled, returns a ClientEncryption instance that is configured with the same settings that Mongoose's underlying MongoClient is using. If the client has not yet been configured, returns null.

Counts number of documents matching filter in a database collection.

If you want to count all documents in a large collection, use the estimatedDocumentCount() function instead. If you call countDocuments({}), MongoDB will always execute a full collection scan and not use any indexes.

The countDocuments() function is similar to count(), but there are a few operators that countDocuments() does not support. Below are the operators that count() supports but countDocuments() does not, and the suggested replacement:

Shortcut for saving one or more documents to the database. MyModel.create(docs) does new MyModel(doc).save() for every doc in docs.

This function triggers the following middleware.

Create the collection for this model. By default, if no indexes are specified, mongoose will not create the collection for the model until any documents are created. Use this method to create the collection explicitly.

Note 1: You may need to call this before starting a transaction See https://www.mongodb.com/docs/manual/core/transactions/#transactions-and-operations

Note 2: You don't have to call this if your schema contains index or unique field. In that case, just use Model.init()

Similar to ensureIndexes(), except for it uses the createIndex function.

Create an Atlas search index. This function only works when connected to MongoDB Atlas.

Creates all Atlas search indexes defined in this model's schema. This function only works when connected to MongoDB Atlas.

Connection instance the model uses.

Deletes all of the documents that match conditions from the collection. It returns an object with the property deletedCount containing the number of documents deleted.

This function triggers deleteMany query hooks. Read the middleware docs to learn more.

Deletes the first document that matches conditions from the collection. It returns an object with the property deletedCount indicating how many documents were deleted.

This function triggers deleteOne query hooks. Read the middleware docs to learn more.

Does a dry-run of Model.syncIndexes(), returning the indexes that syncIndexes() would drop and create if you were to run syncIndexes().

Adds a discriminator type.

Creates a Query for a distinct operation.

Delete an existing Atlas search index by name. This function only works when connected to MongoDB Atlas.

Sends createIndex commands to mongo for each index declared in the schema. The createIndex commands are sent in series.

After completion, an index event is emitted on this Model passing an error if one occurred.

NOTE: It is not recommended that you run this in production. Index creation may impact database performance depending on your load. Use with caution.

Estimates the number of documents in the MongoDB collection. Faster than using countDocuments() for large collections because estimatedDocumentCount() uses collection metadata rather than scanning the entire collection.

Event emitter that reports any errors that occurred. Useful for global error handling.

Returns a document with _id only if at least one document exists in the database that matches the given filter, and null otherwise.

Under the hood, MyModel.exists({ answer: 42 }) is equivalent to MyModel.findOne({ answer: 42 }).select({ _id: 1 }).lean()

This function triggers the following middleware.

Mongoose casts the filter to match the model's schema before the command is sent. See our query casting tutorial for more information on how Mongoose casts filter.

Finds a single document by its _id field. findById(id) is equivalent to findOne({ _id: id }).

The id is cast based on the Schema before sending the command.

This function triggers the following middleware.

Issue a MongoDB findOneAndDelete() command by a document's _id field. In other words, findByIdAndDelete(id) is a shorthand for findOneAndDelete({ _id: id }).

This function triggers the following middleware.

Issues a mongodb findOneAndUpdate command by a document's _id field. findByIdAndUpdate(id, ...) is equivalent to findOneAndUpdate({ _id: id }, ...).

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any).

This function triggers the following middleware.

All top level update keys which are not atomic operation names are treated as set operations:

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

The conditions are cast to their respective SchemaTypes before the command is sent.

Note: conditions is optional, and if conditions is null or undefined, mongoose will send an empty findOne command to MongoDB, which will return an arbitrary document. If you're querying by _id, use findById() instead.

Issue a MongoDB findOneAndDelete() command.

Finds a matching document, removes it, and returns the found document (if any).

This function triggers the following middleware.

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a MongoDB findOneAndReplace() command.

Finds a matching document, replaces it with the provided doc, and returns the document.

This function triggers the following query middleware.

Issues a mongodb findOneAndUpdate command.

Finds a matching document, updates it according to the update arg, passing any options. A Query object is returned.

All top level update keys which are not atomic operation names are treated as set operations:

findOneAndX and findByIdAndX functions support limited validation that you can enable by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Shortcut for creating a new Document from existing raw data, pre-saved in the DB. The document returned has no paths marked as modified initially.

This function is responsible for initializing the underlying connection in MongoDB based on schema options. This function performs the following operations:

Mongoose calls this function automatically when a model is a created using mongoose.model() or connection.model(), so you don't need to call init() to trigger index builds.

However, you may need to call init() to get back a promise that will resolve when your indexes are finished. Calling await Model.init() is helpful if you need to wait for indexes to build before continuing. For example, if you want to wait for unique indexes to build before continuing with a test case.

Shortcut for validating an array of documents and inserting them into MongoDB if they're all valid. This function is faster than .create() because it only sends one operation to the server, rather than one for each document.

Mongoose always validates each document before sending insertMany to MongoDB. So if one document has a validation error, no documents will be saved, unless you set the ordered option to false.

This function does not trigger save middleware.

This function triggers the following middleware.

Shortcut for saving one document to the database. MyModel.insertOne(obj, options) is almost equivalent to new MyModel(obj).save(options). The difference is that insertOne() checks if obj is already a document, and checks for discriminators.

This function triggers the following middleware.

Helper for console.log. Given a model named 'MyModel', returns the string 'Model { MyModel }'.

Lists the indexes currently defined in MongoDB. This may or may not be the same as the indexes defined in your schema depending on whether you use the autoIndex option and if you build indexes manually.

List all Atlas search indexes on this model's collection. This function only works when connected to MongoDB Atlas.

Return the MongoDB namespace for this model as a string. The namespace is the database name, followed by '.', followed by the collection name.

Populates document references.

Changed in Mongoose 6: the model you call populate() on should be the "local field" model, not the "foreign field" model.

Returns the model instance used to create this document if no name specified. If name specified, returns the model with the given name.

Additional properties to attach to the query when calling save() and isNew is false.

Base Mongoose instance the model uses.

If this is a discriminator model, baseModelName is the name of the base model.

The collection instance this model uses. A Mongoose collection is a thin wrapper around a [MongoDB Node.js driver collection](MongoDB Node.js driver collection). Using Model.collection means you bypass Mongoose middleware, validation, and casting.

This property is read-only. Modifying this property is a no-op.

Collection the model uses.

Connection the model uses.

Delete this document from the db. Returns a Query instance containing a deleteOne operation by this document's _id.

Since deleteOne() returns a Query, the deleteOne() will not execute unless you use either await, .then(), .catch(), or .exec()

Registered discriminators for this model.

Signal that we desire an increment of this documents version.

Returns the model instance used to create this document if no name specified. If name specified, returns the model with the given name.

The name of the model

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation with just the modified paths if isNew is false.

If save is successful, the returned promise will fulfill with the document saved.

Apply changes made to this model's schema after this model was compiled. By default, adding virtuals and other properties to a schema after the model is compiled does nothing. Call this function to apply virtuals and properties that were added later.

Replace the existing document with the given document (no atomic operators like $set).

This function triggers the following middleware.

Schema the model uses.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling MyModel.startSession() is equivalent to calling MyModel.db.startSession().

This function does not trigger any middleware.

Makes the indexes in MongoDB match the indexes defined in this model's schema. This function will drop any indexes that are not defined in the model's schema except the _id index, and build any indexes that are in your schema but not in MongoDB.

See the introductory blog post for more information.

You should be careful about running syncIndexes() on production applications under heavy load, because index builds are expensive operations, and unexpected index drops can lead to degraded performance. Before running syncIndexes(), you can use the diffIndexes() function to check what indexes syncIndexes() will drop and create.

Translate any aliases fields/conditions so the final query or document object is pure

By default, translateAliases() overwrites raw fields with aliased fields. So if n is an alias for name, { n: 'alias', name: 'raw' } will resolve to { name: 'alias' }. However, you can set the errorOnDuplicates option to throw an error if there are potentially conflicting paths. The translateAliases option for queries uses errorOnDuplicates.

Only translate arguments of object type anything else is returned raw

Same as updateOne(), except MongoDB will update all documents that match filter (as opposed to just the first one) regardless of the value of the multi option.

Note updateMany will not fire update middleware. Use pre('updateMany') and post('updateMany') instead.

This function triggers the following middleware.

Update only the first document that matches filter.

This function triggers the following middleware.

Update an existing Atlas search index. This function only works when connected to MongoDB Atlas.

Changes the Connection instance this model uses to make requests to MongoDB. This function is most useful for changing the Connection that a Model defined using mongoose.model() uses after initialization.

Note: useConnection() does not apply any connection-level plugins from the new connection. If you use useConnection() to switch a model's connection, the model will still have the old connection's plugins.

Casts and validates the given object against this model's schema, passing the given context to custom validators.

Requires a replica set running MongoDB >= 3.6.0. Watches the underlying collection for changes using MongoDB change streams.

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

The ChangeStream object is an event emitter that emits the following events:

Creates a Query, applies the passed conditions, and returns the Query.

For example, instead of writing:

we can instead write:

Since the Query class also supports where you can continue chaining

**Examples:**

Example 1 (javascript):
```javascript
// `UserModel` is a "Model", a subclass of `mongoose.Model`.
const UserModel = mongoose.model('User', new Schema({ name: String }));

// You can use a Model to create new documents using `new`:
const userDoc = new UserModel({ name: 'Foo' });
await userDoc.save();

// You also use a model to create queries:
const userFromDb = await UserModel.findOne({ name: 'Foo' });
```

Example 2 (r):
```r
Blog.$where('this.username.indexOf("val") !== -1').exec(function (err, docs) {});
```

Example 3 (javascript):
```javascript
// Find the max balance of all accounts
const res = await Users.aggregate([
  { $group: { _id: null, maxBalance: { $max: '$balance' }}},
  { $project: { _id: 0, maxBalance: 1 }}
]);

console.log(res); // [ { maxBalance: 98000 } ]

// Or use the aggregation pipeline builder.
const res = await Users.aggregate().
  group({ _id: null, maxBalance: { $max: '$balance' } }).
  project('-id maxBalance').
  exec();
console.log(res); // [ { maxBalance: 98 } ]
```

Example 4 (css):
```css
const userSchema = new Schema({ name: String }, { timestamps: true });
const User = mongoose.model('User', userSchema);

const obj = { name: 'John' };
User.applyTimestamps(obj);
obj.createdAt; // 2024-06-01T18:00:00.000Z
obj.updatedAt; // 2024-06-01T18:00:00.000Z
```

---

## SchemaArray

**URL:** https://mongoosejs.com/docs/api/schemaarray.html

**Contents:**
- SchemaArray
  - SchemaArray()
      - Parameters:
      - Inherits:
  - SchemaArray.checkRequired()
      - Parameters:
      - Returns:
    - Example:
  - SchemaArray.get()
      - Parameters:

Array SchemaType constructor

Override the function the required validator uses to check whether an array passes the required check.

Attaches a getter for all Array instances

Options for all arrays.

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$all is the function Mongoose calls to cast $all filter operators.

Check if the given value satisfies the required validator.

Adds an enum validator if this is an array of strings or numbers. Equivalent to SchemaString.prototype.enum() or SchemaNumber.prototype.enum()

Returns this schema type's representation in a JSON schema.

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all Array instances.

**Examples:**

Example 1 (javascript):
```javascript
// Require non-empty array to pass `required` check
mongoose.Schema.Types.Array.checkRequired(v => Array.isArray(v) && v.length);

const M = mongoose.model({ arr: { type: Array, required: true } });
new M({ arr: [] }).validateSync(); // `null`, validation fails!
```

Example 2 (css):
```css
// Make all Array instances have `required` of true by default.
mongoose.Schema.Array.set('required', true);

const User = mongoose.model('User', new Schema({ test: Array }));
new User({ }).validateSync().errors.test.message; // Path `test` is required.
```

---

## Map

**URL:** https://mongoosejs.com/docs/api/map.html

**Contents:**
- Map
  - MongooseMap.prototype.$isMongooseMap
      - Type:
  - MongooseMap.prototype.clear()
  - MongooseMap.prototype.delete()
  - MongooseMap.prototype.get()
  - MongooseMap.prototype.set()
    - Example:
  - MongooseMap.prototype.toBSON()
  - MongooseMap.prototype.toJSON()

Set to true for all Mongoose map instances

Overwrites native Map's clear() function to support change tracking.

Overwrites native Map's delete() function to support change tracking.

Overwrites native Map's get() function to support Mongoose getters.

Overwrites native Map's set() function to support setters, populate(), and change tracking. Note that Mongoose maps only support strings and ObjectIds as keys.

Converts this map to a native JavaScript Map so the MongoDB driver can serialize it.

Converts this map to a native JavaScript Map for JSON.stringify(). Set the flattenMaps option to convert this map to a POJO instead.

**Examples:**

Example 1 (css):
```css
doc.myMap.set('test', 42); // works
doc.myMap.set({ obj: 42 }, 42); // Throws "Mongoose maps only support string keys"
doc.myMap.set(10, 42); // Throws "Mongoose maps only support string keys"
doc.myMap.set("$test", 42); // Throws "Mongoose maps do not support keys that start with "$", got "$test""
```

Example 2 (css):
```css
doc.myMap.toJSON() instanceof Map; // true
doc.myMap.toJSON({ flattenMaps: true }) instanceof Map; // false
```

---

## Document

**URL:** https://mongoosejs.com/docs/6.x/docs/api/document.html

**Contents:**
- Document
  - Document.prototype.$assertPopulated()
      - Parameters:
      - Returns:
    - Example:
  - Document.prototype.$clone()
      - Returns:
  - Document.prototype.$errors
      - Type:
  - Document.prototype.$getAllSubdocs()

Throws an error if a given path is not populated

Returns a copy of this document with a deep clone of _doc and $__.

Hash containing current validation $errors.

Get all subdocs (by bfs)

Gets all populated documents associated with this document.

Don't run validation on this path or persist changes to this path.

Increments the numeric value at path by the given val. When you call save() on this document, Mongoose will send a $inc as opposed to a $set.

Checks if a path is set to its default.

Getter/setter, determines whether the document was removed or not.

Returns true if the given path is nullish or only contains empty objects. Useful for determining whether this subdoc will get stripped out by the minimize option.

Boolean flag specifying if the document is new. If you create a document using new, this document will be considered "new". $isNew is how Mongoose determines whether save() should use insertOne() to create a new document or updateOne() to update an existing document.

On the other hand, if you load an existing document from the database using findOne() or another query operation, $isNew will be false.

Mongoose sets $isNew to false immediately after save() succeeds. That means Mongoose sets $isNew to false before post('save') hooks run. In post('save') hooks, $isNew will be false if save() succeeded.

For subdocuments, $isNew is true if either the parent has $isNew set, or if you create a new subdocument.

Empty object that you can use for storing properties on the document. This is handy for passing data to middleware without conflicting with Mongoose internals.

Marks a path as valid, removing existing validation errors.

A string containing the current operation that Mongoose is executing on this document. May be null, 'save', 'validate', or 'remove'.

Alias for parent(). If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Getter/setter around the session associated with this document. Used to automatically set session if you save() a doc that you got from a query with an associated session.

If this is a top-level document, setting the session propagates to all child docs.

Alias for set(), used internally to avoid conflicts

Getter/setter around whether this document will apply timestamps by default when using save() and bulkSave().

Set this property to add additional query filters when Mongoose saves this document and isNew is false.

Takes a populated field and returns it to its unpopulated state.

If the path was not provided, then all populated fields are returned to their unpopulated state.

Returns the list of paths that have been directly modified. A direct modified path is a path that you explicitly set, whether via doc.foo = 'bar', Object.assign(doc, { foo: 'bar' }), or doc.set('foo', 'bar').

A path a may be in modifiedPaths() but not in directModifiedPaths() because a child of a was directly modified.

Returns true if this document is equal to another document.

Documents are considered equal when they have matching _ids, unless neither document has an _id, in which case this function falls back to using deepEqual().

Hash containing current validation errors.

Returns the value of a path.

Returns the changes that happened to the document in the format that will be sent to MongoDB.

Modifying the object that getChanges() returns does not affect the document's change tracking state. Even if you delete user.getChanges().$set, Mongoose will still send a $set to the server.

The string version of this documents _id.

This getter exists on all documents by default. The getter can be disabled by setting the id option of its Schema to false at construction time.

Initializes the document without setters or marking anything modified.

Called internally after a document is returned from mongodb. Normally, you do not need to call this function on your own.

This function triggers init middleware. Note that init hooks are synchronous.

Helper for console.log

Marks a path as invalid, causing validation to fail.

The errorMsg argument will become the message of the ValidationError.

The value argument (if passed) will be available through the ValidationError.value property.

Returns true if path was directly set and modified, else false.

Checks if path was explicitly selected. If no projection, always returns true.

Checks if path is in the init state, that is, it was set by Document#init() and not modified since.

Returns true if any of the given paths is modified, else false. If no arguments, returns true if any path in this document is modified.

If path is given, checks if a path or any full path containing path as part of its path chain has been modified.

Legacy alias for $isNew.

Checks if path was selected in the source query which initialized this document.

Marks the path as having pending changes to write to the db.

Very helpful when using Mixed types.

Returns the list of paths that have been modified.

Overwrite all values in this document with the values of obj, except for immutable properties. Behaves similarly to set(), except for it unsets all properties that aren't in obj.

If this document is a subdocument or populated document, returns the document's parent. Returns the original document if there is no parent.

Populates paths on an existing document.

Gets _id(s) used during population of the given path.

If the path was not populated, returns undefined.

Sends a replaceOne command with this document _id as the query selector.

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation only with the modifications to the database, it does not replace the whole document in the latter case.

If save is successful, the returned promise will fulfill with the document saved.

The document's schema.

Sets the value of a path, or many paths. Alias for .$set.

The return value of this method is used in calls to JSON.stringify(doc).

This method accepts the same options as Document#toObject. To apply the options to every document of your schema by default, set your schemas toJSON option to the same argument.

There is one difference between toJSON() and toObject() options. When you call toJSON(), the flattenMaps option defaults to true, because JSON.stringify() doesn't convert maps to objects by default. When you call toObject(), the flattenMaps option is false by default.

See schema options for more information on setting toJSON option defaults.

Converts this document into a plain-old JavaScript object (POJO).

Buffers are converted to instances of mongodb.Binary for proper storage.

Example of only applying path getters

Example of only applying virtual getters

Example of applying both path and virtual getters

To apply these options to every document of your schema by default, set your schemas toObject option to the same argument.

We may need to perform a transformation of the resulting object based on some criteria, say to remove some sensitive information or return a custom object. In this case we set the optional transform function.

Transform functions receive three arguments

With transformations we can do a lot more than remove properties. We can even return completely new customized objects:

Note: if a transform function returns undefined, the return value will be ignored.

Transformations may also be applied inline, overridding any transform set in the options:

If you want to skip transformations, use transform: false:

If you pass a transform in toObject() options, Mongoose will apply the transform to subdocuments in addition to the top-level document. Similarly, transform: false skips transforms for all subdocuments. Note that this behavior is different for transforms defined in the schema: if you define a transform in schema.options.toObject.transform, that transform will not apply to subdocuments.

Transforms, like all of these options, are also available for toJSON. See this guide to JSON.stringify() to learn why toJSON() and toObject() are separate functions.

See schema options for some more details.

During save, no custom options are applied to the document before being sent to the database.

Helper for console.log

Clears the modified state on the specified path.

Sends an update command with this document _id as the query selector.

Sends an updateOne command with this document _id as the query selector.

Executes registered validation rules for this document.

This method is called pre save and if a validation rule is violated, save is aborted and the error is returned to your callback.

Executes registered validation rules (skipping asynchronous validators) for this document.

This method is useful if you need synchronous validation.

**Examples:**

Example 1 (javascript):
```javascript
const doc = await Model.findOne().populate('author');

doc.$assertPopulated('author'); // does not throw
doc.$assertPopulated('other path'); // throws an error

// Manually populate and assert in one call. The following does
// `doc.$set({ likes })` before asserting.
doc.$assertPopulated('likes', { likes });
```

Example 2 (bash):
```bash
doc.foo = null;
doc.$ignore('foo');
doc.save(); // changes to foo will not be persisted and validators won't be run
```

Example 3 (javascript):
```javascript
const schema = new Schema({ counter: Number });
const Test = db.model('Test', schema);

const doc = await Test.create({ counter: 0 });
doc.$inc('counter', 2);
await doc.save(); // Sends a `{ $inc: { counter: 2 } }` to MongoDB
doc.counter; // 2

doc.counter += 2;
await doc.save(); // Sends a `{ $set: { counter: 2 } }` to MongoDB
```

Example 4 (css):
```css
MyModel = mongoose.model('test', { name: { type: String, default: 'Val '} });
const m = new MyModel();
m.$isDefault('name'); // true
```

---

## Mongoose

**URL:** https://mongoosejs.com/docs/api/mongoose.html

**Contents:**
- Mongoose
  - Mongoose()
      - Parameters:
    - Example:
  - Mongoose.prototype.Aggregate()
  - Mongoose.prototype.CastError()
      - Parameters:
  - Mongoose.prototype.Collection()
  - Mongoose.prototype.Collection()
  - Mongoose.prototype.Connection()

Mongoose constructor.

The exports object of the mongoose module is an instance of this class. Most apps will only use this one instance.

The Mongoose Aggregate constructor

The Mongoose CastError constructor

The Base Mongoose Collection class. mongoose.Collection extends from this class.

The Mongoose Collection constructor

The Mongoose Connection constructor

The Base Mongoose Connection class. mongoose.Connection extends from this class.

Expose connection states for user-land

The Mongoose Date SchemaType.

The Mongoose Decimal128 SchemaType. Used for declaring paths in your schema that should be 128-bit decimal floating points. Do not use this to create a new Decimal128 instance, use mongoose.Types.Decimal128 instead.

The Mongoose Document constructor.

The MongooseError constructor.

The Mongoose Mixed SchemaType. Used for declaring paths in your schema that Mongoose's change tracking, casting, and validation should ignore.

The Mongoose Model constructor.

The Mongoose constructor

The exports of the mongoose module is an instance of this class.

The Mongoose Number SchemaType. Used for declaring paths in your schema that Mongoose should cast to numbers.

The Mongoose ObjectId SchemaType. Used for declaring paths in your schema that should be MongoDB ObjectIds. Do not use this to create a new ObjectId instance, use mongoose.Types.ObjectId instead.

The Mongoose Query constructor.

Expose connection states for user-land

The Mongoose Schema constructor

The Mongoose SchemaType constructor

The constructor used for schematype options

The various Mongoose SchemaTypes.

Alias of mongoose.Schema.Types for backwards compatibility.

The various Mongoose Types.

Using this exposed access to the ObjectId type, we can construct ids on demand.

The Mongoose VirtualType constructor

Opens the default mongoose connection.

The Mongoose module's default connection. Equivalent to mongoose.connections[0], see connections.

This is the connection used by default for every model created using mongoose.model.

To create a new connection, use createConnection().

An array containing all connections associated with this Mongoose instance. By default, there is 1 connection. Calling createConnection() adds a connection to this array.

Creates a Connection instance.

Each connection instance maps to a single database. This method is helpful when managing multiple db connections.

Options passed take precedence over options included in connection strings.

Removes the model named name from the default connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Equivalent to mongoose.connection.deleteModel(name).

Runs .close() on all connections in parallel.

Object with get() and set() containing the underlying driver this Mongoose instance uses to communicate with the database. A driver is a Mongoose-specific interface that defines functions like find().

Gets mongoose options

Returns true if the given value is a Mongoose ObjectId (using instanceof) or if the given value is a 24 character hex string, which is the most commonly used string representation of an ObjectId.

This function is similar to isValidObjectId(), but considerably more strict, because isValidObjectId() will return true for any value that Mongoose can convert to an ObjectId. That includes Mongoose documents, any string of length 12, and any number. isObjectIdOrHexString() returns true only for ObjectId instances or 24 character hex strings, and will return false for numbers, documents, and strings of length 12.

Returns true if Mongoose can cast the given value to an ObjectId, or false otherwise.

Defines a model or retrieves it.

Models defined on the mongoose instance are available to all connection created by the same mongoose instance.

If you call mongoose.model() with twice the same name but a different schema, you will get an OverwriteModelError. If you call mongoose.model() with the same name and same schema, you'll get the same schema back.

When no collection argument is passed, Mongoose uses the model name. If you don't like this behavior, either pass a collection name, use mongoose.pluralize(), or set your schemas collection name option.

Returns an array of model names created on this instance of Mongoose.

Does not include names of models created using connection.model().

The mquery query builder Mongoose uses.

Mongoose uses this function to get the current time when setting timestamps. You may stub out this function using a tool like Sinon for testing.

Takes in an object and deletes any keys from the object whose values are strictly equal to undefined. This function is useful for query filters because Mongoose treats TestModel.find({ name: undefined }) as TestModel.find({ name: null }).

Use this function in pre() middleware to replace the arguments passed to the next middleware or hook.

Use this function in post() middleware to replace the result

Declares a global plugin executed on all Schemas.

Equivalent to calling .plugin(fn) on each Schema you create.

Getter/setter around function for pluralizing collection names.

Sanitizes query filters against query selector injection attacks by wrapping any nested objects that have a property whose name starts with $ in a $eq.

Sets mongoose options

key can be used a object to set multiple options at once. If a error gets thrown for one option, other options will still be evaluated.

Currently supported options are:

Overwrites the current driver used by this Mongoose instance. A driver is a Mongoose-specific interface that defines functions like find().

Use this function in pre() middleware to skip calling the wrapped function.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling mongoose.startSession() is equivalent to calling mongoose.connection.startSession(). Sessions are scoped to a connection, so calling mongoose.startSession() starts a session on the default mongoose connection.

Syncs all the indexes for the models registered with this connection.

Tells sanitizeFilter() to skip the given object when filtering out potential query selector injection attacks. Use this method when you have a known query selector that you want to use.

**Examples:**

Example 1 (javascript):
```javascript
const mongoose = require('mongoose');
mongoose instanceof mongoose.Mongoose; // true

// Create a new Mongoose instance with its own `connect()`, `set()`, `model()`, etc.
const m = new mongoose.Mongoose();
```

Example 2 (css):
```css
const schema = new Schema({ test: Date });
schema.path('test') instanceof mongoose.Date; // true
```

Example 3 (css):
```css
const vehicleSchema = new Schema({ fuelLevel: mongoose.Decimal128 });
```

Example 4 (css):
```css
const schema = new Schema({ arbitrary: mongoose.Mixed });
```

---

## Schematype

**URL:** https://mongoosejs.com/docs/5.x/docs/api/schematype.html

**Contents:**
- Schematype
  - SchemaType()
      - Parameters
    - Example:
  - SchemaType.prototype.cast()
      - Parameters
  - SchemaType.prototype.default()
      - Parameters
      - Returns:
    - Example:

SchemaType constructor. Do not instantiate SchemaType directly. Mongoose converts your schema paths into SchemaTypes automatically.

The function that Mongoose calls to cast arbitrary values to this SchemaType.

Sets a default value for this SchemaType.

Defaults can be either functions which return the value to use as the default or the literal value itself. Either way, the value will be cast based on its schema type before being set during document creation.

Adds a getter to this schematype.

Getters allow you to transform the representation of the data as it travels from the raw mongodb document to the value that you see.

Suppose you are storing credit card numbers and you want to hide everything except the last 4 digits to the mongoose user. You can do so by defining a getter in the following way:

Getters are also passed a second argument, the schematype on which the getter was defined. This allows for tailored behavior based on options passed in the schema.

Defines this path as immutable. Mongoose prevents you from changing immutable paths unless the parent document has isNew: true.

Mongoose also prevents changing immutable properties using updateOne() and updateMany() based on strict mode.

Declares the index options for this schematype.

Indexes are created in the background by default. If background is set to false, MongoDB will not execute any read/write operations you send until the index build. Specify background: false to override Mongoose's default.

Set the model that this path refers to. This is the option that populate looks at to determine the foreign collection it should query.

Adds a required validator to this SchemaType. The validator gets added to the front of this SchemaType's validators array using unshift().

The required validator uses the SchemaType's checkRequired function to determine whether a given value satisfies the required validator. By default, a value satisfies the required validator if val != null (that is, if the value is not null nor undefined). However, most built-in mongoose schema types override the default checkRequired function:

Sets default select() behavior for this path.

Set to true if this path should always be included in the results, false if it should be excluded by default. This setting can be overridden at the query level.

Adds a setter to this schematype.

Setters allow you to transform the data before it gets to the raw mongodb document or query.

Suppose you are implementing user registration for a website. Users provide an email and password, which gets saved to mongodb. The email is a string that you will want to normalize to lower case, in order to avoid one email having more than one account -- e.g., otherwise, avenue@q.com can be registered for 2 accounts via avenue@q.com and AvEnUe@Q.CoM.

You can set up email lower case normalization easily via a Mongoose setter.

As you can see above, setters allow you to transform the data before it stored in MongoDB, or before executing a query.

NOTE: we could have also just used the built-in lowercase: true SchemaType option instead of defining our own function.

Setters are also passed a second argument, the schematype on which the setter was defined. This allows for tailored behavior based on options passed in the schema.

You can also use setters to modify other properties on the document. If you're setting a property name on a document, the setter will run with this as the document. Be careful, in mongoose 5 setters will also run when querying by name with this as the query.

Declares a sparse index.

Declares a full text index.

Defines a custom function for transforming this path when converting a document to JSON.

Mongoose calls this function with one parameter: the current value of the path. Mongoose then uses the return value in the JSON output.

Declares an unique index.

NOTE: violating the constraint returns an E11000 error from MongoDB when saving, not a Mongoose validation error.

Adds validator(s) for this document path.

Validators always receive the value to validate as their first argument and must return Boolean. Returning false or throwing an error means validation failed.

The error message argument is optional. If not passed, the default generic error message template will be used.

From the examples above, you may have noticed that error messages support basic templating. There are a few other template keywords besides {PATH} and {VALUE} too. To find out more, details are available here.

If Mongoose's built-in error message templating isn't enough, Mongoose supports setting the message property to a function.

To bypass Mongoose's error messages and just copy the error message that the validator throws, do this:

Mongoose supports validators that return a promise. A validator that returns a promise is called an async validator. Async validators run in parallel, and validate() will wait until all async validators have settled.

You might use asynchronous validators to retreive other documents from the database to validate against or to meet other I/O bound validation needs.

Validation occurs pre('save') or whenever you manually execute document#validate.

If validation fails during pre('save') and no callback was passed to receive the error, an error event will be emitted on your Models associated db connection, passing the validation error object along.

If you want to handle these errors at the Model level, add an error listener to your Model as shown below.

Get/set the function used to cast arbitrary values to this type.

Get/set the function used to cast arbitrary values to this particular schematype instance. Overrides SchemaType.cast().

Override the function the required validator uses to check whether a value passes the required check. Override this on the individual SchemaType.

Attaches a getter for all instances of this schema type.

Sets a default option for this schema type.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ name: String });
schema.path('name') instanceof SchemaType; // true
```

Example 2 (javascript):
```javascript
const schema = new Schema({ n: { type: Number, default: 10 })
const M = db.model('M', schema)
const m = new M;
console.log(m.n) // 10
```

Example 3 (javascript):
```javascript
// values are cast:
const schema = new Schema({ aNumber: { type: Number, default: 4.815162342 }})
const M = db.model('M', schema)
const m = new M;
console.log(m.aNumber) // 4.815162342

// default unique objects for Mixed types:
const schema = new Schema({ mixed: Schema.Types.Mixed });
schema.path('mixed').default(function () {
  return {};
});

// if we don't use a function to return object literals for Mixed defaults,
// each document will receive a reference to the same object literal creating
// a "shared" object instance:
const schema = new Schema({ mixed: Schema.Types.Mixed });
schema.path('mixed').default({});
const M = db.model('M', schema);
const m1 = new M;
m1.mixed.added = 1;
console.log(m1.mixed); // { added: 1 }
const m2 = new M;
console.log(m2.mixed); // { added: 1 }
```

Example 4 (javascript):
```javascript
function dob (val) {
  if (!val) return val;
  return (val.getMonth() + 1) + "/" + val.getDate() + "/" + val.getFullYear();
}

// defining within the schema
const s = new Schema({ born: { type: Date, get: dob })

// or by retreiving its SchemaType
const s = new Schema({ born: Date })
s.path('born').get(dob)
```

---

## Subdocument

**URL:** https://mongoosejs.com/docs/api/subdocument.html

**Contents:**
- Subdocument
  - Subdocument.prototype.$parent()
  - Subdocument.prototype.$toObject()
  - Subdocument.prototype.deleteOne()
      - Parameters:
  - Subdocument.prototype.inspect()
  - Subdocument.prototype.ownerDocument()
      - Returns:
  - Subdocument.prototype.parent()

Returns this sub-documents parent document.

Override $toObject() to handle minimizing the whole path. Should not minimize if schematype-level minimize is set to false re: gh-11247, gh-14058, gh-14151

Helper for console.log

Returns the top level document of this sub-document.

Returns this sub-documents parent document.

---

## Schematype

**URL:** https://mongoosejs.com/docs/6.x/docs/api/schematype.html

**Contents:**
- Schematype
  - SchemaType()
      - Parameters:
    - Example:
  - SchemaType.cast()
      - Parameters:
      - Returns:
    - Example:
  - SchemaType.checkRequired()
      - Parameters:

SchemaType constructor. Do not instantiate SchemaType directly. Mongoose converts your schema paths into SchemaTypes automatically.

Get/set the function used to cast arbitrary values to this type.

Set & Get the checkRequired function Override the function the required validator uses to check whether a value passes the required check. Override this on the individual SchemaType.

Attaches a getter for all instances of this schema type.

The function that Mongoose calls to cast arbitrary values to this SchemaType.

Get/set the function used to cast arbitrary values to this particular schematype instance. Overrides SchemaType.cast().

Sets a default value for this SchemaType.

Defaults can be either functions which return the value to use as the default or the literal value itself. Either way, the value will be cast based on its schema type before being set during document creation.

Performs a validation of value using the validators declared for this SchemaType.

Adds a getter to this schematype.

Getters allow you to transform the representation of the data as it travels from the raw mongodb document to the value that you see.

Suppose you are storing credit card numbers and you want to hide everything except the last 4 digits to the mongoose user. You can do so by defining a getter in the following way:

Getters are also passed a second argument, the schematype on which the getter was defined. This allows for tailored behavior based on options passed in the schema.

Defines this path as immutable. Mongoose prevents you from changing immutable paths unless the parent document has isNew: true.

Mongoose also prevents changing immutable properties using updateOne() and updateMany() based on strict mode.

Declares the index options for this schematype.

Indexes are created in the background by default. If background is set to false, MongoDB will not execute any read/write operations you send until the index build. Specify background: false to override Mongoose's default.

True if this SchemaType has a required validator. False otherwise.

The path to this SchemaType in a Schema.

Set the model that this path refers to. This is the option that populate looks at to determine the foreign collection it should query.

Adds a required validator to this SchemaType. The validator gets added to the front of this SchemaType's validators array using unshift().

The required validator uses the SchemaType's checkRequired function to determine whether a given value satisfies the required validator. By default, a value satisfies the required validator if val != null (that is, if the value is not null nor undefined). However, most built-in mongoose schema types override the default checkRequired function:

Sets default select() behavior for this path.

Set to true if this path should always be included in the results, false if it should be excluded by default. This setting can be overridden at the query level.

Adds a setter to this schematype.

Setters allow you to transform the data before it gets to the raw mongodb document or query.

Suppose you are implementing user registration for a website. Users provide an email and password, which gets saved to mongodb. The email is a string that you will want to normalize to lower case, in order to avoid one email having more than one account -- e.g., otherwise, avenue@q.com can be registered for 2 accounts via avenue@q.com and AvEnUe@Q.CoM.

You can set up email lower case normalization easily via a Mongoose setter.

As you can see above, setters allow you to transform the data before it stored in MongoDB, or before executing a query.

NOTE: we could have also just used the built-in lowercase: true SchemaType option instead of defining our own function.

Setters are also passed a second argument, the schematype on which the setter was defined. This allows for tailored behavior based on options passed in the schema.

You can also use setters to modify other properties on the document. If you're setting a property name on a document, the setter will run with this as the document. Be careful, in mongoose 5 setters will also run when querying by name with this as the query.

Declares a sparse index.

Declares a full text index.

Defines a custom function for transforming this path when converting a document to JSON.

Mongoose calls this function with one parameter: the current value of the path. Mongoose then uses the return value in the JSON output.

Declares an unique index.

NOTE: violating the constraint returns an E11000 error from MongoDB when saving, not a Mongoose validation error.

Adds validator(s) for this document path.

Validators always receive the value to validate as their first argument and must return Boolean. Returning false or throwing an error means validation failed.

The error message argument is optional. If not passed, the default generic error message template will be used.

From the examples above, you may have noticed that error messages support basic templating. There are a few other template keywords besides {PATH} and {VALUE} too. To find out more, details are available here.

If Mongoose's built-in error message templating isn't enough, Mongoose supports setting the message property to a function.

To bypass Mongoose's error messages and just copy the error message that the validator throws, do this:

Mongoose supports validators that return a promise. A validator that returns a promise is called an async validator. Async validators run in parallel, and validate() will wait until all async validators have settled.

You might use asynchronous validators to retreive other documents from the database to validate against or to meet other I/O bound validation needs.

Validation occurs pre('save') or whenever you manually execute document#validate.

If validation fails during pre('save') and no callback was passed to receive the error, an error event will be emitted on your Models associated db connection, passing the validation error object along.

If you want to handle these errors at the Model level, add an error listener to your Model as shown below.

The validators that Mongoose should run to validate properties at this SchemaType's path.

Sets a default option for this schema type.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ name: String });
schema.path('name') instanceof SchemaType; // true
```

Example 2 (r):
```r
// Disallow `null` for numbers, and don't try to cast any values to
// numbers, so even strings like '123' will cause a CastError.
mongoose.Number.cast(function(v) {
  assert.ok(v === undefined || typeof v === 'number');
  return v;
});
```

Example 3 (javascript):
```javascript
// Use this to allow empty strings to pass the `required` validator
mongoose.Schema.Types.String.checkRequired(v => typeof v === 'string');
```

Example 4 (r):
```r
// Make all numbers round down
mongoose.Number.get(function(v) { return Math.floor(v); });
```

---

## Connection

**URL:** https://mongoosejs.com/docs/5.x/docs/api/connection.html

**Contents:**
- Connection
  - Connection()
      - Parameters
      - Inherits:
  - Connection.prototype.client
      - Type:
  - Connection.prototype.close()
      - Parameters
      - Returns:
  - Connection.prototype.collection()

Connection constructor

For practical reasons, a Connection equals a Db.

The MongoClient instance this connection uses to talk to MongoDB. Mongoose automatically sets this property when the connection is opened.

Closes the connection

Retrieves a collection, creating it if not cached.

Not typically needed by applications. Just talk to your collection through your model.

A hash of the collections associated with this connection

A hash of the global options that are associated with this connection

Helper for createCollection(). Will explicitly create the given collection with specified options. Used to create capped collections and views from mongoose.

Options are passed down without modification to the MongoDB driver's createCollection() function

The mongodb.Db instance, set when the connection is opened

Removes the model named name from this connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Helper for dropCollection(). Will delete the given collection, including all documents and indexes.

Helper for dropDatabase(). Deletes the given database, including all collections, documents, and indexes.

Gets the value of the option key. Equivalent to conn.options[key]

Returns the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB.

The host name portion of the URI. If multiple hosts, such as a replica set, this will contain the first host name in the URI

A number identifier for this connection. Used for debugging when you have multiple connections.

Defines or retrieves a model.

When no collection argument is passed, Mongoose produces a collection name by passing the model name to the utils.toCollectionName method. This method pluralizes the name. If you don't like this behavior, either pass a collection name or set your schemas collection name option.

Returns an array of model names created on this connection.

A POJO containing a map from model names to models. Contains all models that have been added to this connection using Connection#model().

The name of the database this connection points to.

Opens the connection with a URI using MongoClient.connect().

The password specified in the URI

Declares a plugin executed on all schemas you pass to conn.model()

Equivalent to calling .plugin(fn) on each schema you create.

The plugins that will be applied to all models created on this connection.

The port portion of the URI. If multiple hosts, such as a replica set, this will contain the port from the first host name in the URI.

Connection ready state

Each state change emits its associated event name.

Sets the value of the option key. Equivalent to conn.options[key] = val

Set the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB. This is useful if you already have a MongoClient instance, and want to reuse it.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Requires MongoDB >= 3.6.0. Executes the wrapped async function in a transaction. Mongoose will commit the transaction if the async function executes successfully and attempt to retry if there was a retriable error.

Calls the MongoDB driver's session.withTransaction(), but also handles resetting Mongoose document state as shown below.

Switches to a different database using the same connection pool.

Returns a new connection object, with the new db.

The username specified in the URI

Watches the entire underlying database for changes. Similar to Model.watch().

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

**Examples:**

Example 1 (css):
```css
conn.model('User', new Schema({ name: String }));
console.log(conn.model('User')); // Model object
conn.deleteModel('User');
console.log(conn.model('User')); // undefined

// Usually useful in a Mocha `afterEach()` hook
afterEach(function() {
  conn.deleteModel(/.+/); // Delete every model
});
```

Example 2 (javascript):
```javascript
const conn = mongoose.createConnection('mongodb://localhost:27017/mydb');
// Deletes the entire 'mydb' database
await conn.dropDatabase();
```

Example 3 (unknown):
```unknown
conn.get('test'); // returns the 'test' value
```

Example 4 (javascript):
```javascript
const conn = await mongoose.createConnection('mongodb://localhost:27017/test');

conn.getClient(); // MongoClient { ... }
```

---

## Document

**URL:** https://mongoosejs.com/docs/api/document.html

**Contents:**
- Document
  - Document.prototype.$assertPopulated()
      - Parameters:
      - Returns:
    - Example:
  - Document.prototype.$clearModifiedPaths()
      - Returns:
    - Example:
  - Document.prototype.$clone()
      - Returns:

Throws an error if a given path is not populated

Clear the document's modified paths.

Returns a copy of this document with a deep clone of _doc and $__.

Creates a snapshot of this document's internal change tracking state. You can later reset this document's change tracking state using $restoreModifiedPathsSnapshot().

Hash containing current validation $errors.

Get all subdocs (by bfs)

Gets all populated documents associated with this document.

Don't run validation on this path or persist changes to this path.

Increments the numeric value at path by the given val. When you call save() on this document, Mongoose will send a $inc as opposed to a $set.

Checks if a path is set to its default.

Getter/setter, determines whether the document was deleted. The Model.prototype.deleteOne() method sets $isDeleted if the delete operation succeeded.

Returns true if the given path is nullish or only contains empty objects. Useful for determining whether this subdoc will get stripped out by the minimize option.

Boolean flag specifying if the document is new. If you create a document using new, this document will be considered "new". $isNew is how Mongoose determines whether save() should use insertOne() to create a new document or updateOne() to update an existing document.

On the other hand, if you load an existing document from the database using findOne() or another query operation, $isNew will be false.

Mongoose sets $isNew to false immediately after save() succeeds. That means Mongoose sets $isNew to false before post('save') hooks run. In post('save') hooks, $isNew will be false if save() succeeded.

For subdocuments, $isNew is true if either the parent has $isNew set, or if you create a new subdocument.

Empty object that you can use for storing properties on the document. This is handy for passing data to middleware without conflicting with Mongoose internals.

Marks a path as valid, removing existing validation errors.

A string containing the current operation that Mongoose is executing on this document. May be null, 'save', 'validate', or 'remove'.

Alias for parent(). If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Restore this document's change tracking state to the given snapshot. Note that $restoreModifiedPathsSnapshot() does not modify the document's properties, just resets the change tracking state.

This method is especially useful when writing custom transaction wrappers that need to restore change tracking when aborting a transaction.

Getter/setter around the session associated with this document. Used to automatically set session if you save() a doc that you got from a query with an associated session.

If this is a top-level document, setting the session propagates to all child docs.

Alias for set(), used internally to avoid conflicts

Getter/setter around whether this document will apply timestamps by default when using save() and bulkSave().

Set this property to add additional query filters when Mongoose saves this document and isNew is false.

Takes a populated field and returns it to its unpopulated state.

If the path was not provided, then all populated fields are returned to their unpopulated state.

Returns the list of paths that have been directly modified. A direct modified path is a path that you explicitly set, whether via doc.foo = 'bar', Object.assign(doc, { foo: 'bar' }), or doc.set('foo', 'bar').

A path a may be in modifiedPaths() but not in directModifiedPaths() because a child of a was directly modified.

Returns true if this document is equal to another document.

Documents are considered equal when they have matching _ids, unless neither document has an _id, in which case this function falls back to using deepEqual().

Hash containing current validation errors.

Returns the value of a path.

Returns the changes that happened to the document in the format that will be sent to MongoDB.

Modifying the object that getChanges() returns does not affect the document's change tracking state. Even if you delete user.getChanges().$set, Mongoose will still send a $set to the server.

The string version of this documents _id.

This getter exists on all documents by default. The getter can be disabled by setting the id option of its Schema to false at construction time.

Hydrates this document with the data in doc. Does not run setters or mark any paths modified.

Called internally after a document is returned from MongoDB. Normally, you do not need to call this function on your own.

This function triggers init middleware. Note that init hooks are synchronous.

Helper for console.log

Marks a path as invalid, causing validation to fail.

The errorMsg argument will become the message of the ValidationError.

The value argument (if passed) will be available through the ValidationError.value property.

Returns true if path was directly set and modified, else false.

Checks if path was explicitly selected. If no projection, always returns true.

Checks if path is in the init state, that is, it was set by Document#init() and not modified since.

Returns true if any of the given paths is modified, else false. If no arguments, returns true if any path in this document is modified.

If path is given, checks if a path or any full path containing path as part of its path chain has been modified.

Legacy alias for $isNew.

Checks if path was selected in the source query which initialized this document.

Marks the path as having pending changes to write to the db.

Very helpful when using Mixed types.

Returns the list of paths that have been modified.

Overwrite all values in this document with the values of obj, except for immutable properties. Behaves similarly to set(), except for it unsets all properties that aren't in obj.

If this document is a subdocument or populated document, returns the document's parent. Returns the original document if there is no parent.

Populates paths on an existing document.

Gets _id(s) used during population of the given path.

If the path was not populated, returns undefined.

Sends a replaceOne command with this document _id as the query selector.

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation only with the modifications to the database, it does not replace the whole document in the latter case.

If save is successful, the returned promise will fulfill with the document saved.

The document's schema.

Sets the value of a path, or many paths. Alias for .$set.

The return value of this method is used in calls to JSON.stringify(doc).

This method accepts the same options as Document#toObject. To apply the options to every document of your schema by default, set your schemas toJSON option to the same argument.

There is one difference between toJSON() and toObject() options. When you call toJSON(), the flattenMaps option defaults to true, because JSON.stringify() doesn't convert maps to objects by default. When you call toObject(), the flattenMaps option is false by default.

See schema options for more information on setting toJSON option defaults.

Converts this document into a plain-old JavaScript object (POJO).

Buffers are converted to instances of mongodb.Binary for proper storage.

Example of only applying path getters

Example of only applying virtual getters

Example of applying both path and virtual getters

To apply these options to every document of your schema by default, set your schemas toObject option to the same argument.

We may need to perform a transformation of the resulting object based on some criteria, say to remove some sensitive information or return a custom object. In this case we set the optional transform function.

Transform functions receive three arguments

With transformations we can do a lot more than remove properties. We can even return completely new customized objects:

Note: if a transform function returns undefined, the return value will be ignored.

Transformations may also be applied inline, overridding any transform set in the schema options. Any transform function specified in toObject options also propagates to any subdocuments.

If you want to skip transformations, use transform: false:

If you pass a transform in toObject() options, Mongoose will apply the transform to subdocuments in addition to the top-level document. Similarly, transform: false skips transforms for all subdocuments. Note that this behavior is different for transforms defined in the schema: if you define a transform in schema.options.toObject.transform, that transform will not apply to subdocuments.

Transforms, like all of these options, are also available for toJSON. See this guide to JSON.stringify() to learn why toJSON() and toObject() are separate functions.

See schema options for some more details.

During save, no custom options are applied to the document before being sent to the database.

Helper for console.log

Clears the modified state on the specified path.

Sends an updateOne command with this document _id as the query selector.

Executes registered validation rules for this document.

This method is called pre save and if a validation rule is violated, save is aborted and the error is thrown.

Executes registered validation rules (skipping asynchronous validators) for this document.

This method is useful if you need synchronous validation.

**Examples:**

Example 1 (javascript):
```javascript
const doc = await Model.findOne().populate('author');

doc.$assertPopulated('author'); // does not throw
doc.$assertPopulated('other path'); // throws an error

// Manually populate and assert in one call. The following does
// `doc.$set({ likes })` before asserting.
doc.$assertPopulated('likes', { likes });
```

Example 2 (javascript):
```javascript
const doc = await TestModel.findOne();

doc.name = 'test';
doc.$isModified('name'); // true

doc.$clearModifiedPaths();
doc.name; // 'test', `$clearModifiedPaths()` does **not** modify the document's data, only change tracking
```

Example 3 (javascript):
```javascript
const doc = await TestModel.findOne();
const snapshot = doc.$createModifiedPathsSnapshot();
```

Example 4 (bash):
```bash
doc.foo = null;
doc.$ignore('foo');
doc.save(); // changes to foo will not be persisted and validators won't be run
```

---

## Virtualtype

**URL:** https://mongoosejs.com/docs/6.x/docs/api/virtualtype.html

**Contents:**
- Virtualtype
  - VirtualType()
      - Parameters:
    - Example:
  - VirtualType.prototype.applyGetters()
      - Parameters:
      - Returns:
  - VirtualType.prototype.applySetters()
      - Parameters:
      - Returns:

VirtualType constructor

This is what mongoose uses to define virtual attributes via Schema.prototype.virtual.

Applies getters to value.

Applies setters to value.

Adds a custom getter to this virtual.

Mongoose calls the getter function with the below 3 parameters.

Adds a custom setter to this virtual.

Mongoose calls the setter function with the below 3 parameters.

**Examples:**

Example 1 (javascript):
```javascript
const fullname = schema.virtual('fullname');
fullname instanceof mongoose.VirtualType // true
```

Example 2 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.get(function(value, virtual, doc) {
  return this.name.first + ' ' + this.name.last;
});
```

Example 3 (javascript):
```javascript
const virtual = schema.virtual('fullname');
virtual.set(function(value, virtual, doc) {
  const parts = value.split(' ');
  this.name.first = parts[0];
  this.name.last = parts[1];
});

const Model = mongoose.model('Test', schema);
const doc = new Model();
// Calls the setter with `value = 'Jean-Luc Picard'`
doc.fullname = 'Jean-Luc Picard';
doc.name.first; // 'Jean-Luc'
doc.name.last; // 'Picard'
```

---

## Schematype

**URL:** https://mongoosejs.com/docs/7.x/docs/api/schematype.html

**Contents:**
- Schematype
  - SchemaType()
      - Parameters:
    - Example:
  - SchemaType.cast()
      - Parameters:
      - Returns:
    - Example:
  - SchemaType.checkRequired()
      - Parameters:

SchemaType constructor. Do not instantiate SchemaType directly. Mongoose converts your schema paths into SchemaTypes automatically.

Get/set the function used to cast arbitrary values to this type.

Set & Get the checkRequired function Override the function the required validator uses to check whether a value passes the required check. Override this on the individual SchemaType.

Attaches a getter for all instances of this schema type.

The function that Mongoose calls to cast arbitrary values to this SchemaType.

Get/set the function used to cast arbitrary values to this particular schematype instance. Overrides SchemaType.cast().

Sets a default value for this SchemaType.

Defaults can be either functions which return the value to use as the default or the literal value itself. Either way, the value will be cast based on its schema type before being set during document creation.

Performs a validation of value using the validators declared for this SchemaType.

Adds a getter to this schematype.

Getters allow you to transform the representation of the data as it travels from the raw mongodb document to the value that you see.

Suppose you are storing credit card numbers and you want to hide everything except the last 4 digits to the mongoose user. You can do so by defining a getter in the following way:

Getters are also passed a second argument, the schematype on which the getter was defined. This allows for tailored behavior based on options passed in the schema.

Defines this path as immutable. Mongoose prevents you from changing immutable paths unless the parent document has isNew: true.

Mongoose also prevents changing immutable properties using updateOne() and updateMany() based on strict mode.

Declares the index options for this schematype.

Indexes are created in the background by default. If background is set to false, MongoDB will not execute any read/write operations you send until the index build. Specify background: false to override Mongoose's default.

True if this SchemaType has a required validator. False otherwise.

The path to this SchemaType in a Schema.

Set the model that this path refers to. This is the option that populate looks at to determine the foreign collection it should query.

Adds a required validator to this SchemaType. The validator gets added to the front of this SchemaType's validators array using unshift().

The required validator uses the SchemaType's checkRequired function to determine whether a given value satisfies the required validator. By default, a value satisfies the required validator if val != null (that is, if the value is not null nor undefined). However, most built-in mongoose schema types override the default checkRequired function:

Sets default select() behavior for this path.

Set to true if this path should always be included in the results, false if it should be excluded by default. This setting can be overridden at the query level.

Adds a setter to this schematype.

Setters allow you to transform the data before it gets to the raw mongodb document or query.

Suppose you are implementing user registration for a website. Users provide an email and password, which gets saved to mongodb. The email is a string that you will want to normalize to lower case, in order to avoid one email having more than one account -- e.g., otherwise, avenue@q.com can be registered for 2 accounts via avenue@q.com and AvEnUe@Q.CoM.

You can set up email lower case normalization easily via a Mongoose setter.

As you can see above, setters allow you to transform the data before it stored in MongoDB, or before executing a query.

NOTE: we could have also just used the built-in lowercase: true SchemaType option instead of defining our own function.

Setters are also passed a second argument, the schematype on which the setter was defined. This allows for tailored behavior based on options passed in the schema.

You can also use setters to modify other properties on the document. If you're setting a property name on a document, the setter will run with this as the document. Be careful, in mongoose 5 setters will also run when querying by name with this as the query.

Declares a sparse index.

Declares a full text index.

Defines a custom function for transforming this path when converting a document to JSON.

Mongoose calls this function with one parameter: the current value of the path. Mongoose then uses the return value in the JSON output.

Declares an unique index.

NOTE: violating the constraint returns an E11000 error from MongoDB when saving, not a Mongoose validation error.

Adds validator(s) for this document path.

Validators always receive the value to validate as their first argument and must return Boolean. Returning false or throwing an error means validation failed.

The error message argument is optional. If not passed, the default generic error message template will be used.

Below is a list of supported template keywords:

If Mongoose's built-in error message templating isn't enough, Mongoose supports setting the message property to a function.

To bypass Mongoose's error messages and just copy the error message that the validator throws, do this:

Mongoose supports validators that return a promise. A validator that returns a promise is called an async validator. Async validators run in parallel, and validate() will wait until all async validators have settled.

You might use asynchronous validators to retreive other documents from the database to validate against or to meet other I/O bound validation needs.

Validation occurs pre('save') or whenever you manually execute document#validate.

If validation fails during pre('save') and no callback was passed to receive the error, an error event will be emitted on your Models associated db connection, passing the validation error object along.

If you want to handle these errors at the Model level, add an error listener to your Model as shown below.

The validators that Mongoose should run to validate properties at this SchemaType's path.

Sets a default option for this schema type.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ name: String });
schema.path('name') instanceof SchemaType; // true
```

Example 2 (r):
```r
// Disallow `null` for numbers, and don't try to cast any values to
// numbers, so even strings like '123' will cause a CastError.
mongoose.Number.cast(function(v) {
  assert.ok(v === undefined || typeof v === 'number');
  return v;
});
```

Example 3 (javascript):
```javascript
// Use this to allow empty strings to pass the `required` validator
mongoose.Schema.Types.String.checkRequired(v => typeof v === 'string');
```

Example 4 (r):
```r
// Make all numbers round down
mongoose.Number.get(function(v) { return Math.floor(v); });
```

---

## Connection

**URL:** https://mongoosejs.com/docs/api/connection.html

**Contents:**
- Connection
  - Connection()
      - Parameters:
      - Inherits:
  - Connection.prototype.aggregate()
      - Parameters:
      - Returns:
  - Connection.prototype.asPromise()
      - Returns:
    - Example:

Connection constructor

For practical reasons, a Connection equals a Db.

Runs a db-level aggregate() on this connection's underlying db

Returns a promise that resolves when this connection successfully connects to MongoDB, or rejects if this connection failed to connect.

Requires MongoDB Server 8.0 or greater. Executes bulk write operations across multiple models in a single operation. You must specify the model for each operation: Mongoose will use model for casting and validation, as well as determining which collection to apply the operation to.

The MongoClient instance this connection uses to talk to MongoDB. Mongoose automatically sets this property when the connection is opened.

Closes the connection

Retrieves a raw collection instance, creating it if not cached. This method returns a thin wrapper around a [MongoDB Node.js driver collection](MongoDB Node.js driver collection). Using a Collection bypasses Mongoose middleware, validation, and casting, letting you use MongoDB Node.js driver functionality directly.

A hash of the collections associated with this connection

A hash of the global options that are associated with this connection

Helper for createCollection(). Will explicitly create the given collection with specified options. Used to create capped collections and views from mongoose.

Options are passed down without modification to the MongoDB driver's createCollection() function

Calls createCollection() on a models in a series.

The mongodb.Db instance, set when the connection is opened

Removes the model named name from this connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Destroy the connection. Similar to .close, but also removes the connection from Mongoose's connections list and prevents the connection from ever being re-opened.

Helper for dropCollection(). Will delete the given collection, including all documents and indexes.

Helper for dropDatabase(). Deletes the given database, including all collections, documents, and indexes.

Gets the value of the option key. Equivalent to conn.options[key]

Returns the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB.

The host name portion of the URI. If multiple hosts, such as a replica set, this will contain the first host name in the URI

A number identifier for this connection. Used for debugging when you have multiple connections.

Helper for MongoDB Node driver's listCollections(). Returns an array of collection objects.

Helper for MongoDB Node driver's listDatabases(). Returns an object with a databases property that contains an array of database objects.

Defines or retrieves a model.

When no collection argument is passed, Mongoose produces a collection name by passing the model name to the utils.toCollectionName method. This method pluralizes the name. If you don't like this behavior, either pass a collection name or set your schemas collection name option.

Returns an array of model names created on this connection.

A POJO containing a map from model names to models. Contains all models that have been added to this connection using Connection#model().

The name of the database this connection points to.

Listen to events in the Connection

Listen to a event once in the Connection

Opens the connection with a URI using MongoClient.connect().

The password specified in the URI

Declares a plugin executed on all schemas you pass to conn.model()

Equivalent to calling .plugin(fn) on each schema you create.

The plugins that will be applied to all models created on this connection.

The port portion of the URI. If multiple hosts, such as a replica set, this will contain the port from the first host name in the URI.

Connection ready state

Each state change emits its associated event name.

Removes the database connection with the given name created with with useDb().

Throws an error if the database connection was not found.

Sets the value of the option key. Equivalent to conn.options[key] = val

Supported options include:

Set the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB. This is useful if you already have a MongoClient instance, and want to reuse it.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Syncs all the indexes for the models registered with this connection.

Requires MongoDB >= 3.6.0. Executes the wrapped async function in a transaction. Mongoose will commit the transaction if the async function executes successfully and attempt to retry if there was a retriable error.

Calls the MongoDB driver's session.withTransaction(), but also handles resetting Mongoose document state as shown below.

Switches to a different database using the same connection pool.

Returns a new connection object, with the new db.

The username specified in the URI

Watches the entire underlying database for changes. Similar to Model.watch().

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

The ChangeStream object is an event emitter that emits the following events:

A convenience wrapper for connection.client.withSession().

**Examples:**

Example 1 (javascript):
```javascript
const conn = await mongoose.createConnection('mongodb://127.0.0.1:27017/test').
  asPromise();
conn.readyState; // 1, means Mongoose is connected
```

Example 2 (json):
```json
const Test = mongoose.model('Test', new Schema({ name: String }));

await db.bulkWrite([
  { model: Test, name: 'insertOne', document: { name: 'test1' } }, // Can specify model as a Model class...
  { model: 'Test', name: 'insertOne', document: { name: 'test2' } } // or as a model name
], { ordered: false });
```

Example 3 (css):
```css
conn.model('User', new Schema({ name: String }));
console.log(conn.model('User')); // Model object
conn.deleteModel('User');
console.log(conn.model('User')); // undefined

// Usually useful in a Mocha `afterEach()` hook
afterEach(function() {
  conn.deleteModel(/.+/); // Delete every model
});
```

Example 4 (javascript):
```javascript
const conn = mongoose.createConnection('mongodb://127.0.0.1:27017/mydb');
// Deletes the entire 'mydb' database
await conn.dropDatabase();
```

---

## DocumentArray

**URL:** https://mongoosejs.com/docs/api/documentarray.html

**Contents:**
- DocumentArray
  - MongooseDocumentArray.prototype.create()
      - Parameters:
  - MongooseDocumentArray.prototype.id()
      - Parameters:
      - Returns:
    - Example:
  - MongooseDocumentArray.prototype.inspect()
  - MongooseDocumentArray.prototype.pull()
      - Parameters:

Creates a subdocument casted to this schema.

This is the same subdocument constructor used for casting.

Searches array items for the first document with a matching _id.

Helper for console.log

Pulls items from the array atomically.

Wraps Array#push with proper change tracking.

Returns a native js Array of plain js objects

Each sub-document is converted to a plain object by calling its #toObject method.

**Examples:**

Example 1 (javascript):
```javascript
const embeddedDoc = m.array.id(some_id);
```

---

## Array

**URL:** https://mongoosejs.com/docs/api/array.html

**Contents:**
- Array
  - MongooseArray.prototype.$pop()
      - See:
    - NOTE:
  - MongooseArray.prototype.$shift()
      - See:
    - Note:
  - MongooseArray.prototype.addToSet()
      - Parameters:
      - Returns:

Pops the array atomically at most one time per document save().

Calling this multiple times on an array before saving sends the same command as calling it once. This update is implemented using the MongoDB $pop method which enforces this restriction.

Atomically shifts the array at most one time per document save().

Calling this multiple times on an array before saving sends the same command as calling it once. This update is implemented using the MongoDB $pop method which enforces this restriction.

Adds values to the array if not already present.

Clears all pending atomic operations. Called by Mongoose after save().

Public API for getting atomics. Alias for $__getAtomics() that can be implemented by custom container types.

Return whether or not the obj is included in the array.

Return the index of obj or -1 if not found.

Helper for console.log

Pushes items to the array non-atomically.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Wraps Array#pop with proper change tracking.

marks the entire array as modified which will pass the entire thing to $set potentially overwriting any changes that happen between when you retrieved the object and when you save it.

Pulls items from the array atomically. Equality is determined by casting the provided value to an embedded document and comparing using the Document.equals() function.

To remove a document from a subdocument array we may pass an object with a matching _id.

Or we may passing the _id directly and let mongoose take care of it.

The first pull call will result in a atomic operation on the database, if pull is called repeatedly without saving the document, a $set operation is used on the complete array instead, overwriting possible changes that happened on the database in the meantime.

Wraps Array#push with proper change tracking.

Sets the casted val at index i and marks the array modified.

Wraps Array#shift with proper change tracking.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Wraps Array#sort with proper change tracking.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Wraps Array#splice with proper change tracking and casting.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Returns a native js Array.

Wraps Array#unshift with proper change tracking.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwriting any changes that happen between when you retrieved the object and when you save it.

**Examples:**

Example 1 (javascript):
```javascript
doc.array = [1,2,3];

 const popped = doc.array.$pop();
 console.log(popped); // 3
 console.log(doc.array); // [1,2]

 // no affect
 popped = doc.array.$pop();
 console.log(doc.array); // [1,2]

 doc.save(function (err) {
   if (err) return handleError(err);

   // we saved, now $pop works again
   popped = doc.array.$pop();
   console.log(popped); // 2
   console.log(doc.array); // [1]
 })
```

Example 2 (javascript):
```javascript
doc.array = [1,2,3];

 const shifted = doc.array.$shift();
 console.log(shifted); // 1
 console.log(doc.array); // [2,3]

 // no affect
 shifted = doc.array.$shift();
 console.log(doc.array); // [2,3]

 doc.save(function (err) {
   if (err) return handleError(err);

   // we saved, now $shift works again
   shifted = doc.array.$shift();
   console.log(shifted ); // 2
   console.log(doc.array); // [3]
 })
```

Example 3 (javascript):
```javascript
console.log(doc.array) // [2,3,4]
const added = doc.array.addToSet(4,5);
console.log(doc.array) // [2,3,4,5]
console.log(added)     // [5]
```

Example 4 (css):
```css
doc.array.pull(ObjectId)
doc.array.pull({ _id: 'someId' })
doc.array.pull(36)
doc.array.pull('tag 1', 'tag 2')
```

---

## Uuid

**URL:** https://mongoosejs.com/docs/api/uuid.html

**Contents:**
- Uuid
  - UUID()
    - Example:

UUID type constructor

**Examples:**

Example 1 (javascript):
```javascript
const id = new mongoose.Types.UUID();
```

---

## Model

**URL:** https://mongoosejs.com/docs/6.x/docs/api/model.html

**Contents:**
- Model
  - Model()
      - Parameters:
      - Inherits:
    - Example:
  - Model.$where()
      - Parameters:
      - Returns:
      - See:
  - Model.aggregate()

A Model is a class that's your primary tool for interacting with MongoDB. An instance of a Model is called a Document.

In Mongoose, the term "Model" refers to subclasses of the mongoose.Model class. You should not use the mongoose.Model class directly. The mongoose.model() and connection.model() functions create subclasses of mongoose.Model as shown below.

Creates a Query and specifies a $where condition.

Sometimes you need to query for things in mongodb using a JavaScript expression. You can do so via find({ $where: javascript }), or you can use the mongoose shortcut method $where via a Query chain or from your mongoose Model.

Performs aggregations on the models collection.

If a callback is passed, the aggregate is executed and a Promise is returned. If a callback is not passed, the aggregate itself is returned.

This function triggers the following middleware.

Apply defaults to the given document or POJO.

takes an array of documents, gets the changes and inserts/updates documents in the database according to whether or not the document is new, or whether it has changes or not.

bulkSave uses bulkWrite under the hood, so it's mostly useful when dealing with many documents (10K+)

Sends multiple insertOne, updateOne, updateMany, replaceOne, deleteOne, and/or deleteMany operations to the MongoDB server in one command. This is faster than sending multiple independent operations (e.g. if you use create()) because with bulkWrite() there is only one round trip to MongoDB.

Mongoose will perform casting on all operations you provide.

This function does not trigger any middleware, neither save(), nor update(). If you need to trigger save() middleware for every document use create() instead.

The supported operations are:

Cast the given POJO to the model's schema

Deletes all indexes that aren't defined in this model's schema. Used by syncIndexes().

The returned promise resolves to a list of the dropped indexes' names as an array

Counts number of documents that match filter in a database collection.

This method is deprecated. If you want to count the number of documents in a collection, e.g. count({}), use the estimatedDocumentCount() function instead. Otherwise, use the countDocuments() function instead.

Counts number of documents matching filter in a database collection.

If you want to count all documents in a large collection, use the estimatedDocumentCount() function instead. If you call countDocuments({}), MongoDB will always execute a full collection scan and not use any indexes.

The countDocuments() function is similar to count(), but there are a few operators that countDocuments() does not support. Below are the operators that count() supports but countDocuments() does not, and the suggested replacement:

Shortcut for saving one or more documents to the database. MyModel.create(docs) does new MyModel(doc).save() for every doc in docs.

This function triggers the following middleware.

Create the collection for this model. By default, if no indexes are specified, mongoose will not create the collection for the model until any documents are created. Use this method to create the collection explicitly.

Note 1: You may need to call this before starting a transaction See https://www.mongodb.com/docs/manual/core/transactions/#transactions-and-operations

Note 2: You don't have to call this if your schema contains index or unique field. In that case, just use Model.init()

Similar to ensureIndexes(), except for it uses the createIndex function.

Connection instance the model uses.

Deletes all of the documents that match conditions from the collection. It returns an object with the property deletedCount containing the number of documents deleted. Behaves like remove(), but deletes all documents that match conditions regardless of the single option.

This function triggers deleteMany query hooks. Read the middleware docs to learn more.

Deletes the first document that matches conditions from the collection. It returns an object with the property deletedCount indicating how many documents were deleted. Behaves like remove(), but deletes at most one document regardless of the single option.

This function triggers deleteOne query hooks. Read the middleware docs to learn more.

Does a dry-run of Model.syncIndexes(), meaning that the result of this function would be the result of Model.syncIndexes().

Adds a discriminator type.

Creates a Query for a distinct operation.

Passing a callback executes the query.

Sends createIndex commands to mongo for each index declared in the schema. The createIndex commands are sent in series.

After completion, an index event is emitted on this Model passing an error if one occurred.

NOTE: It is not recommended that you run this in production. Index creation may impact database performance depending on your load. Use with caution.

Estimates the number of documents in the MongoDB collection. Faster than using countDocuments() for large collections because estimatedDocumentCount() uses collection metadata rather than scanning the entire collection.

Event emitter that reports any errors that occurred. Useful for global error handling.

Returns a document with _id only if at least one document exists in the database that matches the given filter, and null otherwise.

Under the hood, MyModel.exists({ answer: 42 }) is equivalent to MyModel.findOne({ answer: 42 }).select({ _id: 1 }).lean()

This function triggers the following middleware.

Mongoose casts the filter to match the model's schema before the command is sent. See our query casting tutorial for more information on how Mongoose casts filter.

Finds a single document by its _id field. findById(id) is almost* equivalent to findOne({ _id: id }). If you want to query by a document's _id, use findById() instead of findOne().

The id is cast based on the Schema before sending the command.

This function triggers the following middleware.

* Except for how it treats undefined. If you use findOne(), you'll see that findOne(undefined) and findOne({ _id: undefined }) are equivalent to findOne({}) and return arbitrary documents. However, mongoose translates findById(undefined) into findOne({ _id: null }).

Issue a MongoDB findOneAndDelete() command by a document's _id field. In other words, findByIdAndDelete(id) is a shorthand for findOneAndDelete({ _id: id }).

This function triggers the following middleware.

Issue a mongodb findAndModify remove command by a document's _id field. findByIdAndRemove(id, ...) is equivalent to findOneAndRemove({ _id: id }, ...).

Finds a matching document, removes it, passing the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

Issues a mongodb findAndModify update command by a document's _id field. findByIdAndUpdate(id, ...) is equivalent to findOneAndUpdate({ _id: id }, ...).

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed.

This function triggers the following middleware.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }. To prevent this behaviour, see the overwrite option

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

The conditions are cast to their respective SchemaTypes before the command is sent.

Note: conditions is optional, and if conditions is null or undefined, mongoose will send an empty findOne command to MongoDB, which will return an arbitrary document. If you're querying by _id, use findById() instead.

Issue a MongoDB findOneAndDelete() command.

Finds a matching document, removes it, and passes the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

This function differs slightly from Model.findOneAndRemove() in that findOneAndRemove() becomes a MongoDB findAndModify() command, as opposed to a findOneAndDelete() command. For most mongoose use cases, this distinction is purely pedantic. You should use findOneAndDelete() unless you have a good reason not to.

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a mongodb findAndModify remove command.

Finds a matching document, removes it, passing the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a MongoDB findOneAndReplace() command.

Finds a matching document, replaces it with the provided doc, and passes the returned doc to the callback.

Executes the query if callback is passed.

This function triggers the following query middleware.

Issues a mongodb findAndModify update command.

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed else a Query object is returned.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }. To prevent this behaviour, see the overwrite option

findOneAndX and findByIdAndX functions support limited validation that you can enable by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Shortcut for creating a new Document from existing raw data, pre-saved in the DB. The document returned has no paths marked as modified initially.

This function is responsible for building indexes, unless autoIndex is turned off.

Mongoose calls this function automatically when a model is created using mongoose.model() or connection.model(), so you don't need to call init() to trigger index builds.

However, you may need to call init() to get back a promise that will resolve when your indexes are finished. Calling await Model.init() is helpful if you need to wait for indexes to build before continuing. For example, if you want to wait for unique indexes to build before continuing with a test case.

Shortcut for validating an array of documents and inserting them into MongoDB if they're all valid. This function is faster than .create() because it only sends one operation to the server, rather than one for each document.

Mongoose always validates each document before sending insertMany to MongoDB. So if one document has a validation error, no documents will be saved, unless you set the ordered option to false.

This function does not trigger save middleware.

This function triggers the following middleware.

Helper for console.log. Given a model named 'MyModel', returns the string 'Model { MyModel }'.

Lists the indexes currently defined in MongoDB. This may or may not be the same as the indexes defined in your schema depending on whether you use the autoIndex option and if you build indexes manually.

Executes a mapReduce command.

opts is an object specifying all mapReduce options as well as the map and reduce functions. All options are delegated to the driver implementation. See node-mongodb-native mapReduce() documentation for more detail about options.

This function does not trigger any middleware.

If opts.out is set to replace, merge, or reduce, a Model instance is returned that can be used for further querying. Queries run against this model are all executed with the lean option; meaning only the js object is returned and no Mongoose magic is applied (getters, setters, etc).

Populates document references.

Changed in Mongoose 6: the model you call populate() on should be the "local field" model, not the "foreign field" model.

Returns another Model instance.

Additional properties to attach to the query when calling save() and isNew is false.

Base Mongoose instance the model uses.

If this is a discriminator model, baseModelName is the name of the base model.

Collection the model uses.

This property is read-only. Modifying this property is a no-op.

Collection the model uses.

Connection the model uses.

Removes this document from the db. Equivalent to .remove().

Registered discriminators for this model.

Signal that we desire an increment of this documents version.

Returns another Model instance.

The name of the model

Removes this document from the db.

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation with just the modified paths if isNew is false.

If save is successful, the returned promise will fulfill with the document saved.

Removes all documents that match conditions from the collection. To remove just the first document that matches conditions, set the single option to true.

This method is deprecated. See Deprecation Warnings for details.

This method sends a remove command directly to MongoDB, no Mongoose documents are involved. Because no Mongoose documents are involved, Mongoose does not execute document middleware.

Same as update(), except MongoDB replace the existing document with the given document (no atomic operators like $set).

This function triggers the following middleware.

Schema the model uses.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling MyModel.startSession() is equivalent to calling MyModel.db.startSession().

This function does not trigger any middleware.

Makes the indexes in MongoDB match the indexes defined in this model's schema. This function will drop any indexes that are not defined in the model's schema except the _id index, and build any indexes that are in your schema but not in MongoDB.

See the introductory blog post for more information.

Translate any aliases fields/conditions so the final query or document object is pure

Only translate arguments of object type anything else is returned raw

Updates one document in the database without returning it.

This function triggers the following middleware.

This method is deprecated. See Deprecation Warnings for details.

All update values are cast to their appropriate SchemaTypes before being sent.

The callback function receives (err, rawResponse).

All top level keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting all documents in your collection with { name: 'jason bourne' }.

Be careful to not use an existing model instance for the update clause (this won't work and can cause weird behavior like infinite loops). Also, ensure that the update clause does not have an _id property, which causes Mongo to return a "Mod on _id not allowed" error.

Same as update(), except MongoDB will update all documents that match filter (as opposed to just the first one) regardless of the value of the multi option.

Note updateMany will not fire update middleware. Use pre('updateMany') and post('updateMany') instead.

This function triggers the following middleware.

Same as update(), except it does not support the multi or overwrite options.

This function triggers the following middleware.

Casts and validates the given object against this model's schema, passing the given context to custom validators.

Requires a replica set running MongoDB >= 3.6.0. Watches the underlying collection for changes using MongoDB change streams.

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

The ChangeStream object is an event emitter that emits the following events:

Creates a Query, applies the passed conditions, and returns the Query.

For example, instead of writing:

we can instead write:

Since the Query class also supports where you can continue chaining

**Examples:**

Example 1 (javascript):
```javascript
// `UserModel` is a "Model", a subclass of `mongoose.Model`.
const UserModel = mongoose.model('User', new Schema({ name: String }));

// You can use a Model to create new documents using `new`:
const userDoc = new UserModel({ name: 'Foo' });
await userDoc.save();

// You also use a model to create queries:
const userFromDb = await UserModel.findOne({ name: 'Foo' });
```

Example 2 (r):
```r
Blog.$where('this.username.indexOf("val") !== -1').exec(function (err, docs) {});
```

Example 3 (javascript):
```javascript
// Find the max balance of all accounts
const res = await Users.aggregate([
  { $group: { _id: null, maxBalance: { $max: '$balance' }}},
  { $project: { _id: 0, maxBalance: 1 }}
]);

console.log(res); // [ { maxBalance: 98000 } ]

// Or use the aggregation pipeline builder.
const res = await Users.aggregate().
  group({ _id: null, maxBalance: { $max: '$balance' } }).
  project('-id maxBalance').
  exec();
console.log(res); // [ { maxBalance: 98 } ]
```

Example 4 (javascript):
```javascript
Character.bulkWrite([
  {
    insertOne: {
      document: {
        name: 'Eddard Stark',
        title: 'Warden of the North'
      }
    }
  },
  {
    updateOne: {
      filter: { name: 'Eddard Stark' },
      // If you were using the MongoDB driver directly, you'd need to do
      // `update: { $set: { title: ... } }` but mongoose adds $set for
      // you.
      update: { title: 'Hand of the King' }
    }
  },
  {
    deleteOne: {
      filter: { name: 'Eddard Stark' }
    }
  }
]).then(res => {
 // Prints "1 1 1"
 console.log(res.insertedCount, res.modifiedCount, res.deletedCount);
});
```

---

## SchemaDateOptions

**URL:** https://mongoosejs.com/docs/7.x/docs/api/schemadateoptions.html

**Contents:**
- SchemaDateOptions
  - SchemaDateOptions()
      - Type:
      - Inherits:
    - Example:
  - SchemaDateOptions.prototype.expires
      - Type:
    - Example:
  - SchemaDateOptions.prototype.max
      - Type:

The options defined on a Date schematype.

If set, Mongoose creates a TTL index on this path.

mongo TTL index expireAfterSeconds value will take 'expires' value expressed in seconds.

If set, Mongoose adds a validator that checks that this path is before the given max.

If set, Mongoose adds a validator that checks that this path is after the given min.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ startedAt: Date });
schema.path('startedAt').options; // SchemaDateOptions instance
```

Example 2 (json):
```json
const schema = new Schema({ "expireAt": { type: Date,  expires: 11 } });
// if 'expireAt' is set, then document expires at expireAt + 11 seconds
```

---

## Mongoose

**URL:** https://mongoosejs.com/docs/6.x/docs/api/mongoose.html

**Contents:**
- Mongoose
  - Mongoose()
      - Parameters:
    - Example:
  - Mongoose.prototype.Aggregate()
  - Mongoose.prototype.CastError()
      - Parameters:
  - Mongoose.prototype.Collection()
  - Mongoose.prototype.Connection()
  - Mongoose.prototype.ConnectionStates

Mongoose constructor.

The exports object of the mongoose module is an instance of this class. Most apps will only use this one instance.

The Mongoose Aggregate constructor

The Mongoose CastError constructor

The Mongoose Collection constructor

The Mongoose Connection constructor

Expose connection states for user-land

The Mongoose Date SchemaType.

The Mongoose Decimal128 SchemaType. Used for declaring paths in your schema that should be 128-bit decimal floating points. Do not use this to create a new Decimal128 instance, use mongoose.Types.Decimal128 instead.

The Mongoose Document constructor.

The Mongoose DocumentProvider constructor. Mongoose users should not have to use this directly

The MongooseError constructor.

The Mongoose Mixed SchemaType. Used for declaring paths in your schema that Mongoose's change tracking, casting, and validation should ignore.

The Mongoose Model constructor.

The Mongoose constructor

The exports of the mongoose module is an instance of this class.

The Mongoose Number SchemaType. Used for declaring paths in your schema that Mongoose should cast to numbers.

The Mongoose ObjectId SchemaType. Used for declaring paths in your schema that should be MongoDB ObjectIds. Do not use this to create a new ObjectId instance, use mongoose.Types.ObjectId instead.

The Mongoose Promise constructor.

Storage layer for mongoose promises

The Mongoose Query constructor.

Expose connection states for user-land

The Mongoose Schema constructor

The Mongoose SchemaType constructor

The constructor used for schematype options

The various Mongoose SchemaTypes.

Alias of mongoose.Schema.Types for backwards compatibility.

The various Mongoose Types.

Using this exposed access to the ObjectId type, we can construct ids on demand.

The Mongoose VirtualType constructor

Opens the default mongoose connection.

The Mongoose module's default connection. Equivalent to mongoose.connections[0], see connections.

This is the connection used by default for every model created using mongoose.model.

To create a new connection, use createConnection().

An array containing all connections associated with this Mongoose instance. By default, there is 1 connection. Calling createConnection() adds a connection to this array.

Creates a Connection instance.

Each connection instance maps to a single database. This method is helpful when managing multiple db connections.

Options passed take precedence over options included in connection strings.

Removes the model named name from the default connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Equivalent to mongoose.connection.deleteModel(name).

Runs .close() on all connections in parallel.

Object with get() and set() containing the underlying driver this Mongoose instance uses to communicate with the database. A driver is a Mongoose-specific interface that defines functions like find().

Gets mongoose options

Returns true if the given value is a Mongoose ObjectId (using instanceof) or if the given value is a 24 character hex string, which is the most commonly used string representation of an ObjectId.

This function is similar to isValidObjectId(), but considerably more strict, because isValidObjectId() will return true for any value that Mongoose can convert to an ObjectId. That includes Mongoose documents, any string of length 12, and any number. isObjectIdOrHexString() returns true only for ObjectId instances or 24 character hex strings, and will return false for numbers, documents, and strings of length 12.

Returns true if Mongoose can cast the given value to an ObjectId, or false otherwise.

Defines a model or retrieves it.

Models defined on the mongoose instance are available to all connection created by the same mongoose instance.

If you call mongoose.model() with twice the same name but a different schema, you will get an OverwriteModelError. If you call mongoose.model() with the same name and same schema, you'll get the same schema back.

When no collection argument is passed, Mongoose uses the model name. If you don't like this behavior, either pass a collection name, use mongoose.pluralize(), or set your schemas collection name option.

Returns an array of model names created on this instance of Mongoose.

Does not include names of models created using connection.model().

The node-mongodb-native driver Mongoose uses.

The mquery query builder Mongoose uses.

Mongoose uses this function to get the current time when setting timestamps. You may stub out this function using a tool like Sinon for testing.

Use this function in post() middleware to replace the result

Declares a global plugin executed on all Schemas.

Equivalent to calling .plugin(fn) on each Schema you create.

Getter/setter around function for pluralizing collection names.

Sanitizes query filters against query selector injection attacks by wrapping any nested objects that have a property whose name starts with $ in a $eq.

Sets mongoose options

key can be used a object to set multiple options at once. If a error gets thrown for one option, other options will still be evaluated.

Currently supported options are:

Overwrites the current driver used by this Mongoose instance. A driver is a Mongoose-specific interface that defines functions like find().

Use this function in pre() middleware to skip calling the wrapped function.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling mongoose.startSession() is equivalent to calling mongoose.connection.startSession(). Sessions are scoped to a connection, so calling mongoose.startSession() starts a session on the default mongoose connection.

Syncs all the indexes for the models registered with this connection.

Tells sanitizeFilter() to skip the given object when filtering out potential query selector injection attacks. Use this method when you have a known query selector that you want to use.

**Examples:**

Example 1 (javascript):
```javascript
const mongoose = require('mongoose');
mongoose instanceof mongoose.Mongoose; // true

// Create a new Mongoose instance with its own `connect()`, `set()`, `model()`, etc.
const m = new mongoose.Mongoose();
```

Example 2 (css):
```css
const schema = new Schema({ test: Date });
schema.path('test') instanceof mongoose.Date; // true
```

Example 3 (css):
```css
const vehicleSchema = new Schema({ fuelLevel: mongoose.Decimal128 });
```

Example 4 (css):
```css
const schema = new Schema({ arbitrary: mongoose.Mixed });
```

---

## ArraySubdocument

**URL:** https://mongoosejs.com/docs/api/arraysubdocument.html

**Contents:**
- ArraySubdocument
  - ArraySubdocument.prototype.$parent()
  - ArraySubdocument.prototype.parentArray()
    - Example:

Returns this sub-documents parent document.

Returns this subdocument's parent array.

**Examples:**

Example 1 (css):
```css
const Test = mongoose.model('Test', new Schema({
  docArr: [{ name: String }]
}));
const doc = new Test({ docArr: [{ name: 'test subdoc' }] });

doc.docArr[0].parentArray() === doc.docArr; // true
```

---

## Schema

**URL:** https://mongoosejs.com/docs/6.x/docs/api/schema.html

**Contents:**
- Schema
  - Schema()
      - Parameters:
      - Inherits:
    - Example:
    - Options:
    - Options for Nested Schemas:
    - Note:
  - Schema.Types
      - Type:

When nesting schemas, (children in the example above), always declare the child schema first before passing it into its parent.

The various built-in Mongoose Schema Types.

Using this exposed access to the Mixed SchemaType, we can use them in our schema.

The allowed index types

Adds key path / schema type pairs to this schema.

Add an alias for path. This means getting or setting the alias is equivalent to getting or setting the path.

Array of child schemas (from document arrays and single nested subdocs) and their corresponding compiled models. Each element of the array is an object with 2 properties: schema and model.

This property is typically only useful for plugin authors and advanced users. You do not need to interact with this property at all to use mongoose.

Remove all indexes from this schema.

clearIndexes only removes indexes from your schema object. Does not affect the indexes in MongoDB.

Returns a deep copy of the schema

Inherit a Schema by applying a discriminator on an existing Schema.

Iterates the schemas paths similar to Array#forEach.

The callback is passed the pathname and the schemaType instance.

Gets a schema option.

Defines an index (most likely compound) for this schema.

Returns a list of indexes that this schema declares, via schema.index() or by index: true in a path's options. Indexes are expressed as an array [spec, options].

Plugins can use the return value of this function to modify a schema's indexes. For example, the below plugin makes every index unique by default.

Loads an ES6 class into a schema. Maps setters + getters, static methods, and instance methods to schema virtuals, statics, and methods.

Adds an instance method to documents constructed from Models compiled from this schema.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as methods.

NOTE: Schema.method() adds instance methods to the Schema.methods object. You can also add instance methods directly to the Schema.methods object as seen in the guide

The original object passed to the schema constructor

Returns a new schema that has the paths from the original schema, minus the omitted ones.

This method is analagous to Lodash's omit() function for Mongoose schemas.

Gets/sets schema paths.

Sets a path (if arity 2) Gets a path (if arity 1)

Returns the pathType of path for this schema.

Given a path, returns whether it is a real, virtual, nested, or ad-hoc/undefined path.

The paths defined on this schema. The keys are the top-level paths in this schema, and the values are instances of the SchemaType class.

Returns a new schema that has the picked paths from this schema.

This method is analagous to Lodash's pick() function for Mongoose schemas.

Registers a plugin for this schema.

Defines a post hook for the document

Defines a pre hook for the model.

Adds a method call to the queue.

Removes the given path (or [paths]).

Remove an index by name or index specification.

removeIndex only removes indexes from your schema object. Does not affect the indexes in MongoDB.

Removes the given virtual or virtuals from the schema.

Returns an Array of path strings that are required by this schema.

Sets a schema option.

Adds static "class" methods to Models compiled from this schema.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as methods.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as statics.

Creates a virtual type with the given name.

Returns the virtual type with the given name.

Object containing all virtuals defined on this schema. The objects' keys are the virtual paths and values are instances of VirtualType.

This property is typically only useful for plugin authors and advanced users. You do not need to interact with this property at all to use mongoose.

Reserved document keys.

Keys in this object are names that are warned in schema declarations because they have the potential to break Mongoose/ Mongoose plugins functionality. If you create a schema using new Schema() with one of these property names, Mongoose will log a warning.

NOTE: Use of these terms as method names is permitted, but play at your own risk, as they may be existing mongoose document methods you are stomping on.

**Examples:**

Example 1 (swift):
```swift
const child = new Schema({ name: String });
const schema = new Schema({ name: String, age: Number, children: [child] });
const Tree = mongoose.model('Tree', schema);

// setting schema options
new Schema({ name: String }, { _id: false, autoIndex: false })
```

Example 2 (javascript):
```javascript
const mongoose = require('mongoose');
const ObjectId = mongoose.Schema.Types.ObjectId;
```

Example 3 (css):
```css
const Mixed = mongoose.Schema.Types.Mixed;
new mongoose.Schema({ _user: Mixed })
```

Example 4 (css):
```css
const ToySchema = new Schema();
ToySchema.add({ name: 'string', color: 'string', price: 'number' });

const TurboManSchema = new Schema();
// You can also `add()` another schema and copy over all paths, virtuals,
// getters, setters, indexes, methods, and statics.
TurboManSchema.add(ToySchema).add({ year: Number });
```

---

## SchemaTypeOptions

**URL:** https://mongoosejs.com/docs/api/schematypeoptions.html

**Contents:**
- SchemaTypeOptions
  - SchemaTypeOptions()
      - Type:
    - Example:
  - SchemaTypeOptions.prototype.cast
      - Type:
    - Example:
  - SchemaTypeOptions.prototype.default
      - Type:
  - SchemaTypeOptions.prototype.immutable

The options defined on a schematype.

Allows overriding casting logic for this individual path. If a string, the given string overwrites Mongoose's default cast error message.

The default value for this path. If a function, Mongoose executes the function and uses the return value as the default.

If truthy, Mongoose will disallow changes to this path once the document is saved to the database for the first time. Read more about immutability in Mongoose here.

If truthy, Mongoose will build an index on this path when the model is compiled.

The model that populate() should use if populating this path.

The path in the document that populate() should use to find the model to use.

If true, attach a required validator to this path, which ensures this path cannot be set to a nullish value. If a function, Mongoose calls the function and only checks for nullish values if the function returns a truthy value.

Whether to include or exclude this path by default when loading documents using find(), findOne(), etc.

If truthy, Mongoose will build a sparse index on this path.

If truthy, Mongoose will build a text index on this path.

Define a transform function for this individual schema type. Only called when calling toJSON() or toObject().

The type to cast this path to.

If truthy, Mongoose will build a unique index on this path when the model is compiled. The unique option is not a validator.

Function or object describing how to validate this schematype.

**Examples:**

Example 1 (css):
```css
const schema = new Schema({ name: String });
schema.path('name').options instanceof mongoose.SchemaTypeOptions; // true
```

Example 2 (css):
```css
const schema = new Schema({
  num: {
    type: Number,
    cast: '{VALUE} is not a valid number'
  }
});

// Throws 'CastError: "bad" is not a valid number'
schema.path('num').cast('bad');

const Model = mongoose.model('Test', schema);
const doc = new Model({ num: 'fail' });
const err = doc.validateSync();

err.errors['num']; // 'CastError: "fail" is not a valid number'
```

Example 3 (typescript):
```typescript
const schema = Schema({
  myDate: {
    type: Date,
    transform: v => v.getFullYear()
  }
});
const Model = mongoose.model('Test', schema);

const doc = new Model({ myDate: new Date('2019/06/01') });
doc.myDate instanceof Date; // true

const res = doc.toObject({ transform: true });
res.myDate; // 2019
```

---

## Document

**URL:** https://mongoosejs.com/docs/7.x/docs/api/document.html

**Contents:**
- Document
  - Document.prototype.$assertPopulated()
      - Parameters:
      - Returns:
    - Example:
  - Document.prototype.$clone()
      - Returns:
  - Document.prototype.$errors
      - Type:
  - Document.prototype.$getAllSubdocs()

Throws an error if a given path is not populated

Returns a copy of this document with a deep clone of _doc and $__.

Hash containing current validation $errors.

Get all subdocs (by bfs)

Gets all populated documents associated with this document.

Don't run validation on this path or persist changes to this path.

Increments the numeric value at path by the given val. When you call save() on this document, Mongoose will send a $inc as opposed to a $set.

Checks if a path is set to its default.

Getter/setter, determines whether the document was removed or not.

Returns true if the given path is nullish or only contains empty objects. Useful for determining whether this subdoc will get stripped out by the minimize option.

Boolean flag specifying if the document is new. If you create a document using new, this document will be considered "new". $isNew is how Mongoose determines whether save() should use insertOne() to create a new document or updateOne() to update an existing document.

On the other hand, if you load an existing document from the database using findOne() or another query operation, $isNew will be false.

Mongoose sets $isNew to false immediately after save() succeeds. That means Mongoose sets $isNew to false before post('save') hooks run. In post('save') hooks, $isNew will be false if save() succeeded.

For subdocuments, $isNew is true if either the parent has $isNew set, or if you create a new subdocument.

Empty object that you can use for storing properties on the document. This is handy for passing data to middleware without conflicting with Mongoose internals.

Marks a path as valid, removing existing validation errors.

A string containing the current operation that Mongoose is executing on this document. May be null, 'save', 'validate', or 'remove'.

Alias for parent(). If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Getter/setter around the session associated with this document. Used to automatically set session if you save() a doc that you got from a query with an associated session.

If this is a top-level document, setting the session propagates to all child docs.

Alias for set(), used internally to avoid conflicts

Getter/setter around whether this document will apply timestamps by default when using save() and bulkSave().

Set this property to add additional query filters when Mongoose saves this document and isNew is false.

Takes a populated field and returns it to its unpopulated state.

If the path was not provided, then all populated fields are returned to their unpopulated state.

Returns the list of paths that have been directly modified. A direct modified path is a path that you explicitly set, whether via doc.foo = 'bar', Object.assign(doc, { foo: 'bar' }), or doc.set('foo', 'bar').

A path a may be in modifiedPaths() but not in directModifiedPaths() because a child of a was directly modified.

Returns true if this document is equal to another document.

Documents are considered equal when they have matching _ids, unless neither document has an _id, in which case this function falls back to using deepEqual().

Hash containing current validation errors.

Returns the value of a path.

Returns the changes that happened to the document in the format that will be sent to MongoDB.

Modifying the object that getChanges() returns does not affect the document's change tracking state. Even if you delete user.getChanges().$set, Mongoose will still send a $set to the server.

The string version of this documents _id.

This getter exists on all documents by default. The getter can be disabled by setting the id option of its Schema to false at construction time.

Initializes the document without setters or marking anything modified.

Called internally after a document is returned from mongodb. Normally, you do not need to call this function on your own.

This function triggers init middleware. Note that init hooks are synchronous.

Helper for console.log

Marks a path as invalid, causing validation to fail.

The errorMsg argument will become the message of the ValidationError.

The value argument (if passed) will be available through the ValidationError.value property.

Returns true if path was directly set and modified, else false.

Checks if path was explicitly selected. If no projection, always returns true.

Checks if path is in the init state, that is, it was set by Document#init() and not modified since.

Returns true if any of the given paths is modified, else false. If no arguments, returns true if any path in this document is modified.

If path is given, checks if a path or any full path containing path as part of its path chain has been modified.

Legacy alias for $isNew.

Checks if path was selected in the source query which initialized this document.

Marks the path as having pending changes to write to the db.

Very helpful when using Mixed types.

Returns the list of paths that have been modified.

Overwrite all values in this document with the values of obj, except for immutable properties. Behaves similarly to set(), except for it unsets all properties that aren't in obj.

If this document is a subdocument or populated document, returns the document's parent. Returns the original document if there is no parent.

Populates paths on an existing document.

Gets _id(s) used during population of the given path.

If the path was not populated, returns undefined.

Sends a replaceOne command with this document _id as the query selector.

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation only with the modifications to the database, it does not replace the whole document in the latter case.

If save is successful, the returned promise will fulfill with the document saved.

The document's schema.

Sets the value of a path, or many paths. Alias for .$set.

The return value of this method is used in calls to JSON.stringify(doc).

This method accepts the same options as Document#toObject. To apply the options to every document of your schema by default, set your schemas toJSON option to the same argument.

There is one difference between toJSON() and toObject() options. When you call toJSON(), the flattenMaps option defaults to true, because JSON.stringify() doesn't convert maps to objects by default. When you call toObject(), the flattenMaps option is false by default.

See schema options for more information on setting toJSON option defaults.

Converts this document into a plain-old JavaScript object (POJO).

Buffers are converted to instances of mongodb.Binary for proper storage.

Example of only applying path getters

Example of only applying virtual getters

Example of applying both path and virtual getters

To apply these options to every document of your schema by default, set your schemas toObject option to the same argument.

We may need to perform a transformation of the resulting object based on some criteria, say to remove some sensitive information or return a custom object. In this case we set the optional transform function.

Transform functions receive three arguments

With transformations we can do a lot more than remove properties. We can even return completely new customized objects:

Note: if a transform function returns undefined, the return value will be ignored.

Transformations may also be applied inline, overridding any transform set in the options:

If you want to skip transformations, use transform: false:

If you pass a transform in toObject() options, Mongoose will apply the transform to subdocuments in addition to the top-level document. Similarly, transform: false skips transforms for all subdocuments. Note that this behavior is different for transforms defined in the schema: if you define a transform in schema.options.toObject.transform, that transform will not apply to subdocuments.

Transforms, like all of these options, are also available for toJSON. See this guide to JSON.stringify() to learn why toJSON() and toObject() are separate functions.

See schema options for some more details.

During save, no custom options are applied to the document before being sent to the database.

Helper for console.log

Clears the modified state on the specified path.

Sends an updateOne command with this document _id as the query selector.

Executes registered validation rules for this document.

This method is called pre save and if a validation rule is violated, save is aborted and the error is thrown.

Executes registered validation rules (skipping asynchronous validators) for this document.

This method is useful if you need synchronous validation.

**Examples:**

Example 1 (javascript):
```javascript
const doc = await Model.findOne().populate('author');

doc.$assertPopulated('author'); // does not throw
doc.$assertPopulated('other path'); // throws an error

// Manually populate and assert in one call. The following does
// `doc.$set({ likes })` before asserting.
doc.$assertPopulated('likes', { likes });
```

Example 2 (bash):
```bash
doc.foo = null;
doc.$ignore('foo');
doc.save(); // changes to foo will not be persisted and validators won't be run
```

Example 3 (javascript):
```javascript
const schema = new Schema({ counter: Number });
const Test = db.model('Test', schema);

const doc = await Test.create({ counter: 0 });
doc.$inc('counter', 2);
await doc.save(); // Sends a `{ $inc: { counter: 2 } }` to MongoDB
doc.counter; // 2

doc.counter += 2;
await doc.save(); // Sends a `{ $set: { counter: 2 } }` to MongoDB
```

Example 4 (css):
```css
MyModel = mongoose.model('test', { name: { type: String, default: 'Val '} });
const m = new MyModel();
m.$isDefault('name'); // true
```

---

## API Docs

**URL:** https://mongoosejs.com/docs/5.x/docs/api.html

**Contents:**
- API Docs
- Mongoose
  - Mongoose()
      - Parameters
    - Example:
  - Mongoose.prototype.Aggregate()
  - Mongoose.prototype.CastError()
      - Parameters
  - Mongoose.prototype.Collection()
  - Mongoose.prototype.Connection()

Mongoose constructor.

The exports object of the mongoose module is an instance of this class. Most apps will only use this one instance.

The Mongoose Aggregate constructor

The Mongoose CastError constructor

The Mongoose Collection constructor

The Mongoose Connection constructor

The Mongoose Date SchemaType.

The Mongoose Decimal128 SchemaType. Used for declaring paths in your schema that should be 128-bit decimal floating points. Do not use this to create a new Decimal128 instance, use mongoose.Types.Decimal128 instead.

The Mongoose Document constructor.

The Mongoose DocumentProvider constructor. Mongoose users should not have to use this directly

The MongooseError constructor.

The Mongoose Mixed SchemaType. Used for declaring paths in your schema that Mongoose's change tracking, casting, and validation should ignore.

The Mongoose Model constructor.

The Mongoose constructor

The exports of the mongoose module is an instance of this class.

The Mongoose Number SchemaType. Used for declaring paths in your schema that Mongoose should cast to numbers.

The Mongoose ObjectId SchemaType. Used for declaring paths in your schema that should be MongoDB ObjectIds. Do not use this to create a new ObjectId instance, use mongoose.Types.ObjectId instead.

The Mongoose Promise constructor.

Storage layer for mongoose promises

The Mongoose Query constructor.

Expose connection states for user-land

The Mongoose Schema constructor

The Mongoose SchemaType constructor

The constructor used for schematype options

The various Mongoose SchemaTypes.

Alias of mongoose.Schema.Types for backwards compatibility.

The various Mongoose Types.

Using this exposed access to the ObjectId type, we can construct ids on demand.

The Mongoose VirtualType constructor

Opens the default mongoose connection.

The Mongoose module's default connection. Equivalent to mongoose.connections[0], see connections.

This is the connection used by default for every model created using mongoose.model.

To create a new connection, use createConnection().

An array containing all connections associated with this Mongoose instance. By default, there is 1 connection. Calling createConnection() adds a connection to this array.

Creates a Connection instance.

Each connection instance maps to a single database. This method is helpful when managing multiple db connections.

Options passed take precedence over options included in connection strings.

Removes the model named name from the default connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Equivalent to mongoose.connection.deleteModel(name).

Runs .close() on all connections in parallel.

Object with get() and set() containing the underlying driver this Mongoose instance uses to communicate with the database. A driver is a Mongoose-specific interface that defines functions like find().

Gets mongoose options

Returns true if Mongoose can cast the given value to an ObjectId, or false otherwise.

Defines a model or retrieves it.

Models defined on the mongoose instance are available to all connection created by the same mongoose instance.

If you call mongoose.model() with twice the same name but a different schema, you will get an OverwriteModelError. If you call mongoose.model() with the same name and same schema, you'll get the same schema back.

When no collection argument is passed, Mongoose uses the model name. If you don't like this behavior, either pass a collection name, use mongoose.pluralize(), or set your schemas collection name option.

Returns an array of model names created on this instance of Mongoose.

Does not include names of models created using connection.model().

The node-mongodb-native driver Mongoose uses.

The mquery query builder Mongoose uses.

Mongoose uses this function to get the current time when setting timestamps. You may stub out this function using a tool like Sinon for testing.

Declares a global plugin executed on all Schemas.

Equivalent to calling .plugin(fn) on each Schema you create.

Getter/setter around function for pluralizing collection names.

Sets mongoose options

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling mongoose.startSession() is equivalent to calling mongoose.connection.startSession(). Sessions are scoped to a connection, so calling mongoose.startSession() starts a session on the default mongoose connection.

When nesting schemas, (children in the example above), always declare the child schema first before passing it into its parent.

The various built-in Mongoose Schema Types.

Using this exposed access to the Mixed SchemaType, we can use them in our schema.

The allowed index types

Adds key path / schema type pairs to this schema.

Array of child schemas (from document arrays and single nested subdocs) and their corresponding compiled models. Each element of the array is an object with 2 properties: schema and model.

This property is typically only useful for plugin authors and advanced users. You do not need to interact with this property at all to use mongoose.

Returns a deep copy of the schema

Iterates the schemas paths similar to Array#forEach.

The callback is passed the pathname and the schemaType instance.

Gets a schema option.

Defines an index (most likely compound) for this schema.

Returns a list of indexes that this schema declares, via schema.index() or by index: true in a path's options. Indexes are expressed as an array [spec, options].

Plugins can use the return value of this function to modify a schema's indexes. For example, the below plugin makes every index unique by default.

Loads an ES6 class into a schema. Maps setters + getters, static methods, and instance methods to schema virtuals, statics, and methods.

Adds an instance method to documents constructed from Models compiled from this schema.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as methods.

NOTE: Schema.method() adds instance methods to the Schema.methods object. You can also add instance methods directly to the Schema.methods object as seen in the guide

The original object passed to the schema constructor

Gets/sets schema paths.

Sets a path (if arity 2) Gets a path (if arity 1)

Returns the pathType of path for this schema.

Given a path, returns whether it is a real, virtual, nested, or ad-hoc/undefined path.

The paths defined on this schema. The keys are the top-level paths in this schema, and the values are instances of the SchemaType class.

Returns a new schema that has the picked paths from this schema.

This method is analagous to Lodash's pick() function for Mongoose schemas.

Registers a plugin for this schema.

Defines a post hook for the document

Defines a pre hook for the model.

Adds a method call to the queue.

Removes the given path (or [paths]).

Returns an Array of path strings that are required by this schema.

Sets a schema option.

Adds static "class" methods to Models compiled from this schema.

If a hash of name/fn pairs is passed as the only argument, each name/fn pair will be added as statics.

Creates a virtual type with the given name.

Returns the virtual type with the given name.

Reserved document keys.

Keys in this object are names that are rejected in schema declarations because they conflict with Mongoose functionality. If you create a schema using new Schema() with one of these property names, Mongoose will throw an error.

NOTE: Use of these terms as method names is permitted, but play at your own risk, as they may be existing mongoose document methods you are stomping on.

Connection constructor

For practical reasons, a Connection equals a Db.

The MongoClient instance this connection uses to talk to MongoDB. Mongoose automatically sets this property when the connection is opened.

Closes the connection

Retrieves a collection, creating it if not cached.

Not typically needed by applications. Just talk to your collection through your model.

A hash of the collections associated with this connection

A hash of the global options that are associated with this connection

Helper for createCollection(). Will explicitly create the given collection with specified options. Used to create capped collections and views from mongoose.

Options are passed down without modification to the MongoDB driver's createCollection() function

The mongodb.Db instance, set when the connection is opened

Removes the model named name from this connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Helper for dropCollection(). Will delete the given collection, including all documents and indexes.

Helper for dropDatabase(). Deletes the given database, including all collections, documents, and indexes.

Gets the value of the option key. Equivalent to conn.options[key]

Returns the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB.

The host name portion of the URI. If multiple hosts, such as a replica set, this will contain the first host name in the URI

A number identifier for this connection. Used for debugging when you have multiple connections.

Defines or retrieves a model.

When no collection argument is passed, Mongoose produces a collection name by passing the model name to the utils.toCollectionName method. This method pluralizes the name. If you don't like this behavior, either pass a collection name or set your schemas collection name option.

Returns an array of model names created on this connection.

A POJO containing a map from model names to models. Contains all models that have been added to this connection using Connection#model().

The name of the database this connection points to.

Opens the connection with a URI using MongoClient.connect().

The password specified in the URI

Declares a plugin executed on all schemas you pass to conn.model()

Equivalent to calling .plugin(fn) on each schema you create.

The plugins that will be applied to all models created on this connection.

The port portion of the URI. If multiple hosts, such as a replica set, this will contain the port from the first host name in the URI.

Connection ready state

Each state change emits its associated event name.

Sets the value of the option key. Equivalent to conn.options[key] = val

Set the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB. This is useful if you already have a MongoClient instance, and want to reuse it.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Requires MongoDB >= 3.6.0. Executes the wrapped async function in a transaction. Mongoose will commit the transaction if the async function executes successfully and attempt to retry if there was a retriable error.

Calls the MongoDB driver's session.withTransaction(), but also handles resetting Mongoose document state as shown below.

Switches to a different database using the same connection pool.

Returns a new connection object, with the new db.

The username specified in the URI

Watches the entire underlying database for changes. Similar to Model.watch().

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

Get all subdocs (by bfs)

Don't run validation on this path or persist changes to this path.

Checks if a path is set to its default.

Getter/setter, determines whether the document was removed or not.

Returns true if the given path is nullish or only contains empty objects. Useful for determining whether this subdoc will get stripped out by the minimize option.

Empty object that you can use for storing properties on the document. This is handy for passing data to middleware without conflicting with Mongoose internals.

Marks a path as valid, removing existing validation errors.

A string containing the current operation that Mongoose is executing on this document. May be null, 'save', 'validate', or 'remove'.

Alias for parent(). If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Getter/setter around the session associated with this document. Used to automatically set session if you save() a doc that you got from a query with an associated session.

If this is a top-level document, setting the session propagates to all child docs.

Alias for set(), used internally to avoid conflicts

Set this property to add additional query filters when Mongoose saves this document and isNew is false.

Takes a populated field and returns it to its unpopulated state.

If the path was not provided, then all populated fields are returned to their unpopulated state.

Returns the list of paths that have been directly modified. A direct modified path is a path that you explicitly set, whether via doc.foo = 'bar', Object.assign(doc, { foo: 'bar' }), or doc.set('foo', 'bar').

A path a may be in modifiedPaths() but not in directModifiedPaths() because a child of a was directly modified.

Returns true if this document is equal to another document.

Documents are considered equal when they have matching _ids, unless neither document has an _id, in which case this function falls back to using deepEqual().

Hash containing current validation errors.

Explicitly executes population and returns a promise. Useful for promises integration.

// you can also use doc.execPopulate(options) as a shorthand for // doc.populate(options).execPopulate()

const promise = doc.execPopulate({ path: 'company', select: 'employees' });

// summary promise.then(resolve,reject);

Returns the value of a path.

Returns the changes that happened to the document in the format that will be sent to MongoDB.

Modifying the object that getChanges() returns does not affect the document's change tracking state. Even if you delete user.getChanges().$set, Mongoose will still send a $set to the server.

The string version of this documents _id.

This getter exists on all documents by default. The getter can be disabled by setting the id option of its Schema to false at construction time.

Initializes the document without setters or marking anything modified.

Called internally after a document is returned from mongodb. Normally, you do not need to call this function on your own.

This function triggers init middleware. Note that init hooks are synchronous.

Helper for console.log

Marks a path as invalid, causing validation to fail.

The errorMsg argument will become the message of the ValidationError.

The value argument (if passed) will be available through the ValidationError.value property.

Returns true if path was directly set and modified, else false.

Checks if path was explicitly selected. If no projection, always returns true.

Checks if path is in the init state, that is, it was set by Document#init() and not modified since.

Returns true if any of the given paths is modified, else false. If no arguments, returns true if any path in this document is modified.

If path is given, checks if a path or any full path containing path as part of its path chain has been modified.

Boolean flag specifying if the document is new.

Checks if path was selected in the source query which initialized this document.

Marks the path as having pending changes to write to the db.

Very helpful when using Mixed types.

Returns the list of paths that have been modified.

Overwrite all values in this document with the values of obj, except for immutable properties. Behaves similarly to set(), except for it unsets all properties that aren't in obj.

If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Populates document references, executing the callback when complete. If you want to use promises instead, use this function with execPopulate()

Population does not occur unless a callback is passed or you explicitly call execPopulate(). Passing the same path a second time will overwrite the previous path options. See Model.populate() for explaination of options.

Gets _id(s) used during population of the given path.

If the path was not populated, returns undefined.

Sends a replaceOne command with this document _id as the query selector.

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation only with the modifications to the database, it does not replace the whole document in the latter case.

If save is successful, the returned promise will fulfill with the document saved.

The document's schema.

Sets the value of a path, or many paths.

The return value of this method is used in calls to JSON.stringify(doc).

This method accepts the same options as Document#toObject. To apply the options to every document of your schema by default, set your schemas toJSON option to the same argument.

See schema options for details.

Converts this document into a plain-old JavaScript object (POJO).

Buffers are converted to instances of mongodb.Binary for proper storage.

Example of only applying path getters

Example of only applying virtual getters

Example of applying both path and virtual getters

To apply these options to every document of your schema by default, set your schemas toObject option to the same argument.

We may need to perform a transformation of the resulting object based on some criteria, say to remove some sensitive information or return a custom object. In this case we set the optional transform function.

Transform functions receive three arguments

With transformations we can do a lot more than remove properties. We can even return completely new customized objects:

Note: if a transform function returns undefined, the return value will be ignored.

Transformations may also be applied inline, overridding any transform set in the options:

If you want to skip transformations, use transform: false:

If you pass a transform in toObject() options, Mongoose will apply the transform to subdocuments in addition to the top-level document. Similarly, transform: false skips transforms for all subdocuments.

if you define a transform in schema.options.toObject.transform, that transform will not apply to subdocuments.

Transforms, like all of these options, are also available for toJSON. See this guide to JSON.stringify() to learn why toJSON() and toObject() are separate functions.

See schema options for some more details.

During save, no custom options are applied to the document before being sent to the database.

Helper for console.log

Gets all populated documents associated with this document.

Clears the modified state on the specified path.

Sends an update command with this document _id as the query selector.

Sends an updateOne command with this document _id as the query selector.

Executes registered validation rules for this document.

This method is called pre save and if a validation rule is violated, save is aborted and the error is returned to your callback.

Executes registered validation rules (skipping asynchronous validators) for this document.

This method is useful if you need synchronous validation.

A Model is a class that's your primary tool for interacting with MongoDB. An instance of a Model is called a Document.

In Mongoose, the term "Model" refers to subclasses of the mongoose.Model class. You should not use the mongoose.Model class directly. The mongoose.model() and connection.model() functions create subclasses of mongoose.Model as shown below.

Performs aggregations on the models collection.

If a callback is passed, the aggregate is executed and a Promise is returned. If a callback is not passed, the aggregate itself is returned.

This function triggers the following middleware.

@param {[Document]} documents The array of documents to build write operations of

takes an array of documents, gets the changes and inserts/updates documents in the database according to whether or not the document is new, or whether it has changes or not.

bulkSave uses bulkWrite under the hood, so it's mostly useful when dealing with many documents (10K+)

Sends multiple insertOne, updateOne, updateMany, replaceOne, deleteOne, and/or deleteMany operations to the MongoDB server in one command. This is faster than sending multiple independent operations (e.g. if you use create()) because with bulkWrite() there is only one round trip to MongoDB.

Mongoose will perform casting on all operations you provide.

This function does not trigger any middleware, neither save(), nor update(). If you need to trigger save() middleware for every document use create() instead.

The supported operations are:

Deletes all indexes that aren't defined in this model's schema. Used by syncIndexes().

The returned promise resolves to a list of the dropped indexes' names as an array

Counts number of documents that match filter in a database collection.

This method is deprecated. If you want to count the number of documents in a collection, e.g. count({}), use the estimatedDocumentCount() function instead. Otherwise, use the countDocuments() function instead.

Counts number of documents matching filter in a database collection.

If you want to count all documents in a large collection, use the estimatedDocumentCount() function instead. If you call countDocuments({}), MongoDB will always execute a full collection scan and not use any indexes.

The countDocuments() function is similar to count(), but there are a few operators that countDocuments() does not support. Below are the operators that count() supports but countDocuments() does not, and the suggested replacement:

Shortcut for saving one or more documents to the database. MyModel.create(docs) does new MyModel(doc).save() for every doc in docs.

This function triggers the following middleware.

Create the collection for this model. By default, if no indexes are specified, mongoose will not create the collection for the model until any documents are created. Use this method to create the collection explicitly.

Note 1: You may need to call this before starting a transaction See https://docs.mongodb.com/manual/core/transactions/#transactions-and-operations

Note 2: You don't have to call this if your schema contains index or unique field. In that case, just use Model.init()

Similar to ensureIndexes(), except for it uses the createIndex function.

Deletes all of the documents that match conditions from the collection. Behaves like remove(), but deletes all documents that match conditions regardless of the single option.

This function triggers deleteMany query hooks. Read the middleware docs to learn more.

Deletes the first document that matches conditions from the collection. Behaves like remove(), but deletes at most one document regardless of the single option.

This function triggers deleteOne query hooks. Read the middleware docs to learn more.

Does a dry-run of Model.syncIndexes(), meaning that the result of this function would be the result of Model.syncIndexes().

Adds a discriminator type.

Creates a Query for a distinct operation.

Passing a callback executes the query.

Sends createIndex commands to mongo for each index declared in the schema. The createIndex commands are sent in series.

After completion, an index event is emitted on this Model passing an error if one occurred.

NOTE: It is not recommended that you run this in production. Index creation may impact database performance depending on your load. Use with caution.

Estimates the number of documents in the MongoDB collection. Faster than using countDocuments() for large collections because estimatedDocumentCount() uses collection metadata rather than scanning the entire collection.

Event emitter that reports any errors that occurred. Useful for global error handling.

Returns true if at least one document exists in the database that matches the given filter, and false otherwise.

Under the hood, MyModel.exists({ answer: 42 }) is equivalent to MyModel.findOne({ answer: 42 }).select({ _id: 1 }).lean().then(doc => !!doc)

This function triggers the following middleware.

Mongoose casts the filter to match the model's schema before the command is sent. See our query casting tutorial for more information on how Mongoose casts filter.

Finds a single document by its _id field. findById(id) is almost* equivalent to findOne({ _id: id }). If you want to query by a document's _id, use findById() instead of findOne().

The id is cast based on the Schema before sending the command.

This function triggers the following middleware.

* Except for how it treats undefined. If you use findOne(), you'll see that findOne(undefined) and findOne({ _id: undefined }) are equivalent to findOne({}) and return arbitrary documents. However, mongoose translates findById(undefined) into findOne({ _id: null }).

Issue a MongoDB findOneAndDelete() command by a document's _id field. In other words, findByIdAndDelete(id) is a shorthand for findOneAndDelete({ _id: id }).

This function triggers the following middleware.

Issue a mongodb findAndModify remove command by a document's _id field. findByIdAndRemove(id, ...) is equivalent to findOneAndRemove({ _id: id }, ...).

Finds a matching document, removes it, passing the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

Issues a mongodb findAndModify update command by a document's _id field. findByIdAndUpdate(id, ...) is equivalent to findOneAndUpdate({ _id: id }, ...).

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed.

This function triggers the following middleware.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

The conditions are cast to their respective SchemaTypes before the command is sent.

Note: conditions is optional, and if conditions is null or undefined, mongoose will send an empty findOne command to MongoDB, which will return an arbitrary document. If you're querying by _id, use findById() instead.

Issue a MongoDB findOneAndDelete() command.

Finds a matching document, removes it, and passes the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

This function differs slightly from Model.findOneAndRemove() in that findOneAndRemove() becomes a MongoDB findAndModify() command, as opposed to a findOneAndDelete() command. For most mongoose use cases, this distinction is purely pedantic. You should use findOneAndDelete() unless you have a good reason not to.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a mongodb findAndModify remove command.

Finds a matching document, removes it, passing the found document (if any) to the callback.

Executes the query if callback is passed.

This function triggers the following middleware.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a MongoDB findOneAndReplace() command.

Finds a matching document, replaces it with the provided doc, and passes the returned doc to the callback.

Executes the query if callback is passed.

This function triggers the following query middleware.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

Issues a mongodb findAndModify update command.

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed else a Query object is returned.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }.

Values are cast to their appropriate types when using the findAndModify helpers. However, the below are not executed by default.

findAndModify helpers support limited validation. You can enable these by setting the runValidators options, respectively.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Implements $geoSearch functionality for Mongoose

This function does not trigger any middleware

Shortcut for creating a new Document from existing raw data, pre-saved in the DB. The document returned has no paths marked as modified initially.

This function is responsible for building indexes, unless autoIndex is turned off.

Mongoose calls this function automatically when a model is created using mongoose.model() or connection.model(), so you don't need to call it. This function is also idempotent, so you may call it to get back a promise that will resolve when your indexes are finished building as an alternative to MyModel.on('index')

Shortcut for validating an array of documents and inserting them into MongoDB if they're all valid. This function is faster than .create() because it only sends one operation to the server, rather than one for each document.

Mongoose always validates each document before sending insertMany to MongoDB. So if one document has a validation error, no documents will be saved, unless you set the ordered option to false.

This function does not trigger save middleware.

This function triggers the following middleware.

Helper for console.log. Given a model named 'MyModel', returns the string 'Model { MyModel }'.

Lists the indexes currently defined in MongoDB. This may or may not be the same as the indexes defined in your schema depending on whether you use the autoIndex option and if you build indexes manually.

Executes a mapReduce command.

o is an object specifying all mapReduce options as well as the map and reduce functions. All options are delegated to the driver implementation. See node-mongodb-native mapReduce() documentation for more detail about options.

This function does not trigger any middleware.

If options.out is set to replace, merge, or reduce, a Model instance is returned that can be used for further querying. Queries run against this model are all executed with the lean option; meaning only the js object is returned and no Mongoose magic is applied (getters, setters, etc).

Populates document references.

Additional properties to attach to the query when calling save() and isNew is false.

Creates a Query and specifies a $where condition.

Sometimes you need to query for things in mongodb using a JavaScript expression. You can do so via find({ $where: javascript }), or you can use the mongoose shortcut method $where via a Query chain or from your mongoose Model.

Base Mongoose instance the model uses.

If this is a discriminator model, baseModelName is the name of the base model.

Collection the model uses.

This property is read-only. Modifying this property is a no-op.

Connection the model uses.

Removes this document from the db. Equivalent to .remove().

Registered discriminators for this model.

Returns another Model instance.

The name of the model

Removes this document from the db.

As an extra measure of flow control, remove will return a Promise (bound to fn if passed) so it could be chained, or hooked to recieve errors

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation with just the modified paths if isNew is false.

If save is successful, the returned promise will fulfill with the document saved.

Schema the model uses.

Removes all documents that match conditions from the collection. To remove just the first document that matches conditions, set the single option to true.

This method sends a remove command directly to MongoDB, no Mongoose documents are involved. Because no Mongoose documents are involved, Mongoose does not execute document middleware.

Same as update(), except MongoDB replace the existing document with the given document (no atomic operators like $set).

This function triggers the following middleware.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling MyModel.startSession() is equivalent to calling MyModel.db.startSession().

This function does not trigger any middleware.

Makes the indexes in MongoDB match the indexes defined in this model's schema. This function will drop any indexes that are not defined in the model's schema except the _id index, and build any indexes that are in your schema but not in MongoDB.

See the introductory blog post for more information.

Translate any aliases fields/conditions so the final query or document object is pure

Only translate arguments of object type anything else is returned raw

Updates one document in the database without returning it.

This function triggers the following middleware.

All update values are cast to their appropriate SchemaTypes before being sent.

The callback function receives (err, rawResponse).

All top level keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting all documents in your collection with { name: 'jason bourne' }.

Be careful to not use an existing model instance for the update clause (this won't work and can cause weird behavior like infinite loops). Also, ensure that the update clause does not have an _id property, which causes Mongo to return a "Mod on _id not allowed" error.

Mongoose casts values and runs setters when using update. The following features are not applied by default.

If you need document middleware and fully-featured validation, load the document first and then use save().

Same as update(), except MongoDB will update all documents that match filter (as opposed to just the first one) regardless of the value of the multi option.

Note updateMany will not fire update middleware. Use pre('updateMany') and post('updateMany') instead.

This function triggers the following middleware.

Same as update(), except it does not support the multi or overwrite options.

This function triggers the following middleware.

Casts and validates the given object against this model's schema, passing the given context to custom validators.

Requires a replica set running MongoDB >= 3.6.0. Watches the underlying collection for changes using MongoDB change streams.

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

Creates a Query, applies the passed conditions, and returns the Query.

For example, instead of writing:

we can instead write:

Since the Query class also supports where you can continue chaining

Signal that we desire an increment of this documents version.

Query constructor used for building queries. You do not need to instantiate a Query directly. Instead use Model functions like Model.find().

Specifies a javascript function or expression to pass to MongoDBs query system.

Only use $where when you have a condition that cannot be met using other MongoDB operators like $lt. Be sure to read about all of its caveats before using.

Returns an asyncIterator for use with for/await/of loops This function only works for find() queries. You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

Specifies an $all query condition.

When called with one argument, the most recent path passed to where() is used.

Sets the allowDiskUse option, which allows the MongoDB server to use more than 100 MB for this query's sort(). This option can let you work around QueryExceededMemoryLimitNoDiskUseAllowed errors from the MongoDB server.

Note that this option requires MongoDB server >= 4.4. Setting this option is a no-op for MongoDB 4.2 and earlier.

Calling query.allowDiskUse(v) is equivalent to query.setOptions({ allowDiskUse: v })

Specifies arguments for a $and condition.

Specifies the batchSize option.

Cannot be used with distinct()

Specifies a $box condition

Casts this query to the schema of model

If obj is present, it is cast instead of this query.

Executes the query returning a Promise which will be resolved with either the doc(s) or rejected with the error. Like .then(), but only takes a rejection handler.

More about Promise catch() in JavaScript.

DEPRECATED Alias for circle

Deprecated. Use circle instead.

DEPRECATED Specifies a $centerSphere condition

Deprecated. Use circle instead.

Specifies a $center or $centerSphere condition.

Adds a collation to this op (MongoDB 3.4 and up)

Specifies the comment option.

Cannot be used with distinct()

Specifies this query as a count query.

This method is deprecated. If you want to count the number of documents in a collection, e.g. count({}), use the estimatedDocumentCount() function instead. Otherwise, use the countDocuments() function instead.

Passing a callback executes the query.

This function triggers the following middleware.

Specifies this query as a countDocuments() query. Behaves like count(), except it always does a full collection scan when passed an empty filter {}.

There are also minor differences in how countDocuments() handles $where and a couple geospatial operators. versus count().

Passing a callback executes the query.

This function triggers the following middleware.

The countDocuments() function is similar to count(), but there are a few operators that countDocuments() does not support. Below are the operators that count() supports but countDocuments() does not, and the suggested replacement:

Returns a wrapper around a mongodb driver cursor. A QueryCursor exposes a Streams3 interface, as well as a .next() function.

The .cursor() function triggers pre find hooks, but not post find hooks.

Declare and/or execute this query as a deleteMany() operation. Works like remove, except it deletes every document that matches filter in the collection, regardless of the value of single.

This function triggers deleteMany middleware.

This function calls the MongoDB driver's Collection#deleteMany() function. The returned promise resolves to an object that contains 3 properties:

Declare and/or execute this query as a deleteOne() operation. Works like remove, except it deletes at most one document regardless of the single option.

This function triggers deleteOne middleware.

This function calls the MongoDB driver's Collection#deleteOne() function. The returned promise resolves to an object that contains 3 properties:

Declares or executes a distinct() operation.

Passing a callback executes the query.

This function does not trigger any middleware.

Specifies an $elemMatch condition

Specifies the complementary comparison value for paths specified with where()

Gets/sets the error flag on this query. If this flag is not null or undefined, the exec() promise will reject without executing.

Note that query casting runs after hooks, so cast errors will override custom errors.

Specifies this query as a estimatedDocumentCount() query. Faster than using countDocuments() for large collections because estimatedDocumentCount() uses collection metadata rather than scanning the entire collection.

estimatedDocumentCount() does not accept a filter. Model.find({ foo: bar }).estimatedDocumentCount() is equivalent to Model.find().estimatedDocumentCount()

This function triggers the following middleware.

Specifies an $exists condition

Sets the explain option, which makes this query return detailed execution stats instead of the actual query result. This method is useful for determining what index your queries use.

Calling query.explain(v) is equivalent to query.setOptions({ explain: v })

Find all documents that match selector. The result will be an array of documents.

If there are too many documents in the result to fit in memory, use Query.prototype.cursor()

Declares the query a findOne operation. When executed, the first found document is passed to the callback.

Passing a callback executes the query. The result of the query is a single document.

This function triggers the following middleware.

Issues a MongoDB findOneAndDelete command.

Finds a matching document, removes it, and passes the found document (if any) to the callback. Executes if callback is passed.

This function triggers the following middleware.

This function differs slightly from Model.findOneAndRemove() in that findOneAndRemove() becomes a MongoDB findAndModify() command, as opposed to a findOneAndDelete() command. For most mongoose use cases, this distinction is purely pedantic. You should use findOneAndDelete() unless you have a good reason not to.

Issues a mongodb findAndModify remove command.

Finds a matching document, removes it, passing the found document (if any) to the callback. Executes if callback is passed.

This function triggers the following middleware.

Issues a MongoDB findOneAndReplace command.

Finds a matching document, removes it, and passes the found document (if any) to the callback. Executes if callback is passed.

This function triggers the following middleware.

Issues a mongodb findAndModify update command.

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed.

This function triggers the following middleware.

Specifies a $geometry condition

The argument is assigned to the most recent path passed to where().

geometry() must come after either intersects() or within().

The object argument must contain type and coordinates properties. - type {String} - coordinates {Array}

For update operations, returns the value of a path in the update's $set. Useful for writing getters/setters that can work with both update operations and save().

Returns the current query filter (also known as conditions) as a POJO.

Gets a list of paths to be populated by this query

Returns the current query filter. Equivalent to getFilter().

You should use getFilter() instead of getQuery() where possible. getQuery() will likely be deprecated in a future release.

Returns the current update operations as a JSON object.

Specifies a $gt query condition.

When called with one argument, the most recent path passed to where() is used.

Specifies a $gte query condition.

When called with one argument, the most recent path passed to where() is used.

Cannot be used with distinct()

Specifies an $in query condition.

When called with one argument, the most recent path passed to where() is used.

Declares an intersects query for geometry().

MUST be used after where().

In Mongoose 3.7, intersects changed from a getter to a function. If you need the old syntax, use this.

Requests acknowledgement that this operation has been persisted to MongoDB's on-disk journal.

Defaults to the schema's writeConcern.j option

Sets the lean option.

Documents returned from queries with the lean option enabled are plain javascript objects, not Mongoose Documents. They have no save method, getters/setters, virtuals, or other Mongoose features.

Lean is great for high-performance, read-only cases, especially when combined with cursors.

If you need virtuals, getters/setters, or defaults with lean(), you need to use a plugin. See:

Specifies the maximum number of documents the query will return.

Cannot be used with distinct()

Specifies a $lt query condition.

When called with one argument, the most recent path passed to where() is used.

Specifies a $lte query condition.

When called with one argument, the most recent path passed to where() is used.

Runs a function fn and treats the return value of fn as the new value for the query to resolve to.

Any functions you pass to map() will run after any post hooks.

Specifies a maxDistance query condition.

When called with one argument, the most recent path passed to where() is used.

Specifies the maxScan option.

Cannot be used with distinct()

Sets the maxTimeMS option. This will tell the MongoDB server to abort if the query or write op has been running for more than ms milliseconds.

Calling query.maxTimeMS(v) is equivalent to query.setOptions({ maxTimeMS: v })

DEPRECATED Alias of maxScan

Merges another Query or conditions object into this one.

When a Query is passed, conditions, field selection and options are merged.

Specifies a $mod condition, filters documents for documents whose path property is a number that is equal to remainder modulo divisor.

The model this query is associated with.

Getter/setter around the current mongoose-specific options for this query Below are the current Mongoose-specific options.

Mongoose maintains a separate object for internal options because Mongoose sends Query.prototype.options to the MongoDB server, and the above options are not relevant for the MongoDB server.

Specifies a $ne query condition.

When called with one argument, the most recent path passed to where() is used.

Specifies a $near or $nearSphere condition

These operators return documents sorted by distance.

DEPRECATED Specifies a $nearSphere condition

Deprecated. Use query.near() instead with the spherical option set to true.

Specifies an $nin query condition.

When called with one argument, the most recent path passed to where() is used.

Specifies arguments for a $nor condition.

Specifies arguments for an $or condition.

Make this query throw an error if no documents match the given filter. This is handy for integrating with async/await, because orFail() saves you an extra if statement to check if no document was found.

Specifies a $polygon condition

Specifies paths which should be populated with other documents.

Paths are populated after the query executes and a response is received. A separate query is then executed for each path specified for population. After a response for each query has also been returned, the results are passed to the callback.

Add post middleware to this query instance. Doesn't affect other queries.

Add pre middleware to this query instance. Doesn't affect other queries.

Get/set the current projection (AKA fields). Pass null to remove the current projection.

Unlike projection(), the select() function modifies the current projection in place. This function overwrites the existing projection.

Determines the MongoDB nodes from which to read.

Read more about how to use read preferences here and here.

Sets the readConcern option for the query.

Read more about how to use read concern here.

Specifies a $regex query condition.

When called with one argument, the most recent path passed to where() is used.

Declare and/or execute this query as a remove() operation. remove() is deprecated, you should use deleteOne() or deleteMany() instead.

This function does not trigger any middleware

This function calls the MongoDB driver's Collection#remove() function. The returned promise resolves to an object that contains 3 properties:

Calling remove() creates a Mongoose query, and a query does not execute until you either pass a callback, call Query#then(), or call Query#exec().

Declare and/or execute this query as a replaceOne() operation. Same as update(), except MongoDB will replace the existing document and will not accept any atomic operators ($set, etc.)

Note replaceOne will not fire update middleware. Use pre('replaceOne') and post('replaceOne') instead.

This function triggers the following middleware.

Specifies which document fields to include or exclude (also known as the query "projection")

When using string syntax, prefixing a path with - will flag that path as excluded. When a path does not have the - prefix, it is included. Lastly, if a path is prefixed with +, it forces inclusion of the path, which is useful for paths excluded at the schema level.

A projection must be either inclusive or exclusive. In other words, you must either list the fields to include (which excludes all others), or list the fields to exclude (which implies all other fields are included). The _id field is the only exception because MongoDB includes it by default.

Determines if field selection has been made.

Determines if exclusive field selection has been made.

Determines if inclusive field selection has been made.

Sets the MongoDB session associated with this query. Sessions are how you mark a query as part of a transaction.

Calling session(null) removes the session from this query.

Adds a $set to this query's update without changing the operation. This is useful for query middleware so you can add an update regardless of whether you use updateOne(), updateMany(), findOneAndUpdate(), etc.

Sets query options. Some options only make sense for certain operations.

The following options are only for find():

The following options are only for write operations: update(), updateOne(), updateMany(), replaceOne(), findOneAndUpdate(), and findByIdAndUpdate():

The following options are only for find(), findOne(), findById(), findOneAndUpdate(), and findByIdAndUpdate():

The following options are only for all operations except update(), updateOne(), updateMany(), remove(), deleteOne(), and deleteMany():

The following options are for findOneAndUpdate() and findOneAndRemove()

Sets the query conditions to the provided JSON object.

Sets the current update operation to new value.

Specifies a $size query condition.

When called with one argument, the most recent path passed to where() is used.

Specifies the number of documents to skip.

Cannot be used with distinct()

DEPRECATED Sets the slaveOk option.

Deprecated in MongoDB 2.2 in favor of read preferences.

Specifies a $slice projection for an array.

Specifies this query as a snapshot query.

Cannot be used with distinct()

If an object is passed, values allowed are asc, desc, ascending, descending, 1, and -1.

If a string is passed, it must be a space delimited list of path names. The sort order of each path is ascending unless the path name is prefixed with - which will be treated as descending.

Cannot be used with distinct()

Sets the tailable option (for use with capped collections).

Cannot be used with distinct()

Executes the query returning a Promise which will be resolved with either the doc(s) or rejected with the error.

More about then() in JavaScript.

Converts this query to a customized, reusable query constructor with all arguments and options retained.

Declare and/or execute this query as an update() operation.

All paths passed that are not atomic operations will become $set ops.

This function triggers the following middleware.

Passing an empty object {} as the doc will result in a no-op unless the overwrite option is passed. Without the overwrite option set, the update operation will be ignored and the callback executed without sending the command to MongoDB so as to prevent accidently overwritting documents in the collection.

The operation is only executed when a callback is passed. To force execution without a callback, we must first call update() and then execute it by using the exec() method.

Declare and/or execute this query as an updateMany() operation. Same as update(), except MongoDB will update all documents that match filter (as opposed to just the first one) regardless of the value of the multi option.

Note updateMany will not fire update middleware. Use pre('updateMany') and post('updateMany') instead.

This function triggers the following middleware.

Declare and/or execute this query as an updateOne() operation. Same as update(), except it does not support the multi or overwrite options.

Note updateOne will not fire update middleware. Use pre('updateOne') and post('updateOne') instead.

This function triggers the following middleware.

Flag to opt out of using $geoWithin.

MongoDB 2.4 deprecated the use of $within, replacing it with $geoWithin. Mongoose uses $geoWithin by default (which is 100% backward compatible with $within). If you are running an older version of MongoDB, set this flag to false so your within() queries continue to work.

Sets the specified number of mongod servers, or tag set of mongod servers, that must acknowledge this write before this write is considered successful.

Defaults to the schema's writeConcern.w option

Specifies a path for use with chaining.

Defines a $within or $geoWithin argument for geo-spatial queries.

MUST be used after where().

As of Mongoose 3.7, $geoWithin is always used for queries. To change this behavior, see Query.use$geoWithin.

In Mongoose 3.7, within changed from a getter to a function. If you need the old syntax, use this.

Defaults to the schema's writeConcern option

If w > 1, the maximum amount of time to wait for this write to propagate through the replica set before this operation fails. The default is 0, which means no timeout.

Defaults to the schema's writeConcern.wtimeout option

Returns an asyncIterator for use with for/await/of loops. You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

A QueryCursor is a concurrency primitive for processing query results one document at a time. A QueryCursor fulfills the Node.js streams3 API, in addition to several other mechanisms for loading documents from MongoDB one at a time.

QueryCursors execute the model's pre find hooks before loading any documents from MongoDB, and the model's post find hooks after loading each document.

Unless you're an advanced user, do not instantiate this class directly. Use Query#cursor() instead.

Adds a cursor flag. Useful for setting the noCursorTimeout and tailable flags.

Marks this cursor as closed. Will stop streaming and subsequent calls to next() will error.

Execute fn for every document in the cursor. If fn returns a promise, will wait for the promise to resolve before iterating on to the next one. Returns a promise that resolves when done.

Registers a transform function which subsequently maps documents retrieved via the streams interface or .next()

Get the next document from this cursor. Will return null when there are no documents left.

The options passed in to the QueryCursor constructor.

Aggregate constructor used for building aggregation pipelines. Do not instantiate this class directly, use Model.aggregate() instead.

Returns an asyncIterator for use with [for/await/of loops](https://thecodebarbarian.com/getting-started-with-async-iterators-in-node-js You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not set if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

Sets an option on this aggregation. This function will be deprecated in a future release. Use the cursor(), collation(), etc. helpers to set individual options, or access agg.options directly.

Note that MongoDB aggregations do not support the noCursorTimeout flag, if you try setting that flag with this function you will get a "unrecognized field 'noCursorTimeout'" error.

Appends a new $addFields operator to this aggregate pipeline. Requires MongoDB v3.4+ to work

Sets the allowDiskUse option for the aggregation query (ignored for < 2.6.0)

Appends new operators to this aggregate pipeline

Executes the query returning a Promise which will be resolved with either the doc(s) or rejected with the error. Like .then(), but only takes a rejection handler.

Appends a new $count operator to this aggregate pipeline.

Sets the cursor option option for the aggregation query (ignored for < 2.6.0). Note the different syntax below: .exec() returns a cursor object, and no callback is necessary.

Executes the aggregate pipeline on the currently bound Model.

Execute the aggregation with explain

Combines multiple aggregation pipelines.

Appends new custom $graphLookup operator(s) to this aggregate pipeline, performing a recursive search on a collection.

Note that graphLookup can only consume at most 100MB of memory, and does not allow disk use even if { allowDiskUse: true } is specified.

Appends a new custom $group operator to this aggregate pipeline.

Sets the hint option for the aggregation query (ignored for < 3.6.0)

Appends a new $limit operator to this aggregate pipeline.

Appends new custom $lookup operator to this aggregate pipeline.

Appends a new custom $match operator to this aggregate pipeline.

Get/set the model that this aggregation will execute on.

Appends a new $geoNear operator to this aggregate pipeline.

MUST be used as the first operator in the pipeline.

Lets you set arbitrary options, for middleware or plugins.

Contains options passed down to the aggregate command.

Returns the current pipeline

Appends a new $project operator to this aggregate pipeline.

Mongoose query selection syntax is also supported.

Sets the readPreference option for the aggregation query.

Sets the readConcern level for the aggregation query.

Appends a new $redact operator to this aggregate pipeline.

If 3 arguments are supplied, Mongoose will wrap them with if-then-else of $cond operator respectively If thenExpr or elseExpr is string, make sure it starts with $$, like $$DESCEND, $$PRUNE or $$KEEP.

Appends a new $replaceRoot operator to this aggregate pipeline.

Note that the $replaceRoot operator requires field strings to start with '$'. If you are passing in a string Mongoose will prepend '$' if the specified field doesn't start '$'. If you are passing in an object the strings in your expression will not be altered.

Appends new custom $sample operator to this aggregate pipeline.

Helper for Atlas Text Search's $search stage.

Sets the session for this aggregation. Useful for transactions.

Appends a new $skip operator to this aggregate pipeline.

Appends a new $sort operator to this aggregate pipeline.

If an object is passed, values allowed are asc, desc, ascending, descending, 1, and -1.

If a string is passed, it must be a space delimited list of path names. The sort order of each path is ascending unless the path name is prefixed with - which will be treated as descending.

Appends a new $sortByCount operator to this aggregate pipeline. Accepts either a string field name or a pipeline object.

Note that the $sortByCount operator requires the new root to start with '$'. Mongoose will prepend '$' if the specified field name doesn't start with '$'.

Provides promise for aggregate.

Appends new custom $unwind operator(s) to this aggregate pipeline.

Note that the $unwind operator requires the path name to start with '$'. Mongoose will prepend '$' if the specified field doesn't start '$'.

An AggregationCursor is a concurrency primitive for processing aggregation results one document at a time. It is analogous to QueryCursor.

An AggregationCursor fulfills the Node.js streams3 API, in addition to several other mechanisms for loading documents from MongoDB one at a time.

Creating an AggregationCursor executes the model's pre aggregate hooks, but not the model's post aggregate hooks.

Unless you're an advanced user, do not instantiate this class directly. Use Aggregate#cursor() instead.

Returns an asyncIterator for use with [for/await/of loops](https://thecodebarbarian.com/getting-started-with-async-iterators-in-node-js You do not need to call this function explicitly, the JavaScript runtime will call it for you.

Node.js 10.x supports async iterators natively without any flags. You can enable async iterators in Node.js 8.x using the --harmony_async_iteration flag.

Note: This function is not set if Symbol.asyncIterator is undefined. If Symbol.asyncIterator is undefined, that means your Node.js version does not support async iterators.

Adds a cursor flag. Useful for setting the noCursorTimeout and tailable flags.

Marks this cursor as closed. Will stop streaming and subsequent calls to next() will error.

Execute fn for every document in the cursor. If fn returns a promise, will wait for the promise to resolve before iterating on to the next one. Returns a promise that resolves when done.

Registers a transform function which subsequently maps documents retrieved via the streams interface or .next()

Get the next document from this cursor. Will return null when there are no documents left.

SchemaType constructor. Do not instantiate SchemaType directly. Mongoose converts your schema paths into SchemaTypes automatically.

The function that Mongoose calls to cast arbitrary values to this SchemaType.

Sets a default value for this SchemaType.

Defaults can be either functions which return the value to use as the default or the literal value itself. Either way, the value will be cast based on its schema type before being set during document creation.

Adds a getter to this schematype.

Getters allow you to transform the representation of the data as it travels from the raw mongodb document to the value that you see.

Suppose you are storing credit card numbers and you want to hide everything except the last 4 digits to the mongoose user. You can do so by defining a getter in the following way:

Getters are also passed a second argument, the schematype on which the getter was defined. This allows for tailored behavior based on options passed in the schema.

Defines this path as immutable. Mongoose prevents you from changing immutable paths unless the parent document has isNew: true.

Mongoose also prevents changing immutable properties using updateOne() and updateMany() based on strict mode.

Declares the index options for this schematype.

Indexes are created in the background by default. If background is set to false, MongoDB will not execute any read/write operations you send until the index build. Specify background: false to override Mongoose's default.

Set the model that this path refers to. This is the option that populate looks at to determine the foreign collection it should query.

Adds a required validator to this SchemaType. The validator gets added to the front of this SchemaType's validators array using unshift().

The required validator uses the SchemaType's checkRequired function to determine whether a given value satisfies the required validator. By default, a value satisfies the required validator if val != null (that is, if the value is not null nor undefined). However, most built-in mongoose schema types override the default checkRequired function:

Sets default select() behavior for this path.

Set to true if this path should always be included in the results, false if it should be excluded by default. This setting can be overridden at the query level.

Adds a setter to this schematype.

Setters allow you to transform the data before it gets to the raw mongodb document or query.

Suppose you are implementing user registration for a website. Users provide an email and password, which gets saved to mongodb. The email is a string that you will want to normalize to lower case, in order to avoid one email having more than one account -- e.g., otherwise, avenue@q.com can be registered for 2 accounts via avenue@q.com and AvEnUe@Q.CoM.

You can set up email lower case normalization easily via a Mongoose setter.

As you can see above, setters allow you to transform the data before it stored in MongoDB, or before executing a query.

NOTE: we could have also just used the built-in lowercase: true SchemaType option instead of defining our own function.

Setters are also passed a second argument, the schematype on which the setter was defined. This allows for tailored behavior based on options passed in the schema.

You can also use setters to modify other properties on the document. If you're setting a property name on a document, the setter will run with this as the document. Be careful, in mongoose 5 setters will also run when querying by name with this as the query.

Declares a sparse index.

Declares a full text index.

Defines a custom function for transforming this path when converting a document to JSON.

Mongoose calls this function with one parameter: the current value of the path. Mongoose then uses the return value in the JSON output.

Declares an unique index.

NOTE: violating the constraint returns an E11000 error from MongoDB when saving, not a Mongoose validation error.

Adds validator(s) for this document path.

Validators always receive the value to validate as their first argument and must return Boolean. Returning false or throwing an error means validation failed.

The error message argument is optional. If not passed, the default generic error message template will be used.

From the examples above, you may have noticed that error messages support basic templating. There are a few other template keywords besides {PATH} and {VALUE} too. To find out more, details are available here.

If Mongoose's built-in error message templating isn't enough, Mongoose supports setting the message property to a function.

To bypass Mongoose's error messages and just copy the error message that the validator throws, do this:

Mongoose supports validators that return a promise. A validator that returns a promise is called an async validator. Async validators run in parallel, and validate() will wait until all async validators have settled.

You might use asynchronous validators to retreive other documents from the database to validate against or to meet other I/O bound validation needs.

Validation occurs pre('save') or whenever you manually execute document#validate.

If validation fails during pre('save') and no callback was passed to receive the error, an error event will be emitted on your Models associated db connection, passing the validation error object along.

If you want to handle these errors at the Model level, add an error listener to your Model as shown below.

Get/set the function used to cast arbitrary values to this type.

Get/set the function used to cast arbitrary values to this particular schematype instance. Overrides SchemaType.cast().

Override the function the required validator uses to check whether a value passes the required check. Override this on the individual SchemaType.

Attaches a getter for all instances of this schema type.

Sets a default option for this schema type.

VirtualType constructor

This is what mongoose uses to define virtual attributes via Schema.prototype.virtual.

Applies getters to value.

Applies setters to value.

Adds a custom getter to this virtual.

Mongoose calls the getter function with the below 3 parameters.

Adds a custom setter to this virtual.

Mongoose calls the setter function with the below 3 parameters.

MongooseError constructor. MongooseError is the base class for all Mongoose-specific errors.

An instance of this error class will be returned when mongoose failed to cast a value.

An instance of this error will be returned if you used an array projection and then modified the array in an unsafe way.

An instance of this error class will be returned when save() fails because the underlying document was not found. The constructor takes one parameter, the conditions that mongoose passed to update() when trying to update the document.

Thrown when you try to access a model that has not been registered yet

Thrown when a model with the given name was already registered on the connection. See the FAQ about OverwriteModelError.

An instance of this error class will be returned when you call save() multiple times on the same document in parallel. See the FAQ for more information.

Thrown when your try to pass values to model contrtuctor that were not specified in schema or change immutable properties when strict mode is "throw"

An instance of this error class will be returned when validation failed. The errors property contains an object whose keys are the paths that failed and whose values are instances of CastError or ValidationError.

A ValidationError has a hash of errors that contain individual ValidatorError instances.

Instances of ValidatorError have the following properties:

An instance of this error class will be returned when you call save() after the document in the database was changed in a potentially unsafe way. See the versionKey option for more information.

The default built-in validator error messages.

The name of the error. The name uniquely identifies this Mongoose error. The possible values are:

Pops the array atomically at most one time per document save().

Calling this mulitple times on an array before saving sends the same command as calling it once. This update is implemented using the MongoDB $pop method which enforces this restriction.

Atomically shifts the array at most one time per document save().

Calling this multiple times on an array before saving sends the same command as calling it once. This update is implemented using the MongoDB $pop method which enforces this restriction.

Adds values to the array if not already present.

Return whether or not the obj is included in the array.

Return the index of obj or -1 if not found.

Helper for console.log

Pushes items to the array non-atomically.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Wraps Array#pop with proper change tracking.

marks the entire array as modified which will pass the entire thing to $set potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Pulls items from the array atomically. Equality is determined by casting the provided value to an embedded document and comparing using the Document.equals() function.

To remove a document from a subdocument array we may pass an object with a matching _id.

Or we may passing the _id directly and let mongoose take care of it.

The first pull call will result in a atomic operation on the database, if pull is called repeatedly without saving the document, a $set operation is used on the complete array instead, overwriting possible changes that happened on the database in the meantime.

Wraps Array#push with proper change tracking.

Sets the casted val at index i and marks the array modified.

Wraps Array#shift with proper change tracking.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Wraps Array#sort with proper change tracking.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Wraps Array#splice with proper change tracking and casting.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwritting any changes that happen between when you retrieved the object and when you save it.

Returns a native js Array.

Wraps Array#unshift with proper change tracking.

marks the entire array as modified, which if saved, will store it as a $set operation, potentially overwriting any changes that happen between when you retrieved the object and when you save it.

Array SchemaType constructor

Override the function the required validator uses to check whether an array passes the required check.

Options for all arrays.

Check if the given value satisfies the required validator.

Adds an enum validator if this is an array of strings or numbers. Equivalent to SchemaString.prototype.enum() or SchemaNumber.prototype.enum()

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all Array instances.

SubdocsArray SchemaType constructor

Sets a default option for all DocumentArray instances.

Options for all document arrays.

Adds a discriminator to this document array.

This schema type's name, to defend against minifiers that mangle function names.

Single nested subdocument SchemaType constructor.

Sets a default option for all SingleNestedPath instances.

Adds a discriminator to this single nested subdocument.

The options defined on a schematype.

Allows overriding casting logic for this individual path. If a string, the given string overwrites Mongoose's default cast error message.

The default value for this path. If a function, Mongoose executes the function and uses the return value as the default.

If truthy, Mongoose will disallow changes to this path once the document is saved to the database for the first time. Read more about immutability in Mongoose here.

If truthy, Mongoose will build an index on this path when the model is compiled.

The model that populate() should use if populating this path.

If true, attach a required validator to this path, which ensures this path path cannot be set to a nullish value. If a function, Mongoose calls the function and only checks for nullish values if the function returns a truthy value.

Whether to include or exclude this path by default when loading documents using find(), findOne(), etc.

If truthy, Mongoose will build a sparse index on this path.

If truthy, Mongoose will build a text index on this path.

Define a transform function for this individual schema type. Only called when calling toJSON() or toObject().

The type to cast this path to.

If truthy, Mongoose will build a unique index on this path when the model is compiled. The unique option is not a validator.

Function or object describing how to validate this schematype.

The options defined on an Array schematype.

If this is an array of strings, an array of allowed values for this path. Throws an error if this array isn't an array of strings.

If set, specifies the type of this array's values. Equivalent to setting type to an array whose first element is of.

The options defined on a Buffer schematype.

Set the default subtype for this buffer.

The options defined on a Date schematype.

If set, Mongoose creates a TTL index on this path.

If set, Mongoose adds a validator that checks that this path is before the given max.

If set, Mongoose adds a validator that checks that this path is after the given min.

The options defined on a Number schematype.

If set, Mongoose adds a validator that checks that this path is strictly equal to one of the given values.

If set, Mongoose adds a validator that checks that this path is less than the given max.

If set, Mongoose adds a validator that checks that this path is at least the given min.

Sets default populate options.

The options defined on an ObjectId schematype.

If truthy, uses Mongoose's default built-in ObjectId path.

Sets default populate options.

The options defined on a string schematype.

Array of allowed values for this path

If truthy, Mongoose will add a custom setter that lowercases this string using JavaScript's built-in String#toLowerCase().

Attach a validator that succeeds if the data string matches the given regular expression, and fails otherwise.

If set, Mongoose will add a custom validator that ensures the given string's length is at most the given number.

Mongoose supports two different spellings for this option: maxLength and maxlength. maxLength is the recommended way to specify this option, but Mongoose also supports maxlength (lowercase "l").

If set, Mongoose will add a custom validator that ensures the given string's length is at least the given number.

Mongoose supports two different spellings for this option: minLength and minlength. minLength is the recommended way to specify this option, but Mongoose also supports minlength (lowercase "l").

Sets default populate options.

If truthy, Mongoose will add a custom setter that removes leading and trailing whitespace using JavaScript's built-in String#trim().

If truthy, Mongoose will add a custom setter that uppercases this string using JavaScript's built-in String#toUpperCase().

**Examples:**

Example 1 (javascript):
```javascript
const mongoose = require('mongoose');
mongoose instanceof mongoose.Mongoose; // true

// Create a new Mongoose instance with its own `connect()`, `set()`, `model()`, etc.
const m = new mongoose.Mongoose();
```

Example 2 (css):
```css
const schema = new Schema({ test: Date });
schema.path('test') instanceof mongoose.Date; // true
```

Example 3 (css):
```css
const vehicleSchema = new Schema({ fuelLevel: mongoose.Decimal128 });
```

Example 4 (css):
```css
const schema = new Schema({ arbitrary: mongoose.Mixed });
```

---

## Error

**URL:** https://mongoosejs.com/docs/api/error.html

**Contents:**
- Error
  - Error()
      - Parameters:
      - Type:
      - Inherits:
    - Example:
  - Error.CastError
      - Type:
  - Error.DivergentArrayError
      - Type:

MongooseError constructor. MongooseError is the base class for all Mongoose-specific errors.

An instance of this error class will be thrown when mongoose failed to cast a value.

An instance of this error will be thrown if you used an array projection and then modified the array in an unsafe way.

An instance of this error class will be thrown when save() fails because the underlying document was not found. The constructor takes one parameter, the conditions that mongoose passed to updateOne() when trying to update the document.

Thrown when you try to access a model that has not been registered yet

Thrown when some documents failed to save when calling bulkSave()

Thrown when the MongoDB Node driver can't connect to a valid server to send an operation to.

Thrown when a model with the given name was already registered on the connection. See the FAQ about OverwriteModelError.

An instance of this error class will be thrown when you call save() multiple times on the same document in parallel. See the FAQ for more information.

Thrown when your try to pass values to model constructor that were not specified in schema or change immutable properties when strict mode is "throw"

An instance of this error class will be returned when mongoose failed to populate with a path that is not existing.

An instance of this error class will be thrown when validation failed. The errors property contains an object whose keys are the paths that failed and whose values are instances of CastError or ValidationError.

A ValidationError has a hash of errors that contain individual ValidatorError instances.

Instances of ValidatorError have the following properties:

An instance of this error class will be thrown when you call save() after the document in the database was changed in a potentially unsafe way. See the versionKey option for more information.

The default built-in validator error messages.

The name of the error. The name uniquely identifies this Mongoose error. The possible values are:

**Examples:**

Example 1 (css):
```css
const Model = mongoose.model('Test', new mongoose.Schema({ answer: Number }));
const doc = new Model({ answer: 'not a number' });
const err = doc.validateSync();

err instanceof mongoose.Error.ValidationError; // true
```

Example 2 (css):
```css
const schema = Schema({ name: { type: String, required: true } });
const Model = mongoose.model('Test', schema);
const doc = new Model({});

// Top-level error is a ValidationError, **not** a ValidatorError
const err = doc.validateSync();
err instanceof mongoose.Error.ValidationError; // true

// A ValidationError `err` has 0 or more ValidatorErrors keyed by the
// path in the `err.errors` property.
err.errors['name'] instanceof mongoose.Error.ValidatorError;

err.errors['name'].kind; // 'required'
err.errors['name'].path; // 'name'
err.errors['name'].value; // undefined
```

---

## SchemaObjectId

**URL:** https://mongoosejs.com/docs/api/schemaobjectid.html

**Contents:**
- SchemaObjectId
  - SchemaObjectId()
      - Parameters:
      - Inherits:
  - SchemaObjectId.cast()
      - Parameters:
      - Returns:
      - Type:
    - Example:
  - SchemaObjectId.checkRequired()

ObjectId SchemaType constructor.

Get/set the function used to cast arbitrary values to objectids.

Override the function the required validator uses to check whether a string passes the required check.

Attaches a getter for all ObjectId instances

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$in is the function Mongoose calls to cast $in filter operators.

Adds an auto-generated ObjectId default if turnOn is true.

Check if the given value satisfies a required validator.

Returns this schema type's representation in a JSON schema.

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all ObjectId instances.

**Examples:**

Example 1 (javascript):
```javascript
// Make Mongoose only try to cast length 24 strings. By default, any 12
// char string is a valid ObjectId.
const original = mongoose.ObjectId.cast();
mongoose.ObjectId.cast(v => {
  assert.ok(typeof v !== 'string' || v.length === 24);
  return original(v);
});

// Or disable casting entirely
mongoose.ObjectId.cast(false);
```

Example 2 (javascript):
```javascript
// Allow empty strings to pass `required` check
mongoose.Schema.Types.String.checkRequired(v => v != null);

const M = mongoose.model({ str: { type: String, required: true } });
new M({ str: '' }).validateSync(); // `null`, validation passes!
```

Example 3 (javascript):
```javascript
// Always convert to string when getting an ObjectId
mongoose.ObjectId.get(v => v.toString());

const Model = mongoose.model('Test', new Schema({}));
typeof (new Model({})._id); // 'string'
```

Example 4 (css):
```css
// Make all object ids have option `required` equal to true.
mongoose.Schema.ObjectId.set('required', true);

const Order = mongoose.model('Order', new Schema({ userId: ObjectId }));
new Order({ }).validateSync().errors.userId.message; // Path `userId` is required.
```

---

## Decimal128

**URL:** https://mongoosejs.com/docs/api/decimal128.html

**Contents:**
- Decimal128
  - Decimal128()
    - Example:

Decimal128 type constructor

**Examples:**

Example 1 (javascript):
```javascript
const id = new mongoose.Types.Decimal128('3.1415');
```

---

## Connection

**URL:** https://mongoosejs.com/docs/6.x/docs/api/connection.html

**Contents:**
- Connection
  - Connection()
      - Parameters:
      - Inherits:
  - Connection.prototype.asPromise()
      - Returns:
    - Example:
  - Connection.prototype.client
      - Type:
  - Connection.prototype.close()

Connection constructor

For practical reasons, a Connection equals a Db.

Returns a promise that resolves when this connection successfully connects to MongoDB, or rejects if this connection failed to connect.

The MongoClient instance this connection uses to talk to MongoDB. Mongoose automatically sets this property when the connection is opened.

Closes the connection

Retrieves a collection, creating it if not cached.

Not typically needed by applications. Just talk to your collection through your model.

A hash of the collections associated with this connection

A hash of the global options that are associated with this connection

Helper for createCollection(). Will explicitly create the given collection with specified options. Used to create capped collections and views from mongoose.

Options are passed down without modification to the MongoDB driver's createCollection() function

The mongodb.Db instance, set when the connection is opened

Removes the model named name from this connection, if it exists. You can use this function to clean up any models you created in your tests to prevent OverwriteModelErrors.

Destory the connection (not just a alias of .close)

Helper for dropCollection(). Will delete the given collection, including all documents and indexes.

Helper for dropDatabase(). Deletes the given database, including all collections, documents, and indexes.

Gets the value of the option key. Equivalent to conn.options[key]

Returns the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB.

The host name portion of the URI. If multiple hosts, such as a replica set, this will contain the first host name in the URI

A number identifier for this connection. Used for debugging when you have multiple connections.

Defines or retrieves a model.

When no collection argument is passed, Mongoose produces a collection name by passing the model name to the utils.toCollectionName method. This method pluralizes the name. If you don't like this behavior, either pass a collection name or set your schemas collection name option.

Returns an array of model names created on this connection.

A POJO containing a map from model names to models. Contains all models that have been added to this connection using Connection#model().

The name of the database this connection points to.

Opens the connection with a URI using MongoClient.connect().

The password specified in the URI

Declares a plugin executed on all schemas you pass to conn.model()

Equivalent to calling .plugin(fn) on each schema you create.

The plugins that will be applied to all models created on this connection.

The port portion of the URI. If multiple hosts, such as a replica set, this will contain the port from the first host name in the URI.

Connection ready state

Each state change emits its associated event name.

Sets the value of the option key. Equivalent to conn.options[key] = val

Supported options include:

Set the MongoDB driver MongoClient instance that this connection uses to talk to MongoDB. This is useful if you already have a MongoClient instance, and want to reuse it.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Syncs all the indexes for the models registered with this connection.

Requires MongoDB >= 3.6.0. Executes the wrapped async function in a transaction. Mongoose will commit the transaction if the async function executes successfully and attempt to retry if there was a retriable error.

Calls the MongoDB driver's session.withTransaction(), but also handles resetting Mongoose document state as shown below.

Switches to a different database using the same connection pool.

Returns a new connection object, with the new db.

The username specified in the URI

Watches the entire underlying database for changes. Similar to Model.watch().

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

The ChangeStream object is an event emitter that emits the following events:

**Examples:**

Example 1 (javascript):
```javascript
const conn = await mongoose.createConnection('mongodb://127.0.0.1:27017/test').
  asPromise();
conn.readyState; // 1, means Mongoose is connected
```

Example 2 (css):
```css
conn.model('User', new Schema({ name: String }));
console.log(conn.model('User')); // Model object
conn.deleteModel('User');
console.log(conn.model('User')); // undefined

// Usually useful in a Mocha `afterEach()` hook
afterEach(function() {
  conn.deleteModel(/.+/); // Delete every model
});
```

Example 3 (javascript):
```javascript
const conn = mongoose.createConnection('mongodb://127.0.0.1:27017/mydb');
// Deletes the entire 'mydb' database
await conn.dropDatabase();
```

Example 4 (unknown):
```unknown
conn.get('test'); // returns the 'test' value
```

---

## Buffer

**URL:** https://mongoosejs.com/docs/api/buffer.html

**Contents:**
- Buffer
  - MongooseBuffer.mixin.copy()
      - Parameters:
      - Returns:
      - Type:
    - Note:
  - MongooseBuffer.mixin.equals()
      - Parameters:
      - Returns:
  - MongooseBuffer.mixin.subtype()

Buffer#copy does not mark target as modified so you must copy from a MongooseBuffer for it to work as expected. This is a work around since copy modifies the target, not this.

Determines if this buffer is equals to other buffer

Sets the subtype option and marks the buffer modified.

Converts this buffer for storage in MongoDB, including subtype

Converts this buffer to its Binary type representation.

Converts this buffer to a UUID. Throws an error if subtype is not 4.

**Examples:**

Example 1 (javascript):
```javascript
const bson = require('bson')
bson.BSON_BINARY_SUBTYPE_DEFAULT
bson.BSON_BINARY_SUBTYPE_FUNCTION
bson.BSON_BINARY_SUBTYPE_BYTE_ARRAY
bson.BSON_BINARY_SUBTYPE_UUID
bson.BSON_BINARY_SUBTYPE_MD5
bson.BSON_BINARY_SUBTYPE_USER_DEFINED

doc.buffer.subtype(bson.BSON_BINARY_SUBTYPE_UUID);
```

Example 2 (javascript):
```javascript
const mongodb = require('mongodb')
mongodb.BSON.BSON_BINARY_SUBTYPE_DEFAULT
mongodb.BSON.BSON_BINARY_SUBTYPE_FUNCTION
mongodb.BSON.BSON_BINARY_SUBTYPE_BYTE_ARRAY
mongodb.BSON.BSON_BINARY_SUBTYPE_UUID
mongodb.BSON.BSON_BINARY_SUBTYPE_MD5
mongodb.BSON.BSON_BINARY_SUBTYPE_USER_DEFINED
doc.buffer.toObject(mongodb.BSON.BSON_BINARY_SUBTYPE_USER_DEFINED);
```

---

## SchemaBuffer

**URL:** https://mongoosejs.com/docs/api/schemabuffer.html

**Contents:**
- SchemaBuffer
  - SchemaBuffer()
      - Parameters:
      - Inherits:
  - SchemaBuffer.checkRequired()
      - Parameters:
      - Returns:
      - Type:
    - Example:
  - SchemaBuffer.get()

Buffer SchemaType constructor

Override the function the required validator uses to check whether a string passes the required check.

Attaches a getter for all Buffer instances

Contains the handlers for different query operators for this schema type. For example, $conditionalHandlers.$exists is the function Mongoose calls to cast $exists filter operators.

Check if the given value satisfies a required validator. To satisfy a required validator, a buffer must not be null or undefined and have non-zero length.

Sets the default subtype for this buffer. You can find a list of allowed subtypes here.

Returns this schema type's representation in a JSON schema.

This schema type's name, to defend against minifiers that mangle function names.

Sets a default option for all Buffer instances.

**Examples:**

Example 1 (javascript):
```javascript
// Allow empty strings to pass `required` check
mongoose.Schema.Types.String.checkRequired(v => v != null);

const M = mongoose.model({ buf: { type: Buffer, required: true } });
new M({ buf: Buffer.from('') }).validateSync(); // validation passes!
```

Example 2 (javascript):
```javascript
// Always convert to string when getting an ObjectId
mongoose.Schema.Types.Buffer.get(v => v.toString('hex'));

const Model = mongoose.model('Test', new Schema({ buf: Buffer } }));
typeof (new Model({ buf: Buffer.fromString('hello') }).buf); // 'string'
```

Example 3 (css):
```css
const s = new Schema({ uuid: { type: Buffer, subtype: 4 });
const M = db.model('M', s);
const m = new M({ uuid: 'test string' });
m.uuid._subtype; // 4
```

Example 4 (css):
```css
// Make all buffers have `required` of true by default.
mongoose.Schema.Buffer.set('required', true);

const User = mongoose.model('User', new Schema({ test: Buffer }));
new User({ }).validateSync().errors.test.message; // Path `test` is required.
```

---

## Document

**URL:** https://mongoosejs.com/docs/5.x/docs/api/document.html

**Contents:**
- Document
  - Document.prototype.$getAllSubdocs()
  - Document.prototype.$ignore()
      - Parameters
    - Example:
  - Document.prototype.$isDefault()
      - Parameters
      - Returns:
    - Example
  - Document.prototype.$isDeleted()

Get all subdocs (by bfs)

Don't run validation on this path or persist changes to this path.

Checks if a path is set to its default.

Getter/setter, determines whether the document was removed or not.

Returns true if the given path is nullish or only contains empty objects. Useful for determining whether this subdoc will get stripped out by the minimize option.

Empty object that you can use for storing properties on the document. This is handy for passing data to middleware without conflicting with Mongoose internals.

Marks a path as valid, removing existing validation errors.

A string containing the current operation that Mongoose is executing on this document. May be null, 'save', 'validate', or 'remove'.

Alias for parent(). If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Getter/setter around the session associated with this document. Used to automatically set session if you save() a doc that you got from a query with an associated session.

If this is a top-level document, setting the session propagates to all child docs.

Alias for set(), used internally to avoid conflicts

Set this property to add additional query filters when Mongoose saves this document and isNew is false.

Takes a populated field and returns it to its unpopulated state.

If the path was not provided, then all populated fields are returned to their unpopulated state.

Returns the list of paths that have been directly modified. A direct modified path is a path that you explicitly set, whether via doc.foo = 'bar', Object.assign(doc, { foo: 'bar' }), or doc.set('foo', 'bar').

A path a may be in modifiedPaths() but not in directModifiedPaths() because a child of a was directly modified.

Returns true if this document is equal to another document.

Documents are considered equal when they have matching _ids, unless neither document has an _id, in which case this function falls back to using deepEqual().

Hash containing current validation errors.

Explicitly executes population and returns a promise. Useful for promises integration.

// you can also use doc.execPopulate(options) as a shorthand for // doc.populate(options).execPopulate()

const promise = doc.execPopulate({ path: 'company', select: 'employees' });

// summary promise.then(resolve,reject);

Returns the value of a path.

Returns the changes that happened to the document in the format that will be sent to MongoDB.

Modifying the object that getChanges() returns does not affect the document's change tracking state. Even if you delete user.getChanges().$set, Mongoose will still send a $set to the server.

The string version of this documents _id.

This getter exists on all documents by default. The getter can be disabled by setting the id option of its Schema to false at construction time.

Initializes the document without setters or marking anything modified.

Called internally after a document is returned from mongodb. Normally, you do not need to call this function on your own.

This function triggers init middleware. Note that init hooks are synchronous.

Helper for console.log

Marks a path as invalid, causing validation to fail.

The errorMsg argument will become the message of the ValidationError.

The value argument (if passed) will be available through the ValidationError.value property.

Returns true if path was directly set and modified, else false.

Checks if path was explicitly selected. If no projection, always returns true.

Checks if path is in the init state, that is, it was set by Document#init() and not modified since.

Returns true if any of the given paths is modified, else false. If no arguments, returns true if any path in this document is modified.

If path is given, checks if a path or any full path containing path as part of its path chain has been modified.

Boolean flag specifying if the document is new.

Checks if path was selected in the source query which initialized this document.

Marks the path as having pending changes to write to the db.

Very helpful when using Mixed types.

Returns the list of paths that have been modified.

Overwrite all values in this document with the values of obj, except for immutable properties. Behaves similarly to set(), except for it unsets all properties that aren't in obj.

If this document is a subdocument or populated document, returns the document's parent. Returns undefined otherwise.

Populates document references, executing the callback when complete. If you want to use promises instead, use this function with execPopulate()

Population does not occur unless a callback is passed or you explicitly call execPopulate(). Passing the same path a second time will overwrite the previous path options. See Model.populate() for explaination of options.

Gets _id(s) used during population of the given path.

If the path was not populated, returns undefined.

Sends a replaceOne command with this document _id as the query selector.

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation only with the modifications to the database, it does not replace the whole document in the latter case.

If save is successful, the returned promise will fulfill with the document saved.

The document's schema.

Sets the value of a path, or many paths.

The return value of this method is used in calls to JSON.stringify(doc).

This method accepts the same options as Document#toObject. To apply the options to every document of your schema by default, set your schemas toJSON option to the same argument.

See schema options for details.

Converts this document into a plain-old JavaScript object (POJO).

Buffers are converted to instances of mongodb.Binary for proper storage.

Example of only applying path getters

Example of only applying virtual getters

Example of applying both path and virtual getters

To apply these options to every document of your schema by default, set your schemas toObject option to the same argument.

We may need to perform a transformation of the resulting object based on some criteria, say to remove some sensitive information or return a custom object. In this case we set the optional transform function.

Transform functions receive three arguments

With transformations we can do a lot more than remove properties. We can even return completely new customized objects:

Note: if a transform function returns undefined, the return value will be ignored.

Transformations may also be applied inline, overridding any transform set in the options:

If you want to skip transformations, use transform: false:

If you pass a transform in toObject() options, Mongoose will apply the transform to subdocuments in addition to the top-level document. Similarly, transform: false skips transforms for all subdocuments.

if you define a transform in schema.options.toObject.transform, that transform will not apply to subdocuments.

Transforms, like all of these options, are also available for toJSON. See this guide to JSON.stringify() to learn why toJSON() and toObject() are separate functions.

See schema options for some more details.

During save, no custom options are applied to the document before being sent to the database.

Helper for console.log

Gets all populated documents associated with this document.

Clears the modified state on the specified path.

Sends an update command with this document _id as the query selector.

Sends an updateOne command with this document _id as the query selector.

Executes registered validation rules for this document.

This method is called pre save and if a validation rule is violated, save is aborted and the error is returned to your callback.

Executes registered validation rules (skipping asynchronous validators) for this document.

This method is useful if you need synchronous validation.

**Examples:**

Example 1 (bash):
```bash
doc.foo = null;
doc.$ignore('foo');
doc.save(); // changes to foo will not be persisted and validators won't be run
```

Example 2 (css):
```css
MyModel = mongoose.model('test', { name: { type: String, default: 'Val '} });
const m = new MyModel();
m.$isDefault('name'); // true
```

Example 3 (r):
```r
product.remove(function (err, product) {
  product.$isDeleted(); // true
  product.remove(); // no-op, doesn't send anything to the db

  product.$isDeleted(false);
  product.$isDeleted(); // false
  product.remove(); // will execute a remove against the db
})
```

Example 4 (css):
```css
const schema = new Schema({ nested: { foo: String } });
const Model = mongoose.model('Test', schema);
const doc = new Model({});
doc.$isEmpty('nested'); // true
doc.nested.$isEmpty(); // true

doc.nested.foo = 'bar';
doc.$isEmpty('nested'); // false
doc.nested.$isEmpty(); // false
```

---

## Model

**URL:** https://mongoosejs.com/docs/7.x/docs/api/model.html

**Contents:**
- Model
  - Model()
      - Parameters:
      - Inherits:
    - Example:
  - Model.$where()
      - Parameters:
      - Returns:
      - See:
  - Model.aggregate()

A Model is a class that's your primary tool for interacting with MongoDB. An instance of a Model is called a Document.

In Mongoose, the term "Model" refers to subclasses of the mongoose.Model class. You should not use the mongoose.Model class directly. The mongoose.model() and connection.model() functions create subclasses of mongoose.Model as shown below.

Creates a Query and specifies a $where condition.

Sometimes you need to query for things in mongodb using a JavaScript expression. You can do so via find({ $where: javascript }), or you can use the mongoose shortcut method $where via a Query chain or from your mongoose Model.

Performs aggregations on the models collection.

If a callback is passed, the aggregate is executed and a Promise is returned. If a callback is not passed, the aggregate itself is returned.

This function triggers the following middleware.

Apply defaults to the given document or POJO.

takes an array of documents, gets the changes and inserts/updates documents in the database according to whether or not the document is new, or whether it has changes or not.

bulkSave uses bulkWrite under the hood, so it's mostly useful when dealing with many documents (10K+)

Sends multiple insertOne, updateOne, updateMany, replaceOne, deleteOne, and/or deleteMany operations to the MongoDB server in one command. This is faster than sending multiple independent operations (e.g. if you use create()) because with bulkWrite() there is only one round trip to MongoDB.

Mongoose will perform casting on all operations you provide.

This function does not trigger any middleware, neither save(), nor update(). If you need to trigger save() middleware for every document use create() instead.

The supported operations are:

Cast the given POJO to the model's schema

Deletes all indexes that aren't defined in this model's schema. Used by syncIndexes().

The returned promise resolves to a list of the dropped indexes' names as an array

Counts number of documents that match filter in a database collection.

This method is deprecated. If you want to count the number of documents in a collection, e.g. count({}), use the estimatedDocumentCount() function instead. Otherwise, use the countDocuments() function instead.

Counts number of documents matching filter in a database collection.

If you want to count all documents in a large collection, use the estimatedDocumentCount() function instead. If you call countDocuments({}), MongoDB will always execute a full collection scan and not use any indexes.

The countDocuments() function is similar to count(), but there are a few operators that countDocuments() does not support. Below are the operators that count() supports but countDocuments() does not, and the suggested replacement:

Shortcut for saving one or more documents to the database. MyModel.create(docs) does new MyModel(doc).save() for every doc in docs.

This function triggers the following middleware.

Create the collection for this model. By default, if no indexes are specified, mongoose will not create the collection for the model until any documents are created. Use this method to create the collection explicitly.

Note 1: You may need to call this before starting a transaction See https://www.mongodb.com/docs/manual/core/transactions/#transactions-and-operations

Note 2: You don't have to call this if your schema contains index or unique field. In that case, just use Model.init()

Similar to ensureIndexes(), except for it uses the createIndex function.

Connection instance the model uses.

Deletes all of the documents that match conditions from the collection. It returns an object with the property deletedCount containing the number of documents deleted. Behaves like remove(), but deletes all documents that match conditions regardless of the single option.

This function triggers deleteMany query hooks. Read the middleware docs to learn more.

Deletes the first document that matches conditions from the collection. It returns an object with the property deletedCount indicating how many documents were deleted. Behaves like remove(), but deletes at most one document regardless of the single option.

This function triggers deleteOne query hooks. Read the middleware docs to learn more.

Does a dry-run of Model.syncIndexes(), returning the indexes that syncIndexes() would drop and create if you were to run syncIndexes().

Adds a discriminator type.

Creates a Query for a distinct operation.

Sends createIndex commands to mongo for each index declared in the schema. The createIndex commands are sent in series.

After completion, an index event is emitted on this Model passing an error if one occurred.

NOTE: It is not recommended that you run this in production. Index creation may impact database performance depending on your load. Use with caution.

Estimates the number of documents in the MongoDB collection. Faster than using countDocuments() for large collections because estimatedDocumentCount() uses collection metadata rather than scanning the entire collection.

Event emitter that reports any errors that occurred. Useful for global error handling.

Returns a document with _id only if at least one document exists in the database that matches the given filter, and null otherwise.

Under the hood, MyModel.exists({ answer: 42 }) is equivalent to MyModel.findOne({ answer: 42 }).select({ _id: 1 }).lean()

This function triggers the following middleware.

Mongoose casts the filter to match the model's schema before the command is sent. See our query casting tutorial for more information on how Mongoose casts filter.

Finds a single document by its _id field. findById(id) is almost* equivalent to findOne({ _id: id }). If you want to query by a document's _id, use findById() instead of findOne().

The id is cast based on the Schema before sending the command.

This function triggers the following middleware.

* Except for how it treats undefined. If you use findOne(), you'll see that findOne(undefined) and findOne({ _id: undefined }) are equivalent to findOne({}) and return arbitrary documents. However, mongoose translates findById(undefined) into findOne({ _id: null }).

Issue a MongoDB findOneAndDelete() command by a document's _id field. In other words, findByIdAndDelete(id) is a shorthand for findOneAndDelete({ _id: id }).

This function triggers the following middleware.

Issue a mongodb findOneAndRemove command by a document's _id field. findByIdAndRemove(id, ...) is equivalent to findOneAndRemove({ _id: id }, ...).

Finds a matching document, removes it, and returns the found document (if any).

This function triggers the following middleware.

Issues a mongodb findOneAndUpdate command by a document's _id field. findByIdAndUpdate(id, ...) is equivalent to findOneAndUpdate({ _id: id }, ...).

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any).

This function triggers the following middleware.

All top level update keys which are not atomic operation names are treated as set operations:

This helps prevent accidentally overwriting your document with { name: 'jason bourne' }. To prevent this behaviour, see the overwrite option

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

The conditions are cast to their respective SchemaTypes before the command is sent.

Note: conditions is optional, and if conditions is null or undefined, mongoose will send an empty findOne command to MongoDB, which will return an arbitrary document. If you're querying by _id, use findById() instead.

Issue a MongoDB findOneAndDelete() command.

Finds a matching document, removes it, and returns the found document (if any).

This function triggers the following middleware.

This function differs slightly from Model.findOneAndRemove() in that findOneAndRemove() becomes a MongoDB findAndModify() command, as opposed to a findOneAndDelete() command. For most mongoose use cases, this distinction is purely pedantic. You should use findOneAndDelete() unless you have a good reason not to.

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a mongodb findOneAndRemove command.

Finds a matching document, removes it, and returns the found document (if any).

This function triggers the following middleware.

findOneAndX and findByIdAndX functions support limited validation. You can enable validation by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Issue a MongoDB findOneAndReplace() command.

Finds a matching document, replaces it with the provided doc, and returns the document.

This function triggers the following query middleware.

Issues a mongodb findOneAndUpdate command.

Finds a matching document, updates it according to the update arg, passing any options, and returns the found document (if any) to the callback. The query executes if callback is passed else a Query object is returned.

All top level update keys which are not atomic operation names are treated as set operations:

findOneAndX and findByIdAndX functions support limited validation that you can enable by setting the runValidators option.

If you need full-fledged validation, use the traditional approach of first retrieving the document.

Shortcut for creating a new Document from existing raw data, pre-saved in the DB. The document returned has no paths marked as modified initially.

This function is responsible for building indexes, unless autoIndex is turned off.

Mongoose calls this function automatically when a model is created using mongoose.model() or connection.model(), so you don't need to call init() to trigger index builds.

However, you may need to call init() to get back a promise that will resolve when your indexes are finished. Calling await Model.init() is helpful if you need to wait for indexes to build before continuing. For example, if you want to wait for unique indexes to build before continuing with a test case.

Shortcut for validating an array of documents and inserting them into MongoDB if they're all valid. This function is faster than .create() because it only sends one operation to the server, rather than one for each document.

Mongoose always validates each document before sending insertMany to MongoDB. So if one document has a validation error, no documents will be saved, unless you set the ordered option to false.

This function does not trigger save middleware.

This function triggers the following middleware.

Helper for console.log. Given a model named 'MyModel', returns the string 'Model { MyModel }'.

Lists the indexes currently defined in MongoDB. This may or may not be the same as the indexes defined in your schema depending on whether you use the autoIndex option and if you build indexes manually.

Populates document references.

Changed in Mongoose 6: the model you call populate() on should be the "local field" model, not the "foreign field" model.

Returns the model instance used to create this document if no name specified. If name specified, returns the model with the given name.

Additional properties to attach to the query when calling save() and isNew is false.

Base Mongoose instance the model uses.

If this is a discriminator model, baseModelName is the name of the base model.

The collection instance this model uses. A Mongoose collection is a thin wrapper around a [MongoDB Node.js driver collection](MongoDB Node.js driver collection). Using Model.collection means you bypass Mongoose middleware, validation, and casting.

This property is read-only. Modifying this property is a no-op.

Collection the model uses.

Connection the model uses.

Removes this document from the db. Equivalent to .remove().

Registered discriminators for this model.

Signal that we desire an increment of this documents version.

Returns the model instance used to create this document if no name specified. If name specified, returns the model with the given name.

The name of the model

Saves this document by inserting a new document into the database if document.isNew is true, or sends an updateOne operation with just the modified paths if isNew is false.

If save is successful, the returned promise will fulfill with the document saved.

Replace the existing document with the given document (no atomic operators like $set).

This function triggers the following middleware.

Schema the model uses.

Requires MongoDB >= 3.6.0. Starts a MongoDB session for benefits like causal consistency, retryable writes, and transactions.

Calling MyModel.startSession() is equivalent to calling MyModel.db.startSession().

This function does not trigger any middleware.

Makes the indexes in MongoDB match the indexes defined in this model's schema. This function will drop any indexes that are not defined in the model's schema except the _id index, and build any indexes that are in your schema but not in MongoDB.

See the introductory blog post for more information.

You should be careful about running syncIndexes() on production applications under heavy load, because index builds are expensive operations, and unexpected index drops can lead to degraded performance. Before running syncIndexes(), you can use the diffIndexes() function to check what indexes syncIndexes() will drop and create.

Translate any aliases fields/conditions so the final query or document object is pure

By default, translateAliases() overwrites raw fields with aliased fields. So if n is an alias for name, { n: 'alias', name: 'raw' } will resolve to { name: 'alias' }. However, you can set the errorOnDuplicates option to throw an error if there are potentially conflicting paths. The translateAliases option for queries uses errorOnDuplicates.

Only translate arguments of object type anything else is returned raw

Same as updateOne(), except MongoDB will update all documents that match filter (as opposed to just the first one) regardless of the value of the multi option.

Note updateMany will not fire update middleware. Use pre('updateMany') and post('updateMany') instead.

This function triggers the following middleware.

Update only the first document that matches filter.

This function triggers the following middleware.

Casts and validates the given object against this model's schema, passing the given context to custom validators.

Requires a replica set running MongoDB >= 3.6.0. Watches the underlying collection for changes using MongoDB change streams.

This function does not trigger any middleware. In particular, it does not trigger aggregate middleware.

The ChangeStream object is an event emitter that emits the following events:

Creates a Query, applies the passed conditions, and returns the Query.

For example, instead of writing:

we can instead write:

Since the Query class also supports where you can continue chaining

**Examples:**

Example 1 (javascript):
```javascript
// `UserModel` is a "Model", a subclass of `mongoose.Model`.
const UserModel = mongoose.model('User', new Schema({ name: String }));

// You can use a Model to create new documents using `new`:
const userDoc = new UserModel({ name: 'Foo' });
await userDoc.save();

// You also use a model to create queries:
const userFromDb = await UserModel.findOne({ name: 'Foo' });
```

Example 2 (r):
```r
Blog.$where('this.username.indexOf("val") !== -1').exec(function (err, docs) {});
```

Example 3 (javascript):
```javascript
// Find the max balance of all accounts
const res = await Users.aggregate([
  { $group: { _id: null, maxBalance: { $max: '$balance' }}},
  { $project: { _id: 0, maxBalance: 1 }}
]);

console.log(res); // [ { maxBalance: 98000 } ]

// Or use the aggregation pipeline builder.
const res = await Users.aggregate().
  group({ _id: null, maxBalance: { $max: '$balance' } }).
  project('-id maxBalance').
  exec();
console.log(res); // [ { maxBalance: 98 } ]
```

Example 4 (javascript):
```javascript
Character.bulkWrite([
  {
    insertOne: {
      document: {
        name: 'Eddard Stark',
        title: 'Warden of the North'
      }
    }
  },
  {
    updateOne: {
      filter: { name: 'Eddard Stark' },
      // If you were using the MongoDB driver directly, you'd need to do
      // `update: { $set: { title: ... } }` but mongoose adds $set for
      // you.
      update: { title: 'Hand of the King' }
    }
  },
  {
    deleteOne: {
      filter: { name: 'Eddard Stark' }
    }
  }
]).then(res => {
 // Prints "1 1 1"
 console.log(res.insertedCount, res.modifiedCount, res.deletedCount);
});
```

---
