# Morning Metrics - How It Works

## The One-Sentence Version

Your personal dashboard in 30 seconds - email, calendar, and stats without opening five apps.

## Why This Exists

Every morning, Ed checks the same things:
- How many emails need attention?
- What meetings are on today?
- Any urgent fires to put out?

Opening Gmail, then Calendar, then checking each inbox tab... it's death by a thousand clicks. And you lose 10 minutes before you've even started working.

Morning Metrics is like having a PA who does the rounds and comes back with a one-page summary: "Here's what you need to know."

## The Gary Halbert Analogy

Gary used to say the most important thing is to "get the lay of the land" before you start writing. You don't draft copy until you know what you're working with.

Morning Metrics is getting the lay of the land for your day. Quick scan, know the terrain, then execute.

## How You Use It

Just say:
- "morning metrics"
- "check my stats"
- "what's my day look like"

Claude runs the script, talks to Gmail and Calendar, and hands you a clean briefing:

```
## Morning Metrics - January 10, 2026

### Calendar
Today's meetings: 2
- 9:30 AM: Weekly biz catchup
- 3:00 PM: Workshop

### Email
- Unread: 201
- Primary inbox: 45
- Important flagged: 3
```

30 seconds. You know if today is a fire drill or smooth sailing.

## What It Connects To

| Source | What You Get |
|--------|--------------|
| Gmail | Unread count, important emails |
| Calendar | Today's meetings, upcoming week |
| Substack | (Planned) Subscriber stats |
| Stripe | (Planned) Revenue snapshot |

## The Win-the-Day Connection

This skill is a building block for the full morning routine. Win-the-day orchestrates:
1. **Morning Metrics** (this skill) - Get the lay of the land
2. Capture Triage - Process your inbox
3. Task Clarity Scanner - Review today's tasks
4. Set your Top 3 - Decide what ships today

Metrics first, then action.
