---
name: multithread-outreach
description: Creates role-specific messages for multiple stakeholders in a deal. Use this skill when engaging additional contacts, following up with people who weren't on calls, or executing account-based selling strategies.
---

# Multithread Outreach

This skill creates tailored outreach messages for different stakeholders within an account, enabling you to engage multiple decision-makers and influencers with role-specific messaging.

## Objective

Generate personalized, role-appropriate messages for various stakeholders in a deal-ensuring each person receives communication relevant to their priorities while maintaining consistent core messaging.

## Why Multithreading Matters

### The Problem with Single-Threading
- Deals stall when your champion leaves or goes dark
- You miss perspectives from key decision-makers
- No internal advocates beyond your main contact
- Limited visibility into the buying process

### Benefits of Multithreading
- **Resilience**: Deal survives if one contact goes dark
- **Speed**: Multiple parallel conversations accelerate decisions
- **Intelligence**: Learn about different perspectives and priorities
- **Influence**: Build coalition of supporters across the org

## Stakeholder Categories

### Executive Sponsors (C-Level, VP)
**What They Care About:**
- Business outcomes and ROI
- Strategic alignment
- Risk mitigation
- Competitive advantage
- Resource allocation

**Messaging Approach:**
- Lead with business impact
- Keep it brief and high-level
- Quantify value when possible
- Focus on outcomes, not features
- Respect their time

### Operational Leaders (Directors, Managers)
**What They Care About:**
- Team productivity and efficiency
- Implementation feasibility
- Day-to-day impact
- Change management
- Success metrics

**Messaging Approach:**
- Balance strategic and tactical
- Address implementation concerns
- Show understanding of their challenges
- Include relevant details
- Offer to support their team

### Technical Buyers (IT, Security, Architecture)
**What They Care About:**
- Integration requirements
- Security and compliance
- Technical architecture
- Maintenance overhead
- Vendor reliability

**Messaging Approach:**
- Lead with technical credibility
- Address integration and security early
- Provide technical resources
- Offer to connect with your tech team
- Respect their expertise

### End Users
**What They Care About:**
- Ease of use
- Daily workflow impact
- Training and adoption
- Current pain points
- Personal productivity

**Messaging Approach:**
- Focus on user experience
- Acknowledge their pain points
- Highlight ease of adoption
- Show empathy for their situation
- Offer hands-on demonstrations

### Economic Buyers (Finance, Procurement)
**What They Care About:**
- Total cost of ownership
- Pricing and terms
- Contract flexibility
- Budget timing
- Vendor risk

**Messaging Approach:**
- Lead with value and ROI
- Be transparent about pricing
- Address procurement concerns
- Highlight financial flexibility
- Provide case study ROI data

## Message Structure by Scenario

### Scenario 1: Initial Introduction (Never Met)
Someone your contact suggested you reach out to.

```
Subject: [Contact Name] suggested we connect

Hi [Name],

[Contact Name] mentioned you'd be a good person to include
in our conversation about [initiative].

We've been discussing [brief summary] with [their team/department],
and given your role in [their area], I thought you might find
[specific aspect] relevant.

[1-2 sentences on business impact specific to their role]

Would you be open to a brief conversation, or would you prefer
I keep you updated via email as things progress?

Best,
[Your name]
```

### Scenario 2: Post-Call Briefing (Wasn't on the Call)
Someone who should know about a conversation they weren't part of.

```
Subject: Update: [Company] and [Your Company] Discussion

Hi [Name],

I wanted to share a quick update from my conversation with
[their colleague] earlier this [day/week].

Key discussion points:
- [Point relevant to their role]
- [Another relevant point]
- [Outcome or next step]

Given your focus on [their area], I thought [specific aspect]
might be particularly relevant to you.

Happy to give you a brief overview if helpful-or simply keep
you in the loop as we progress. What works best?

Best,
[Your name]
```

### Scenario 3: Champion Enablement
Helping your champion sell internally.

```
Subject: Materials for your internal discussion

Hi [Name],

As promised, here are some resources for your conversation with
[other stakeholders]:

For [Stakeholder 1 - role]:
- [Relevant resource/talking point]

For [Stakeholder 2 - role]:
- [Relevant resource/talking point]

I've also attached [executive summary/one-pager] that you can
share or forward as needed.

Let me know if there's anything else I can prepare to help the
conversation go smoothly.

Best,
[Your name]
```

### Scenario 4: Executive Air Cover
Reaching up to get executive support.

```
Subject: [Specific business outcome] at [Company]

Hi [Name],

[Their company] has been evaluating [your solution category]
to address [business challenge]. Your team has identified
[specific opportunity or risk].

Based on similar situations with [comparable company], we've
seen [quantified result] through [your approach].

I've been working with [their direct report] on the details-
happy to provide an executive briefing if helpful as this
moves toward a decision.

Would a brief call be worthwhile?

Best,
[Your name]
```

## Messaging Guidelines

### Consistency Across Stakeholders
- Core value proposition stays the same
- Key facts and claims are consistent
- Pricing/timeline aligned
- No conflicting information

### Role-Specific Customization
- Lead with what matters to them
- Use appropriate level of detail
- Match formality to their role
- Reference relevant benefits

### Coordination Rules
- Don't contradict what you told others
- Reference connections appropriately
- Time outreach thoughtfully
- Share relevant intel with your champion

### What to Avoid
- Exact same message to multiple people (they'll compare)
- Going over your contact's head without warning
- Inconsistent information across stakeholders
- Pushy or aggressive outreach to executives

## Email Length Guidelines

| Stakeholder Type | Target Length |
|------------------|---------------|
| Executives | 75-125 words |
| Operational Leaders | 150-250 words |
| Technical Buyers | 150-300 words |
| End Users | 100-175 words |
| Economic Buyers | 125-200 words |

## Output Format

When creating multithread messages, produce:

### For Each Stakeholder:
1. **Name & Role**: Who this is for
2. **Priority Level**: How important to engage them
3. **Message Type**: Which scenario applies
4. **Subject Line**: Specific, relevant subject
5. **Full Message**: Complete email in appropriate tone/length
6. **Timing Suggestion**: When to send relative to other outreach
7. **Coordination Notes**: What to tell your champion

### Overall Strategy:
- **Outreach Sequence**: Order of who to contact
- **Message Themes**: How messaging varies by role
- **Risk Notes**: Potential concerns with the approach

## Cross-References

- Use `prospect-research` for stakeholder intelligence
- Apply `company-intelligence` for organization context
- Reference `call-analysis` for conversation-specific follow-ups
- Inform `powerful-framework` with new stakeholder insights
- Coordinate with `follow-up-emails` for primary contact
