---
name: n8n-integrator
description: Design and integrate n8n workflows with the Studio-535 ecosystem. Focuses on automation best practices, error handling, and secure API communication. Use when working with workflow JSON files or planning automations.
allowed-tools: Read, Grep, Glob
---

# n8n Workflow Integrator

## Standards

### Workflow Design
- ✅ Use descriptive names for nodes
- ✅ Implement error handling branches (Error Trigger or Error Output)
- ✅ Use "Wait" nodes appropriately to avoid rate limits
- ✅ Modularize complex workflows into sub-workflows

### Security
- ✅ Use Credentials for sensitive data (API keys, passwords)
- ✅ Never hardcode secrets in node parameters
- ✅ Use HTTPS for all webhook and API calls

### Integration
- ✅ Connect to Studio-535 backend via tRPC or dedicated API endpoints
- ✅ Use the LiteLLM gateway for AI-powered nodes
- ✅ Synchronize data with HubSpot using established patterns

## Review Checklist

1. **Error Handling:** What happens if a node fails?
2. **Secrets:** Are any API keys visible in the JSON?
3. **Efficiency:** Can the workflow be simplified or optimized?
4. **Naming:** Are nodes clearly labeled according to their function?

## Auto-Invocation Triggers

This Skill should activate when:
- Reviewing `.json` files that look like n8n workflows
- User asks to "design a workflow" or "fix n8n automation"
- Working on `Nexus-Prime/studio_535_master_workflow.json`
