---
name: nate-jones-deliberate-practice
description: Nate B. Jones's Practice Gym for knowledge workers. Evaluate decision docs, specs, and exec updates against rubrics with quoted evidence. Build team-calibrated rubrics. Convert messy situations into 15-30 min practice drills. See stronger versions with explicit gap analysis. Find systematic weakness patterns. Create artifact-based interview exercises. Triggers on "evaluate my doc", "score this", "build a rubric", "practice drill", "what did I miss", "weakness pattern", "interview exercise", "calibrate rubric".
---

# Knowledge Worker Practice Gym

AI-powered deliberate practice for knowledge work. Each prompt is interactive - paste it, answer the opening question, and the model guides you through.

## Workflow Selection

**Not sure where to start?**
- Router (auto-selects the right workflow) -> `references/00-router.md`

**Revenue Architect (FirstMile)?**
- 4 calibrated rubrics + 38 Questions integration -> `references/10-revenue-architect-practice-gym.md`
- LinkedIn thought leadership content -> `references/11-linkedin-content-rubric.md`

**Evaluating an artifact?**
- Decision docs, one-pagers -> `references/01-decision-doc-evaluator.md`
- PRDs, specs, process docs -> `references/02-spec-evaluator.md`
- Exec emails, status updates -> `references/03-executive-update-evaluator.md`

**Building standards?**
- Define "what good looks like" -> `references/04-rubric-builder.md`
- Calibrate with real examples -> `references/05-example-annotator.md`

**Practicing or hiring?**
- Convert messy situation to drill -> `references/06-messy-to-drill.md`
- See what you missed -> `references/07-stronger-version.md`
- Find patterns across docs -> `references/08-weakness-analyzer.md`
- Create interview exercise -> `references/09-interview-exercise.md`

## Usage Patterns

**Individual**: Rubric Builder -> weekly Messy-to-Drill -> Evaluator -> Stronger Version -> monthly Weakness Analyzer

**Team**: Rubric Builder (group session) -> Example Annotator (calibrate) -> wire Evaluators to review process -> track scores quarterly

**Hiring**: Interview Exercise Generator -> use same rubric as internal practice

## The Chain

```
skill -> recurring behavior -> recognizable pattern in artifacts -> rubric -> drills
```
