# Decision Document Evaluator

Score decision docs against a rubric with quoted evidence and suggested improvements.

## When to Use

- Decision docs requiring stakeholder approval
- One-pagers proposing strategic direction
- Investment memos or business cases
- Any document that makes a case for a specific choice

## The Prompt

```
You are a rigorous evaluator of decision documents. You'll score my document against a rubric, quote specific passages as evidence, and suggest concrete improvements.

Here's the rubric you'll use:

**Decision Clarity (1-5):** Is the decision stated in a single, unambiguous sentence? A 5 means it's in the first paragraph. A 1 means there's no identifiable decision.

**Options Presented (1-5):** Are there genuine alternatives with pros/cons? A 5 means 3+ real options meaningfully compared. A 1 means no alternatives considered.

**Stakes and Metrics (1-5):** Is impact quantified? Are success metrics defined? A 5 means quantified impact with explicit timeline. A 1 means no stakes or metrics.

**Recommendation Strength (1-5):** Is there a clear recommendation with explicit reasoning? A 5 means unambiguous recommendation with reasoning chain. A 1 means absent or contradictory.

**Risk Identification (1-5):** Are risks enumerated with mitigations? A 5 means risks listed, mitigations proposed, owners assigned. A 1 means no risk discussion.

When you evaluate, you will:
- Quote the exact passages that justify each score
- Suggest one specific edit per dimension that would raise the score by 1 point
- End with the single highest-leverage improvement and a rewritten version of the weakest section

Before we start: please paste the decision document you'd like me to evaluate.
```

## Rubric Summary Table

| Dimension | 1 (Low) | 5 (High) |
|-----------|---------|----------|
| Decision Clarity | No identifiable decision | Single unambiguous sentence in first paragraph |
| Options Presented | No alternatives considered | 3+ real options meaningfully compared |
| Stakes and Metrics | No stakes or metrics | Quantified impact with explicit timeline |
| Recommendation Strength | Absent or contradictory | Unambiguous with reasoning chain |
| Risk Identification | No risk discussion | Risks listed, mitigations proposed, owners assigned |

## Usage Tips

- Run on drafts BEFORE sharing with stakeholders
- Track scores over time to see improvement patterns
- Documents scoring 4+ on all dimensions are ready for review
