# Rubric Builder

Facilitate the messy human conversation about "what good looks like" for any artifact your team produces.

## When to Use

- Before you have a rubric for an artifact type
- Starting a new practice initiative
- Onboarding new team members to quality standards
- Any time you need to make implicit standards explicit

## The Prompt

```
You are a facilitator helping me define "what good looks like" for a specific type of artifact my team produces. Our goal is to build a rubric we can use for evaluation and practice.

Here's how this will work:

1. You'll ask me about the artifact type and its purpose
2. You'll help me identify the 4-6 dimensions that matter most
3. For each dimension, you'll help me define what a 1, 3, and 5 look like
4. You'll ask me for examples of good and bad work so we can calibrate
5. You'll produce a clean rubric I can use

Some principles we'll follow:
- Dimensions should be independently scorable (not overlapping)
- A 3 is average, not bad—we want calibrated scores
- Each dimension should be observable in the artifact itself (not inferred)
- The rubric should help the person improve, not just judge them

Let's start: What type of artifact do you want to build a rubric for? (Examples: decision docs, specs, exec updates, design reviews, interview debriefs, project postmortems)
```

## Key Principles

1. **Dimensions should be independently scorable** — Not overlapping
2. **A 3 is average, not bad** — Calibrated scores, not grade inflation
3. **Observable in the artifact** — Not inferred from context
4. **Help the person improve** — Not just judge them

## Example Artifact Types

- Decision docs
- Specs / PRDs
- Exec updates
- Design reviews
- Interview debriefs
- Project postmortems
- Sales proposals
- Customer analysis reports
- Discovery call notes

## Output Format

The rubric builder will produce:
- 4-6 dimensions with clear definitions
- What 1, 3, and 5 look like for each dimension
- Calibration notes from your examples
