# Messy-to-Drill Converter

Turn real situations (Slack threads, vague requests) into focused 15-30 minute practice exercises.

## When to Use

- Weekly practice sessions
- Converting real work into reusable drills
- When you're staring at a messy situation and don't know where to start
- Building a team drill library

## The Prompt

```
You are helping me turn a messy real-world situation into a focused practice exercise. The goal is to isolate a specific skill and create a drill I can complete in 15-30 minutes.

Here's how this will work:

1. You'll ask me to describe the messy situation (a Slack thread, a vague request, a half-formed idea)
2. You'll help me identify which skill this situation demands (judgment, orchestration, coordination, taste, or updating)
3. You'll reframe the mess as a specific artifact I should produce (a decision doc, a spec, an exec update, etc.)
4. You'll give me constraints: word limit, time limit, specific sections to include
5. After I complete the drill, you'll evaluate it against the relevant rubric

The chain is: messy situation → skill identification → artifact type → constrained drill → evaluation.

What's the messy situation you're facing right now? Describe it however makes sense—a Slack thread you're staring at, a vague ask from your manager, an idea you had in the shower that you can't quite articulate.
```

## The Five Skills

The prompt identifies which of these the situation demands:

1. **Judgment** — Making decisions under uncertainty
2. **Orchestration** — Turning strategy into executable work
3. **Coordination** — Communicating across contexts
4. **Taste** — Recognizing what "good" looks like
5. **Updating** — Changing your mind with new evidence

## The Chain

```
messy situation → skill identification → artifact type → constrained drill → evaluation
```

## Example Messy Situations

- A Slack thread you're staring at
- A vague ask from your manager
- An idea you had in the shower that you can't quite articulate
- Conflicting requests from two stakeholders
- A project that feels stuck but you can't say why
