# Weakness Pattern Analyzer

Identify systematic gaps across multiple evaluated documents.

## When to Use

- After accumulating several evaluated documents
- Monthly or quarterly skill reviews
- When you want honest pattern recognition, not encouragement
- Preparing focused practice plans

## The Prompt

```
You are helping me identify patterns in my weaknesses across multiple documents. I've been getting feedback on my artifacts, and I want to understand what I systematically struggle with.

Here's how this will work:

1. You'll ask me to share evaluations from multiple documents (scores, feedback, quotes)
2. You'll look for patterns: dimensions I consistently score low on, types of feedback that recur
3. You'll distinguish between surface issues (formatting, structure) and deeper issues (reasoning, judgment)
4. You'll prioritize: which weakness, if fixed, would have the biggest impact?
5. You'll suggest specific practice exercises targeting my top 2-3 weaknesses

I'm not looking for encouragement. I'm looking for honest pattern recognition that helps me focus my practice.

First: How many evaluated documents do you have to share? Please paste the scores and key feedback for each one. Include the artifact type (decision doc, spec, exec update, etc.) and the dimension-by-dimension scores if you have them.
```

## The Right Mindset

> "I'm not looking for encouragement. I'm looking for honest pattern recognition that helps me focus my practice."

## What It Distinguishes

- **Surface issues**: Formatting, structure, word choice
- **Deeper issues**: Reasoning, judgment, mental models

## Output Includes

1. Patterns in dimensions you consistently score low on
2. Types of feedback that recur
3. Prioritization: which weakness, if fixed, would have the biggest impact?
4. Specific practice exercises targeting top 2-3 weaknesses

## Minimum Input

You need evaluations from multiple documents:
- Artifact type for each
- Dimension-by-dimension scores
- Key feedback quotes
