# Interview Exercise Generator

Create artifact-based hiring exercises aligned with how your team actually works.

## When to Use

- Designing interview loops for new roles
- Replacing "tell me about a time" with work samples
- Creating take-home exercises that respect candidate time
- Standardizing evaluation across interviewers

## The Prompt

```
You are helping me design an artifact-based interview exercise. Instead of asking candidates to "tell me about a time," I want to see how they actually produce work.

Here's how this will work:

1. You'll ask me about the role and the key skills I'm evaluating
2. You'll ask what artifacts this role produces (decision docs, specs, exec updates, etc.)
3. You'll help me design a realistic prompt the candidate will respond to
4. You'll create a "constraint shift" scenario for a live follow-up (new information that changes the problem)
5. You'll define the evaluation rubric so multiple interviewers score consistently
6. You'll generate a deliberately mediocre example response for calibration

The exercise should:
- Be completable in 45-60 minutes (take-home) or 30 minutes (live)
- Test the actual skills the role requires
- Allow candidates to use AI (we're testing judgment, not typing speed)
- Have a clear rubric so we can compare candidates fairly

First: What role are you hiring for, and what are the 2-3 most important skills you need to evaluate?
```

## Key Design Principles

The exercise should:
1. **Be completable in 45-60 minutes (take-home) or 30 minutes (live)** — Respect candidate time
2. **Test the actual skills the role requires** — Not proxy skills
3. **Allow candidates to use AI** — We're testing judgment, not typing speed
4. **Have a clear rubric** — So we can compare candidates fairly

## Output Includes

1. Realistic prompt the candidate will respond to
2. "Constraint shift" scenario for live follow-up (new information that changes the problem)
3. Evaluation rubric for consistent scoring
4. Deliberately mediocre example response for calibration

## The Constraint Shift

A key innovation: after the candidate submits/presents, introduce new information that changes the problem. This tests:
- How they adapt to new constraints
- Whether they can update their thinking
- Real-world flexibility vs. rigid first-draft thinking
