# Revenue Architect Practice Gym

Custom rubrics and workflows for FirstMile Revenue Architect role. Built on Nate B. Jones's deliberate practice framework, calibrated against actual work artifacts.

## Four Calibrated Rubrics

### Rubric 1: Customer Shipping Analysis Report

**Purpose:** Data-driven report showing prospect's shipping profile + savings opportunity  
**Audience:** Prospect decision-maker (CEO, VP Ops, Logistics Manager)

| Dimension | 1 (Weak) | 3 (Solid) | 5 (Exceptional) |
|-----------|----------|-----------|-----------------|
| **Data Accuracy** | Numbers don't match source; calculation errors | Numbers correct; methodology sound | Flags data quality issues; shows confidence intervals |
| **Insight Clarity** | Just data tables, no interpretation | Clear takeaways after each section | Insights connect to prospect's stated business goals |
| **Savings Credibility** | Vague "up to 40%"; no methodology | Clear math; defensible assumptions | Multiple scenarios; acknowledges where we DON'T win |
| **Visual Communication** | Dense tables; hard to scan | Clean tables; logical flow | Executive-ready; key insights highlighted |
| **Geographic Intelligence** | Just lists states; no zone analysis | Shows top destinations; Select vs National split | Maps to FirstMile network strengths; quantifies routing advantages |
| **Actionable Next Steps** | No clear ask | Includes next step; clear CTA | Maps to specific solutions with timeline; pilot included |

**Calibration:** Stackd FINAL_PROPOSAL = 5, Caputron Profile = 3

---

### Rubric 2: Proposal Summary / Deal Matrix

**Purpose:** Frame deal opportunity, competitive position, path to close  
**Audience:** Prospect + Internal (Brock, Kevin)

| Dimension | 1 (Weak) | 3 (Solid) | 5 (Exceptional) |
|-----------|----------|-----------|-----------------|
| **Savings Credibility** | Unverified projections | Verified from actual data | Sensitivity analysis; confidence level stated |
| **Competitive Honesty** | Ignores weaknesses; oversells | Acknowledges where we don't win | "Why we might lose" section; proactive objection handling |
| **Value Prop Clarity** | Generic FirstMile pitch | Clear why we win THIS deal | Multiple value angles quantified |
| **Objection Anticipation** | No awareness of pushback | Basic objections identified | Pre-handles concerns in document |
| **Win Probability Calibration** | No assessment or wildly optimistic | Realistic 50-60% with reasoning | Tied to specific deal factors; "might win/might lose" |
| **Next Steps Definition** | Vague "we'll follow up" | Clear next step with timeline | Sequenced action plan with contingencies |

**Calibration:** Stackd FINAL_PROPOSAL exemplifies 5-level work

---

### Rubric 3: Discovery Call Notes (CVM 38 Questions)

**Purpose:** Capture intelligence to inform rate creation and deal strategy  
**Source Framework:** FirstMile CVM White Glove 38 Questions

| Dimension | 1 (Weak) | 3 (Solid) | 5 (Exceptional) |
|-----------|----------|-----------|-----------------|
| **Section 1: Volume Reality (Q1-9)** | Vague "they ship a lot" | 5+ questions answered; 20% variance | All 9 answered; 10% variance; exclusions documented |
| **Section 2: Carrier Setup (Q10-16)** | Don't know current carriers | Primary carrier + 2-3 pain points | Full competitive landscape; contract penalties |
| **Section 3: Service Requirements (Q17-24)** | No SLA requirements | Top destinations; basic transit expectations | Peak performance data; special handling documented |
| **Section 4: Operational Fit (Q25-32)** | No tech stack info | WMS known; basic integration path | Full tech stack; cutoffs, locations, team structure |
| **Section 5: Decision & Commitment (Q33-38)** | Don't know who decides | Decision-maker + timeline captured | Full buying committee; commitment locked; barriers identified |
| **Red Flags Documented** | No awareness of risks | 1-2 red flags noted | All red flags with mitigation strategies |

**Red Flags to Watch:**
- Vague answers on volume control
- "Let's start small and see" without defined ramp
- Multiple decision-makers with unclear authority
- IT/integration team not involved
- No clear pain point driving the change

---

### Rubric 4: Brand Scout Report

**Purpose:** Competitive intelligence and lead qualification before outreach  
**Audience:** Internal (yourself)

| Dimension | 1 (Weak) | 3 (Solid) | 5 (Exceptional) |
|-----------|----------|-----------|-----------------|
| **Company Intelligence** | Just name and website | Industry, size, location documented | Revenue estimate; growth trajectory; recent news |
| **Contact Mapping** | No contacts or generic info@ | Key contact with title | Full buying committee; email patterns tested |
| **Shipping Intelligence** | "They probably ship stuff" | Current carriers; basic volume estimate | Contract timing; volume by service level; pain points |
| **FirstMile Fit Assessment** | No fit analysis | Basic opportunity score | Quantified opportunity; honest "why we might not win" |
| **Personalization Notes** | Generic outreach planned | 2-3 hooks identified | Deep personalization from LinkedIn, news, culture |
| **Source Documentation** | No sources cited | Sources listed | Every claim linked; confidence levels noted |

**Calibration:** Cowtown_Logistics_brand_scout = 5

---

## Practice Workflows

### Weekly Rhythm (Pick One)

**Option A: Messy-to-Drill**
1. Take a messy situation (stalled deal, confusing prospect)
2. Ask: "Convert this to a 20-minute practice drill"
3. Complete the drill
4. Score against relevant rubric
5. Request stronger version

**Option B: Artifact Evaluation**
1. Take a real artifact you produced
2. Score yourself against rubric
3. Ask Claude to evaluate with quoted evidence
4. Compare scores
5. Focus next week on lowest dimension

**Option C: Discovery Call Debrief**
1. After every call, capture answers to 38 Questions
2. Score against Discovery rubric
3. Identify missed sections
4. Plan questions for follow-up

### Monthly Rhythm

**Weakness Pattern Analysis**
1. Collect 4+ evaluated artifacts
2. Ask: "Analyze weakness patterns across these evaluations"
3. Identify 1-2 dimensions to focus
4. Create targeted drills

---

## Quick Commands

**Evaluate artifact:**
```
Evaluate this [artifact type] against my Revenue Architect Practice Gym rubric. Score each dimension 1-5 with quoted evidence. Be honest.

[paste artifact]
```

**Generate stronger version:**
```
Show me what a 5 looks like on [dimension] for this [artifact type]. Annotate what you changed and why.

[paste artifact]
```

**Convert mess to drill:**
```
Convert this messy situation into a 20-minute practice drill. Identify the skill being tested.

[describe situation]
```

**Discovery debrief:**
```
I just finished a discovery call with [COMPANY]. Help me capture answers to the 38 Questions. Here's what I remember:

[dump everything]

Score my capture and tell me what to ask on follow-up.
```

---

## 38 Questions Quick Reference

| Section | Key Questions | Must Capture |
|---------|---------------|--------------|
| **1. Volume Reality** | Q1 (total), Q2 (commitments), Q6 (realistic %), Q8 (seasonal) | REAL addressable volume |
| **2. Carrier Setup** | Q10 (mix), Q11 (cost), Q13 (pain), Q14 (contracts), Q15 (penalties) | Why they'd switch |
| **3. Service Req** | Q17 (states), Q18 (transit), Q19 (on-time), Q20 (peak) | SLA expectations |
| **4. Operational** | Q25 (locations), Q26 (cutoff), Q27 (WMS), Q28 (tech), Q29 (API) | Integration path |
| **5. Decision** | Q33 (makers), Q34 (timeline), Q37 (commitment), Q38 (barriers) | Lock the deal |

---

## Scoring from Actual Work

| Artifact | Type | Score | Key Gaps |
|----------|------|-------|----------|
| Stackd FINAL_PROPOSAL | Proposal | 4.7/5 | Use as teaching example |
| Caputron Profile | Analysis | 3.0/5 | Missing savings, next steps |
| Stackd Discovery | Discovery | 2.5/5 | Template good, capture sparse |

**Biggest Opportunity:** Discovery Call Notes → better capture cascades to better Analysis and Proposals
