# LinkedIn Thought Leadership Content Rubric

Calibrated rubric for evaluating LinkedIn posts + visuals in the December Pipeline Priming campaign and beyond.

## When to Use

- After creating a LinkedIn post draft
- Before publishing to catch weak dimensions
- When iterating on underperforming content
- Training on what "good" looks like for FirstMile thought leadership

## The 6 Dimensions

### 1. Hook Strength
How effectively does the opening stop the scroll and create curiosity?

| Score | Definition | Observable Evidence |
|-------|------------|---------------------|
| **1** | Generic statement, no tension | "Shipping is important for ecommerce brands" |
| **2** | Mild interest, but skippable | "Here's something to think about with shipping" |
| **3** | Decent question, creates mild curiosity | "Ever wonder why your shipping costs keep rising?" |
| **4** | Strong provocation, most will pause | "Your carrier should ask you this before quoting rates:" |
| **5** | Specific provocation that stops scroll, creates "I need to know" urgency | "The question that predicts whether a carrier switch will succeed or fail:" |

**Key principle**: Hooks work through specificity + tension, not cleverness.

---

### 2. Insight Density
Does the post deliver genuine value or just repackage obvious information?

| Score | Definition | Observable Evidence |
|-------|------------|---------------------|
| **1** | Obvious/common knowledge only | "Shipping costs affect your margins" |
| **2** | One semi-useful observation | "Different carriers have different strengths" |
| **3** | One useful insight with some specificity | "FBA volume isn't addressable for carrier negotiations" |
| **4** | Multiple insights that build on each other | FBA + 3PL + Marketplace breakdown with specific examples |
| **5** | Layered insights creating "aha" moment, reframes how reader thinks | 500K→200K addressable volume example that changes their mental model |

**Key principle**: Insight = "I didn't know that" or "I never thought of it that way"

---

### 3. Visual Clarity
How quickly can someone understand the image without reading the post?

| Score | Definition | Observable Evidence |
|-------|------------|---------------------|
| **1** | Confusing, too much text, unclear flow | Cluttered infographic with competing elements |
| **2** | Readable but requires study | Multiple paths through the visual |
| **3** | Clear message, standard infographic quality | Single flow, readable labels |
| **4** | Instantly scannable, reinforces post message | Left-to-right progression, visual hierarchy |
| **5** | Image tells the complete story alone, could stand without post text | Before→After transformation visible in 2 seconds |

**Key principle**: If they only see the image (mobile scroll), do they get the point?

---

### 4. Brand Alignment
Does this look and feel unmistakably FirstMile?

| Score | Definition | Observable Evidence |
|-------|------------|---------------------|
| **1** | Off-brand colors, unprofessional tone | Random colors, casual/meme style |
| **2** | Generic professional but not FirstMile | Stock photo feel, no brand elements |
| **3** | Correct colors (#366092), generic corporate feel | Blue is there but feels templated |
| **4** | FirstMile colors + professional data-driven tone | Matches brand guidelines, clean execution |
| **5** | Unmistakably FirstMile, elevates brand perception | Premium feel, consistent with best FirstMile materials |

**Key principle**: Would this fit on firstmile.com without modification?

**FirstMile Brand Elements**:
- Primary: #366092 (navy blue)
- Style: Professional, data-driven, clean
- Tone: Expert but approachable, not salesy
- Never: Emojis in visuals, carrier names, cluttered layouts

---

### 5. CTA Quality
Does the closing invite meaningful engagement?

| Score | Definition | Observable Evidence |
|-------|------------|---------------------|
| **1** | No engagement hook | Post just ends |
| **2** | Generic ask | "Thoughts?" or "Agree?" |
| **3** | Decent question related to topic | "What's your experience with this?" |
| **4** | Specific question that invites response | "What percentage of your volume do you actually control?" |
| **5** | Question that promises value for engaging + low friction to answer | "Drop your top 5 destination states - I'll tell you which zones are costing you" |

**Key principle**: Best CTAs offer something in exchange for engagement.

---

### 6. 38 Questions Integration
Does this surface discovery questions that lead to sales conversations?

| Score | Definition | Observable Evidence |
|-------|------------|---------------------|
| **1** | No framework connection | Generic shipping content |
| **2** | Tangentially related to discovery topics | Mentions shipping but not discovery-worthy |
| **3** | Mentions a pain point from 38 Questions | References volume or contracts vaguely |
| **4** | Directly asks or implies a discovery question | "What volume do you actually control?" = Q1, Q3, Q4 |
| **5** | Multiple 38Q connections + natural path to conversation | Volume control + contract timing + implementation barriers |

**Key principle**: Every post should make them think "I should figure this out" → which leads to discovery call.

**38 Questions Reference**:
- Q1-Q6: Volume & Channel Mix
- Q11-Q13: Cost & Benchmarking
- Q14-Q16: Contract & Commitment
- Q17-Q18: Geography & Zones
- Q19-Q21: Performance & SLAs
- Q36-Q38: Implementation & Barriers

---

## Scoring Template

```markdown
## Post Evaluation: [POST TITLE]

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | /5 | "[quote from post]" |
| Insight Density | /5 | [specific insights identified] |
| Visual Clarity | /5 | [description of visual flow] |
| Brand Alignment | /5 | [brand elements present/missing] |
| CTA Quality | /5 | "[quote CTA]" |
| 38Q Integration | /5 | Maps to Q[X], Q[Y] |

**Total: /30**

### Lowest Dimension: [NAME]
**Current**: [what it does now]
**Stronger Version**: [improved version]
```

---

## Iteration Workflow

```
1. Draft post + image prompt
2. Generate image
3. Score all 6 dimensions with quoted evidence
4. Identify lowest 1-2 dimensions
5. Request "stronger version" of weak elements
6. Regenerate/revise
7. Re-score to confirm improvement
8. Publish when 25+ total score
```

**Publishing Thresholds**:
- **25-30**: Publish confidently
- **20-24**: Improve lowest dimension before publishing
- **Below 20**: Significant revision needed

---

## Example Calibration: Post #1 (Volume Reality)

**Post**: "Your carrier should ask you this before quoting rates: What volume do you actually control?"

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | **5** | "Your carrier should ask you this before quoting rates" - specific, creates curiosity gap |
| Insight Density | **5** | FBA/3PL/Marketplace breakdown + 500K→200K concrete example |
| Visual Clarity | **5** | Left→right flow, clear labels, bottom CTA bar, 2-second comprehension |
| Brand Alignment | **5** | #366092 blue, professional corporate style, clean execution |
| CTA Quality | **4** | "What percentage do you actually control?" - good but could offer value for engaging |
| 38Q Integration | **5** | Directly maps to Q1 (total volume), Q3 (channels), Q4 (addressable), Q6 (control) |

**Total: 29/30**

**Improvement opportunity (CTA)**:
- Current: "What percentage of your shipping volume do you actually control?"
- Stronger: "Quick math: What % of your volume is truly addressable? Drop your number - I'll share what I'm seeing across similar brands."

---

## Integration with December Pipeline Priming

This rubric supports the 6-post LinkedIn series:

| Post | Date | Topic | Primary 38Q |
|------|------|-------|-------------|
| 1 | Dec 16 | Volume Reality | Q1, Q3, Q4, Q6 |
| 2 | Dec 19 | Contract Question | Q14, Q15 |
| 3 | Dec 23 | Peak Performance | Q19, Q20, Q21 |
| 4 | Dec 30 | Implementation Barriers | Q37, Q38 |
| 5 | Jan 6 | Zone Distribution | Q17 |
| 6 | Jan 21 | GRI Reaction | Q11, Q36 |

Each post should score 25+ before publishing.

---

## Performance Correlation (Calibrated Dec 2025)

**Data Source**: LinkedIn PostAnalytics exports from Posts 1-2

### Rubric Score → Expected Performance

| Rubric Score | Expected Impressions | Expected Reactions | Expected Executive Reach |
|--------------|---------------------|-------------------|-------------------------|
| 28-30 | 650-750 | 9-12 | 18-25% |
| 25-27 | 550-650 | 7-9 | 12-18% |
| 22-24 | 450-550 | 5-7 | 8-12% |
| <22 | <450 | <5 | <8% |

**Critical Finding**: 6-point rubric drop = 22% impression drop, 50% executive reach drop

### Dimension Impact on Performance

| Dimension | Impact if Weak | Evidence |
|-----------|---------------|----------|
| Hook Strength | -25% impressions | Number-led vs question-led hooks |
| CTA Quality | 0 comments | Closed questions don't drive engagement |
| Visual Clarity | -15% engagement | Metaphors underperform concrete transformations |
| 38Q Integration | Lower executive reach | Weak framework = less thought leadership signal |

### Patterns That Work

**Hooks**:
- "Your [X] should..." format = HIGH performance
- Direct question = HIGH performance
- Number-led = MEDIUM performance

**CTAs**:
- Value exchange ("Drop X, I'll tell you Y") = UNTESTED but recommended
- Open question = MEDIUM (no comments generated yet)
- Closed question = LOW (zero comments)

**Visuals**:
- Before→After transformation = HIGH
- Report card/scorecard = TESTING (Post 3)
- Metaphor (iceberg) = MEDIUM

### Pre-Publish Requirements (MANDATORY)

Before ANY LinkedIn post:

1. Score all 6 dimensions with quoted evidence
2. Verify total is 25+ (if 22-24, improve weakest dimension first)
3. Verify hook uses "Your [X] should..." or question format
4. Verify CTA offers value exchange
5. Verify visual passes 2-second comprehension test
6. Reference: `december-pipeline-priming/references/performance-analytics.md`

**DO NOT publish posts scoring <25 without revision.**
