---
name: new-yorker-style
description: Write prose in The New Yorker's distinctive literary style. Applies the magazine's house conventions (diaeresis, British spellings, serial comma), elegant sentence construction, and commitment to clarity. Use when writing essays, articles, profiles, long-form journalism, or any sophisticated prose. Triggers on requests for "New Yorker style," literary writing, magazine-quality prose, or elegant nonfiction.
---

# The New Yorker Writing Style

Write with clarity, harmony, truth, and unfailing courtesy to the reader. This skill applies The New Yorker's distinctive voice: urbane yet accessible, witty without being precious, sophisticated but never obscure.

## Core Philosophy

Ved Mehta, staff writer from 1961–1994, distilled the style: **"Clarity, harmony, truth and unfailing courtesy to the reader."**

David Foster Wallace articulated what this means in practice:
> "In the broadest possible sense, writing well means to communicate clearly and interestingly and in a way that feels alive to the reader. Where there's some kind of relationship between the writer and the reader—even though it's mediated by a kind of text—there's an electricity about it."

The reader cannot read your mind. Every word must earn its place.

## Voice and Tone

### The New Yorker Sound
- **Urbane but not elitist**: Assume an intelligent, curious reader
- **Literary yet conversational**: Balance formality with warmth
- **Witty without straining**: Humor emerges from observation, not forced cleverness
- **Precise but not pedantic**: Choose the exact word, not the impressive one

### What to Avoid
- Sentimentality or sensationalism
- Jargon without explanation
- Clichés and vogue expressions
- Excessive qualification ("very," "really," "quite")
- The passive voice when active would serve

## Sentence Craft

### Rhythm and Variation
Follow a long, complex sentence with a short, punchy one:
> "By 2000, the investigation of the helicopter-conversion industry was winding down, with disappointing results for Wales and the U.S. Attorney's Office. **Only one case remained.**"

Begin paragraphs with short sentences when appropriate:
> "**Progress came slowly.** Anderson remained the only suspect; in 2004, the Seattle Times reported that the F.B.I. had searched Anderson's home."

### Sentence Openers
Start sentences with light openers—transitional words, subordinate clauses, or scene-setting phrases:
> "**Wales,** an Assistant United States Attorney in Seattle, had planned to have dinner with his girlfriend. **But** that afternoon Wales called and said he had projects to work on at home."

### Linking and Flow
Link the first sentence of a paragraph to the last sentence of the preceding one:
> "Neither Wales's romantic life nor the fender bender yielded **promising leads** in the murder investigation.
>
> Wales's work on gun control also failed to **produce suspects.**"

Convey chronology through transition phrases rather than bare dates:
- "Three months before his death..."
- "About fifteen minutes later..."
- "Two weeks after the murder..."
- "Meanwhile..."
- "Not long after the meeting..."

## Punctuation

The New Yorker follows "close punctuation"—commas fall with precision, as E.B. White observed, "like knives in a circus act, outlining the victim."

### The Serial Comma
Always use it:
> "She bought apples, oranges, and pears."

### Em Dashes
Set off explanatory phrases with em dashes for emphasis and clarity:
> "The proposal brought out the full might of the gun-control lobby, which spent four million dollars—**primarily on television advertisements and direct-mail appeals**—and voters rejected the measure."

Use dashes when commas would create ambiguity.

### Semicolons
Reserve for parallel constructions:
> "United States Attorneys establish the priorities for each of the nation's ninety-four judicial districts and announce significant indictments; Assistant U.S. Attorneys are more like civil servants; they perform the day-to-day work."

### Colons
Use to introduce an explanation that could stand as a complete sentence:
> "The phrase was partly a joke, a bit of feigned grandiosity to justify a tendency toward excessive meticulousness: **Wales did things slowly.**"

### Hyphens
Hyphenate phrasal adjectives for clarity:
- cell-phone towers
- gun-control initiative
- death-penalty case
- law-enforcement official
- forty-year-old pilot
- highest-ranking official

## House Style Conventions

### The Diaeresis
The New Yorker uses the diaeresis (not umlaut) over the second vowel in doubled-vowel pairs to indicate a new syllable:
- coöperate (not cooperate or co-operate)
- reëlect
- reëmerge
- reëxamine
- preëminent

Also retain accents in borrowed words:
- naïve
- élite
- résumé
- café

### British-Influenced Spellings
Double consonants where American usage would not:
- focussed (not focused)
- travelling (not traveling)
- marvellous (not marvelous)
- kidnapped
- worshipped

### Distinctive Spellings
- theatre (not theater)
- carrousel (not carousel)
- vender (not vendor)
- teen-ager (hyphenated)
- per cent (two words)
- good-by (hyphenated)

### Recent Updates (2025)
- inbox (formerly in-box)
- website (formerly Web site)
- internet (formerly Internet)
- cellphone (formerly cell phone)

## The Writing Process

### Draft with Deliberation
Wallace advocated writing by hand for early drafts: "Writing makes me slow down in a way that helps me pay attention." Whether handwritten or typed, the first draft should emerge slowly enough for genuine thought.

### Revision as Respect
> "One of the things that's good about writing and practicing writing is it's a great remedy for my natural self-involvement and self-centeredness... I never forget there's someone on the end of the line, that I owe that person certain allegiances."

Each revision asks: Does this serve the reader?

### Earning Interest
Wallace's humbling insight for every writer:
> "I am not, in and of myself, interesting to a reader. If I want to seem interesting, work has to be done in order to make myself interesting."

## Fact-Checking Ethic

In 1927, The New Yorker ran an article about Edna St. Vincent Millay with multiple errors, and her mother threatened to sue. The magazine developed the most rigorous fact-checking process in American journalism.

Apply this standard:
- Verify every name, date, title, and statistic
- Question every quotation—is this precisely what was said?
- Check obvious "facts" hardest; familiarity breeds false confidence
- When uncertain, investigate rather than assume

## Quick Reference

| Element | New Yorker Style |
|---------|------------------|
| Serial comma | Always |
| Theatre/theater | theatre |
| Focused/focussed | focussed |
| Traveled/travelled | travelled |
| Cooperate | coöperate |
| Naive | naïve |
| Elite | élite |
| Teenager | teen-ager |
| Percent | per cent |
| Website | website (as of 2025) |
| Internet | internet (as of 2025) |

## Further Reading

For detailed spelling lists and additional punctuation rules, see [references/style-details.md](references/style-details.md).
