# New Yorker Style Details

Detailed spelling, punctuation, and formatting rules for New Yorker house style.

## Table of Contents
1. [Diaeresis Words](#diaeresis-words)
2. [Accented Foreign Words](#accented-foreign-words)
3. [British-Style Spellings](#british-style-spellings)
4. [Distinctive Spellings](#distinctive-spellings)
5. [Hyphenation Rules](#hyphenation-rules)
6. [Numbers and Numerals](#numbers-and-numerals)
7. [Titles and Names](#titles-and-names)
8. [Punctuation Details](#punctuation-details)
9. [Common Errors to Avoid](#common-errors-to-avoid)

---

## Diaeresis Words

The diaeresis indicates that the second vowel begins a new syllable. Use it in:

### Common Words
- coöperate, coöperation, coöperative
- coördinate, coördination
- reëlect, reëlection
- reëmerge, reëmergence
- reëxamine, reëxamination
- reënact, reënactment
- reëntry
- reëducate
- preëmpt, preëmption, preëmptive
- preëminent, preëminence

### Less Common
- zoölogy, zoölogical
- semiënclosed

**Note**: The diaeresis is distinct from the umlaut, which changes vowel pronunciation in German. The New Yorker's diaeresis merely signals syllable division.

---

## Accented Foreign Words

Retain accents on words borrowed from other languages:

### French
- naïve, naïveté
- élite
- résumé
- café
- cliché
- protégé, protégée
- fiancé, fiancée
- exposé
- entrée
- tête-à-tête
- vis-à-vis

### German
- über (when used in English contexts)
- Führer (historical)

### Spanish
- piñata
- jalapeño
- señor, señora, señorita

---

## British-Style Spellings

The New Yorker favors doubled consonants in certain words:

### Always Double
- focussed, focussing (not focused, focusing)
- travelled, travelling, traveller (not traveled, etc.)
- marvelled, marvelling, marvellous
- cancelled, cancelling
- labelled, labelling
- channelled, channelling
- modelled, modelling
- quarrelled, quarrelling
- kidnapped, kidnapping, kidnapper
- worshipped, worshipping, worshipper

### Theatre Not Theater
- theatre (for the art form and venues)
- "the theatre" in phrases like "world of the theatre"
- theatrical (standard spelling)

---

## Distinctive Spellings

Words The New Yorker spells differently from standard American usage:

| Standard American | New Yorker |
|-------------------|------------|
| teenager | teen-ager |
| percent | per cent |
| carousel | carrousel |
| vendor | vender |
| goodbye | good-by |
| theater | theatre |
| OK | O.K. |
| goodbye | good-by |

### Technology Terms (2025 Update)
| Former Style | Current Style |
|--------------|---------------|
| Web site | website |
| in-box | inbox |
| e-mail | email |
| Internet | internet |
| cell phone | cellphone |
| on-line | online |

---

## Hyphenation Rules

### Phrasal Adjectives
Hyphenate compound modifiers before a noun:
- a well-known author
- a first-rate performance
- a five-year-old child
- a high-school student
- a long-term investment
- a real-estate agent
- a so-called expert

**Do not hyphenate after the noun**:
- The author is well known.
- The performance was first rate.

### Age Expressions
- a forty-year-old man
- He is forty years old. (no hyphens)
- a four-year-old (noun use)

### Compound Nouns
- teen-ager
- good-by
- per cent (two words, no hyphen)
- mind-set
- make-up (noun)
- set-up (noun)

### Prefixes
Generally close up prefixes:
- nonprofit
- nonfiction
- preschool
- postwar
- midtown
- semiannual

Exceptions requiring hyphens:
- self-conscious, self-esteem, self-made
- ex-husband, ex-president
- anti-intellectual
- pre-existing (before a vowel)
- co-author (when disambiguation needed)

---

## Numbers and Numerals

### Spell Out
- Numbers one through ninety-nine
- Round numbers: a hundred, a thousand, a million
- Ages: "He was forty-two years old"
- Centuries: "the nineteenth century"
- Decades: "the nineteen-sixties" or "the sixties"

### Use Numerals
- Specific large numbers: 142, 1,547
- Dates: January 15, 2025
- Addresses: 350 Fifth Avenue
- Percentages with "per cent": 15 per cent
- Times: 3:30 P.M.
- Page numbers, chapter numbers

### Money
- Spell out: "five dollars," "a hundred thousand dollars"
- Use figures for precision: $5.95, $147,000

---

## Titles and Names

### Books, Plays, Films
- Italicize: *The Great Gatsby*, *Hamlet*, *Casablanca*

### Articles, Short Stories, Poems
- Use quotation marks: "The Lottery," "The Road Not Taken"

### Magazines and Newspapers
- Italicize: *The New Yorker*, *The New York Times*
- Note: "The" is italicized when part of the official title

### Honorifics
- Spell out on first reference: Senator Elizabeth Warren
- Thereafter: Warren or Ms. Warren
- Dr. only for medical doctors, not Ph.D.s

---

## Punctuation Details

### Comma Usage (Close Punctuation)
The New Yorker uses more commas than most publications:

**Before "too" at end of sentence**:
- "I thought so, too."

**Around "however" mid-sentence**:
- "The theory, however, has been disputed."

**In direct address**:
- "Tell me, John, what you think."

**Before conjunctions in compound sentences**:
- "She read the book, and she wrote a review."

### Em Dashes
- No spaces around em dashes
- Use for parenthetical statements stronger than commas allow
- Use for dramatic effect or emphasis

### En Dashes
- For ranges: pages 15–30, 2020–2025
- For compound adjectives with proper nouns: New York–based

### Quotation Marks
- Periods and commas inside
- Colons and semicolons outside
- Question marks: inside if part of the quote, outside if not

### Ellipses
- Three dots with spaces: . . .
- Four dots at end of sentence: . . . . (period plus ellipsis)

---

## Common Errors to Avoid

### That vs. Which
- **That**: defining/restrictive clauses (no comma)
  - "The book that I read was fascinating."
- **Which**: non-defining/non-restrictive clauses (with comma)
  - "The book, which I finished yesterday, was fascinating."

### Who vs. Whom
- **Who**: subject (he/she)
  - "Who wrote this?"
- **Whom**: object (him/her)
  - "To whom should I address this?"

### Fewer vs. Less
- **Fewer**: countable items
  - "fewer than ten items"
- **Less**: uncountable quantities
  - "less water"

### Elegant Variation (Avoid)
Do not use synonyms merely to avoid repetition:
- BAD: "The fleet-footed second-sacker slugged a four-bagger."
- GOOD: Repeat the noun or use a pronoun.

H.W. Fowler called this "the fatal influence of a false theory that a word once used should not be used again in the neighborhood." The New Yorker agrees.

### Dangling Modifiers
Ensure the modifier attaches to the correct noun:
- WRONG: "Walking down the street, the building came into view."
- RIGHT: "Walking down the street, I saw the building come into view."

### Split Infinitives
The New Yorker permits them when clarity or rhythm demands:
- "to boldly go" is acceptable
- Avoid awkward splits: "to more than double" → "more than to double"

---

## The Spirit of the Style

Mary Norris, The New Yorker's "Comma Queen," offers the essential principle:

> "These rules are good to know. It's also good to know when to break them."

The goal is always clarity and service to the reader. When a rule interferes with comprehension or creates awkwardness, the rule yields.

As David Foster Wallace observed:
> "The average person you're writing for is an acute, sensitive, attentive, sophisticated reader who will appreciate adroitness, precision, economy, and clarity."

Write for that reader.
