---
name: newsletter
description: "Create best-in-class newsletters that people actually want to read. Use when someone needs to write a newsletter edition, develop a newsletter format, or improve their newsletter game. Covers multiple formats - roundup, deep-dive, personal essay, curated links, news briefing. References patterns from Lenny Rachitsky, Morning Brew, Greg Isenberg, Sahil Bloom, The Hustle, and top AI newsletters. Triggers on: write newsletter, newsletter format, help with my newsletter, newsletter edition about X, weekly roundup. Outputs publication-ready newsletter content or format templates."
---

# Newsletter Skill

Most newsletters are forgettable. Subscribers open them once, skim the first paragraph, delete.

The newsletters that build loyal audiences—and businesses—do something different. They have a format readers can rely on. A voice that's recognizable. Content worth opening.

This skill helps you create newsletters people actually look forward to.

---

## The core job

Transform your content, curation, or ideas into **publication-ready newsletters** that:
- Get opened (subject line + sender reputation)
- Get read (hook + scannability)
- Get remembered (voice + value)
- Get shared (insight worth passing on)

---

## First: What type of newsletter?

Different formats serve different purposes. Pick your archetype:

### 1. Deep-Dive / Framework (Lenny Rachitsky style)
**Best for:** Expertise, thought leadership, premium positioning
**Frequency:** Weekly
**Length:** 1,500-3,000 words
**Revenue:** Premium subscriptions ($15-30/month)

One topic explored thoroughly. Original frameworks. Actionable templates.

### 2. News Briefing (Morning Brew / Finimize style)
**Best for:** Daily habit formation, broad audience, ad revenue
**Frequency:** Daily or 3x/week
**Length:** 500-1,000 words
**Revenue:** Sponsorships, ads

Quick hits on what happened. Scannable. Gets you up to speed in 5 minutes.

### 3. Curated Links + Commentary (Ben's Bites style)
**Best for:** Niche expertise, building in public, creator economy
**Frequency:** Daily or weekly
**Length:** 500-1,500 words
**Revenue:** Affiliate, sponsorships, community

Hand-picked links with your take on why each matters.

### 4. Personal Essay / Reflection (Sahil Bloom style)
**Best for:** Personal brand, philosophy, coaching/courses
**Frequency:** Weekly
**Length:** 1,000-2,000 words
**Revenue:** Courses, coaching, premium tier

Themed reflections with frameworks for life/work improvement.

### 5. Startup/Builder Updates (Greg Isenberg style)
**Best for:** Founder audience, community building, deal flow
**Frequency:** Weekly
**Length:** 800-1,500 words
**Revenue:** Community, advisory, investments

Ideas, observations, and frameworks from the building trenches.

### 6. Irreverent News + Stories (The Hustle style)
**Best for:** Broad business audience, entertainment + education
**Frequency:** Daily
**Length:** 800-1,200 words
**Revenue:** Sponsorships, subscriptions

News told through narrative with personality and humor.

---

## Format Templates

### Template 1: Deep-Dive Framework Newsletter

```
SUBJECT LINE: [Specific question or problem] — [Hint at framework]

---

[PERSONAL OPENER - 2-3 sentences]
Brief personal context or why this topic is on your mind.

[THE QUESTION - Bold]
**[State the exact question you're answering]**

[CONTEXT - 1-2 paragraphs]
Why this matters. What's at stake. Who this is for.

---

## [FRAMEWORK NAME]

[Framework intro - 2-3 sentences explaining what it is]

### [Component 1]
[Explanation + example]

### [Component 2]
[Explanation + example]

### [Component 3]
[Explanation + example]

---

## How to Apply This

[Specific steps or implementation guidance]

1. [Step 1 with detail]
2. [Step 2 with detail]
3. [Step 3 with detail]

---

## Template / Checklist

[Downloadable or copy-paste resource]

---

## The Bottom Line

[2-3 sentence summary of key insight]

[SIGN-OFF]
[Your name]

P.S. [Personal note, question for readers, or CTA]
```

**Example from Lenny Rachitsky:**
> "How do you make good decisions in situations where you lack perfect information? This question came from three different readers this month, so let me share the frameworks I actually use..."

---

### Template 2: News Briefing Newsletter

```
SUBJECT LINE: [Day/Date]: [Hook about biggest story]

---

[LOGO/HEADER]

[ONE-LINE HOOK]
Today: [Teaser of what's inside]

---

## MARKETS
[Brief market data if relevant to your niche]
↑ [Metric 1] | ↓ [Metric 2] | → [Metric 3]

---

## TODAY'S TOP STORIES

### [STORY 1 HEADLINE - Intriguing, not straight news]

[2-3 sentence explanation of what happened]

**Why it matters:** [1-2 sentences on implications]

---

### [STORY 2 HEADLINE]

[2-3 sentence explanation]

**The bottom line:** [1 sentence takeaway]

---

### [STORY 3 HEADLINE]

[2-3 sentence explanation]

---

## QUICK HITS
• [One-liner news item 1]
• [One-liner news item 2]
• [One-liner news item 3]

---

## [SIGNATURE SECTION - Quiz, poll, or engagement hook]

[Question or interactive element]

---

[FOOTER with social links, referral program]
```

**Morning Brew voice markers:**
- Humor in unexpected places
- Pop culture references
- Relatable analogies ("It's like if Netflix and your credit card had a baby...")
- Bold the surprising part of each story

---

### Template 3: Curated Links + Commentary

```
SUBJECT LINE: [Number] things worth your time: [Hook topic]

---

Hey [First Name] 👋

[1-2 sentence personal opener - what you've been thinking about]

Here's what caught my attention this week:

---

## 🔥 The Big One

**[Link Title](URL)**

[2-3 sentences on why this matters and your take]

---

## 📚 Worth Reading

**[Link 1 Title](URL)**
[1-2 sentence commentary]

**[Link 2 Title](URL)**
[1-2 sentence commentary]

**[Link 3 Title](URL)**
[1-2 sentence commentary]

---

## 🛠️ Tools & Resources

**[Tool Name](URL)** — [What it does + your opinion]

**[Tool Name](URL)** — [What it does + your opinion]

---

## 💭 One Thing I'm Thinking About

[Personal reflection or question - 2-3 sentences]

---

That's it for this week. Hit reply if anything resonated.

[Your name]
```

**Ben's Bites voice markers:**
- Genuine enthusiasm (not performative)
- "I found this and thought you'd like it" energy
- Commentary adds value beyond the link
- Organized by type (reading, tools, news)

---

### Template 4: Personal Essay / Reflection

```
SUBJECT LINE: [Philosophical hook or contrarian take]

---

[OPENING HOOK - Story, observation, or provocative statement]
[2-4 sentences that create intrigue]

---

## [THE CORE IDEA]

[State your thesis clearly - 1-2 sentences]

[Expand on why you believe this - personal experience or observation]

---

## The Framework

[Present your mental model or framework]

**[Element 1]:** [Explanation]

**[Element 2]:** [Explanation]

**[Element 3]:** [Explanation]

---

## Questions to Ask Yourself

1. [Reflection question]
2. [Reflection question]
3. [Reflection question]

---

## The Takeaway

[1-2 sentence distillation of core insight]

[PERSONAL SIGN-OFF]
[Your name]

P.S. [Often includes a template download or resource]
```

**Sahil Bloom voice markers:**
- Opens with philosophical hook or life observation
- Frameworks have memorable names
- Includes reflection questions for reader
- Warm but substantive tone

---

### Template 5: Builder/Startup Update

```
SUBJECT LINE: [Contrarian observation or "here's what I'm seeing"]

---

Look...

[Personal observation or realization that hooks - 2-3 sentences]

---

## The Idea

[Present a concept, framework, or trend you're seeing]

Here's what's working:

**[Pattern 1]** — [Real example with company name]

**[Pattern 2]** — [Real example with company name]

**[Pattern 3]** — [Real example with company name]

---

## Why This Matters Now

[Context on why timing matters - market shifts, technology changes, etc.]

---

## How to Think About This

[Your framework or mental model for the opportunity]

---

## What I'm Doing About It

[Personal application - your projects, investments, experiments]

---

If you're building in this space, I want to hear about it. Reply to this email.

[Your name]

---

📍 [Event or community plug]
🎙️ [Podcast or content plug]
```

**Greg Isenberg voice markers:**
- "Look..." opener
- Peer-to-peer energy, not guru
- Real company examples, named
- Building in public transparency
- Community-focused CTAs

---

### Template 6: Irreverent News + Story

```
SUBJECT LINE: [Unexpected angle on news + emoji]

---

[HOOK HEADLINE - Surprising juxtaposition or question]

[Opening anecdote that humanizes the story - 3-4 sentences]

---

**What happened:** [Factual summary in 2-3 sentences]

**Why it's weird:** [The angle that makes this interesting]

**The bigger picture:** [Business implication]

---

## Also Worth Knowing

**[Story 2 Headline]**
[Brief summary with personality]

**[Story 3 Headline]**
[Brief summary with personality]

---

## The Number of the Day

**[Surprising statistic]**

[1-2 sentence context on why it matters]

---

## One More Thing

[Lighter item, meme-worthy moment, or unexpected angle]

---

See you tomorrow,
[Editor nickname] 🦊
```

**The Hustle voice markers:**
- Irreverent but not trying too hard
- Headlines that create curiosity
- "Why it's weird" — finds the surprising angle
- Editor nicknames/personalities
- Pop culture and meme fluency

---

## Voice & Tone Guide

### The Newsletter Voice Spectrum

```
FORMAL ←————————|————————→ CASUAL
             Newsletter sweet spot
                    ↓
         Professional but personable
         Smart friend, not professor
         Opinions with reasoning
         Direct, not corporate
```

### Voice Principles

**1. Write like you talk (but tighter)**
Read it out loud. If you wouldn't say it, don't write it.

**2. Have opinions**
"I think X because Y" beats "Some experts say X while others say Y."

**3. Be specific**
Not "recently" → "Last Tuesday"
Not "a lot" → "47%"
Not "a company" → "Notion"

**4. Show your work**
Not "this is important" → "I spent 3 hours on this because..."

**5. Admit uncertainty**
"I'm not sure but..." builds more trust than fake confidence.

### Words That Kill Newsletters

**Avoid:**
- "In today's edition..."
- "This week we'll explore..."
- "Without further ado..."
- "It goes without saying..."
- Corporate jargon (leverage, synergy, ecosystem)
- Excessive exclamation marks!!!

**Use instead:**
- Jump straight into content
- "Here's what I found..."
- "The short version:"
- Conversational transitions

---

## Subject Line Formulas

### What Works

**1. Specific + Curiosity**
> "The $47K email mistake (and how to avoid it)"

**2. Question they're asking themselves**
> "Should you raise prices in a recession?"

**3. Contrarian take**
> "Why I stopped using [popular tool]"

**4. Number + Specificity**
> "7 newsletter formats that actually work"

**5. Direct value proposition**
> "The framework I use for every product decision"

### What Doesn't Work

- Clickbait that doesn't deliver
- ALL CAPS
- [NEWSLETTER NAME] in subject
- Vague ("This week's update")
- Too clever (sacrifices clarity)

---

## Scannability Checklist

Before sending, verify:

```
[ ] Headers break content every 200-300 words
[ ] Bold text marks key insights (not everything)
[ ] Short paragraphs (1-3 sentences max)
[ ] Bullet points for lists of 3+
[ ] White space between sections
[ ] Mobile-friendly (preview on phone)
[ ] One clear CTA (not five)
[ ] Above-fold content hooks reader
```

### The 30% Rule

Highlighted/bold text should be <30% of total text. More than that, nothing stands out.

---

## Hook Patterns

### Pattern 1: The Direct Question
> "How do you make decisions when you don't have enough data?"

### Pattern 2: The Contrarian Statement
> "Most SEO advice is wrong. Here's what actually works."

### Pattern 3: The Personal Story
> "Last week I made a $40K mistake. Let me tell you about it."

### Pattern 4: The Surprising Stat
> "73% of newsletters get deleted unread. Here's why yours won't."

### Pattern 5: The Observation
> "I noticed something weird in my analytics..."

### Pattern 6: The Promise
> "By the end of this email, you'll know exactly how to..."

---

## Curation vs. Original Content

### When to Curate
- You're covering a fast-moving space (AI, news)
- Your value is taste/filtering (too much content exists)
- You're building daily habit (can't write 2000 words/day)

### When to Create Original
- You have unique expertise or access
- You're building premium/paid tier
- You want stronger differentiation

### The Hybrid (Best for Most)

```
70% Original insight/commentary
30% Curated links with your take

OR

1 Deep original piece
+ 3-5 curated links with commentary
```

**Never:** Link dump without commentary. That's RSS, not a newsletter.

---

## The Newsletter Creation Workflow

### Step 1: Gather
- What happened this week in your space?
- What did you learn/create/notice?
- What questions are readers asking?
- What links are worth sharing?

### Step 2: Select
- Pick 1 main topic (deep dive) OR 3-5 items (roundup)
- Ask: "Would I forward this to a friend?"
- Cut anything that's "fine but not great"

### Step 3: Structure
- Choose your template
- Outline before writing
- Front-load the best stuff

### Step 4: Write
- Hook first (spend 25% of time here)
- Get the draft down fast
- Add personality in editing

### Step 5: Polish
- Read out loud
- Cut 20% (newsletters are always too long)
- Check scannability
- Mobile preview

### Step 6: Send
- Best times: Tuesday-Thursday, 6-10am local
- Subject line A/B test if possible
- Personal preview to yourself first

---

## Best-in-Class Examples to Study

| Newsletter | Type | What to Learn |
|------------|------|---------------|
| **Lenny Rachitsky** | Deep-Dive | Framework presentation, credibility anchoring |
| **Morning Brew** | News Briefing | Voice, scannability, referral program |
| **Ben's Bites** | Curated + Commentary | Curation that adds value |
| **Sahil Bloom** | Personal Essay | Reflection frameworks, templates |
| **Greg Isenberg** | Builder Updates | Peer energy, real examples |
| **The Hustle** | Irreverent News | Personality, unexpected angles |
| **Finimize** | Financial Briefing | "Key takeaways" format |
| **The Rundown AI** | AI News | Business implications framing |
| **boringmarketer** | Marketing | Contrarian takes, systems thinking |

---

## How This Connects to Other Skills

**Input from:**
- **brand-voice** → Ensures newsletter voice matches overall brand
- **keyword-research** → Identifies topics your audience searches for
- **positioning-angles** → Provides contrarian angles for content

**Uses:**
- **direct-response-copy** → For CTAs and conversion elements
- **seo-content** → When repurposing newsletter into blog posts

**The flow:**
1. brand-voice defines how newsletter should sound
2. keyword-research or audience questions suggest topics
3. **newsletter creates the edition**
4. Content repurposed for SEO or social

---

## The Test

Before hitting send, ask:

1. **Would I open this?** (Subject line test)
2. **Would I read past the first paragraph?** (Hook test)
3. **Would I remember this tomorrow?** (Value test)
4. **Would I forward this to a colleague?** (Share test)
5. **Does this sound like me, not a committee?** (Voice test)

If any answer is no, revise before sending.
