# Newsletter Examples & Patterns

Detailed breakdowns of what makes top newsletters work. Study these, then adapt for your voice.

---

## Lenny Rachitsky — The Framework Newsletter

**Stats:** 1M+ subscribers, $15/month paid tier
**Frequency:** Weekly (free), 2x weekly (paid)
**Niche:** Product management, growth, startups

### What Makes It Work

**1. Credibility Anchoring**
Lenny doesn't claim to invent everything. He credits sources:
> "This framework came from my time at Airbnb, developed with [specific colleague]..."

This makes him more trustworthy, not less.

**2. The Q&A Format**
Many editions answer reader questions directly. Creates:
- Proof of engaged audience
- Content that addresses real problems
- Variety in topics

**3. Framework + Template**
Every framework includes implementation guidance:
> "Here's the RAT Decision Framework. And here's the exact template we used."

Readers can apply it immediately.

**4. Free vs Paid Architecture**
Free: Frameworks and insights
Paid: Deep dives, archives, podcast content

Taste → Want more → Pay

### Sample Structure

```
[Personal opener - 2 sentences]

Q: [Reader question in their words]

A: [Lenny's response - builds framework]

## The [Name] Framework

[Explanation]

### When to Use It
[Guidance]

### Template
[Downloadable resource]

## Other Frameworks to Consider
[Brief alternatives]

---

That's it for this week.

[Sign-off]
Lenny
```

### Voice Markers
- "I've seen this work at Airbnb, Notion, and Stripe..."
- "The honest answer is..."
- Credits others liberally
- Admits what he doesn't know

---

## Morning Brew — The Daily Briefing

**Stats:** 5M+ subscribers
**Frequency:** Daily
**Niche:** Business news for young professionals

### What Makes It Work

**1. The 22% Humor Rule**
~22% of jokes require business literacy (inside jokes for regulars)
~78% are universally relatable (accessible to new readers)

This balance builds community without alienating newcomers.

**2. Markets Section First**
Opens with what readers expect: market data. Delivers utility immediately.

**3. Intentional Bolding**
Only bold the most surprising or important detail in each story. If everything is bold, nothing is.

**4. Referral Program Design**
Rewards match audience preferences:
- Laptop stickers (work from home)
- Joggers (casual dress)
- Merchandise that signals belonging

Not generic Amazon gift cards.

### Sample Structure

```
[LOGO]

MARKETS
S&P: ↑2.1% | Nasdaq: ↑1.8% | BTC: ↓3.2%

---

BUSINESS

[Intriguing headline, not straight news]

[2-3 sentences on what happened]

**The bottom line:** [1 sentence takeaway]

---

[Second story - same format]

---

QUICK HITS
• [One-liner]
• [One-liner]
• [One-liner]

---

GAMES
[Trivia or interactive element]
```

### Voice Markers
- Pop culture references in unexpected places
- "It's like if [relatable thing] and [other thing] had a baby"
- Emoji use is restrained but purposeful
- Self-aware about being a business newsletter

**Sample Opening:**
> "Tesla's having a moment. And not the good kind of moment like when you nail parallel parking on the first try."

---

## Ben's Bites — The Curated Commentary

**Stats:** 140K+ subscribers
**Frequency:** Daily
**Niche:** AI news and tools

### What Makes It Work

**1. Curation That Adds Value**
Every link includes Ben's take on *why* it matters. Not just "check this out" but "check this out because..."

**2. Three Content Types**
- News summaries (time-sensitive)
- Hand-picked articles (evergreen)
- Tool showcases (practical)

Variety keeps it interesting.

**3. The AI Project Tracker**
Created a database of every link ever curated. Became a referral incentive AND a product.

**4. Enthusiasm Without Hype**
Genuinely excited about AI without the "EVERYTHING IS CHANGING" panic energy.

### Sample Structure

```
Hey friends 👋

[1-2 sentence personal opener]

---

## 🔥 Today's top story

[Headline + link]

[3-4 sentences on what it is and why it matters]

My take: [1-2 sentences of opinion]

---

## 🗞️ News

• [One-liner + link]
• [One-liner + link]
• [One-liner + link]

---

## 🛠️ Cool tools

[Tool name + link] — [What it does, my opinion]

---

See you tomorrow!
Ben
```

### Voice Markers
- "This is cool because..."
- "I'm skeptical about X but..."
- "Found this and immediately thought of you all"
- Friendly, not performative

---

## Sahil Bloom — The Reflection Newsletter

**Stats:** 700K+ subscribers
**Frequency:** Weekly
**Niche:** Personal development, life frameworks

### What Makes It Work

**1. Themed Editions**
Each newsletter has a coherent theme, not random assortment:
- The Annual Review
- The Wealth Score
- Winner's Game vs Loser's Game

**2. Reflection Questions**
Every framework includes questions for self-application:
> "Ask yourself: What did I not do this year because of fear?"

Transforms passive reading into active reflection.

**3. Templates and Tools**
Frameworks come with implementation resources:
- Downloadable PDFs
- Quizzes
- Checklists

**4. The Wealth Score Concept**
Redefined "wealth" across 5 dimensions. Original framework that became signature IP.

### Sample Structure

```
[Hook - philosophical observation]

---

## The [Framework Name]

[What it is - 2-3 sentences]

### [Dimension 1]
[Explanation + why it matters]

### [Dimension 2]
[Explanation + why it matters]

### [Dimension 3]
[Explanation + why it matters]

---

## Questions to Ask

1. [Reflection question]
2. [Reflection question]
3. [Reflection question]

---

## The Takeaway

[Core insight distilled]

---

[Warm sign-off]
Sahil

P.S. [Template or resource link]
```

### Voice Markers
- Opens with philosophical observation
- "A failure to X will eventually result in Y"
- Uses "you" directly and personally
- Warm but not saccharine

---

## Greg Isenberg — The Builder Newsletter

**Stats:** 150K+ subscribers
**Frequency:** Weekly
**Niche:** Startups, community, internet business

### What Makes It Work

**1. The "Look..." Opener**
Conversational, peer-to-peer energy from the first word.

**2. Real Company Examples**
Every concept includes specific, named examples:
> "Audible's Shared Clips feature does this perfectly..."
> "Notion's template universe is engineered for this..."

Not abstract. Concrete.

**3. Building in Public**
Shares what he's actually doing—investments, projects, experiments. Skin in the game.

**4. Community-First CTAs**
Calls to action aren't "buy my course" but "come to my event" or "join the community."

### Sample Structure

```
Look...

[Personal observation or realization - 2-3 sentences]

---

## Here's what I'm seeing

[Trend or pattern]

**Example 1:** [Company name] does this by [specific mechanism]

**Example 2:** [Company name] does this by [specific mechanism]

---

## Why now?

[Context on timing and opportunity]

---

## What I'm doing about it

[Personal application or investment]

---

If you're building in this space, hit reply. Serious.

Greg

---

📍 [Event plug]
🎙️ [Podcast plug]
```

### Voice Markers
- "Look..." opener
- "Here's what's actually happening..."
- Names names (companies, people)
- "Serious." as emphasis
- Casual punctuation (dashes, ellipses)

---

## The Hustle — The Irreverent News

**Stats:** 2.5M+ subscribers
**Frequency:** Daily
**Niche:** Business news with personality

### What Makes It Work

**1. Unexpected Angles**
Not "Company raises $50M" but "Why this $50M raise means your coffee is about to get weird"

**2. The Editor Personality**
Each edition ends with an editor nickname. Creates human connection and encourages reading to the end.

**3. Anecdote-First Structure**
Opens with human-scale story before zooming out to business implications.

**4. "Why it's weird"**
Every story answers: why should you care? What's the surprising angle?

### Sample Structure

```
[UNEXPECTED HEADLINE]

[Opening anecdote - humanizes the story]

---

**What happened:** [Factual summary]

**Why it's weird:** [The angle]

**The bigger picture:** [Business implication]

---

## Also this happened

[Story 2 - same structure, shorter]

---

## The number

**$4.7 billion**

That's how much [context for surprising stat]

---

Later nerds 🤓
[Editor nickname]
```

### Voice Markers
- Headlines that make you curious
- "Here's the thing..."
- Self-aware humor
- "Later nerds" / personality in sign-offs
- Knows when to be serious (doesn't joke about everything)

---

## The Rundown AI — The Applied News

**Stats:** 600K+ subscribers
**Frequency:** Daily
**Niche:** AI news with business application

### What Makes It Work

**1. "Why it matters to you"**
Every story includes explicit business application:
> "Why it matters: If you're building [X], this means [Y]"

**2. The 5-Minute Promise**
Explicitly positioned as "everything you need in 5 minutes." Respects reader time.

**3. Tools Section**
Practical "here's what you can use today" separate from news.

**4. Business-First Framing**
Not "cool AI thing" but "how this AI thing affects your work/business."

### Sample Structure

```
Today in AI: [One-line hook]

---

## 🚀 Top Story

[Headline]

[What happened - 2-3 sentences]

**Why it matters:** [Business application]

**PLUS:** [Related tool or secondary angle]

---

## 📰 Quick Hits

• [Story + implication]
• [Story + implication]
• [Story + implication]

---

## 🛠️ Tool of the Day

[Name] — [What it does + who it's for]

---

That's it for today. Forward to someone who needs to know.
```

### Voice Markers
- Always connects to "what you can do with this"
- No hype, just facts + implications
- "Forward to someone..." CTA

---

## Patterns Across All Great Newsletters

### 1. Consistent Format
Readers know what to expect. Sections are predictable. Navigation is easy.

### 2. Distinct Voice
You could identify the newsletter from a random paragraph. Not generic, not corporate.

### 3. Clear Value Proposition
Each type delivers something specific:
- Lenny: Frameworks you can use
- Morning Brew: 5-minute business update
- Ben's Bites: AI curation you can trust
- Sahil: Life improvement through reflection
- Greg: Ideas from the building trenches
- The Hustle: Business news that doesn't bore you

### 4. Respect for Reader Time
- Above-fold content earns continued reading
- Scannability for busy readers
- Clear sections for different consumption modes

### 5. Human Moments
- Personal openers
- Admits uncertainty
- Shows personality
- Signs off with a name, not a brand

---

## Quick Reference: Which Format for Your Goals?

| Goal | Format | Example |
|------|--------|---------|
| Build authority | Deep-Dive Framework | Lenny Rachitsky |
| Daily habit | News Briefing | Morning Brew |
| Niche curator | Curated + Commentary | Ben's Bites |
| Personal brand | Essay/Reflection | Sahil Bloom |
| Founder audience | Builder Updates | Greg Isenberg |
| Broad audience | Irreverent News | The Hustle |
| Fast-moving space | Applied News | The Rundown AI |
