---
name: newsletter
description: Creates engaging newsletters using 9 proven formats for recurring audience engagement. This skill should be used when launching a newsletter, improving open and click rates, varying content to prevent subscriber fatigue, or when existing newsletters feel stale or generic.
---

# Newsletter

This skill creates newsletters people actually want to read - not just promotional blasts that get ignored or unsubscribed from.

## Objective

Build recurring engagement through newsletters that deliver consistent value, strengthen audience relationships, and naturally drive business goals.

## Intake Questions

Before creating newsletter content, gather context:

1. **Audience**: Who are subscribers? What do they care about?
2. **Frequency**: How often do you send? (Daily, weekly, monthly)
3. **Brand voice**: What tone should the newsletter have? (From `brand-voice` skill)
4. **Primary goal**: Education, entertainment, conversion, or community?
5. **Existing content**: What blog posts, insights, or resources can be repurposed?
6. **Unique angle**: What can you offer that no other newsletter does?
7. **Past performance**: What formats/topics have worked well or poorly?

## The 9 Newsletter Formats

### 1. Curated Links
Collect the best resources, articles, and tools on a topic so readers don't have to.

**Structure**:
- Brief intro (2-3 sentences)
- 5-10 curated items with commentary
- Each item: Title, source, your take (why it matters)
- Optional: categorize by theme

**Best for**: Busy professionals, niche industries, staying current on trends

**Example**: "The best marketing reads from this week, so you don't have to scroll Twitter."

### 2. Original Essay
Long-form thinking on a single topic - your perspective, insights, or argument.

**Structure**:
- Hook: Surprising opening
- Thesis: Main argument/insight
- Body: Supporting points with examples
- Conclusion: Takeaway and implications

**Best for**: Thought leadership, building authority, deep audience connection

**Example**: "Why I think content marketing is dead (and what's replacing it)"

### 3. Story-Driven
Narrative format with a lesson embedded - personal stories, customer stories, or observations.

**Structure**:
- Set the scene
- Build tension/conflict
- Resolution or realization
- Explicit lesson/takeaway

**Best for**: Personal brands, coaches, anyone with interesting experiences

**Example**: "The sales call that made me rethink everything about pricing"

### 4. How-To Tutorial
Step-by-step instructions for accomplishing something specific.

**Structure**:
- What you'll learn/achieve
- Prerequisites (if any)
- Numbered steps with details
- Common mistakes to avoid
- Expected outcome

**Best for**: Skill-building audiences, technical topics, actionable content

**Example**: "How to set up your first automated email sequence (in 30 minutes)"

### 5. News Roundup + Commentary
Industry news with your unique perspective and analysis.

**Structure**:
- 3-5 news items
- Each item: What happened, why it matters, your take
- Optional: predictions or implications

**Best for**: Industry-specific newsletters, keeping audiences informed

**Example**: "This week in AI: 3 announcements that change everything (and 2 that don't)"

### 6. Q&A / AMA
Answer reader questions or common questions in your space.

**Structure**:
- Question (from reader or common)
- Your answer with depth
- Additional context or resources
- Invitation for more questions

**Best for**: Building community, demonstrating expertise, engagement

**Example**: "You asked: How do I get my first 1,000 email subscribers?"

### 7. Case Study Deep-Dive
Detailed breakdown of a success story, failure, or interesting example.

**Structure**:
- Background: Who, what, when
- Challenge: What they were trying to solve
- Approach: What they did
- Results: What happened (with numbers)
- Lessons: What we can learn

**Best for**: B2B, proof-driven audiences, demonstrating what's possible

**Example**: "How [Company] increased conversions by 340% with one landing page change"

### 8. Behind-the-Scenes
Transparency about your process, decisions, numbers, or journey.

**Structure**:
- What you're sharing
- The context/why
- The details (be specific)
- What you learned
- What's next

**Best for**: Building trust, creator economy, indie businesses

**Example**: "My November revenue breakdown: $47K (here's what worked and what didn't)"

### 9. Hybrid/Mixed Format
Combine multiple formats in recurring sections.

**Structure example**:
- Opening thought (essay-style)
- 3 curated links
- One tactical tip (how-to)
- Closing question (engagement)

**Best for**: Maintaining variety, longer newsletters, diverse audiences

**Example**: "One big idea, three links, and a question to ponder"

## Format Selection Guide

| Your Situation | Best Format |
|----------------|-------------|
| Limited time to write | Curated Links, News Roundup |
| Strong opinions/expertise | Original Essay, Commentary |
| Personal brand | Story-Driven, Behind-the-Scenes |
| Teaching/educating | How-To Tutorial, Case Study |
| Building community | Q&A/AMA, Story-Driven |
| Consistent schedule | Hybrid (predictable structure) |

## Subject Line Formulas

High-open-rate patterns:

### Curiosity
- "The [topic] mistake I keep making"
- "What [surprising thing] taught me about [topic]"
- "I changed my mind about [thing]"

### Utility
- "How to [achieve result] in [timeframe]"
- "[Number] ways to [solve problem]"
- "The [tool/method] that changed my [outcome]"

### Specificity
- "[Specific result] in [specific timeframe]"
- "Why [specific person/company] does [specific thing]"
- "The exact [template/script] I use for [task]"

### Personal
- "A confession about [topic]"
- "What I wish I knew about [topic]"
- "The real reason I [action]"

### Pattern Interrupt
- Single word or emoji
- Question only
- "[Category]:" format

## Engagement Hooks

First 1-3 lines that prevent immediate delete:

- **Say something disagreeable**: Challenge a common assumption in the first line.
- **Specific examples**: Use a real-world scenario or name a specific tool/event.
- **Human touch**: Include a "un-AI" statement (humor or a bold opinion).
- **Relatable frustration**: Show you understand exactly what the reader is going through.
- **No Em-Dashes**: Never use em-dashes (-) or en-dashes (-) in the content.

**Avoid opening with**:
- "Hope you're doing well!"
- "Happy [day of week]!"
- "In this issue..."
- Self-focused statements

## Format Rotation Strategy

Prevent subscriber fatigue by rotating formats:

**Weekly newsletter example**:
- Week 1: Original Essay
- Week 2: Curated Links + Commentary
- Week 3: Case Study or Tutorial
- Week 4: Behind-the-Scenes or Q&A

**Twice-weekly example**:
- Tuesday: Educational (Tutorial, Essay)
- Friday: Lighter (Links, Behind-the-Scenes)

## Output Format

When creating newsletter content, deliver:

1. **Format Selection**: Which of the 9 formats and why
2. **Subject Line Options**: 5-7 variations to test
3. **Preview Text**: First line optimized for email previews
4. **Full Newsletter Content**: Following the chosen format structure
5. **CTA Recommendation**: What action to drive (if any)
6. **Send Time Suggestion**: Based on audience behavior patterns

## Cross-References

- Apply `brand-voice` for consistent tone across all newsletters
- Use `keyword-research` insights for topic ideation
- Repurpose `seo-content` into newsletter formats
- `lead-magnet` can be promoted in newsletters
- `content-atomizer` turns newsletters into social content
- `email-sequences` handles automated flows vs. broadcast newsletters
