---
name: Newsletter Writer
slug: newsletter-writer
description: Create engaging newsletters that get read, clicked, and shared
category: communication
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "write newsletter"
  - "draft newsletter"
  - "create newsletter"
  - "newsletter content"
tags:
  - newsletter
  - content-marketing
  - email-marketing
  - engagement
---

# Newsletter Writer

The Newsletter Writer skill helps you create compelling newsletters that cut through inbox noise and drive engagement. Whether you're sending weekly updates to your team, monthly roundups to customers, or regular thought leadership to your audience, this skill ensures your content is valuable, scannable, and action-oriented.

This skill understands the unique challenges of newsletter writing: capturing attention in crowded inboxes, maintaining consistent voice and format, balancing information with engagement, and driving specific actions. It helps you structure content that people actually want to read, not just delete.

Great newsletters build relationships, drive traffic, and keep your audience engaged over time. This skill makes the writing process efficient while maintaining quality and consistency across every issue.

## Core Workflows

### Workflow 1: Write Newsletter Issue
1. **Define Theme**: Identify main topic or purpose for this issue
2. **Gather Content**: Collect updates, links, stories, and insights
3. **Structure Sections**: Organize into clear, scannable segments
4. **Write Engaging Copy**: Create compelling headlines and descriptions
5. **Add CTAs**: Include clear calls-to-action
6. **Polish & Review**: Check for clarity, tone, and value

### Workflow 2: Create Newsletter Template
1. **Define Sections**: Establish recurring content blocks
2. **Set Tone Guidelines**: Document voice and style
3. **Design Structure**: Create repeatable format
4. **Build Examples**: Show what good content looks like
5. **Document Process**: Create content gathering workflow

### Workflow 3: Content Curation
1. **Source Material**: Gather links, updates, highlights
2. **Filter for Relevance**: Select most valuable items
3. **Add Context**: Write why each item matters
4. **Balance Content**: Mix types and tones appropriately
5. **Credit Sources**: Attribute and link properly

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Write newsletter | "Draft newsletter on [topic/theme]" |
| Create template | "Build newsletter template for [type]" |
| Curate content | "Curate newsletter content on [topic]" |
| Write subject line | "Create subject line for [newsletter topic]" |
| Draft intro | "Write newsletter intro for [theme]" |
| Create section | "Write [section name] section about [topic]" |
| Add CTA | "Write call-to-action for [goal]" |
| Polish draft | "Review and improve this newsletter: [paste]" |

## Newsletter Types Supported

- **Company Updates**: Internal news and announcements
- **Product Updates**: Feature releases and roadmap
- **Content Roundups**: Curated links and resources
- **Thought Leadership**: Industry insights and commentary
- **Event Recaps**: Conference or event summaries
- **Community Highlights**: User stories and wins
- **Educational**: Tips, tutorials, how-tos
- **Weekly Digests**: Regular summary of activity
- **Personal**: Founder or leader updates
- **Sales/Marketing**: Promotional campaigns

## Standard Newsletter Structure

```markdown
# [Catchy, Value-Focused Subject Line]

## [Optional: Preview Text - First sentence shown in inbox]

---

### 👋 [Greeting/Opening]
[Brief personal note or context - 2-3 sentences]

---

### 📰 [Main Feature or Top Story]
[Most important content - lead with the value]

**Why this matters:** [Clear benefit to reader]

[Call-to-action button or link]

---

### 🔍 [Section 2: Supporting Content]
**[Item 1]**
[Description - what it is and why it's interesting]
[Link: Read more →]

**[Item 2]**
[Description]
[Link: Check it out →]

**[Item 3]**
[Description]
[Link: Learn more →]

---

### 💡 [Tip/Insight Section]
[Quick actionable advice or interesting observation]

---

### 📅 [What's Coming Next]
[Tease future content or upcoming events]

---

### 📣 [Final CTA or Ask]
[One clear action you want readers to take]

[Button or link]

---

**[Signature/Sign-off]**
[Personal touch - name, photo, social links]

[Footer: Unsubscribe, preferences, company info]
```

## Subject Line Formula

Great subject lines are:
- **Specific**: Tell them what's inside
- **Benefit-Driven**: What they'll gain
- **Curiosity-Inducing**: Make them want to open
- **Short**: Under 50 characters when possible
- **Personal**: Use "you" and "your"

| Type | Example |
|------|---------|
| **Benefit** | "3 ways to cut meeting time in half" |
| **Curiosity** | "The surprising truth about async work" |
| **News** | "We just launched our biggest update yet" |
| **Question** | "Are you making this common design mistake?" |
| **Number** | "5 features you didn't know existed" |
| **Urgency** | "Last call: Early bird pricing ends Friday" |
| **Personal** | "Here's what I learned failing at product launches" |
| **Direct** | "Your weekly startup resources are here" |

## Content Section Types

### 1. Feature Story
The main attraction - your most important content.
- Lead with the hook
- Explain the benefit clearly
- Use storytelling when appropriate
- Include clear CTA

### 2. Curated Links
3-5 handpicked resources.
- Brief description (1-2 sentences)
- Why it's worth their time
- Consistent format
- Clear link labels

### 3. Quick Tips
Actionable advice they can use immediately.
- Be specific and practical
- Number the steps
- Keep it brief
- Make it actionable

### 4. Community Highlights
Showcase readers, customers, or community.
- Real stories from real people
- Include names and photos when possible
- Make them the hero
- Link to their work

### 5. Behind the Scenes
Humanize your brand.
- Share process, not just outcomes
- Be authentic and honest
- Include photos or screenshots
- Show the team

### 6. What's New
Product updates, feature releases.
- Focus on benefits, not features
- Include screenshots or demos
- Explain why it matters
- Link to detailed docs

## Writing Best Practices

### Opening Hook
First 2-3 sentences are critical.
- Lead with value or curiosity
- Be personal and conversational
- Avoid generic greetings
- Set the tone for the issue

Good: "I spent 3 hours in meetings yesterday and accomplished exactly nothing. Let's talk about how to fix that."

Bad: "Hello! Welcome to this week's newsletter. We have some exciting updates to share with you today."

### Content Balance
Mix content types for variety:
- 1 deep piece (main feature)
- 3-5 quick hits (curated links)
- 1 actionable tip
- 1 personal touch or community highlight

### Tone and Voice
- **Conversational**: Write like you talk
- **Scannable**: Short paragraphs, bullets, headers
- **Personal**: Use "I" and "you"
- **Valuable**: Every item should be worth their time
- **Consistent**: Same voice every issue

### Call-to-Action Strategy
- **One Primary CTA**: Main action you want
- **Multiple Secondary CTAs**: Links to explore
- **Clear Labels**: Tell them exactly what happens when they click
- **Benefit-Focused**: "Get the template" not "Click here"

## Engagement Tactics

### Increase Opens
- Subject line testing
- Send time optimization
- From name personalization
- Preview text optimization

### Increase Clicks
- Clear value proposition
- Compelling link labels
- Visual hierarchy
- Strategic CTA placement

### Increase Shares
- Valuable, shareable content
- Easy social sharing buttons
- "Forward to a friend" option
- Quotable pull quotes

### Reduce Unsubscribes
- Set clear expectations
- Deliver consistent value
- Respect reader time
- Make preferences adjustable

## Newsletter Templates

### Template 1: Weekly Team Update
```markdown
Subject: [Team] Weekly - Week of [Date]

👋 Happy [Day], team!

Quick update on what's happening this week:

🚀 **This Week's Big Win**
[Highlight one major accomplishment]
Shoutout to @person for making this happen!

📊 **By the Numbers**
• Metric 1: [value] (↑ [change])
• Metric 2: [value] (→ flat)
• Metric 3: [value] (↓ [change])

🏃 **In Progress**
[3-5 key initiatives with one-line status]

⚠️ **Heads Up**
[Anything team needs to know about]

📅 **This Week**
• Event 1 (Date/Time)
• Event 2 (Date/Time)

💡 **Tip of the Week**
[One quick, actionable tip]

Questions? Hit reply or catch me in Slack.

[Name]
```

### Template 2: Product Newsletter
```markdown
Subject: New: [Feature Name] + 4 more updates

Hey [Name],

We just shipped something I think you'll love.

🎉 **Introducing [Feature Name]**
[What it does and why it's awesome - 2-3 sentences]

[Screenshot or GIF]

This means you can now [specific benefit].

→ Try it now

---

**Also New This Week:**

✨ [Feature 2] - [One line benefit]
🔧 [Improvement] - [One line benefit]
🐛 [Bug fix] - [One line benefit]
📚 [Docs/Resources] - [One line benefit]

→ Full changelog

---

💡 **Power User Tip**
[Quick tip to get more value from product]

---

See you next week with more updates!

[Name]
[Product Team]

P.S. - [Personal note or ask for feedback]
```

### Template 3: Content Roundup
```markdown
Subject: 5 articles on [topic] worth your time

Hi there,

This week I found some great content on [topic]. Here are my top picks:

📖 **Must Read**
[Article Title]
By [Author] at [Publication]

[2-3 sentence summary and why it's worth reading]

→ Read it here

---

**Also Worth Your Time:**

1. **[Title]** - [One sentence on what makes it valuable]
   → Link

2. **[Title]** - [One sentence]
   → Link

3. **[Title]** - [One sentence]
   → Link

4. **[Title]** - [One sentence]
   → Link

---

💬 **My Take**
[Your perspective or insight on the theme]

---

📅 **Coming Next Week**
[Tease next issue's theme]

Hit reply and tell me what you thought!

[Name]
```

### Template 4: Event Recap
```markdown
Subject: [Event Name] Highlights - You missed some good stuff

Hey friends,

Just got back from [Event Name] and wanted to share the highlights.

🎤 **Key Takeaways**

**1. [Insight]**
[Speaker/Source]
[Why it matters - 2-3 sentences]

**2. [Insight]**
[Speaker/Source]
[Why it matters]

**3. [Insight]**
[Speaker/Source]
[Why it matters]

---

📸 **Photo Highlights**
[2-3 best photos with captions]

---

🤝 **Interesting People I Met**
[Brief notes on interesting connections]

---

💡 **My Biggest Aha Moment**
[Personal reflection on most valuable insight]

---

📚 **Resources Mentioned**
• [Resource 1] → Link
• [Resource 2] → Link
• [Resource 3] → Link

---

Couldn't make it this year? [Link to recordings/materials]

See you there next year!

[Name]
```

## Optimization Checklist

Before sending, verify:

**Subject Line**
- [ ] Under 50 characters
- [ ] Benefit or curiosity-driven
- [ ] No spam trigger words
- [ ] Tested alternatives

**Preview Text**
- [ ] Complements subject line
- [ ] Adds value, doesn't repeat
- [ ] Properly formatted

**Content**
- [ ] Value in first paragraph
- [ ] Scannable structure
- [ ] Consistent voice
- [ ] All links work
- [ ] Images load properly
- [ ] Mobile-friendly format

**CTAs**
- [ ] One clear primary CTA
- [ ] Action-oriented labels
- [ ] Links to right destinations
- [ ] Tracking parameters added

**Housekeeping**
- [ ] Sender name/email correct
- [ ] Unsubscribe link present
- [ ] Footer info complete
- [ ] Sent to test first

## Common Pitfalls to Avoid

- **Too Long**: Most newsletters should be under 500 words
- **Buried Lede**: Put the best content first
- **All About You**: Focus on reader value, not company news
- **Inconsistent Schedule**: Send on a predictable cadence
- **No Clear Purpose**: Every issue should have a point
- **Poor Formatting**: Dense text blocks kill readability
- **Weak CTAs**: Tell them exactly what to do
- **No Personality**: Let your voice show through
- **Boring Subject Lines**: You lose 50% of value if they don't open

## Metrics to Track

- **Open Rate**: Are subject lines working?
- **Click Rate**: Is content engaging?
- **Click-to-Open Rate**: Quality of content for those who open
- **Unsubscribe Rate**: Are you providing value?
- **Forward Rate**: Is it shareable?
- **Top Links**: What content resonates most?

## Integration Points

- **Email Platforms**: Mailchimp, ConvertKit, Substack, Beehiiv
- **Analytics**: Track opens, clicks, conversions
- **Content Sources**: RSS feeds, social media, bookmarks
- **Scheduling**: Calendar for planning and sending
- **Design Tools**: Template builders and image creation
