---
name: nielsen-minimalist-design
description:
  Elimina información irrelevante que compite por atención con lo esencial. Use
  cuando evalúe densidad de información, jerarquía visual, o simplifique
  interfaces sobrecargadas.
metadata:
  author: ux-ui-skills
  version: "1.0"
  category: heuristics
---

# Diseño Estético y Minimalista

## Resumen

Los diálogos no deberían contener información irrelevante o rara vez necesaria.
Cada unidad extra de información en un diálogo compite con las unidades
relevantes y disminuye su visibilidad relativa.

## Origen

- **Autor**: Jakob Nielsen
- **Año**: 1994 (refinado 2020)
- **Fuente**: Nielsen Norman Group - "10 Usability Heuristics for User Interface
  Design"

## Fundamento Psicológico

La atención humana es un recurso limitado. El exceso de estímulos causa **fatiga
de decisión** y **ceguera por exceso de información**. El principio de Prägnanz
(Gestalt) indica que el cerebro prefiere interpretaciones simples. Los estudios
de eyetracking muestran que los usuarios ignoran sistemáticamente elementos
percibidos como ruido.

## Aplicación en Diseño

### Jerarquía Visual Clara

- Un solo punto focal principal por pantalla
- Contraste para elementos importantes
- Uso estratégico de whitespace
- Tamaño proporcional a importancia

### Eliminación de Ruido

- Remover elementos decorativos sin función
- Consolidar opciones relacionadas
- Ocultar opciones avanzadas por defecto
- Eliminar duplicación de información

### Content-First Design

- Contenido antes que chrome (bordes, sombras)
- Interfaces que "desaparecen" ante el contenido
- Full-screen modes para inmersión
- Texto conciso y escaneable

### Progressive Disclosure

- Mostrar solo lo esencial inicialmente
- Expandir detalles bajo demanda
- Niveles de complejidad graduales
- Default views optimizadas para casos comunes

## Ejemplos

- **Google Search**: Página casi vacía, focus total en búsqueda
- **Medium**: Diseño limpio centrado en lectura
- **Apple**: Productos y sitio web minimalistas
- **Notion**: Interface que se adapta al contenido
- **iA Writer**: Solo texto, sin distracciones

## Anti-patterns

- ❌ Dashboards con docenas de métricas sin jerarquía
- ❌ Banners, pop-ups y notificaciones simultáneas
- ❌ Sidebars sobrecargadas de opciones
- ❌ Fondos decorativos que compiten con contenido
- ❌ Información redundante en múltiples lugares

## Métricas

- **Signal-to-Noise Ratio**: Proporción de contenido útil
- **Time to Task Completion**: Reducido con diseño limpio
- **Eye-Tracking Heatmaps**: Verificar focus en elementos clave
- **Perceived Complexity Score**: Evaluación subjetiva de usuarios

## Principios Relacionados

- [[pragnanz]] - Gestalt: preferencia por simplicidad
- [[cognitive-load]] - Reducir carga cognitiva
- [[von-restorff-effect]] - Lo distintivo se destaca mejor con menos ruido

## Referencias

- Nielsen, J. (1994). "Usability Engineering". Morgan Kaufmann
- Tufte, E. (2001). "The Visual Display of Quantitative Information"
- https://www.nngroup.com/articles/aesthetic-minimalist-design/
