---
name: Notion Icon Strategy
description: This skill should be used when the user asks about "Notion icons", "page icons", "emoji icons", "icon consistency", "visual organization", "icon meaning", "database icons", "icon color coding", "meaningful icons", or needs to apply consistent, meaningful iconography to Notion pages and databases.
version: 0.1.0
---

# Notion Icon Strategy

A comprehensive system for applying meaningful, consistent icons across a Notion workspace. Icons should communicate purpose at a glance while maintaining visual harmony.

## Icon Philosophy

### Three Principles

1. **Semantic Meaning** - Icons communicate what the page IS or DOES
2. **Visual Consistency** - Related pages share icon patterns
3. **Cognitive Load Reduction** - Users recognize meaning without reading titles

### Icon Hierarchy

```
Level 1: Structural (PARA sections) - Fixed, memorable
Level 2: Domain (Areas) - Distinctive per responsibility
Level 3: Type (Database items) - Consistent within collections
Level 4: Unique (One-off pages) - Descriptive of specific content
```

## Icon Types in Notion API

Notion supports four icon types:

```json
// Standard Emoji
{ "type": "emoji", "emoji": "🏠" }

// External URL
{ "type": "external", "external": { "url": "https://..." } }

// Uploaded File
{ "type": "file_upload", "file_upload": { "id": "..." } }

// Workspace Custom Emoji
{ "type": "custom_emoji", "custom_emoji": { "id": "...", "name": "...", "url": "..." } }
```

**Recommendation:** Use standard emoji for maximum compatibility and minimal maintenance. Reserve custom/external icons for brand-specific needs.

---

## PARA Structural Icons

Top-level PARA sections use fixed, instantly recognizable icons:

| Section | Icon | Rationale |
|---------|------|-----------|
| Home | 🏠 | Universal "home base" recognition |
| Inbox | 📥 | Clearly "incoming/unprocessed" |
| Projects | 🚀 | Active, forward momentum |
| Areas | 🎯 | Ongoing focus/responsibility |
| Resources | 📚 | Knowledge library metaphor |
| Archives | 🗄️ | Storage/filing cabinet |
| Meta | ⚙️ | Configuration/system settings |

**Rule:** Never change these icons. They become navigation landmarks.

---

## Area Icons (Domain-Based)

Each Area gets a distinctive icon reflecting its domain. Choose icons that are:
- **Distinct from each other** (no confusion between areas)
- **Memorable** (consistent association builds over time)
- **Domain-appropriate** (reflects the responsibility)

### Recommended Area Icons

| Area | Primary | Alternatives | Rationale |
|------|---------|--------------|-----------|
| Product | 📦 | 🎯, 💎 | Core deliverable/output |
| Engineering | 💻 | 🔧, ⚙️ | Technical work |
| Marketing | 📣 | 🎨, 🎯 | Communication/outreach |
| Operations | ⚡ | 🔄, 🏭 | Execution/process |
| Finance | 📊 | 💰, 🧮 | Numbers/analysis |
| Design | 🎨 | ✨, 🖼️ | Visual/creative |
| Sales | 🤝 | 💼, 📈 | Relationships/growth |
| Support | 🛟 | 🆘, 💬 | Assistance/help |
| Legal | ⚖️ | 📜, 🔒 | Compliance/contracts |
| HR/People | 👥 | 🧑‍🤝‍🧑, 💼 | Team/personnel |

### Area Icon Rules

1. **One icon per area** - Never vary within an area
2. **Propagate to children** - Subpages inherit area context through navigation, not icons
3. **Area dashboards** - Use the area icon on the main area page

---

## Database Item Icons (Type-Coded)

Items within databases should have consistent icons based on their **type** property. This creates instant visual recognition when scanning database views.

### Resource Type Icons

| Type | Icon | Description |
|------|------|-------------|
| Spec | 📋 | Formal specifications, requirements |
| Guide | 📖 | How-to documentation, tutorials |
| Playbook | 📒 | Step-by-step procedures, runbooks |
| Reference | 🏷️ | Quick lookup, glossaries, lists |
| Template | 📝 | Reusable formats and structures |
| Concept | 💡 | Explanatory content, principles |
| Process | 🔄 | Workflow documentation |
| Policy | 📜 | Rules, guidelines, standards |
| Report | 📈 | Analysis, metrics, summaries |
| Archive | 📦 | Historical/deprecated content |

### Project Status Icons

Use colored circles for project status (visible in list/board views):

| Status | Icon | Meaning |
|--------|------|---------|
| Not Started | ⚪ | Planned but not begun |
| Active | 🟢 | Currently in progress |
| On Hold | 🟡 | Paused, waiting on dependency |
| Blocked | 🔴 | Cannot proceed, needs resolution |
| Complete | ✅ | Successfully finished |

### SECI Phase Icons (Knowledge Status)

Track knowledge maturity using SECI-based icons:

| Phase | Icon | Meaning |
|-------|------|---------|
| Socialization | 💬 | Tacit, needs discussion/experience |
| Externalization | 📝 | Being documented, draft state |
| Combination | 🔗 | Synthesized, connected to other knowledge |
| Internalization | 🎯 | Actionable, ready for application |

### Priority Icons

| Priority | Icon | When to Use |
|----------|------|-------------|
| Critical | 🔥 | Must address immediately |
| High | ⬆️ | Important, do soon |
| Medium | ➡️ | Normal priority |
| Low | ⬇️ | Nice to have |

---

## One-Off Page Icons (Unique, Descriptive)

Pages that don't belong to a database should have unique icons describing their specific content. Match the icon to the page's primary purpose.

### Meeting & Communication

| Content | Icon | Use For |
|---------|------|---------|
| Meeting Notes | 🗓️ | Scheduled discussions |
| Standup | 🧍 | Daily syncs |
| Retrospective | 🔍 | Review sessions |
| Workshop | 🛠️ | Collaborative work sessions |
| Interview | 🎤 | Candidate/user interviews |
| Announcement | 📢 | Team communications |

### Decision & Planning

| Content | Icon | Use For |
|---------|------|---------|
| Decision Record | ⚖️ | ADRs, documented decisions |
| Proposal | 💡 | Ideas for consideration |
| Roadmap | 🗺️ | Future planning |
| Strategy | 🎯 | High-level direction |
| OKRs | 🎪 | Objectives and key results |
| Post-mortem | 🔬 | Incident analysis |

### Creative & Ideation

| Content | Icon | Use For |
|---------|------|---------|
| Brainstorm | 💭 | Ideation sessions |
| Sketch | ✏️ | Early designs |
| Prototype | 🧪 | Experimental work |
| Research | 🔎 | Discovery findings |
| Inspiration | ✨ | Reference collection |

### Technical & Reference

| Content | Icon | Use For |
|---------|------|---------|
| Architecture | 🏗️ | System design |
| Diagram | 📊 | Visual documentation |
| API Docs | 🔌 | Integration reference |
| Schema | 🗃️ | Data structure |
| Changelog | 📋 | Version history |
| Troubleshooting | 🔧 | Debug guides |

### Operational

| Content | Icon | Use For |
|---------|------|---------|
| Checklist | ✓ | Task lists |
| SOP | 📑 | Standard procedures |
| Escalation | 🚨 | Emergency contacts |
| On-Call | 📞 | Support rotation |
| Runbook | 📒 | Operational procedures |
| Audit | 🔍 | Compliance checks |

---

## Color Coding Through Emoji Selection

While Notion doesn't support icon colors directly, you can achieve color coding through careful emoji selection:

### Warm Colors (Action, Urgency)

🔴 🟠 🟡 🔥 ⚠️ 🚨 - Alerts, blockers, urgent items

### Cool Colors (Stable, Reference)

🔵 🟢 💚 🩵 - Active, healthy, stable items

### Neutral (System, Meta)

⚪ ⚙️ 🔧 ⬜ - Configuration, settings, meta pages

### Semantic Emoji Sets

**Status Traffic Lights:**
```
🔴 Blocked/Critical
🟡 Warning/On Hold
🟢 Active/Healthy
```

**Progress Indicators:**
```
⬜ Not started
🔲 In progress
✅ Complete
```

**Quality/Health:**
```
💚 Excellent
💛 Good
🧡 Needs attention
❤️ Critical
```

---

## Implementation Guidelines

### When Creating New Pages

1. **Database items:** Apply type-based icon from the relevant category
2. **Area subpages:** Use content-appropriate unique icon (not area icon)
3. **Standalone pages:** Match icon to primary content type

### When Setting Up Databases

1. Consider making icons automatic via templates
2. Document icon meanings in database description
3. Use consistent icon for all items of same type

### Icon Maintenance

1. **Audit quarterly:** Review for consistency
2. **Document changes:** Update this guide when adding new patterns
3. **Onboard new members:** Share icon meanings during workspace intro

---

## Anti-Patterns to Avoid

### Don't: Random Icons
```
❌ Using 🎉 for a meeting note just because you like it
✅ Using 🗓️ consistently for all meeting notes
```

### Don't: Inconsistent Database Icons
```
❌ Some projects have 🚀, others have 📁, others have no icon
✅ All projects have status-based icons (🟢, 🟡, etc.)
```

### Don't: Overload with Meaning
```
❌ 🔴🔥⚠️🚨 on one page (redundant urgency)
✅ 🔴 for blocked status (single clear signal)
```

### Don't: Icon-less Important Pages
```
❌ Major area dashboard with no icon
✅ Every navigational page has an appropriate icon
```

---

## Quick Reference Card

```
PARA Structure:
🏠 Home  📥 Inbox  🚀 Projects  🎯 Areas  📚 Resources  🗄️ Archives  ⚙️ Meta

Resource Types:
📋 Spec  📖 Guide  📒 Playbook  🏷️ Reference  📝 Template  💡 Concept

Status:
⚪ Not Started  🟢 Active  🟡 On Hold  🔴 Blocked  ✅ Complete

Priority:
🔥 Critical  ⬆️ High  ➡️ Medium  ⬇️ Low

SECI Phases:
💬 Socialization  📝 Externalization  🔗 Combination  🎯 Internalization
```

---

## Additional Resources

- **`references/emoji-semantics.md`** - Complete emoji meaning guide
- **`references/icon-automation.md`** - Automating icons via templates/formulas
