# Emoji Semantics Reference

A comprehensive guide to emoji meanings and appropriate use cases in Notion workspaces.

## Category: Objects & Tools

### Documents & Files
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 📄 | Generic document | Untyped pages, imports |
| 📋 | Clipboard/spec | Specifications, checklists |
| 📝 | Writing/memo | Notes, drafts, templates |
| 📑 | Tabbed document | Multi-section docs, SOPs |
| 📜 | Scroll/policy | Policies, guidelines, rules |
| 📰 | News | Announcements, updates |
| 📓 | Notebook | Personal notes, journals |
| 📒 | Ledger | Playbooks, procedures |
| 📕 | Closed book | Completed references |
| 📖 | Open book | Guides, tutorials |
| 📚 | Books/library | Collections, resources |
| 🗂️ | File cabinet | Organization, archives |
| 🗃️ | Card file | Databases, schemas |
| 🗄️ | Filing cabinet | Archives, storage |

### Communication
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 💬 | Speech bubble | Discussions, comments |
| 💭 | Thought bubble | Ideas, brainstorms |
| 🗣️ | Speaking head | Voice/tone, announcements |
| 📢 | Loudspeaker | Announcements |
| 📣 | Megaphone | Marketing, campaigns |
| 📧 | Email | Email templates, comms |
| 📨 | Incoming mail | Inbox items |
| 📩 | Envelope with arrow | Outbound comms |
| 📥 | Inbox tray | Capture, incoming |
| 📤 | Outbox tray | Exports, outputs |

### Tools & Equipment
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 🔧 | Wrench | Fixes, maintenance |
| 🔨 | Hammer | Building, construction |
| ⚙️ | Gear | Settings, configuration |
| 🛠️ | Tools | Workshops, utilities |
| 🔩 | Nut and bolt | Technical details |
| ⛏️ | Pick | Deep work, exploration |
| 🔬 | Microscope | Analysis, research |
| 🔭 | Telescope | Vision, roadmaps |
| 🧪 | Test tube | Experiments, tests |
| 💡 | Light bulb | Ideas, concepts |
| 🔌 | Plug | Integrations, APIs |
| 🔋 | Battery | Energy, resources |
| 💻 | Laptop | Engineering, dev |
| 🖥️ | Desktop | Systems, infrastructure |

## Category: Symbols & Indicators

### Status Indicators
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| ✅ | Check mark | Complete, approved |
| ❌ | X mark | Rejected, failed |
| ⚪ | White circle | Not started |
| 🔘 | Radio button | Selected option |
| 🟢 | Green circle | Active, healthy |
| 🟡 | Yellow circle | Warning, on hold |
| 🟠 | Orange circle | Caution |
| 🔴 | Red circle | Blocked, critical |
| 🔵 | Blue circle | Info, reference |
| 🟣 | Purple circle | Special, unique |
| ⬛ | Black square | Inactive |
| ⬜ | White square | Empty, pending |
| 🔲 | Black square button | In progress |
| 🔳 | White square button | Queued |

### Arrows & Direction
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| ⬆️ | Up arrow | High priority, increase |
| ⬇️ | Down arrow | Low priority, decrease |
| ➡️ | Right arrow | Medium, continue |
| ⬅️ | Left arrow | Back, return |
| ↩️ | Return arrow | Rollback, undo |
| 🔄 | Refresh | Process, cycle |
| 🔀 | Shuffle | Random, variety |
| 🔃 | Clockwise | Recurring |
| ↔️ | Bidirectional | Relations, connections |

### Priority & Urgency
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 🔥 | Fire | Critical, hot |
| ⚠️ | Warning | Caution needed |
| 🚨 | Siren | Emergency, alert |
| ❗ | Exclamation | Important |
| ❓ | Question | Needs clarification |
| 💥 | Collision | Breaking change |
| ⭐ | Star | Featured, favorite |
| 🌟 | Glowing star | Highlighted |
| ⚡ | Lightning | Fast, urgent |
| 🏃 | Running | Sprint, quick |

## Category: People & Activities

### Meetings & Events
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 🗓️ | Calendar | Scheduled meetings |
| 📅 | Calendar page | Date-specific events |
| 📆 | Tear-off calendar | Planning |
| 🕐 | Clock | Time-sensitive |
| ⏰ | Alarm | Reminders, deadlines |
| 🎤 | Microphone | Presentations, talks |
| 🎬 | Clapperboard | Kickoffs, launches |
| 🧍 | Standing person | Standups |
| 👥 | People | Team, groups |
| 🤝 | Handshake | Partnerships, sales |
| 🙋 | Raised hand | Questions, volunteers |

### Roles & People
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 👤 | Person silhouette | User, individual |
| 👥 | People silhouette | Team, group |
| 🧑‍💼 | Office worker | Business |
| 🧑‍💻 | Technologist | Engineering |
| 🧑‍🎨 | Artist | Design |
| 🧑‍🔬 | Scientist | Research |
| 🧑‍🏫 | Teacher | Training |
| 🧑‍⚖️ | Judge | Legal |
| 🧑‍🔧 | Mechanic | Operations |

## Category: Nature & Time

### Growth & Progress
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 🌱 | Seedling | New, starting |
| 🌿 | Herb | Growing |
| 🌳 | Tree | Mature, established |
| 🍂 | Fallen leaf | Deprecated |
| 🌸 | Flower | Launch, release |
| 🏆 | Trophy | Achievement |
| 🎯 | Target | Goals, objectives |
| 🚀 | Rocket | Launch, projects |
| 📈 | Chart up | Growth, improvement |
| 📉 | Chart down | Decline |

### Time & History
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| ⏳ | Hourglass | In progress, waiting |
| ⌛ | Done hourglass | Completed wait |
| 🕰️ | Clock | Historical |
| 📆 | Calendar | Dated |
| 🗓️ | Spiral calendar | Scheduled |

## Category: Places & Objects

### Buildings & Locations
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 🏠 | House | Home, main |
| 🏢 | Office | Business |
| 🏭 | Factory | Operations |
| 🏗️ | Construction | Building, WIP |
| 🗺️ | Map | Navigation, sitemap |
| 📍 | Pin | Location |
| 🧭 | Compass | Direction |

### Containers
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 📦 | Package | Product, deliverable |
| 🎁 | Gift | Rewards, bonuses |
| 🧰 | Toolbox | Utilities |
| 🗑️ | Trash | Deleted |
| 📁 | Folder | Category |
| 📂 | Open folder | Active category |

## Category: Abstract Concepts

### Quality & Value
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 💎 | Gem | Premium, valuable |
| 🏅 | Medal | Achievement |
| 🎖️ | Military medal | Honor |
| ⭐ | Star | Featured |
| 💫 | Dizzy star | Magic, special |
| ✨ | Sparkles | New, fresh |
| 🌈 | Rainbow | Variety, options |
| 🎨 | Palette | Design, creative |
| 🖼️ | Frame | Visual, gallery |

### Security & Privacy
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| 🔒 | Locked | Secure, private |
| 🔓 | Unlocked | Public, open |
| 🔐 | Locked with key | Authenticated |
| 🔑 | Key | Access, credentials |
| 🛡️ | Shield | Protection |
| ⚔️ | Swords | Conflict, competition |

### Logic & Structure
| Emoji | Meaning | Best Used For |
|-------|---------|---------------|
| ⚖️ | Balance | Decisions, trade-offs |
| 🔗 | Link | Connections, relations |
| 🧩 | Puzzle | Components, integration |
| 🎲 | Die | Random, experiments |
| 🧮 | Abacus | Calculations |
| 📊 | Charts | Analytics |
| 📉 | Trend down | Decline |
| 📈 | Trend up | Growth |

---

## Emoji Selection Principles

### 1. Consistency Over Creativity
Choose one emoji per concept and stick with it. A boring but consistent icon system beats a creative but chaotic one.

### 2. Universal Recognition
Prefer emojis with widely understood meanings. Avoid culture-specific or ambiguous symbols.

### 3. Visual Distinction
When choosing between similar emojis, pick the one that's most visually distinct at small sizes.

### 4. Meaning Over Aesthetics
Choose the emoji that best conveys meaning, even if another looks "nicer."

### 5. Platform Consistency
Test how emojis render across platforms (Mac, Windows, mobile). Some vary significantly.

---

## Platform Rendering Notes

Emojis can look different across platforms. Generally safe choices:
- Basic shapes (circles, squares)
- Common objects (house, book, folder)
- Standard symbols (arrows, checkmarks)

Emojis to test first:
- People and faces (skin tone variations)
- Complex objects (can lose detail)
- Newer emojis (may not render on older systems)
