# Character Personas

Character templates for different story settings. Use these to create consistent, vivid NPCs.

## Palace Setting (宫廷)

### Emperor (皇上)
- **Speech**: Formal, uses "朕" (royal we), measured pace
- **Traits**: Wise but constrained by tradition, seeks truth, values loyalty
- **Sample dialogue**: "朕听闻此事，心中甚慰。卿且细细道来。"
- **Conflict potential**: Wants reform but faces court opposition

### Empress (皇后)
- **Speech**: Elegant, diplomatic, uses "本宫"
- **Traits**: Intelligent, patient, protective of the harem's peace
- **Sample dialogue**: "本宫素来不问朝政，但这后宫之事，还需本宫做主。"
- **Conflict potential**: Balances power between factions

### Imperial Consort (贵妃)
- **Speech**: Sweet surface, sharp undertones
- **Traits**: Ambitious, calculating, jealous of rivals
- **Sample dialogue**: "妹妹初来乍到，姐姐自当多多关照。"
- **Conflict potential**: Main antagonist, schemes for power

### Guard Captain (侍卫统领)
- **Speech**: Curt, military precision, says little
- **Traits**: Loyal, honorable, secretly romantic
- **Sample dialogue**: "末将职责所在。" / "别怕，有我在。"
- **Romantic arc**: Stone-faced → protective → confession

### Court Official (官员)
- **Speech**: Verbose, political, uses honorifics
- **Traits**: Either corrupt (antagonist) or righteous (ally)
- **Sample dialogue (corrupt)**: "大人明鉴，下官一心为国..."
- **Sample dialogue (righteous)**: "微臣斗胆直言，此事恐有蹊跷。"

### Palace Maid (宫女)
- **Speech**: Deferential, uses "奴婢"
- **Traits**: Observant, either loyal friend or potential spy
- **Sample dialogue**: "奴婢不敢，只是听闻..."
- **Story role**: Information source, ally or betrayer

### Mysterious Sage (高人/道士)
- **Speech**: Cryptic, philosophical, speaks in riddles
- **Traits**: Sees through protagonist's secret, provides guidance
- **Sample dialogue**: "天机不可泄露，但姑娘既有慧根，自能悟出真谛。"
- **Story role**: Explains fantasy elements, provides artifacts

## Modern Setting (现代)

### CEO/Boss
- **Speech**: Direct, time-conscious, business jargon
- **Traits**: Competent, possibly cold exterior with hidden depths
- **Romantic arc**: Professional distance → respect → attraction

### Best Friend
- **Speech**: Casual, supportive, uses slang
- **Traits**: Loyal, comic relief, gives advice
- **Story role**: Confidant, grounds protagonist

### Rival
- **Speech**: Polished, competitive undertones
- **Traits**: Capable, jealous, may reform or escalate
- **Conflict potential**: Professional competition, romantic triangle

## Fantasy Setting (玄幻)

### Sect Master
- **Speech**: Archaic, formal, uses cultivation terms
- **Traits**: Powerful, enigmatic, tests the protagonist
- **Sample dialogue**: "此子根骨奇特，收入门下也未尝不可。"

### Spirit/Immortal
- **Speech**: Detached, timeless perspective
- **Traits**: Bound by cosmic rules, offers cryptic help
- **Sample dialogue**: "凡人之身，竟有如此灵力，有趣..."

### Demon/Villain
- **Speech**: Menacing, contemptuous of mortals
- **Traits**: Powerful, has reasons for villainy
- **Sample dialogue**: "区区凡人，也敢与本座为敌？"

## Creating Romantic Tension

### First Meeting
- Physical detail noticed (eyes, voice, presence)
- Unexpected circumstance (rescue, collision, misunderstanding)
- One line that echoes throughout: "别怕" / "我会记住你的"

### Building Connection
- Shared danger creates trust
- Small acts of care (protection, gifts, attention)
- Misunderstandings that create longing

### Confession Formula
1. Vulnerability moment (injury, revelation, crisis)
2. Callback to first meeting
3. Simple, direct declaration
4. Physical gesture (embrace, hand-holding, forehead touch)

## Tech-as-Magic Substitutions

| Modern Tech | Ancient Disguise | Story Use |
|-------------|------------------|-----------|
| Smartphone | 照妖镜/神镜 | Recording, light, evidence |
| Flashbang | 天雷/闪光符 | Escape, surprise attack |
| Taser | 电击护身符 | Self-defense |
| Walkie-talkie | 传音玉 | Communication |
| Chemistry | 炼丹术 | Poison detection, healing |
| First aid | 仙术/奇门医术 | Healing knowledge |
| Psychology | 读心术/察言观色 | Understanding people |
