# Poetry and Lyrics Pairings

Ancient Chinese poetry paired with modern song lyrics for thematic resonance.

## By Theme

### Awakening / New Beginnings (觉醒/开始)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 李清照《如梦令》"昨夜雨疏风骤，浓睡不消残酒" | 《起风了》"我曾难自拔于世界之大" | Transmigration, waking in new world |
| 苏轼《定风波》"莫听穿林打叶声，何妨吟啸且徐行" | 《平凡之路》"我曾经跨过山和大海" | Accepting new reality |
| 王维《终南别业》"行到水穷处，坐看云起时" | 《追梦赤子心》"充满鲜花的世界到底在哪里" | Hope amid uncertainty |

### First Meeting / Fate (初遇/缘分)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 王维《相思》"红豆生南国，春来发几枝" | 《遇见》"听见冬天的离开" | Destined encounter |
| 李商隐《无题》"身无彩凤双飞翼，心有灵犀一点通" | 《小幸运》"我听见雨滴落在青青草地" | Instant connection |
| 纳兰性德《木兰词》"人生若只如初见，何事秋风悲画扇" | 《后来》"后来我总算学会了如何去爱" | Bittersweet meeting |

### Struggle / Perseverance (奋斗/坚持)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 李白《行路难》"长风破浪会有时，直挂云帆济沧海" | 《孤勇者》"谁说站在光里的才算英雄" | Overcoming obstacles |
| 辛弃疾《破阵子》"醉里挑灯看剑，梦回吹角连营" | 《倔强》"逆风的方向更适合飞翔" | Preparing for battle |
| 文天祥《过零丁洋》"人生自古谁无死？留取丹心照汗青" | 《光》"也许会有那么一束光" | Sacrifice, courage |

### Longing / Separation (思念/离别)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 苏轼《江城子》"夜来幽梦忽还乡" | 《夜空中最亮的星》"每当我找不到存在的意义" | Missing home/past |
| 柳永《雨霖铃》"执手相看泪眼，竟无语凝噎" | 《匆匆那年》"匆匆那年我们究竟说了几遍再见" | Parting moment |
| 李煜《虞美人》"春花秋月何时了？往事知多少" | 《光年之外》"感受停在我发端的指尖" | Nostalgia, loss |

### Love Confession (告白/爱情)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 秦观《鹊桥仙》"两情若是久长时，又岂在朝朝暮暮" | 《明月几时有》"但愿人长久，千里共婵娟" | Declaration of love |
| 白居易《长恨歌》"在天愿作比翼鸟，在地愿为连理枝" | 《爱的就是你》"就是喜欢你" | Wedding, union |
| 元稹《离思》"曾经沧海难为水，除却巫山不是云" | 《最浪漫的事》"我能想到最浪漫的事" | Eternal devotion |

### Victory / Achievement (胜利/成就)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 岳飞《满江红》"壮志饥餐胡虏肉，笑谈渴饮匈奴血" | 《沧海一声笑》"沧海一声笑，滔滔两岸潮" | Triumph over enemies |
| 王昌龄《从军行》"黄沙百战穿金甲，不破楼兰终不还" | 《我相信》"我相信我就是我" | Mission accomplished |
| 陆游《示儿》"王师北定中原日，家祭无忘告乃翁" | 《年少有为》"假如我年少有为不自卑" | Legacy, recognition |

### Mystery / Supernatural (神秘/玄幻)
| Ancient | Modern | Use for |
|---------|--------|---------|
| 李白《梦游天姥吟留别》"安能摧眉折腰事权贵" | 《大鱼》"怕你飞远去，怕你离我而去" | Spiritual awakening |
| 屈原《离骚》"路漫漫其修远兮，吾将上下而求索" | 《凉凉》"凉凉天意潋滟一身花色" | Cultivation journey |
| 曹操《短歌行》"对酒当歌，人生几何！" | 《江南》"风到这里就是粘，粘住过客的思念" | Philosophical moment |

## By Chapter Position

### Opening Chapters (1-2)
Best choices: Awakening/New Beginnings + First Meeting themes
- Set tone of displacement and hope
- Introduce romantic possibility

### Middle Chapters (3-7)
Best choices: Struggle + Longing themes
- Build tension and obstacles
- Develop relationships through separation/reunion

### Climax Chapters (8-9)
Best choices: Victory + Sacrifice themes
- Epic confrontation
- Character proves worth

### Ending Chapter (10)
Best choices: Love Confession + Eternal themes
- Resolution of romance
- Future-looking closure

## Usage Tips

1. **Opening quote**: Place after chapter title, before main text
2. **Closing quote**: Place after "（第X章完）" marker
3. **Integration**: Reference the poetry's meaning in character dialogue or narration
4. **Contrast**: Ancient poetry for timeless emotions, modern lyrics for protagonist's inner voice
