---
name: novel-development
description:
  Work on novel-specific features including plot engines, character development,
  world-building, timeline management, and GOAP-based story generation. Use when
  implementing narrative systems, character arcs, or story planning tools.
---

# Novel Development

## Quick Reference

- **[Plot Engine](plot-engine.md)** - Story analysis, generation, and hole
  detection
- **[Character Development](character-development.md)** - Character arcs and
  relationship systems
- **[World Building](world-building.md)** - Locations, cultures, and lore
  management
- **[Story Structure](story-structure.md)** - Narrative frameworks and timeline
  management

## When to Use

- Implementing plot analysis or generation systems
- Building character relationship graphs or development tools
- Creating world-building management systems
- Working on timeline or story structure features
- Developing GOAP-based story generation
- Analyzing narrative structures or character arcs

## Core Methodology

- **Narrative Analysis**: Apply story structure theory (three-act, beat sheets,
  hero's journey)
- **Character Modeling**: Use relationship graphs and arc tracking
- **World Consistency**: Maintain coherent lore and location data
- **GOAP Integration**: Leverage goal-oriented action planning for story
  generation
- **Data Validation**: Ensure narrative consistency and logical flow

## Integration

- **architecture-guardian**: Enforce clean architecture for narrative features
- **domain-expert**: Apply domain-driven design to narrative concepts
- **qa-engineer**: Test narrative logic and edge cases
- **performance-engineer**: Optimize large narrative data structures
- **writing-assistant**: Integrate with writing tools and style analysis

## Best Practices

✓ Use type-safe data structures for narrative elements ✓ Maintain referential
integrity between characters, locations, and events ✓ Implement validation for
narrative consistency ✓ Optimize for large story datasets ✓ Provide visual
feedback for complex relationships

## Content Modules

See detailed modules:

- **[Plot Engine](plot-engine.md)**: Analysis, generation, and hole detection
  systems
- **[Character Development](character-development.md)**: Arcs, relationships,
  and evolution
- **[World Building](world-building.md)**: Locations, cultures, and lore
  management
- **[Story Structure](story-structure.md)**: Frameworks and timeline management
- **[GOAP Integration](goap-integration.md)**: AI-driven story generation
