# 小说生成器 v2.0 发布信息

## 📦 包信息
- **包名**: novelgen-v2.0.0.zip
- **版本**: 2.0.0
- **发布时间**: Tue Oct 28 10:56:24 CST 2025
- **包大小**: 204K

## 🆕 v2.0 新增功能

### 核心功能
1. **智能导入设定系统**
   - 自动扫描外部目录
   - AI辅助内容识别和分类
   - 支持多种设定类型

2. **统一API接口**
   - 所有功能统一入口
   - 标准化请求响应格式
   - 支持AI任务集成

3. **章节记忆分析**
   - 自动解析章节内容
   - 生成多维度记忆（情感、行动、关系等）
   - 智能情感权重计算

4. **智能编辑功能**
   - 支持本地和AI辅助编辑
   - 上下文感知更新
   - 多种编辑模式

5. **记忆管理系统**
   - 多维度记忆展示
   - 时间线、关联网络视图
   - 记忆统计和分析

### 技术改进
- 模块化架构设计
- AI集成架构
- 完整的错误处理
- 详细的日志记录
- 标准化的数据格式

## 📋 安装要求

### 系统要求
- Python 3.7+
- Claude Code (推荐)
- 支持的平台: macOS, Linux, Windows

### 安装步骤
1. 解压: `unzip novelgen-v2.0.0.zip`
2. 进入: `cd novelgen`
3. 安装: `./install.sh`
4. 验证: `python3 scripts/unified_api.py --request-json '{"action":"system.status"}'`

## 🚀 快速开始

### 基础使用
```bash
# 查看系统状态
python3 scripts/unified_api.py --request-json '{"action":"system.status"}'

# 显示世界观设定
python3 scripts/settings_display_manager.py --type worldview

# 创建角色
python3 scripts/data_managers/character_manager.py --action create --name "主角"
```

### 高级功能
```bash
# 智能导入设定
python3 scripts/unified_api.py --request-json '{
  "action": "import.from_directory",
  "target_directory": "./materials"
}'

# 分析章节生成记忆
python3 scripts/chapter_memory_analyzer.py --action analyze --chapter 1
python3 scripts/chapter_memory_analyzer.py --action apply --chapter 1

# 智能编辑章节
python3 scripts/unified_api.py --request-json '{
  "action": "chapter.intelligent_edit",
  "chapter_number": 1,
  "edit_request": {
    "content": "新内容",
    "edit_mode": "append"
  }
}'
```

## 📖 文档索引

### 核心文档
- **SKILL.md**: 完整功能介绍
- **USAGE_EXAMPLES.md**: 详细使用示例
- **INSTALLATION.md**: 安装指南
- **CHANGELOG_V2.md**: 更新日志

### 技术文档
- **scripts/**: 所有核心脚本
- **references/**: 参考文档
- **assets/**: 资源文件

## 🎯 使用场景

### 适用人群
- 长篇小说作者
- 系列小说创作者
- 小说工作室
- 个人创作爱好者

### 支持的小说类型
- 科幻小说
- 奇幻小说
- 都市小说
- 历史小说
- 悬疑小说
- 现代小说

## 🔗 相关链接

- 官方文档: USAGE_EXAMPLES.md
- 更新日志: CHANGELOG_V2.md
- 安装指南: INSTALLATION.md
- 技术支持: GitHub Issues

---

🎉 享受创作之旅！
