# Contributing Reference

## Overview

The contributing section provides guidelines for contributing to the Odoo codebase and documentation.

## Structure

The contributing documentation is organized into two main sections:
- **Development** - Code contribution guidelines
- **Documentation** - Documentation contribution guidelines

## Development (`content/contributing/development/`)

Guidelines for contributing code to Odoo.

### Main Topics

**Code contribution process:**
- Workflow for submitting pull requests
- Code review process
- Coding standards and conventions
- Testing requirements

### Key Files
- `development.rst` - Main development contribution guide

### Common Use Cases

**Contributing code:**
1. Read the development contribution guide
2. Follow coding standards
3. Write tests
4. Submit pull request for review

**Getting code approved:**
- Follow the code review process
- Address reviewer feedback
- Ensure tests pass

## Documentation (`content/contributing/documentation/`)

Guidelines for contributing to the Odoo documentation.

### Main Topics

**Documentation contribution process:**
- Writing documentation
- Documentation structure
- RST formatting guidelines
- Translation guidelines

### Key Files
- `documentation.rst` - Main documentation contribution guide
- `install_git.rst` - Git installation for contributors

### Common Use Cases

**Contributing documentation:**
1. Understand the documentation structure
2. Follow RST formatting guidelines
3. Write clear, concise documentation
4. Submit documentation changes

**Translating documentation:**
1. Understand translation workflow
2. Use proper terminology
3. Follow translation guidelines

## General Contributing

### Main Files
- `contributing.rst` - General contributing overview

### Related Information

**Developer documentation** - See `references/developer.md` for development resources

**Community forums:**
- Odoo community forums: https://www.odoo.com/forum

## Search Patterns

### For Code Contribution
- Keywords: "pull request", "PR", "code contribution", "review process"
- Keywords: "coding standards", "conventions", "style guide"
- Keywords: "testing", "test requirements", "unit tests"
- Keywords: "git", "branch", "commit", "workflow"

### For Documentation Contribution
- Keywords: "documentation", "writing docs", "RST"
- Keywords: "translation", "localization", "locale"
- Keywords: "documentation structure", "formatting"
- Keywords: "sphinx", "build docs"

### General
- Keywords: "contribute", "contribution", "guidelines"
- Keywords: "community", "forum", "help"

## File Structure

```
content/contributing/
├── development.rst
├── documentation.rst
├── install_git.rst
├── contributing.rst
├── development/
└── documentation/
```

## Getting Started with Contributions

### As a Developer
1. Set up development environment: See `references/developer.md`
2. Read contribution guidelines: `content/contributing/development.rst`
3. Understand code review process
4. Start with small contributions

### As a Documentation Writer
1. Learn RST syntax
2. Understand documentation structure: See `references/structure.md`
3. Read documentation guidelines: `content/contributing/documentation.rst`
4. Start with improving existing documentation

### As a Translator
1. Understand translation workflow
2. Use proper terminology
3. Follow translation guidelines
4. Contribute to locale-specific documentation

## Related Resources

- **Developer resources**: See `references/developer.md`
- **Documentation structure**: See `references/structure.md`
- **Community**: https://www.odoo.com/forum
