# Legal Reference

## Overview

The legal section contains licensing information, terms of service, and other legal documentation for Odoo.

## Structure

The legal documentation is organized as follows:
- Main legal index file
- Licenses directory
- Terms directory
- Supporting legal files

## Main Files

### Main Legal Documentation
- `legal.rst` - Main legal documentation index
- `cla.rst` - Contributor License Agreement
- `coc.rst` - Code of Conduct
- `licenses.rst` - Licenses information
- `terms.rst` - Terms of service and agreements

## Directories

### Licenses (`content/legal/licenses/`)
- Contains license files for Odoo software

### Terms (`content/legal/terms/`)
- Contains terms of service and user agreements

## Common Use Cases

### Understanding Licensing
- Read `content/legal/licenses.rst` for overview
- Check `content/legal/licenses/` for specific license texts

### Contributor Legal Information
- **CLA**: Contributor License Agreement: `content/legal/cla.rst`
- Required for code contributors

### Community Guidelines
- **Code of Conduct**: `content/legal/coc.rst`
- Expected behavior for community members

### Terms of Service
- Read `content/legal/terms.rst` for general terms
- Check `content/legal/terms/` for specific agreements

## License Types

### Odoo Community Edition
- Free and open-source
- Licensed under GNU LGPLv3
- See: https://github.com/odoo/odoo/blob/master/LICENSE

### Odoo Enterprise Edition
- Shared source
- Commercial license
- More features than Community

## Legal Search Patterns

### Licensing
- Keywords: "license", "LGPL", "GNU", "open source", "commercial"
- Keywords: "Community Edition", "Enterprise Edition"
- Keywords: "proprietary", "source", "copyright"

### Contributor Agreements
- Keywords: "CLA", "Contributor License Agreement"
- Keywords: "contributor", "agreement", "legal contribution"

### Terms & Policies
- Keywords: "terms", "service", "terms of service", "agreement"
- Keywords: "privacy", "data", "GDPR"
- Keywords: "policy", "guidelines", "conduct"

### Compliance
- Keywords: "compliance", "regulation", "audit"
- Keywords: "legal", "law", "regulatory"

## File Structure

```
content/legal/
├── cla.rst
├── coc.rst
├── licenses.rst
├── terms.rst
├── legal.rst
├── img/
├── licenses/
└── terms/
```

## Related Information

- **Odoo Editions**: See `references/administration.md` for Community vs Enterprise differences
- **Contributing**: See `references/contributing.md` for contribution guidelines

## Key Points to Remember

### For Developers
- Review CLA before contributing code
- Understand the difference between Community (LGPLv3) and Enterprise licenses
- Follow code of conduct when participating in the community

### For Users
- Understand the license of the edition you're using
- Review terms of service for online platforms
- Be aware of data privacy policies

### For Businesses
- Understand licensing implications for commercial use
- Review terms for hosting and cloud services
- Consider legal implications of custom modifications
