# 業務ドキュメント作成ガイドライン

## 1. 目的

本ガイドラインは、社内で作成される各種業務ドキュメント（例：リリース手順書、日報記録ルール、業務マニュアル、規程など）の形式を統一し、**誰が見ても理解しやすく、実務に活用しやすいドキュメント**を整備することを目的とする。

---

## 2. 適用範囲

* 開発関連の手順書（リリース、テスト、環境切替 など）
* 運用・管理関連ドキュメント（日報、週報、申請フロー、インシデント対応 など）
* 事務・バックオフィス関連ドキュメント（勤怠処理手順、経費精算手順 など）
* その他、社内で業務を実行するためのドキュメント全般

---

## 3. ドキュメントの基本構成（必須見出し）

すべての業務ドキュメントは、以下の見出しを原則として含めること。

### 3.1 目的

* ドキュメントの意図や存在理由を簡潔に記載する。
* 読者がこのドキュメントを読むべき理由を明確にする。
* 例：「本書はサービスリリースを安全に行うための手順を定める。」
* 例：「本規程は従業員の勤怠管理を適切に行うためのルールを定める。」

### 3.2 適用範囲

* 本ドキュメントがどの業務やどの対象者に適用されるかを明確にする。
* 対象システム、対象業務、対象者（部門、役職）を明記する。
* 例：「本手順書は本番環境へのリリースを実施するすべての開発者に適用される。」
* 例：「本マニュアルは経理部門の経費処理担当者に適用される。」

### 3.3 責任と役割

* 実施者・確認者・承認者を明示する。
* RACI マトリックス（Responsible, Accountable, Consulted, Informed）の使用を推奨。
* 例：
  - **実施者**：開発担当者
  - **確認者**：リーダー、QA担当
  - **承認者**：プロジェクトマネージャー
  - **報告先**：運用チーム

### 3.4 手順・ルール

* 業務を遂行するための手順を順序立てて記載する。
* 番号付きリストを使用し、各ステップを明確にする。
* 表やフローチャート、チェックリストの活用を推奨。
* 各手順には以下を含めることが望ましい：
  - 何をするのか（アクション）
  - なぜそれをするのか（理由・目的）
  - どのように確認するのか（検証方法）

**手順記載の例：**

```markdown
1. コードレビューの実施
   - すべてのプルリクエストに対してレビューを実施する
   - 最低1名のレビュアーによる承認が必要
   - チェック項目：コーディング規約準拠、テストカバレッジ確認

2. マージとビルド
   - レビュー承認後、mainブランチにマージする
   - CI/CDパイプラインで自動ビルドが実行されることを確認
   - ビルド失敗時は即座にロールバック手順を開始

3. デプロイ実行
   - ステージング環境での検証完了後にデプロイ
   - デプロイ時間帯：平日19:00-21:00（業務時間外）
   - デプロイ責任者がSlackでデプロイ開始を通知
```

### 3.5 例外・注意点（必要に応じて）

* よくあるエラーや例外ケースと、その対応策を記載する。
* 特殊なケースや緊急時の対応手順を明記する。
* トラブルシューティング情報を含める。

**記載例：**

```markdown
**例外ケース：**
- 緊急リリースの場合、承認フローを簡略化し、事後報告を許可する
- システム障害発生時は、インシデント対応手順書（INC-001）に従う

**よくあるエラー：**
- デプロイ失敗：ロールバックスクリプトを実行（scripts/rollback.sh）
- 環境変数未設定：.env.example を参照し、必要な変数を設定
```

### 3.6 関連ドキュメント・参照先

* 関連するマニュアル、規程、外部資料などをリンクまたは記載する。
* 他のドキュメントとの依存関係を明確にする。

**記載例：**

```markdown
- [コーディング規約](./coding-standards.md)
- [インシデント対応手順](./incident-response.md)
- [AWS デプロイガイド](https://docs.aws.amazon.com/...)
```

### 3.7 改訂履歴

* 改訂日・改訂者・変更内容を必ず残す。
* バージョン番号または改訂日で管理する。
* 変更理由も簡潔に記載する。

**記載例：**

```markdown
| 改訂日     | 改訂者 | バージョン | 変更内容                           |
|------------|--------|------------|------------------------------------|
| 2025/10/01 | 山田   | 1.0        | 初版作成                           |
| 2025/11/15 | 佐藤   | 1.1        | デプロイ時間帯の変更を反映         |
| 2026/01/10 | 鈴木   | 2.0        | 緊急リリース手順を追加             |
```

---

## 4. 書式・表記ルール

### 4.1 見出し番号

* 階層的に番号を付与する：1 → 1.1 → 1.1.1
* 見出しレベルに応じてMarkdownの `#`, `##`, `###` を使用

### 4.2 表現方法

* **断定的に記載する**：「〜すること」「〜しなければならない」
* **曖昧表現を避ける**：「なるべく」「できれば」「たぶん」などは使用しない
* **能動態を使用する**：「確認される」→「確認する」
* **明確な動詞を使う**：「実施する」「承認する」「報告する」

**良い例：**
- ✅ 「リーダーは必ずレビューを実施すること」
- ✅ 「デプロイ前に必ずバックアップを取得する」

**悪い例：**
- ❌ 「できればレビューをしてください」
- ❌ 「なるべくバックアップを取るようにする」

### 4.3 書式統一

* **日付形式**：西暦（YYYY/MM/DD）または ISO 8601（YYYY-MM-DD）
* **時刻形式**：24時間表記（HH:MM）
* **人名・役職**：正式名称を用いる
* **略語**：初出時に正式名称を記載（例：SOP (Standard Operating Procedure)）

### 4.4 視認性の向上

* **手順は番号付きリスト**で整理する
* **チェックリスト**を活用する（□ または - [ ]）
* **図や表**には必ずタイトル・番号を付ける
* **重要な注意事項**は強調表示（太字、警告ブロック）

**チェックリスト例：**

```markdown
## リリース前チェックリスト

- [ ] コードレビュー完了
- [ ] ユニットテスト全件パス
- [ ] ステージング環境での検証完了
- [ ] バックアップ取得完了
- [ ] 関係者への事前通知完了
```

---

## 5. ドキュメント管理ルール

### 5.1 版管理

* 各ドキュメントはバージョン番号または改訂日で管理する
* メジャー変更時：バージョン番号を 1.0 → 2.0
* マイナー変更時：バージョン番号を 1.0 → 1.1
* Git などのバージョン管理システムの使用を推奨

### 5.2 承認フロー

* **作成者** → **部門責任者** → **必要に応じて管理部門**が承認
* 承認者の署名または承認記録を残す
* 重要度の高いドキュメントは複数人のレビューを必須とする

### 5.3 公開方法

* 最新版は社内ポータルまたはドキュメント管理ツールで共有する
* 古いバージョンはアーカイブとして保管
* アクセス権限を適切に設定（部門限定、全社公開など）

### 5.4 定期見直し

* 少なくとも年1回は内容の有効性を確認し、更新する
* 業務プロセス変更時は速やかにドキュメントを更新
* レビュー実施日を改訂履歴に記録

---

## 6. 付録：テンプレートと記載例

### 6.1 基本テンプレート

```markdown
# [ドキュメントタイトル]

**バージョン:** 1.0  
**最終更新日:** YYYY/MM/DD  
**作成者:** [氏名]  
**承認者:** [氏名]

---

## 1. 目的
（ドキュメントの目的を記載）

## 2. 適用範囲
（対象業務・対象者を記載）

## 3. 責任と役割
（実施者・確認者・承認者を明記）

## 4. 手順・ルール
（業務手順を順序立てて記載）

## 5. 例外・注意点
（例外ケースや注意事項を記載）

## 6. 関連ドキュメント
（関連資料へのリンクを記載）

## 7. 改訂履歴
（変更履歴を記録）
```

### 6.2 各セクションの記載例

以下は各セクションの実践的な記載例です。ドキュメントタイプに応じて適切な形式を選択してください。

#### 「責任と役割」セクションの記載例

**パターンA: 表形式（推奨）**

| 役割         | 担当者/部門        | 責任内容                           |
|--------------|--------------------|------------------------------------|
| 実施者       | 開発担当           | リリース作業の実施                 |
| 確認者       | リーダー           | リリース内容の確認                 |
| 承認者       | PM/管理者          | リリース実施の最終承認             |
| 報告先       | 運用チーム         | リリース結果の報告を受ける         |

**パターンB: 箇条書き（シンプルなケース）**

- **実施者**: 経理担当者（経費データの入力と申請）
- **確認者**: 経理リーダー（申請内容の妥当性確認）
- **承認者**: 部門長（最終承認）

#### 「手順・ルール」セクションの記載例

**リリース手順の例:**

```markdown
### 4.1 事前準備（リリース3日前）
1. リリースノートの作成
2. ステージング環境での最終検証
3. 関係者への事前通知（Slack/メール）

### 4.2 リリース実施（当日 19:00-21:00）
1. バックアップ取得
   ```bash
   ./scripts/backup.sh production
   ```
2. デプロイ実行
   ```bash
   ./scripts/deploy.sh production
   ```
3. 動作確認（ヘルスチェック、主要機能確認）

### 4.3 事後確認
1. エラーログ監視（24時間）
2. 関係者への完了報告
```

**日報記録ルールの例:**

```markdown
### 4.1 記入項目
1. **今日の作業内容**（箇条書き、3-5項目）
2. **進捗状況**（予定に対する達成率％）
3. **課題・相談事項**（あれば記載）
4. **明日の予定**（主要タスク2-3項目）

### 4.2 提出方法
- 記入場所: 社内ポータルの日報フォーム
- 提出期限: 業務終了時（18:00まで）
- 提出先: 直属の上長
```

**インシデント対応手順の例:**

```markdown
### 4.1 検知・初動対応（0-5分）
1. インシデントの検知（監視アラート or ユーザー報告）
2. 影響範囲の確認（全体 or 一部機能）
3. 対応チャネルの開設（Slack #incident）

### 4.2 エスカレーション（5-15分）
- レベル1: 担当者が対応（復旧見込み30分以内）
- レベル2: チームリーダーに報告（復旧見込み1時間以内）
- レベル3: マネージャーに報告（復旧見込み1時間以上）

### 4.3 復旧作業
1. 原因の特定
2. 修正作業の実施
3. 動作確認
4. 関係者への報告
```

#### 「例外・注意点」セクションの記載例

**トラブルシューティング形式:**

```markdown
### 5.1 よくあるエラーと対処法

**エラー: デプロイ失敗（exit code 1）**
- 原因: 環境変数の未設定
- 対処: `.env.example` を参照し、必要な変数を `.env` に設定

**エラー: データベース接続エラー**
- 原因: 接続数の上限超過
- 対処: `scripts/restart-db-pool.sh` を実行してコネクションプールをリセット
```

**例外ケース形式:**

```markdown
### 5.1 例外ケース

**緊急リリースの場合:**
- 承認フローを簡略化（PM承認のみで実施可）
- リリース後24時間以内に正式報告書を提出

**営業時間中の緊急対応:**
- 顧客への事前通知なしで実施可
- 対応完了後、影響を受けた顧客に個別連絡
```

#### 「関連ドキュメント」セクションの記載例

```markdown
## 6. 関連ドキュメント

**社内資料:**
- [コーディング規約](./coding-standards.md)
- [テスト手順書](./testing-procedures.md)
- [インシデント対応手順](./incident-response.md)

**外部リソース:**
- [AWS デプロイベストプラクティス](https://docs.aws.amazon.com/...)
- [Docker 公式ドキュメント](https://docs.docker.com/)

**関連システム:**
- Slack チャンネル: #dev-releases
- 監視ダッシュボード: https://monitoring.company.com
```

---

## 7. よくある質問（FAQ）

### Q1: どの程度詳細に記載すべきか？

**A:** 業務未経験者が読んでも実施できるレベルの詳細度を目指す。ただし、専門知識が前提となる場合は、その前提を「適用範囲」に明記する。

### Q2: 図やフローチャートは必須か？

**A:** 必須ではないが、複雑な手順や分岐がある場合は視覚的な説明を強く推奨する。

### Q3: 改訂履歴はどこまで残すべきか？

**A:** 原則としてすべての改訂を記録する。古い改訂はアーカイブとして別ファイルに移動してもよい。

---

**このガイドラインに従い、統一された高品質な業務ドキュメントを作成してください。**
