# 出力フォーマット

## フォーマットテンプレート

```markdown
# X投稿最適化結果

**生成日時**: YYYY-MM-DD HH:MM:SS

---

## 原稿分析
- 核となるメッセージ: [...]
- ターゲット読者: [...]
- キーポイント: [...]

## パターン1: 短文投稿（140字）
[生成された投稿内容]

**推奨ハッシュタグ**: #xxx #yyy #zzz
**画像アイデア**: [...]
**投稿時間帯**: [...]
**期待効果**: [...]

## パターン2: スレッド投稿
### 1つ目のツイート
[内容]

### 2つ目のツイート
[内容]

[...]

**推奨ハッシュタグ**: #xxx #yyy #zzz
**画像アイデア**: [...]
**投稿時間帯**: [...]
**期待効果**: [...]

## パターン3: 長文投稿
[生成された投稿内容]

**推奨ハッシュタグ**: #xxx #yyy #zzz
**画像アイデア**: [...]
**投稿時間帯**: [...]
**期待効果**: [...]

## 改善提案とA/Bテスト案
[...]
```

## 各パターンの特徴

### パターン1: 短文投稿（140字）
- **目的**: 渾身の1ツイートでインパクトを与える
- **特徴**:
  - 140字以内
  - インパクトのある1行目
  - ハッシュタグ3〜5個
  - 絵文字2〜3個
- **適用シーン**: 速報性の高い情報、シンプルなメッセージ

### パターン2: スレッド投稿
- **目的**: 段階的に情報を伝え、滞在時間を最大化
- **特徴**:
  - 各ツイート140字程度
  - 3〜5ツイートで構成
  - 1つ目に『』でタイトル
  - 最初のツイートにハッシュタグ
- **適用シーン**: ステップバイステップの説明、ストーリー性のある内容

### パターン3: 長文投稿
- **目的**: 詳細な情報提供で保存価値を高める
- **特徴**:
  - 1000〜3000字程度
  - 段落・見出し・箇条書き活用
  - ハッシュタグは末尾
- **適用シーン**: 技術解説、詳細なレビュー、ノウハウ共有
