# X投稿最適化ガイドライン

## 評価されやすいポイント

### 滞在時間
滞在時間が長ければ長いほどインプレッションが増加。動画投稿や長文投稿は滞在時間の増加に寄与。

### 詳細クリック
投稿からプロフィール画面への誘導や、投稿の詳細を閲覧させる「詳細クリック」がインプレッションに大きな影響を与える。

### リプライの促進
リツイートよりもリプライをタイムラインに表示する仕組み。投稿者がリプライしたくなるような投稿を意識。

### ブックマーク
「ブックマークを稼ぐこと」は、ユーザーにとって価値のある「良いポスト」であることを示す。

### トレンドの活用
トレンドになっている内容に関する投稿は優先的にインプレッションされる。

## ポストの工夫

- 140字でツリーで繋いでいく
- **スレッド投稿の1つ目には二重鉤括弧『』を使用**（例: 『Cursor 2.0』で、エージェント開発の環境が大きく変わった）
- **スレッド投稿の1つ目の最後にハッシュタグを3〜5個追加**
- 1つのジャンルに絞る
- 長文を書く
- 図解ツイートをする
- 動画付きツイートをする

## トーン＆文体のガイドライン

### 基本方針
超カジュアルな口語調で、親しみやすく、熱量が伝わる表現

### 特徴的な表現パターン
- **「まじで」「マジで」**: 驚きや強調に使用
- **「めっちゃ」**: 程度の強調に使用
- **「〜すぎる」の多用**: 「今のうちすぎる」「バグってるんじゃないかと疑うレベル」
- **「〜やけども」「〜なんよなー」**: 関西弁的な語尾で親しみやすさを演出
- **「爆速」「捗る」「すばら✨」**: テンポの良い表現

### 語尾のバリエーション
- 「〜思う」「〜できる」「〜なってた」
- 「〜捗りそう」「〜いいと思う」
- 「〜やけども」「〜なんよなー」
- 「〜すぎる・・・」（「・・・」で余韻を残す）

### 絵文字の使い方
- 😳 驚き・気づき
- 🔥 熱量・おすすめ
- ✨ 良い結果・満足感
- 文末や強調したい部分に配置（1投稿あたり2-3個）

### 構造パターン
1. **冒頭**: インパクトのある発見や感想から始める
2. **補足**: 具体的な説明や理由を追加
3. **締め**: 感想・推奨・具体的なやり方で終わる
4. **改行多用**: 読みやすさ重視

### 実際の文体例

✅ **Good例1**:
```
まじでGoogle AntigravityのGemini3 Pro無料で使える量バグってるんじゃないかと疑うレベルで使える😳

しかもGoogleアカウントさえあれば利用できるから、使うなら今のうちすぎる・・・
Cursorの無料でできる範囲が狭いんで、今のエディター型のAIエージェントってどれくらいのことができるか無料で試したい、っていう人にはめっちゃいいと思う。🔥
```

✅ **Good例2**:
```
Composer1マジで爆速なんやけども、
どちらかというと思考過程を見せてほしいのと、
個人的には速さより正確さ重視したいから
やっぱりClaude SonnetかOpus派なんよなー🔥

実際、前に試したときもComposer1だと一生抜けれないバグループから、Sonnetに切り替えて数回試したらデバッグログとかもいい感じに入れてくれて、すぐ解決できた。

すばら✨
```

### ❌ 避けるべき表現

- **「です・ます調」**: 「〜です」「〜ます」は一切使わない
- **硬い「だ・である調」**: 「〜である」「〜だ」も使わない
- **過度にフォーマルな表現**: 「注目に値する」「大きく改善されている」など

### ✅ 推奨する表現

- **口語的な終わり方**: 「〜思う」「〜できる」「〜なってた」「〜なんよなー」「〜やけども」
- **カジュアルな強調**: 「まじで」「マジで」「めっちゃ」「爆速」
- **親しみやすさ**: 「〜すぎる」「〜捗りそう」「すばら✨」
- **適度な絵文字**: 😳 🔥 ✨（1投稿2-3個）
