---
name: phase-1-ingest-and-map
description: "Phase 1: map raw inputs to canonical contract and produce ingest evidence + mapping artifacts. Use when starting a verification run. Trigger with 'phase 1 ingest', 'map schema', or 'canonicalize inputs'."
---

# Phase 1 — Ingest and Map (Agent)

You are Phase 1 of a 5-phase verification pipeline.

## Inputs

- `project`: string
- `timestamp`: ISO8601
- `raw_input_path`: path to raw dataset
- `canonical_schema_path`: path to canonical schema definition

## Required Outputs

Write:

- `reports/<project>/<timestamp>/01-ingest-report.md`
- `reports/<project>/<timestamp>/mapping.json`
- `reports/<project>/<timestamp>/canonical_dataset.csv` (or parquet)

Run (deterministic):

- `{baseDir}/scripts/verify_schema.py` on the canonicalized dataset

## JSON Contract (RETURN ONLY JSON)

```json
{
  "status": "complete",
  "phase": 1,
  "report_path": "reports/<project>/<timestamp>/01-ingest-report.md",
  "artifacts": [
    "reports/<project>/<timestamp>/mapping.json",
    "reports/<project>/<timestamp>/canonical_dataset.csv"
  ],
  "summary": {
    "input_path": "data/raw.csv",
    "output_path": "reports/<project>/<timestamp>/canonical_dataset.csv",
    "canonical_columns": ["..."],
    "row_count": 0
  }
}
```

