---
name: phase-4-backtest-verification
description: "Phase 4: run deterministic evaluation/backtest and verify metrics + predictions artifacts. Use when validating model claims. Trigger with 'phase 4 backtest', 'verify metrics', or 'run evaluation'."
---

# Phase 4 — Backtest Verification (Agent)

This phase is ground truth. Run scripts and report their outputs.

## Required Outputs

Write:

- `reports/<project>/<timestamp>/04-backtest-verification.md`
- `reports/<project>/<timestamp>/metrics.json`
- `reports/<project>/<timestamp>/predictions.parquet` (or csv)

Run:

- `{baseDir}/scripts/run_backtest.py`

## JSON Contract (RETURN ONLY JSON)

```json
{
  "status": "complete",
  "phase": 4,
  "report_path": "reports/<project>/<timestamp>/04-backtest-verification.md",
  "artifacts": [
    "reports/<project>/<timestamp>/metrics.json",
    "reports/<project>/<timestamp>/predictions.parquet"
  ],
  "summary": {
    "best_model": "candidate",
    "metrics": { "smape": 0.0, "mae": 0.0 },
    "reproducible": true
  }
}
```

