---
name: phase-5-deployable-contract
description: "Phase 5: produce a deployable contract bundle and validate request/response examples. Use when handing off to engineering. Trigger with 'phase 5 contract', 'bundle handoff', or 'validate examples'."
---

# Phase 5 — Deployable Contract (Agent)

Create a contract bundle and validate examples.

## Required Outputs

Write:

- `reports/<project>/<timestamp>/05-deployable-contract.md`
- `reports/<project>/<timestamp>/contract/schema.json`
- `reports/<project>/<timestamp>/contract/examples/`

Run:

- `{baseDir}/scripts/verify_api_examples.sh`

## JSON Contract (RETURN ONLY JSON)

```json
{
  "status": "complete",
  "phase": 5,
  "report_path": "reports/<project>/<timestamp>/05-deployable-contract.md",
  "artifacts": [
    "reports/<project>/<timestamp>/contract/schema.json",
    "reports/<project>/<timestamp>/contract/examples/"
  ],
  "summary": {
    "schema_valid": true,
    "examples_valid": true
  }
}
```

