#!/usr/bin/env bash
set -euo pipefail

schema="${1:-}"
examples_dir="${2:-}"

if [ -z "$schema" ] || [ -z "$examples_dir" ]; then
  echo "Usage: verify_api_examples.sh <schema.json> <examples_dir>"
  exit 2
fi

if [ ! -f "$schema" ]; then
  echo "ERROR: missing schema: $schema"
  exit 1
fi

if [ ! -d "$examples_dir" ]; then
  echo "ERROR: missing examples dir: $examples_dir"
  exit 1
fi

# Minimal placeholder validation:
# - ensure JSON parses for each example
for f in "$examples_dir"/*.json; do
  [ -f "$f" ] || continue
  jq empty "$f" >/dev/null
done

echo "OK: examples parse as JSON (schema validation TODO)"

