# Preshipping Groups Reference

Complete list of entitlement groups provisioned for preshipping environments.

## Group Categories

### Core User Groups

| Group | Purpose |
|-------|---------|
| `users@{partition}.{domain}` | Base platform access |
| `users.datalake.ops@{partition}.{domain}` | Data lake operations |
| `users.datalake.admin@{partition}.{domain}` | Data lake administration |
| `users.datalake.admins@{partition}.{domain}` | Data lake admins group |

### Data Ownership

| Group | Purpose |
|-------|---------|
| `data.default.owner@{partition}.{domain}` | Default data record ownership |
| `data.wellbore.owner@{partition}.{domain}` | Wellbore data ownership |

### SDMS (Seismic Data Management)

| Group | Purpose |
|-------|---------|
| `data.sdms.opendes.autotest.524e8fe2-184b-48c0-8a2f-e3b60bff1938.admin@{partition}.{domain}` | SDMS autotest admin (specific tenant) |
| `data.sdms.opendes.acl.test.admin@{partition}.{domain}` | SDMS ACL testing admin |
| `data.sdms.opendes.autotest.viewer@{partition}.{domain}` | SDMS autotest viewer |
| `data.sdms.opendes.autotest.admin@{partition}.{domain}` | SDMS autotest admin |
| `data.tgs.poc.viewers@{partition}.{domain}` | TGS POC data viewers |

### Secret Service

| Group | Purpose |
|-------|---------|
| `service.secret.admin@{partition}.{domain}` | Manage secrets |
| `service.secret.viewer@{partition}.{domain}` | View secrets |
| `service.secret.editor@{partition}.{domain}` | Edit secrets |

### Search Service

| Group | Purpose |
|-------|---------|
| `service.search.admin@{partition}.{domain}` | Search service administration |
| `service.search.user@{partition}.{domain}` | Search service usage |

### Delivery Service

| Group | Purpose |
|-------|---------|
| `service.delivery.viewer@{partition}.{domain}` | View delivery data |

### Reservoir DMS

| Group | Purpose |
|-------|---------|
| `service.reservoir-dms.viewers@{partition}.{domain}` | View reservoir data |
| `service.reservoir-dms.owners@{partition}.{domain}` | Own reservoir data |

### Seismic

| Group | Purpose |
|-------|---------|
| `seismic.default.viewers@{partition}.{domain}` | View seismic data |
| `seismic.default.admins@{partition}.{domain}` | Administer seismic data |
| `seismic_default_viewers@{partition}.{domain}` | View seismic (legacy naming) |
| `seismic_default_admins@{partition}.{domain}` | Admin seismic (legacy naming) |
| `seistore.system.admin@{partition}.{domain}` | Seistore system administration |

## Default Configuration

- **Role**: All users are added as `OWNER` (can manage group membership)
- **Partition**: From `AI_OSDU_DATA_PARTITION` environment variable
- **Domain**: From config file (default: `contoso.com`)

## Customization

To modify the group list, edit:
```
skills/osdu-preshipping/config/groups.json
```

The JSON structure supports:
- `name`: Group name prefix (without `@{partition}.{domain}`)
- `description`: Human-readable purpose
- `default_role`: Override role for all groups (default: `OWNER`)
- `domain`: Override domain suffix
