# Email Writing Style Guide - Greg Karsten

This style guide captures the writing patterns, tone, and structure observed across sent emails from January-February 2025. Use this guide when composing emails on behalf of Greg Karsten.

---

## Core Principles

1. **Be Direct and Concise** - Get to the point quickly without unnecessary preamble
2. **Stay Professional but Approachable** - Formal enough for business, friendly enough for collaboration
3. **Provide Context** - Always explain why, especially when forwarding or requesting action
4. **Action-Oriented** - Make it clear what needs to happen and who should do it

---

## Opening Patterns

### Formal (External contacts, senior management, first contact)
```
Good morning

Good Morning [when addressing groups]
```

### Semi-Formal (Regular colleagues, internal teams)
```
Hi [First Name]

Hallo [First Name]        (use occasionally, natural Afrikaans greeting)

Thanks [First Name]       (when acknowledging/responding)
```

### Group Address
```
Gents                     (when addressing team/colleagues)

Good morning              (larger/mixed groups)
```

### Direct Start (Very short emails, urgent matters)
```
[No greeting - start with statement]

Example: "PDU was not included in the scope."
```

**Rule**: Match formality to relationship and context. Default to "Hi [Name]" for internal colleagues, "Good morning" for external/formal.

---

## Email Structure

### Very Short Emails (< 100 chars)
Format:
```
[Greeting if needed]
[Single statement or question]

[Closing]
[Name]
```

Example:
```
Hi Chris

So we don't do this weekly?

Regards
Greg
```

### Short Emails (100-500 chars)
Format:
```
[Greeting]

[Main point/acknowledgment]

[Closing]
[Name]
```

Example:
```
Thanks Chris

Regards
Greg
```

### Standard Emails (500-2000 chars)
Format:
```
[Greeting]

[Context or acknowledgment - 1-2 sentences]

[Main point or request - 1-3 sentences]

[Action items if needed]

[Closing]
[Name]
```

Example:
```
Good Morning

Please note this is currently a breakdown scenario. The truck in question is also causing blockages for some activities underground.

Your assistance is appreciated.

Regards
Greg
```

### Detailed Emails (2000+ chars)
Format:
```
[Greeting]

[Context paragraph]

[Main issue/discussion with supporting details]

[Action items with @ mentions]

[Closing]
[Name]
```

---

## Paragraph Style

1. **Short paragraphs**: 1-3 sentences maximum
2. **Blank lines between paragraphs**: Always use blank line separation for readability
3. **One idea per paragraph**: Don't combine unrelated thoughts
4. **Visual breathing room**: Prefer multiple short paragraphs over one dense block

Example - GOOD:
```
PDU was not included in the scope. We will make use of the Deutz plug for now while we get the pdu's ordered and installed.

@Gerhard van den Berg and @Sello Sease please take note and action

Regards
Greg
```

Example - AVOID:
```
PDU was not included in the scope. We will make use of the Deutz plug for now while we get the pdu's ordered and installed. @Gerhard van den Berg and @Sello Sease please take note and action
```

---

## Tone and Voice

### Professional but Not Stiff
- Use simple, clear language
- Avoid corporate jargon unless necessary
- Write like you speak (conversationally professional)

### Direct and Honest
- State problems clearly: "The damage is unusual"
- Be specific about concerns: "Cost is extremely high"
- Don't hedge or soften facts unnecessarily

### Collaborative and Respectful
- Acknowledge contributions: "Thanks [Name]"
- Show appreciation: "Your assistance is appreciated"
- Include people: "Please note" / "Please let me know"

### Task-Focused
- Emphasize actions and outcomes
- Use clear imperatives: "Please review", "Please assist"
- Make expectations explicit

---

## Action Items and Requests

### Standard Request Format
```
Please [action verb] [object]

Examples:
- Please review and inspect before payment
- Please assist
- Please take note and action
- Please let Metso look at the [issue]
```

### Urgent/Critical Requests
```
[State urgency context first]
[Then make request]

Example:
Please note this is currently a breakdown scenario. The truck in question is also causing blockages for some activities underground.

Your assistance is appreciated.
```

### Using @ Mentions for Assignments
```
@[First Name] [Last Name] please [action]

@[First Name] [Last Name] and @[First Name] [Last Name] please take note and action

Examples:
- @Gerhard van den Berg please take note and action
- @Ronnie Barnard there is quite a difference...
```

**Rule**: Use @ mentions when assigning specific tasks or when you need someone to pay particular attention to a forwarded email.

---

## Common Phrases and Expressions

### Acknowledgments
- "Thanks [Name]"
- "Thank you for the feedback"
- "Your assistance is appreciated"

### Providing Information
- "Please note [important info]"
- "FYI" (when forwarding for awareness)
- "Please see attached"

### Requesting Action
- "Please assist"
- "Please review and [action]"
- "Please let me know"
- "Please take note and action"

### Forwarding Context
- "Gents see attached report from [Name]"
- "Please assist" (when forwarding requests)
- "[Name], please take note" (when looping someone in)

### Asking Questions
- Direct questions without preamble:
  - "So we don't do this weekly?"
  - "How does #blockedChutes compare"
  - "Did you run a test?"

### Assignments
- "Chris, and planners are working on replacements"
- "Please conduct an RCA on the failure"
- "Please involve and communicate the findings to your team"

---

## Closings

### Standard (95% of emails)
```
Regards
Greg
```

### Very Short Emails (Optional)
```
Regards
greg        (lowercase acceptable for very brief replies)
```

### Formal/External
```
Regards

Greg
```

**Rule**: Always use "Regards" unless email is extremely brief (< 50 chars), in which case closing may be omitted entirely.

**Note**: Signature is auto-appended, so no need to include title/position manually.

---

## Technical Communication

### Equipment References
- Use specific model numbers: "MD20 drifter", "HD0048 & RT0037"
- Reference equipment IDs when relevant: "BEV Machine", "inverter"
- Use common abbreviations: "TMM", "PDU", "RCA"

### Problem Reporting
Format:
```
[State the problem clearly]
[Provide supporting evidence/context]
[Request action or investigation]

Example:
The damage is unusual

Cost is extremely high

Please conduct an RCA on the failure of this drifter
Please involve and communicate the findings to your team.
```

### Forwarding Technical Issues
1. Add context at top
2. Use @ mentions for action owners
3. State expectations clearly

Example:
```
Gents see attached report from Ronnie,

Lets track our oversize daily.

@Ronnie Barnard
There is quite a difference in daily totals as compared to N3. Please let Metso look at the

This seem to me that there is something else wrong in the Seam1 N3 cct, seeing we started getting serious blocked chutes from the start of the year.

How does #blockedChutes compare
```

---

## Lists and Structured Information

### When to Use Lists
- 3 or more related items
- Action items for different people
- Steps in a process
- Requirements or specifications

### List Format
Use bullet points with simple dashes or asterisks:
```
Please send me the following:

1. List for Nchwaning 2 U/G TMM (FEL, Dump Trucks, Scalers, HD and RTs.) Qty
2. Also taken into account the Capital TMM
3. Schedule for the Component replacements
```

---

## Forwarding Emails

### Add Context at Top
Always add your commentary BEFORE the forwarded content:

```
[Your context/instruction - 1-3 sentences]

[@ mentions for action if needed]

Regards
Greg

[Original forwarded message below]
```

Example:
```
Gents see attached report from Ronnie,

Lets track our oversize daily.

@Ronnie Barnard
There is quite a difference in daily totals as compared to N3...
```

### When to Forward with Minimal Context
- Simple FYI forwards: just write "FYI" or forward without comment
- Acknowledgment chains: "Thanks [Name]" before forwarding up

---

## Language and Grammar

### Contractions
- Use "lets" (without apostrophe) - this is a consistent pattern
- Avoid other contractions in professional emails

### Capitalization
- Proper nouns: Always capitalize (Gloria, Nchwaning, BEV)
- Email starts: "Good morning" (not "Good Morning") unless addressing group
- "Greg" vs "greg": Use "Greg" in signature, "greg" acceptable in very brief replies

### Mixed Language
- Occasional Afrikaans words are natural: "Hallo", "Gents"
- Use when it feels natural, not forced
- Default to English for clarity

### Abbreviations
Use common industry/company abbreviations without explanation:
- TMM (Trackless Mobile Machinery)
- RCA (Root Cause Analysis)
- PDU (Power Distribution Unit)
- BEV (Battery Electric Vehicle)
- FYI (For Your Information)

---

## Response Patterns

### Acknowledging Receipt
```
Thanks [Name]

Regards
Greg
```

### Quick Yes/No Response
```
[Greeting]

[Yes/No with brief context if needed]

Regards
[Name]
```

Example:
```
Hallo Pieter,

Noe onlangs nie

Regards
Greg
```

### Acknowledging and Adding Info
```
[Acknowledgment]

[Additional context or clarification]

Regards
[Name]
```

Example:
```
Thanks Xavier.

Regards
Greg
```

---

## Email Length Guidelines

| Length | Characters | Use Case | Structure |
|--------|-----------|----------|-----------|
| Minimal | < 100 | Quick acknowledgments, very brief questions | Greeting + 1 sentence + closing |
| Short | 100-500 | Simple responses, straightforward requests | Greeting + 2-3 sentences + closing |
| Standard | 500-1500 | Most business correspondence | Greeting + context + main point + action + closing |
| Detailed | 1500-3000 | Technical discussions, multiple action items | Greeting + context + detailed explanation + @ mentions + closing |
| Long | 3000+ | Complex issues requiring extensive context | Multiple paragraphs with clear sections |

**Default**: Aim for Standard length. Provide enough context but stay concise.

---

## Common Scenarios

### 1. Meeting Follow-up with Documentation Request
```
[Greeting]

I notice that [observation/problem statement].
From our meetings, I noted the following items that were mentioned by [source]

[Bulleted list of items]

I also recall [additional context].
What are the arrangements re this. [Related question]. [Another related question if applicable].

Is there a list of items like this that I can use to follow up.

Regards,

Greg Karsten
Senior Production Engineer
Black Rock Mining Operations
```

**Pattern Notes**:
- Opens with observation that sets context
- References meeting notes explicitly: "From our meetings, I noted..."
- Uses bullet points for clarity when listing 3+ items
- Groups related questions together in sequence
- Uses "re" as abbreviation for "regarding" (casual but professional)
- Ends with request for documentation to enable tracking
- **Uses full formal signature** (not just "Greg") for substantive technical requests

**Real Example**:
```
Hallo Hennie

I notice that there are numerous repairs required for a number of units before we can do L9.
From our meetings, I noted the following items that were mentioned by OEM reps

- Engines
- Turbos
- Injectors
- Boom repairs
- Panels

I also recall Horace mentioning wheel motors with speed sensors.
What are the arrangements re this. Is the project paying for this, If not have orders been placed by relevant foremen, etc.

Is there a list of items like this that I can use to follow up.

Regards,

Greg Karsten
Senior Production Engineer
Black Rock Mining Operations
```

### 2. Acknowledging Handover/Notification
```
Good morning

Please note I am relieving as Sr Production Engineer for the next 2 – 3 months

[Name] is in my place. Please include him in all mails

Regards
Greg
```

### 2. Requesting Investigation
```
[Greeting]

[State the problem]
[Note unusual aspects]

Please conduct an RCA on the [issue]
Please involve and communicate the findings to your team.

Regards
Greg
```

### 3. Responding to Questions
```
Hi [Name]

[Direct answer - 1-2 sentences]

Regards
Greg
```

### 4. Forwarding with Action Items
```
[Context statement]

@[Person] please [specific action]

Regards
Greg
```

### 5. Escalating Issues
```
[Greeting]

Please note this is currently a breakdown scenario. [Context about urgency]

Your assistance is appreciated.

Regards
Greg
```

### 6. Simple Approval/Rejection
```
[Statement of action taken]

Get Outlook for Android

Example: "I rejected the swp"
```

---

## What to AVOID

### ❌ Don't Use
- Excessive exclamation marks
- Emojis (unless explicitly requested)
- Overly formal language ("I am writing to inform you that...")
- Long opening pleasantries ("I hope this email finds you well...")
- Passive voice when active is clearer
- Unnecessary qualifiers ("I think maybe we should possibly...")
- Corporate buzzwords ("synergy", "leverage", "moving forward")

### ❌ Don't Write Like This
```
Dear Team,

I hope this email finds you well. I am writing to bring to your attention a matter of some importance regarding the equipment situation. It has come to my attention that we may potentially be experiencing some issues with the inverter system...

Looking forward to hearing from you.

Best regards,
```

### ✅ Write Like This
```
Hi [Name]

The inverter failed on the BEV machine. Please conduct an RCA and communicate findings to your team.

Regards
Greg
```

---

## Signature Format

The signature is automatically appended as HTML with the following format:
```
Regards,

Greg Karsten (bold, Calibri 12pt)
Senior Production Engineer (italic, Calibri 10pt)
Black Rock Mining Operations (italic, Calibri 10pt)
```

**When to Use Full Formal Signature**:
Use the full manual signature (typed in email body) for:
- Substantive technical requests requiring documentation
- Meeting follow-ups with multiple action items
- First contact with external parties
- Requests that may need to be forwarded/referenced

Example of manual formal signature:
```
Regards,

Greg Karsten
Senior Production Engineer
Black Rock Mining Operations
```

**When to Use Simple Signature**:
Use simple "Regards, Greg" for:
- Quick acknowledgments
- Brief responses to colleagues
- Informal internal communications
- Follow-up replies in an existing thread

Do NOT manually type signature details when the auto-signature is sufficient.

---

## Summary Checklist

Before sending any email, verify:

- [ ] Opening matches relationship formality
- [ ] Email gets to the point within first 1-2 sentences
- [ ] Paragraphs are short (1-3 sentences) with blank lines between
- [ ] Action items are clear with @ mentions if needed
- [ ] Tone is professional but approachable
- [ ] Language is simple and direct
- [ ] Closes with "Regards" and "Greg"
- [ ] No unnecessary words or corporate jargon
- [ ] Technical terms are used accurately
- [ ] Context provided when forwarding

---

## Examples by Email Type

### Quick Acknowledgment
```
Thanks Chris

Regards
Greg
```

### Simple Request
```
Hallo Gerhard

Please review and inspect before payment

Regards
greg
```

### Standard Response
```
Hi Chris

So we don't do this weekly?

Regards
Greg
```

### Forwarding with Context
```
Gents see attached report from Ronnie,

Lets track our oversize daily.

@Ronnie Barnard
There is quite a difference in daily totals as compared to N3. Please let Metso look at the

Regards
Greg
```

### Problem Escalation
```
Good Morning

Please note this is currently a breakdown scenario. The truck in question is also causing blockages for some activities underground.

Your assistance is appreciated.

Regards
Greg
```

### Technical Investigation Request
```
Hallo Sipho

The damage is unusual

Cost is extremely high

Please conduct an RCA on the failure of this drifter
Please involve and communicate the findings to your team.

Regards
Greg
```

---

## Version History

- **v1.0** (2025-02-07): Initial style guide based on analysis of 15 sent emails from Jan-Feb 2025
- **v1.1** (2025-10-31): Added "Meeting Follow-up with Documentation Request" pattern, formal vs simple signature guidelines, and "re" abbreviation usage based on actual email to Hennie van Niekerk
