---
name: paper
description: Use this skill when the user asks to "print markdown", "print document", "pretty print", "paper", "export to print", "markdown to printer", "print conversation", "print chat", or wants to print Claude's output beautifully. Also triggers on Korean commands like "프린트해줘", "뽑아줘", "출력해줘", "인쇄해줘", "마크다운 출력", "문서 뽑기", "예쁘게 출력", "프린터로 보내줘", "대화 프린트", "대화 출력", "대화 뽑기", "채팅 출력", or any Korean request for printing documents or conversations.
version: 1.0.0
---

# Paper - Markdown Print Skill

This skill enables beautiful printing of markdown documents with customizable templates.

## Capabilities

- Convert markdown to styled HTML
- Open OS print dialog for direct printing
- Support multiple templates (B&W friendly, color, minimal)
- Syntax highlighting for code blocks
- **Print Claude Code conversations** with beautiful formatting

## Templates

| Template | Style | Best For |
|----------|-------|----------|
| `default` | Clean, professional | B&W printers, general documents |
| `report` | Colorful, headers/footers | Color printers, formal reports |
| `minimal` | Compact, ink-saving | Draft printing, reference sheets |

## Workflow

### Step 1: Identify the source

Determine what the user wants to print:

1. **Explicit file path** - User provides a `.md` file path
2. **Conversation** - User wants to print Claude Code conversation (`.jsonl` file)
3. **Recent output** - User wants to print Claude's recent markdown output
4. **Unclear** - Ask the user using AskUserQuestion

### Step 2: Select template

Guide template selection based on user's printer or preference:

- **B&W printer** → Recommend `default` or `minimal`
- **Color printer** → Recommend `report`
- **Quick draft** → Recommend `minimal`
- **Formal document** → Recommend `report`

If unclear, ask using AskUserQuestion with these options:
- `default` - Clean document (B&W friendly)
- `report` - Professional report (color)
- `minimal` - Ink-saving (B&W)

### Step 3: Execute print

Run the print command:

**For markdown files:**
```bash
cd ${CLAUDE_PLUGIN_ROOT} && node scripts/paper.mjs "<file_path>" --template <template>
```

**For conversations:**
```bash
# Print the latest conversation
cd ${CLAUDE_PLUGIN_ROOT} && node scripts/paper.mjs --conversation --latest --template <template>

# Print a specific conversation file
cd ${CLAUDE_PLUGIN_ROOT} && node scripts/paper.mjs --conversation "<path_to_jsonl>" --template <template>
```

### Step 4: Inform user

Let user know:
- Browser window will open with print dialog
- They can select printer and adjust settings
- Close browser when done

## Example Conversations

### Direct file print
```
User: Print README.md
Assistant: [Executes /paper README.md]
```

### Template selection
```
User: I want to print this report for a meeting
Assistant: For a formal meeting document, I recommend the 'report' template
which includes headers, page numbers, and professional styling.
[Executes with --template report]
```

### Printer type hint
```
User: Print this on my black and white printer
Assistant: [Executes with --template default or minimal]
```

### Conversation printing (대화 프린트)
```
User: Print our conversation / 대화 프린트해줘
Assistant: [Executes with --conversation --latest]
```

### Specific conversation file
```
User: Print the conversation from ~/.claude/projects/.../00abc123.jsonl
Assistant: [Executes with --conversation "<path>"]
```

## Conversation Printing Feature

Print Claude Code conversations with beautiful formatting:

- **Claudy icon** (🤖) for Claude's messages
- **Developer icon** (👨‍💻) for user messages
- Markdown rendering for all message content
- Code syntax highlighting preserved
- Tool usage and results displayed clearly

### Conversation File Location

Claude Code stores conversations in:
```
~/.claude/projects/<project_hash>/<session_id>.jsonl
```

Use `--latest` to automatically find the most recent conversation.

## Technical Details

- **Engine**: Playwright (Chromium)
- **Markdown parser**: marked with highlight.js
- **Output**: Direct to OS print dialog
- **Temporary files**: Auto-cleaned after printing
