---
name: paper-structure
description: Paper structure, LaTeX conventions, and citation format for this research project
allowed-tools: Read, Grep, Glob
---

# Paper Structure

## Current Paper

- Title: [Paper Title]
- Target Venue: [Conference/Journal]
- Deadline: [Submission Deadline]
- Page Limit: [e.g., 8 pages + references]

## Document Structure

```
paper/
├── main.tex           # Main document
├── sections/
│   ├── 01-intro.tex
│   ├── 02-related.tex
│   ├── 03-method.tex
│   ├── 04-experiments.tex
│   └── 05-conclusion.tex
├── figures/
├── tables/
└── references.bib
```

## LaTeX Conventions

### Figures

```latex
\begin{figure}[t]
  \centering
  \includegraphics[width=\linewidth]{figures/method.pdf}
  \caption{Our proposed method overview.}
  \label{fig:method}
\end{figure}
```

### Tables

```latex
\begin{table}[t]
  \centering
  \caption{Comparison with baselines.}
  \label{tab:results}
  \begin{tabular}{lcc}
    \toprule
    Method & Accuracy & F1 \\
    \midrule
    Baseline & 0.85 & 0.83 \\
    Ours & \textbf{0.92} & \textbf{0.90} \\
    \bottomrule
  \end{tabular}
\end{table}
```

### Citations

```latex
% Single author
\citet{Smith2023} showed that...
As shown in prior work~\citep{Smith2023}...

% Multiple authors
\citet{Smith2023,Jones2024} demonstrated...
```

## Citation Format

BibTeX entries in `references.bib`:

```bibtex
@inproceedings{Smith2023,
  author    = {John Smith and Jane Doe},
  title     = {A Novel Approach to X},
  booktitle = {Proceedings of ABC 2023},
  year      = {2023},
  pages     = {1--10},
}
```

## Key References

1. [Foundation paper] - Smith et al., 2020
2. [Baseline method] - Jones et al., 2022
3. [Related approach] - Brown et al., 2023

## Reproducibility Checklist

- [ ] Random seeds documented
- [ ] Hyperparameters in appendix
- [ ] Dataset splits specified
- [ ] Code repository linked
- [ ] Compute resources listed
