# 번역 오류 패턴 (Error Patterns)

> **목적**: 반복되는 번역 오류 패턴을 기록하여 사전 방지
> **관리**: Feedback Learner 에이전트가 피드백 기반 업데이트
> **출처**: Style Guide + 실제 번역 피드백

---

## 1. 수량/범위 오역 (Critical)

| 원문 | 잘못된 번역 | 올바른 번역 | 심각도 |
|------|-------------|-------------|--------|
| more than one | 하나 이상 | **둘 이상** / 하나 초과 | Critical |
| less than two | 둘 이하 | **하나 이하** / 둘 미만 | Critical |
| no less than X | X 이하 | **X 이상** / X보다 적지 않은 | Major |
| no more than X | X 이상 | **X 이하** / X를 초과하지 않는 | Major |

**주의**: 수량 범위 오역은 청구항의 기술적 범위를 완전히 변경할 수 있음

---

## 2. 상기(Antecedent Basis) 누락 (Critical)

| 상황 | 잘못된 번역 | 올바른 번역 | 심각도 |
|------|-------------|-------------|--------|
| 두 번째 이후 참조 시 | 화합물이... | **상기** 화합물이... | Critical |
| 정관사 the 무시 | 방법을... | **상기** 방법을... | Major |
| 종속항 참조 | 제1항에서 청구된 시스템 | 제1항에 따른 **상기** 시스템 | Major |

**규칙**:
- 첫 등장: 관사 생략 또는 부정형 (a/an → 생략)
- 이후 참조: 반드시 "상기" 사용 (the → 상기)

---

## 3. 도메인별 용어 혼동 (Major)

| 원문 | 잘못된 번역 | 올바른 번역 | 도메인 | 심각도 |
|------|-------------|-------------|--------|--------|
| substrate | 기판 | **기재** | 화학 | Major |
| substrate | 기재 | **기판** | 전자/반도체 | Major |
| ground | 지면 | **접지** | 전기 | Major |
| cell | 셀 | **세포** | 바이오 | Minor |
| cell | 세포 | **셀** | 전자 | Minor |
| tablet | 정제 | **태블릿** | IT | Minor |

---

## 4. 의학/해부학 용어 오역 (Major)

| 원문 | 잘못된 번역 | 올바른 번역 | 심각도 |
|------|-------------|-------------|--------|
| distal end | 말단 | **원위 단부** | Major |
| proximal end | 말단 | **근위 단부** | Major |
| anterior | 앞쪽 | **전방** / **전측** | Minor |
| posterior | 뒤쪽 | **후방** / **후측** | Minor |
| lateral | 측면 | **외측** | Minor |
| medial | 중간 | **내측** | Minor |

---

## 5. 특허 관용구 오역 (Major)

| 원문 | 잘못된 번역 | 올바른 번역 | 심각도 |
|------|-------------|-------------|--------|
| SEQ ID NO: 1 | 서열 번호: 1 | **서열번호 1** | Major |
| person skilled in the art | 당업자 | **통상의 기술자** | Minor |
| state of the art | 예술의 상태 | **최신 기술** | Major |
| prior art | 이전 기술 | **선행 기술** | Minor |

---

## 6. 구두점 오용 (Minor)

| 상황 | 잘못된 예 | 올바른 예 | 심각도 |
|------|-----------|-----------|--------|
| 콜론 뒤 완전한 문장 | 시스템은 다음을 수행한다: 데이터를... | 시스템이 수행하는 기능은: 데이터... | Minor |
| 불필요한 쉼표 | 상기 화합물은, 실질적으로... | 상기 화합물은 실질적으로... | Neutral |
| 세미콜론 오용 | 제1 단계; 제2 단계 | 제1 단계, 제2 단계 | Minor |

---

## 7. 번역투/직역 (Minor)

| 원문 | 잘못된 번역 | 올바른 번역 | 심각도 |
|------|-------------|-------------|--------|
| It is understood that... | 그것은 이해된다... | ~인 것으로 이해된다 | Minor |
| There is provided... | 그곳에 제공된다... | ~가 제공된다 | Minor |
| It should be noted that... | 그것은 주목되어야 한다... | ~에 주목해야 한다 | Minor |

---

## 8. 청구항 구조 오류 (Major)

| 상황 | 잘못된 예 | 올바른 예 | 심각도 |
|------|-----------|-----------|--------|
| 마침표 중복 | ...포함하는 방법.. | ...포함하는 방법. | Major |
| 명사구 미완결 | ...을 포함한다. | ...을 포함하는 방법. | Critical |
| 서두 형식 오류 | 방법이며, | 방법으로서, | Major |
| 결미 형식 오류 | ...포함한다 방법. | ...포함하는 방법. | Major |

---

## 9. 화학식 처리 오류 (Major)

| 상황 | 잘못된 처리 | 올바른 처리 | 심각도 |
|------|-------------|-------------|--------|
| 화학식 재도입 | 상기 화학식에서... | **상기 식에서**... | Minor |
| 문장 단절 | 화학식 [식] 상기 화합물은 | 하기 화학식의 화합물..., [식] 상기 식에서... | Major |

---

## 패턴 추가 규칙

1. **추가 기준**: 동일 오류 2회 이상 발생 시
2. **심각도 분류**:
   - Critical: 의미 왜곡, 법적 영향, 청구항 무효화 가능
   - Major: 사용자 혼란, 중요 내용 변경
   - Minor: 의미 손실 없음, 스타일/유창성 저하
   - Neutral: 선호도 차이
3. **업데이트**: Feedback Learner가 피드백 분석 후 자동 추가

---

## 최근 업데이트

- 데이터 정제: 불완전한 항목 삭제 (2026-01-16)
- 초기 패턴 구축 (2026-01-10) - Style Guide 기반

---

## 피드백 기반 패턴

<!-- Feedback Learner가 검증된 패턴만 아래에 추가합니다 -->

| 원문 | 수정 | 심각도 | 설명 |
|------|------|--------|------|
| (패턴이 추가되면 여기에 기록됩니다) | | | |