# Feedback Learner 상세 규칙

> 이 파일은 Feedback Learner 에이전트의 상세 규칙을 정의합니다.
> 에이전트 파일: `.claude/agents/feedback-learner.md`

---

## 출력 형식

### 업데이트 보고서

```markdown
# 피드백 반영 보고서
**날짜**: [날짜]
**프로젝트**: [프로젝트명]

## 처리된 피드백

### 1. [피드백 내용 요약]
- **유형**: 용어 수정
- **원문**: substrate
- **기존 번역**: 기판
- **수정 번역**: 기재
- **반영 파일**: terminology-db.md
- **상태**: 완료

## 파일 업데이트 내역

| 파일 | 변경 유형 | 변경 내용 |
|------|-----------|-----------|
| terminology-db.md | 추가 | substrate: 기재 (화학 도메인) |
| error-patterns.md | 추가 | substrate 도메인별 오역 패턴 |
| feedback-log.md | 추가 | 피드백 기록 #N |

## 자동 커밋 (선택적)
- [ ] git add .claude/skills/patent-translator/data/
- [ ] git commit -m "Update: terminology and feedback from [project]"
- [ ] git push
```

---

## 피드백 유형 분류

### 1. 용어 수정 (Terminology Correction)
**트리거**: "~로 번역해줘", "~가 아니라 ~야", "용어가 틀렸어"

**처리**:
1. terminology-db.md에 용어 추가/수정
2. project-tb.md 업데이트
3. 도메인 정보 포함 시 비고란에 기록

### 2. 스타일 선호 (Style Preference)
**트리거**: "이 표현 싫어", "~보다 ~가 좋아", "이게 더 자연스러워"

**처리**:
1. feedback-log.md에 선호도 기록
2. 반복 시 style-guide.md 개선 제안 생성

### 3. 오류 지적 (Error Report)
**트리거**: "오역이야", "상기가 빠졌어", "잘못됐어"

**처리**:
1. 오류 패턴 분석
2. error-patterns.md에 패턴 추가
3. 반복 오류 시 우선순위 높임

### 4. 원문 오류 확인 (Source Error Confirmation)
**트리거**: "원문이 틀렸어", "원문 확인했어", "원문 그대로야"

**처리**:
1. source-error-patterns.md 업데이트
2. Source Analyzer 검출 정확도 피드백

### 5. 승인 (Approval)
**트리거**: "좋아", "이거 완벽해", "이대로 저장해"

**처리**:
1. approved-translations/에 저장
2. 우수 번역 사례로 기록

---

## 프로젝트 TB 업데이트 규칙

### 섹션 완료 후 업데이트
```markdown
## [섹션명] 추가 용어 (섹션 N)
| English | Korean | 첫 등장 | 비고 |
|---------|--------|---------|------|
| [새 용어] | [번역] | [위치] | [비고] |
```

### 중복 제거
- 동일 용어가 이미 존재하면 추가하지 않음
- 번역이 다르면 충돌 보고 (사용자 판단 요청)

### 용어 통합
- 상위 섹션(TAC)의 용어가 우선
- 하위 섹션에서 같은 용어 발견 시 skip

---

## 학습 우선순위

| 우선순위 | 피드백 유형 | 이유 |
|----------|-------------|------|
| 1 | 용어 수정 | 용어 일관성이 특허번역 품질의 핵심 |
| 2 | 오류 지적 | 반복 오류 방지 |
| 3 | 원문 오류 확인 | Source Analyzer 정확도 향상 |
| 4 | 스타일 선호 | 장기적 품질 개선 |
| 5 | 승인 | 참조 자료 축적 |

---

## 자동 학습 규칙

### 패턴 인식
동일 피드백 2회 이상 발생 시:
1. error-patterns.md에 패턴으로 등록
2. 향후 번역 시 사전 경고

### 도메인 학습
특정 도메인의 피드백이 누적되면:
1. 도메인별 용어 섹션 강화
2. 도메인 식별 정확도 향상

### 클라이언트 패턴
동일 클라이언트의 피드백 패턴 분석:
1. 클라이언트 선호 용어 기록
2. 향후 프로젝트에 자동 적용

---

## 승인 번역 저장 형식

`approved-translations/[project-name]-[date].md`

```markdown
# 승인된 번역: [프로젝트명]
**승인일**: [날짜]
**도메인**: [도메인]

## 우수 번역 사례

### 청구항 번역
| 원문 | 번역 | 비고 |
|------|------|------|

### 기술 용어 번역
| 원문 | 번역 | 도메인 | 비고 |
|------|------|--------|------|

### 복잡한 구문 번역
| 원문 | 번역 | 처리 방법 |
|------|------|-----------|
```

---

## Git 연동 (선택적)

피드백 반영 후 자동 커밋 옵션:

```bash
# 데이터 파일만 커밋 (output/ 제외)
git add .claude/skills/patent-translator/data/
git commit -m "Update: terminology and feedback from [project-name]"
git push
```

**주의**: 자동 푸시는 수동 검토 후 실행 권장

---

## 피드백 통계

feedback-log.md의 통계 섹션 자동 업데이트:

| 항목 | 수치 |
|------|------|
| 총 피드백 수 | [N] |
| 용어 수정 | [N] |
| 스타일 선호 | [N] |
| 오류 지적 | [N] |
| 원문 오류 확인 | [N] |
| 승인 | [N] |
