# Translation Reviewer 상세 규칙

> 이 파일은 Translation Reviewer 에이전트의 상세 규칙을 정의합니다.
> 에이전트 파일: `.claude/agents/translation-reviewer.md`

---

## 2단계 검토 시스템

번역 품질 보장을 위해 **기계적 검토**와 **의미적 검토**를 분리합니다.

### 1단계: 기계적 검토 (스크립트)

`scripts/validate-translation.py`가 섹션 파일 생성 시 자동 실행됩니다.

| 검사 항목 | 담당 | 비고 |
|-----------|------|------|
| 참조부호 형식 | 스크립트 | `명사(10)` vs `명사 (10)` |
| 청구항 번호 연속성 | 스크립트 | 1, 2, 3... 누락 검사 |
| 청구항 마침표 종결 | 스크립트 | 마침표로 끝나는지 검사 |
| 서수 형식 | 스크립트 | `제1` vs `첫째` |
| 전환구 일관성 | 스크립트 | comprising → 포함하는 |
| 기본 상기 검사 | 스크립트 | 단순 재등장 누락 |
| 약어 풀이 형식 | 스크립트 | 첫 등장 시 `한국어(English, ABBR)` |
| 숫자-단위 공백 | 스크립트 | `10 mL` vs `10mL` |

**출력**:

- `[MECHANICAL_CHECK_PASSED]`: 의미적 검토 진행
- `[MECHANICAL_CHECK_FAILED]`: 오류 목록 제시, 수정 후 재검사

### 2단계: 의미적 검토 (Translation Reviewer)

기계적 검토 통과 후 에이전트가 수행합니다.

| 검사 항목 | 담당 | 비고 |
|-----------|------|------|
| 의미 정확성 | 에이전트 | 왜곡, 누락, 오역, 첨가 |
| 복잡한 상기 판단 | 에이전트 | 문맥 의존적 판단 필요 |
| 용어 적합성 | 에이전트 | 도메인별 전문 용어 선택 |
| 청구항 어미/구조 | 에이전트 | 법적 의미 보존 |
| 유창성 | 에이전트 | 자연스러운 한국어 |

---

## 출력 형식

### 검토 보고서
`output/[project]/review-report-section-XX.md`

```markdown
# 번역 검토 보고서
**프로젝트**: [프로젝트명]
**섹션**: [섹션명]
**검토일**: [날짜]
**검토 결과**: 통과 / 수정 필요

---

## 점수 요약

| 항목 | 배점 | 점수 | 비고 |
|------|------|------|------|
| 정확성 | 50 | XX | |
| 용어 일관성 | 25 | XX | |
| 스타일 준수 | 15 | XX | |
| 유창성 | 10 | XX | |
| **총점** | **100** | **XX** | |

**결과**: [통과 (95점↑) / 수정 필요 (95점↓)]

---

## 검출된 오류

### Critical 오류 (즉시 수정 필요)
| No. | 위치 | 원문 | 현재 번역 | 문제 | 권장 수정 |
|-----|------|------|-----------|------|-----------|

### Major 오류 (수정 권장)
| No. | 위치 | 원문 | 현재 번역 | 문제 | 권장 수정 |
|-----|------|------|-----------|------|-----------|

### Minor 오류 (선택적 수정)
| No. | 위치 | 원문 | 현재 번역 | 문제 | 권장 수정 |
|-----|------|------|-----------|------|-----------|

---

## 수정 지시 (95점 미만 시)

1. [구체적 수정 지시 1]
2. [구체적 수정 지시 2]

---

## 우수 번역 사례 (피드백용)

| 원문 | 번역 | 비고 |
|------|------|------|
```

---

## 평가 기준

### 1. 정확성 (50점)

| 오류 유형 | 감점 | 예시 |
|-----------|------|------|
| 의미 왜곡 | -10~20 | comprising → 구성되는 (범위 제한) |
| 누락 | -5~15 | 문장 또는 구 누락 |
| 오역 | -5~10 | substrate → 기판 (화학 분야) |
| 첨가 | -3~5 | 원문에 없는 내용 추가 |

### 2. 용어 일관성 (25점)

| 오류 유형 | 감점 | 예시 |
|-----------|------|------|
| 상기 누락 (TAC) | -10 | 상기 화합물 → 화합물 |
| 상기 누락 (Desc) | -5 | |
| 용어 불일치 | -5~10 | 항체-약물 접합체 / ADC 혼용 |
| project-tb.md 미준수 | -3~5 | 확립된 용어와 다른 번역 |

### 3. 스타일 가이드 준수 (15점)

| 오류 유형 | 감점 | 예시 |
|-----------|------|------|
| 청구항 구조 오류 | -5~10 | 명사구 미완결 |
| 구두점 오용 | -1~3 | 불필요한 세미콜론 |
| 서수 형식 오류 | -1 | 첫째 → 제1 |
| 참조부호 형식 오류 | -1~2 | 핸드가드 (12) → 핸드가드(12) |

### 4. 유창성 (10점)

| 오류 유형 | 감점 | 예시 |
|-----------|------|------|
| 비문 | -3~5 | 문법적으로 잘못된 문장 |
| 어색한 표현 | -1~2 | 의미는 통하나 부자연스러움 |
| 번역투 | -1 | 영어 구조 그대로 번역 |

---

## 섹션별 가중치

| 섹션 | 가중치 | 비고 |
|------|--------|------|
| Claims | x1.5 | 법적 효력, 최고 중요도 |
| Abstract | x1.3 | 공개 문서, 높은 중요도 |
| Title | x1.2 | 검색/식별 목적 |
| Background | x1.0 | 표준 |
| Summary | x1.0 | 표준 |
| Drawings | x0.9 | 상대적 낮은 중요도 |
| Detailed Description | x0.9 | 길이 대비 중요도 |

**계산 방식**: 기본 점수 × 가중치 (최대 100점)

---

## 95점 임계값 근거

1. **청구항 무효화 위험**: 사소한 오역도 청구항 해석에 영향
2. **법적 분쟁 가능성**: 특허 침해 소송에서 번역 품질이 쟁점
3. **심사관 거절 사유**: 불명확한 번역은 거절 이유 제공

---

## 검토 절차

### Step 1: 원문-번역문 대조
1. 문장 단위 대조
2. 누락/첨가 확인
3. 의미 정확성 검증

### Step 2: 용어 일관성 검사
1. project-tb.md 대조
2. 상기(antecedent basis) 검사
3. 동일 용어 일관성 검사

### Step 3: 스타일 가이드 검사
1. 청구항 구조 검사 (TAC 섹션)
2. 구두점 규칙 준수 검사
3. 형식 규칙 준수 검사

### Step 4: 점수 산출 및 결과 판정
1. 각 항목별 감점 합산
2. 총점 계산
3. 95점 기준 통과/수정 판정

### Step 5: 보고서 생성
1. 검출된 오류 목록화
2. 수정 지시 작성 (95점 미만 시)
3. 우수 번역 사례 기록

---

## 재검토 규칙

1. **1차 검토 불통과**: Patent Translator에게 수정 지시
2. **2차 검토 불통과**: 구체적 수정안 제시
3. **3차 검토 불통과**: 사용자에게 판단 요청
