# Source Analyzer 상세 규칙

> 이 파일은 Source Analyzer 에이전트의 상세 규칙을 정의합니다.
> 에이전트 파일: `.claude/agents/source-analyzer.md`

---

## 출력 형식

### 1. terminology-analysis.md

```markdown
# 용어 분석 결과
**프로젝트**: [프로젝트명]
**분석 섹션**: [섹션명]
**분석일**: [날짜]

## 도메인 식별
- **주 도메인**: [예: 제약/바이오]
- **부 도메인**: [예: 면역학, ADC]

## 핵심 용어 (번역 확정)
| No. | English | Korean | 첫 등장 | 근거 |
|-----|---------|--------|---------|------|
| 1 | antibody drug conjugate | 항체-약물 접합체 | Claim 1 | terminology-db.md |

## 신규 용어 (번역 제안)
| No. | English | 제안 번역 | 첫 등장 | 대안 |
|-----|---------|-----------|---------|------|
| 1 | MUC1 SEA domain | MUC1 SEA 도메인 | [0012] | - |

## 상기(Antecedent Basis) 추적 대상
| 용어 | 첫 등장 (부정형) | 이후 참조 시 |
|------|------------------|--------------|
| compound | Claim 1 | 상기 화합물 |
```

### 2. source-error-report.md

```markdown
# 원문 오류 보고서
**프로젝트**: [프로젝트명]
**분석일**: [날짜]
**검출된 오류**: [N]건

## 1. 참조부호 불일치 (Critical)
| 위치 | 참조부호 | 문제 | 제안 |
|------|----------|------|------|
| [0023] | 10 | "housing"으로 기술 | 통일 필요 |

## 2. 용어 불일치 (Major)
| 위치 | 용어 A | 용어 B | 비고 |
|------|--------|--------|------|

## 3. 수치 모순 (Major)
| 위치 A | 위치 B | 내용 | 비고 |
|--------|--------|------|------|

---
**번역 시 주의사항**: 위 오류 부분은 번역문에 [원문 오류] 주석으로 표시됨
```

### 3. project-tb.md 초기화 형식

```markdown
# Project Term Base
**프로젝트**: [프로젝트명]
**최종 업데이트**: [날짜] (섹션 1 완료 후)
**총 용어 수**: [N]개

## 핵심 용어 (Title/Abstract/Claims에서 확립)
| English | Korean | 첫 등장 | 비고 |
|---------|--------|---------|------|
| antibody drug conjugate | 항체-약물 접합체 | Claims 1 | ADC |
```

---

## 분석 절차

### Step 1: 섹션 유형 확인
- TAC (Title/Abstract/Claims): 우선 분석, project-tb.md 초기화
- Description: project-tb.md 참조, 신규 용어 추가

### Step 2: 용어 추출
1. 전문 용어 및 기술 용어 추출
2. 참조부호와 연관 명사 매핑
3. 약어 및 두문자어 식별

### Step 3: 기존 DB 대조
1. `terminology-db.md` 검색
2. `project-tb.md` 검색 (있을 경우)
3. 매칭 용어: 기존 번역 채택
4. 미매칭 용어: 번역 제안 생성

### Step 4: 원문 오류 검출
1. 참조부호 일관성 검사
2. 용어 일관성 검사
3. 수치/범위 모순 검사
4. 문법/구문 오류 검사
5. `source-error-patterns.md` 참조

### Step 5: 상기 추적 대상 표시
- 첫 등장 위치 기록
- Patent Translator가 이후 참조 시 "상기" 삽입하도록 안내

---

## 오류 심각도 기준

| 심각도 | 설명 | 예시 |
|--------|------|------|
| Critical | 기술적 내용에 직접 영향 | 참조부호 불일치, 수치 모순 |
| Major | 번역 일관성에 영향 | 용어 불일치, 정의 누락 |
| Minor | 가독성 저하 | 문법 오류, 오타 |

---

## 참조 규칙

1. **용어 우선순위**: 클라이언트 용어집 > project-tb.md > terminology-db.md
2. **원문 오류 처리**: Critical/Major → 반드시 보고서 포함, Minor → [참고] 표시
3. **도메인별 용어**: 동일 용어가 도메인에 따라 다른 번역 가질 경우 도메인 명시
