# 원문 오류 패턴 (Source Error Patterns)

> **목적**: 반복되는 원문(영문) 오류 패턴을 기록하여 Source Analyzer의 검출 정확도 향상
> **관리**: Feedback Learner 에이전트가 실제 검출 결과 기반 업데이트

---

## 1. 참조부호 불일치 (Reference Number Inconsistency)

### 1.1 동일 부호, 다른 명칭
**설명**: 같은 참조부호가 문서 내 다른 용어로 기술됨

| 위치 예시 | 참조부호 | 용어 A | 용어 B | 권장 조치 |
|-----------|----------|--------|--------|-----------|
| [0023] vs [0045] | (10) | housing | casing | 원문 확인 요청 |
| Claim 1 vs [0012] | (20) | connector | coupling | 용어 통일 필요 |

**검출 방법**: 참조부호 추출 후 연관 명사 매핑, 불일치 검출

### 1.2 정의되지 않은 참조부호
**설명**: 도면의 간단한 설명에 정의 없이 명세서에서 사용됨

**패턴 예시**:
- `element (25)` - 도면 설명에서 (25) 정의 없음
- `the connector (30)` - (30)이 어느 도면에도 미등장

**검출 방법**: 도면 설명 섹션에서 참조부호 목록 추출 → 전체 문서에서 사용된 참조부호와 대조

---

## 2. 용어 불일치 (Terminology Inconsistency)

### 2.1 동일 개념, 다른 용어
**설명**: 동일한 개념이 문서 내 다른 용어로 기술됨

| 위치 예시 | 용어 A | 용어 B | 동일 개념 여부 | 심각도 |
|-----------|--------|--------|----------------|--------|
| Abstract vs Claims | composition | formulation | 확인 필요 | Major |
| Claim 1 vs Claim 5 | administering | delivering | 문맥 확인 | Minor |
| [0015] vs [0089] | compound | agent | 확인 필요 | Major |

**검출 방법**: 동의어/유사어 사전 기반 검출, 빈도 분석

### 2.2 약어 정의 누락
**설명**: 약어가 정의 없이 사용됨

**패턴 예시**:
- `ADC` - 첫 등장 시 "antibody drug conjugate" 정의 없음
- `IC50` - 전체 문서에서 정의 없이 사용

---

## 3. 수치/범위 모순 (Numerical Contradiction)

### 3.1 범위 충돌
**설명**: 동일 파라미터에 대해 서로 다른 수치 범위 기술

| 위치 예시 | 파라미터 | 값 A | 값 B | 심각도 |
|-----------|----------|------|------|--------|
| [0034] vs [0056] | 농도 범위 | 10-20% | 15-25% | Critical |
| Claims vs Spec | 온도 범위 | 20-30°C | 25-35°C | Critical |

**검출 방법**: 수치 + 단위 + 문맥 추출, 범위 중첩/충돌 분석

### 3.2 수치 오류
**설명**: 명백한 수치 오류 (오타 의심)

**패턴 예시**:
- `100-20 mg` → `10-20 mg` 오타 의심
- `1000 μg` vs `100 mg` → 단위 불일치

---

## 4. 문법/구문 오류 (Grammar/Syntax Error)

### 4.1 주어-동사 불일치
| 원문 예시 | 오류 유형 | 심각도 |
|-----------|-----------|--------|
| "The compound are..." | 주어-동사 불일치 | Minor |
| "Each of the elements have..." | 단/복수 불일치 | Minor |

### 4.2 관사 오류
| 원문 예시 | 오류 유형 | 심각도 |
|-----------|-----------|--------|
| "...a the compound..." | 관사 중복 | Minor |
| "...compound of claim 1..." | 정관사 누락 | Minor |

### 4.3 전치사 오류
| 원문 예시 | 오류 유형 | 심각도 |
|-----------|-----------|--------|
| "binding of the receptor" | binding to → binding of | Minor |

---

## 5. 논리적 모순 (Logical Contradiction)

### 5.1 내용적 모순
**설명**: 서로 상충하는 기술적 내용

| 위치 예시 | 내용 A | 내용 B | 심각도 |
|-----------|--------|--------|--------|
| [0025] vs [0078] | "반응을 실온에서 수행" | "반응을 80°C에서 수행" | Major |
| Claim 3 vs [0045] | "화합물 A를 포함" | "화합물 A를 제외" | Critical |

### 5.2 순서 오류
**설명**: 단계나 순서가 논리적으로 맞지 않음

**패턴 예시**:
- "제2 단계에서 얻은 생성물을 제1 단계에 사용"

---

## 6. 참조 오류 (Reference Error)

### 6.1 잘못된 청구항 참조
| 원문 예시 | 오류 유형 | 심각도 |
|-----------|-----------|--------|
| "The method of claim 5" (claim 5가 장치 청구항) | 참조 유형 불일치 | Major |
| "...according to claim 20" (claim 20 미존재) | 존재하지 않는 청구항 | Critical |

### 6.2 잘못된 도면 참조
| 원문 예시 | 오류 유형 | 심각도 |
|-----------|-----------|--------|
| "As shown in FIG. 10" (FIG. 10 미존재) | 존재하지 않는 도면 | Major |

---

## 검출 우선순위

| 우선순위 | 오류 유형 | 이유 |
|----------|-----------|------|
| 1 | 참조부호 불일치 | 도면과 명세서 대응 오류 → 심사 거절 사유 |
| 2 | 수치/범위 모순 | 기술적 범위 불명확 → 청구항 해석 문제 |
| 3 | 용어 불일치 | 용어 일관성 부재 → 번역 일관성 저해 |
| 4 | 논리적 모순 | 내용 신뢰성 저하 |
| 5 | 문법/구문 오류 | 가독성 저하, 번역 품질 영향 |

---

## 패턴 학습 규칙

1. **추가 기준**: 실제 원문에서 검출된 오류 중 유사 패턴 2회 이상 발생 시
2. **검출 정확도 추적**:
   - True Positive: 실제 오류를 정확히 검출
   - False Positive: 오류 아닌 것을 오류로 검출 → 패턴 수정 필요
3. **클라이언트별 패턴**: 특정 클라이언트의 원문에서 반복되는 오류 유형 별도 기록

---

## 최근 업데이트

- 초기 패턴 템플릿 구축 (2026-01-10)

